/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.queryresultscache;

import java.util.Arrays;
import java.util.concurrent.Callable;

public interface QueryResultsCache {
    public <T> T execute(Callable<T> var1, Class<?> var2, String var3, Object ... var4);

    public void resetForNextTransaction();

    public static class Value<T> {
        private T result;

        public Value(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }

    public static class Key {
        private final Class<?> callingClass;
        private final String methodName;
        private final Object[] keys;

        public Key(Class<?> callingClass, String methodName, Object ... keys) {
            this.callingClass = callingClass;
            this.methodName = methodName;
            this.keys = keys;
        }

        public Class<?> getCallingClass() {
            return this.callingClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Object[] getKeys() {
            return this.keys;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.callingClass == null ? other.callingClass != null : !this.callingClass.equals(other.callingClass)) {
                return false;
            }
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            return Arrays.equals(this.keys, other.keys);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callingClass == null ? 0 : this.callingClass.hashCode());
            result = 31 * result + Arrays.hashCode(this.keys);
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }

        public String toString() {
            return this.callingClass.getName() + "#" + this.methodName + Arrays.toString(this.keys);
        }
    }
}

