/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.metamodel.DomainMember;
import org.apache.isis.applib.services.metamodel.DomainModel;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.applib.services.metamodel.Util;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.schema.metamodel.v1.MetamodelDto;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY, objectType="isisApplib.MetaModelServicesMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.500")
public class MetaModelServicesMenu {
    private final MimeType mimeTypeTextCsv;
    private final MimeType mimeTypeTextXml;
    @Inject
    MetaModelService metaModelService;
    @Inject
    JaxbService jaxbService;

    public MetaModelServicesMenu() {
        try {
            this.mimeTypeTextCsv = new MimeType("text", "csv");
            this.mimeTypeTextXml = new MimeType("application", "xml");
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Action(domainEvent=DownloadMetaModelEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Meta Model (CSV)")
    @MemberOrder(sequence="500.500.2")
    public Clob downloadMetaModelCsv(@ParameterLayout(named=".csv file name") String csvFileName) {
        DomainModel domainMembers = this.metaModelService.getDomainModel();
        List<String> list = MetaModelServicesMenu.asList(domainMembers);
        StringBuilder buf = MetaModelServicesMenu.asBuf(list);
        return new Clob(Util.withSuffix(csvFileName, "csv"), this.mimeTypeTextCsv, buf.toString().toCharArray());
    }

    public String default0DownloadMetaModelCsv() {
        return "metamodel.csv";
    }

    private String toXml(MetamodelDto model) {
        return this.jaxbService.toXml(model);
    }

    @Action(domainEvent=DownloadMetaModelXmlEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Meta Model (XML)")
    @MemberOrder(sequence="500.500.2")
    public Clob downloadMetaModelXml(@ParameterLayout(named=".xml file name") String fileName, @ParameterLayout(named="Packages", describedAs="Subset of the complete meta model, only including packages starting with given prefix.") List<String> packages, @ParameterLayout(named="Ignore Interfaces") @Parameter(optionality=Optionality.MANDATORY) boolean ignoreInterfaces) {
        MetaModelService.Config config = new MetaModelService.Config().withIgnoreNoop().withIgnoreAbstractClasses().withIgnoreInterfaces().withIgnoreBuiltInValueTypes();
        for (String pkg : packages) {
            config = config.withPackagePrefix(pkg);
        }
        if (ignoreInterfaces) {
            config = config.withIgnoreInterfaces();
        }
        MetamodelDto metamodelDto = this.metaModelService.exportMetaModel(config);
        String xml = this.jaxbService.toXml(metamodelDto);
        return new Clob(_Strings.asFileNameWithExtension((String)fileName, (String)".xml"), "text/xml", (CharSequence)xml);
    }

    public String validateDownloadMetaModelXml(String fileName, List<String> packagePrefixes, boolean ignoreInterfaces) {
        if (packagePrefixes == null || packagePrefixes.isEmpty()) {
            return "At least one package must be selected";
        }
        return null;
    }

    public String default0DownloadMetaModelXml() {
        return "metamodel.xml";
    }

    public List<String> choices1DownloadMetaModelXml() {
        DomainModel domainModel = this.metaModelService.getDomainModel();
        List<DomainMember> export = domainModel.getDomainMembers();
        TreeSet packages = _Sets.newTreeSet();
        for (DomainMember domainMember : export) {
            String packageName = domainMember.getPackageName();
            String[] split = packageName.split("[.]");
            StringBuilder buf = new StringBuilder();
            for (String part : split) {
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(part);
                packages.add(buf.toString());
            }
        }
        return new ArrayList<String>(packages);
    }

    public boolean default2DownloadMetaModelXml() {
        return true;
    }

    private static StringBuilder asBuf(List<String> list) {
        StringBuilder buf = new StringBuilder();
        for (String row : list) {
            buf.append(row).append("\n");
        }
        return buf;
    }

    private static List<String> asList(DomainModel model) {
        ArrayList list = _Lists.newArrayList();
        list.add(MetaModelServicesMenu.header());
        for (DomainMember row : model.getDomainMembers()) {
            list.add(MetaModelServicesMenu.asTextCsv(row));
        }
        return list;
    }

    private static String header() {
        return "classType,packageName,className,memberType,memberName,numParams,contributed?,contributedBy,mixedIn?,mixin,hidden,disabled,choices,autoComplete,default,validate";
    }

    private static String asTextCsv(DomainMember row) {
        return Stream.of(row.getClassType(), row.getPackageName(), row.getClassName(), row.getType(), row.getMemberName(), row.getNumParams(), row.isContributed() ? "Y" : "", row.getContributedBy(), row.isMixedIn() ? "Y" : "", row.getMixin(), row.getHidden(), row.getDisabled(), row.getChoices(), row.getAutoComplete(), row.getDefault(), row.getValidate()).collect(Collectors.joining(","));
    }

    public static class DownloadMetaModelXmlEvent
    extends ActionDomainEvent {
    }

    public static class DownloadMetaModelEvent
    extends ActionDomainEvent {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<MetaModelServicesMenu> {
        private static final long serialVersionUID = 1L;
    }
}

