/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.i18n;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.isis.applib.annotation.Programmatic;

public interface TranslationService {
    @Programmatic
    public String translate(String var1, String var2);

    @Programmatic
    public String translate(String var1, String var2, String var3, int var4);

    @Programmatic
    public Mode getMode();

    public static enum Mode {
        DISABLED(configValue -> configValue != null && ("disable".equalsIgnoreCase((String)configValue) || "disabled".equalsIgnoreCase((String)configValue))),
        READ(configValue -> configValue != null && ("read".equalsIgnoreCase((String)configValue) || "reader".equalsIgnoreCase((String)configValue))),
        WRITE(configValue -> !READ.matches((String)configValue) && !DISABLED.matches((String)configValue));

        private final Predicate<String> matchesConfigValue;

        private Mode(Predicate<String> matchesConfigValue) {
            this.matchesConfigValue = Objects.requireNonNull(matchesConfigValue);
        }

        public boolean matches(String configValue) {
            return this.matchesConfigValue.test(configValue);
        }

        public boolean isRead() {
            return this == READ;
        }

        public boolean isWrite() {
            return this == WRITE;
        }

        public boolean isDisabled() {
            return this == DISABLED;
        }
    }
}

