/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.h2;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.commons.internal.base._Strings;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY, objectType="isisApplib.H2ManagerMenu")
@DomainServiceLayout(named="Prototyping", menuOrder="500.800", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
public class H2ManagerMenu {
    private String url;

    @PostConstruct
    public void init(Map<String, String> properties) {
        this.url = properties.get("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionURL");
    }

    @Action(semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING, domainEvent=ActionDomainEvent.class)
    @ActionLayout(named="H2 Console", cssClassFa="database")
    public LocalResourcePath openH2Console() {
        return new LocalResourcePath("/db/");
    }

    public boolean hideOpenH2Console() {
        return _Strings.isNullOrEmpty((CharSequence)this.url) || !this.url.contains("h2:mem");
    }

    public static class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<H2ManagerMenu> {
        private static final long serialVersionUID = 1L;
    }
}

