/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.conmap;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.base._NullSafe;

public interface ContentMappingService {
    @Programmatic
    public Object map(Object var1, List<MediaType> var2);

    public static class Util {
        public static String determineDomainType(List<MediaType> acceptableMediaTypes) {
            for (MediaType acceptableMediaType : acceptableMediaTypes) {
                Map parameters = acceptableMediaType.getParameters();
                String domainType = (String)parameters.get("x-ro-domain-type");
                if (domainType == null) continue;
                return domainType;
            }
            throw new IllegalArgumentException("Could not locate x-ro-domain-type parameter in any of the provided media types; got: " + _NullSafe.stream(acceptableMediaTypes).filter(_NullSafe::isPresent).map(Object::toString).collect(Collectors.joining(", ")));
        }

        public static boolean isSupported(Class<?> clazz, List<MediaType> acceptableMediaTypes) {
            String domainType = Util.determineDomainType(acceptableMediaTypes);
            return clazz.getName().equals(domainType);
        }
    }
}

