/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.layout;

import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.Contributed;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.commons.internal.resources._Resources;

@Mixin(method="act")
public class Object_openRestApi {
    private final Object object;
    @Inject
    BookmarkService bookmarkService;
    @Inject
    SwaggerService swaggerService;

    public Object_openRestApi(Object object) {
        this.object = object;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(contributed=Contributed.AS_ACTION, cssClassFa="fa-external-link", position=ActionLayout.Position.PANEL_DROPDOWN)
    @MemberOrder(name="datanucleusIdLong", sequence="750.1")
    public LocalResourcePath act() {
        Bookmark bookmark = this.bookmarkService.bookmarkFor(this.object);
        return new LocalResourcePath(String.format("/%s/objects/%s/%s", _Resources.getRestfulPathIfAny(), bookmark.getObjectType(), bookmark.getIdentifier()));
    }

    public static class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<Object_openRestApi> {
        private static final long serialVersionUID = 1L;
    }
}

