/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.mixins.layout;

import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.Contributed;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.layout.LayoutService;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.commons.internal.base._Strings;

@Mixin(method="act")
public class Object_downloadLayoutXml {
    private final Object object;
    @Inject
    LayoutService layoutService;

    public Object_downloadLayoutXml(Object object) {
        this.object = object;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(contributed=Contributed.AS_ACTION, cssClassFa="fa-download", position=ActionLayout.Position.PANEL_DROPDOWN)
    @MemberOrder(name="datanucleusIdLong", sequence="700.1")
    public Object act(@ParameterLayout(named="File name") String fileName, LayoutService.Style style) {
        String xml = this.layoutService.toXml(this.object.getClass(), style);
        return new Clob(_Strings.asFileNameWithExtension((String)fileName, (String)(style.name().toLowerCase() + ".xml")), "text/xml", (CharSequence)xml);
    }

    public String default0Act() {
        return _Strings.asFileNameWithExtension((String)this.object.getClass().getSimpleName(), (String)"layout");
    }

    public LayoutService.Style default1Act() {
        return LayoutService.Style.NORMALIZED;
    }

    public static class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<Object_downloadLayoutXml> {
        private static final long serialVersionUID = 1L;
    }
}

