/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts.teardown;

import javax.inject.Inject;
import javax.jdo.metadata.TypeMetadata;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport;
import org.apache.isis.commons.internal.base._Strings;

@Programmatic
public abstract class TeardownFixtureAbstract
extends FixtureScript {
    @Inject
    private IsisJdoSupport isisJdoSupport;

    protected void deleteFrom(Class<?> cls) {
        this.preDeleteFrom(cls);
        TypeMetadata metadata = this.isisJdoSupport.getJdoPersistenceManager().getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            this.deleteFrom(cls.getSimpleName());
        } else {
            String schema = metadata.getSchema();
            String table = metadata.getTable();
            if (_Strings.isNullOrEmpty((CharSequence)table)) {
                table = cls.getSimpleName();
            }
            if (_Strings.isNullOrEmpty((CharSequence)schema)) {
                this.deleteFrom(table);
            } else {
                this.deleteFrom(schema, table);
            }
        }
        this.postDeleteFrom(cls);
    }

    protected Integer deleteFrom(String schema, String table) {
        return this.isisJdoSupport.executeUpdate(String.format("DELETE FROM \"%s\".\"%s\"", schema, table));
    }

    protected void deleteFrom(String table) {
        this.isisJdoSupport.executeUpdate(String.format("DELETE FROM \"%s\"", table));
    }

    protected void preDeleteFrom(Class<?> cls) {
    }

    protected void postDeleteFrom(Class<?> cls) {
    }
}

