/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.isis.applib.AbstractService;
import org.apache.isis.applib.ViewModel;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.MinLength;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.fixturescripts.BuilderScriptAbstract;
import org.apache.isis.applib.fixturescripts.ExecutionParameters;
import org.apache.isis.applib.fixturescripts.ExecutionParametersService;
import org.apache.isis.applib.fixturescripts.FixtureResult;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.PersonaWithBuilderScript;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryService;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.fixturespec.FixtureScriptsSpecification;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.title.TitleService;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public abstract class FixtureScripts
extends AbstractService {
    private FixtureScriptsSpecification specification;
    private List<FixtureScript> fixtureScriptList;
    private final ThreadLocal<PrintStream> fixtureTracing = new ThreadLocal<PrintStream>(){
        {
            this.set(System.out);
        }
    };
    @Inject
    FactoryService factoryService;
    @Inject
    TitleService titleService;
    @Inject
    JaxbService jaxbService;
    @Inject
    BookmarkService bookmarkService;
    @Inject
    ServiceRegistry serviceRegistry;
    @Inject
    RepositoryService repositoryService;
    @Inject
    TransactionService transactionService;
    @Inject
    ClassDiscoveryService classDiscoveryService;
    @Inject
    ExecutionParametersService executionParametersService;

    public FixtureScripts(FixtureScriptsSpecification specification) {
        this.specification = specification;
    }

    @Programmatic
    public FixtureScriptsSpecification getSpecification() {
        return this.specification;
    }

    protected void setSpecification(FixtureScriptsSpecification specification) {
        this.specification = specification;
    }

    @Programmatic
    public String getPackagePrefix() {
        return this.specification.getPackagePrefix();
    }

    @Programmatic
    public NonPersistedObjectsStrategy getNonPersistedObjectsStrategy() {
        return this.specification.getNonPersistedObjectsStrategy();
    }

    @Programmatic
    public MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return this.specification.getMultipleExecutionStrategy();
    }

    @Programmatic
    @PostConstruct
    public void init() {
    }

    @Programmatic
    public List<FixtureScript> getFixtureScriptList() {
        if (this.fixtureScriptList == null) {
            this.fixtureScriptList = this.findAndInstantiateFixtureScripts();
        }
        return this.fixtureScriptList;
    }

    private List<FixtureScript> findAndInstantiateFixtureScripts() {
        return this.findFixtureScriptSubTypesInPackage().stream().filter(fixtureScriptCls -> {
            String packageName = fixtureScriptCls.getPackage().getName();
            return packageName.startsWith(this.getPackagePrefix());
        }).map(this::newFixtureScript).filter(Objects::nonNull).sorted((o1, o2) -> Comparator.comparing(FixtureScript::getFriendlyName).thenComparing(FixtureScript::getQualifiedName).compare((FixtureScript)o1, (FixtureScript)o2)).collect(Collectors.toList());
    }

    private Set<Class<? extends FixtureScript>> findFixtureScriptSubTypesInPackage() {
        return this.findSubTypesOfClasses(FixtureScript.class, this.getPackagePrefix());
    }

    private <T> Set<Class<? extends T>> findSubTypesOfClasses(Class<T> cls, String packagePrefix) {
        return this.classDiscoveryService.findSubTypesOfClasses(cls, packagePrefix);
    }

    private FixtureScript newFixtureScript(Class<? extends FixtureScript> fixtureScriptCls) {
        try {
            Constructor<? extends FixtureScript> constructor = fixtureScriptCls.getConstructor(new Class[0]);
            FixtureScript template = constructor.newInstance(new Object[0]);
            if (!template.isDiscoverable()) {
                return null;
            }
            FixtureScript instance = this.factoryService.instantiate(fixtureScriptCls);
            instance.setParentPath(template.getParentPath());
            return instance;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Programmatic
    public PrintStream getFixtureTracing() {
        return this.fixtureTracing.get();
    }

    @Programmatic
    public void setFixtureTracing(PrintStream fixtureTracing) {
        this.fixtureTracing.set(fixtureTracing);
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @MemberOrder(sequence="10")
    public List<FixtureResult> runFixtureScript(FixtureScript fixtureScript, @ParameterLayout(named="Parameters", describedAs="Script-specific parameters (if any).  The format depends on the script implementation (eg key=value, CSV, JSON, XML etc)", multiLine=10) @Parameter(optionality=Optionality.OPTIONAL) String parameters) {
        this.serviceRegistry.injectServicesInto(fixtureScript);
        return fixtureScript.withTracing(this.fixtureTracing.get()).run(parameters);
    }

    public FixtureScript default0RunFixtureScript() {
        return this.getFixtureScriptList().isEmpty() ? null : this.getFixtureScriptList().get(0);
    }

    protected List<FixtureScript> choices0RunFixtureScript() {
        return this.getFixtureScriptList();
    }

    protected List<FixtureScript> autoComplete0RunFixtureScript(@MinLength(value=1) String arg) {
        Predicate<String> contains = str -> str != null && str.contains(arg);
        return _NullSafe.stream(this.getFixtureScriptList()).filter(script -> contains.test(script.getFriendlyName()) || contains.test(script.getLocalName())).collect(Collectors.toList());
    }

    public String disableRunFixtureScript() {
        return this.getFixtureScriptList().isEmpty() ? "No fixture scripts found under package '" + this.getPackagePrefix() + "'" : null;
    }

    public String validateRunFixtureScript(FixtureScript fixtureScript, String parameters) {
        return fixtureScript.validateRun(parameters);
    }

    protected List<FixtureResult> runScript(FixtureScript fixtureScript, String parameters) {
        return fixtureScript.run(parameters);
    }

    @Programmatic
    public void runFixtureScript(final FixtureScript ... fixtureScriptList) {
        if (fixtureScriptList.length == 1) {
            this.runFixtureScript(fixtureScriptList[0], (String)null);
        } else {
            this.runFixtureScript(new FixtureScript(){

                @Override
                protected void execute(FixtureScript.ExecutionContext executionContext) {
                    FixtureScript[] fixtureScripts;
                    for (FixtureScript fixtureScript : fixtureScripts = fixtureScriptList) {
                        executionContext.executeChild((FixtureScript)this, fixtureScript);
                    }
                }
            }, (String)null);
        }
        this.transactionService.nextTransaction();
    }

    @Programmatic
    public <P extends PersonaWithBuilderScript<T, F>, T, F extends BuilderScriptAbstract<T, F>> T runBuilderScript(P persona) {
        return this.runBuilderScript(persona.builder());
    }

    @Programmatic
    public <T, F extends BuilderScriptAbstract<T, F>> T runBuilderScript(F fixtureScript) {
        this.serviceRegistry.injectServicesInto(fixtureScript);
        fixtureScript.run(null);
        T object = fixtureScript.getObject();
        this.transactionService.nextTransaction();
        return object;
    }

    @Programmatic
    public FixtureScript findFixtureScriptFor(Class<? extends FixtureScript> fixtureScriptClass) {
        List<FixtureScript> fixtureScripts = this.getFixtureScriptList();
        for (FixtureScript fs : fixtureScripts) {
            if (!fixtureScriptClass.isAssignableFrom(fs.getClass())) continue;
            return fs;
        }
        return null;
    }

    @Programmatic
    public FixtureScript.ExecutionContext newExecutionContext(String parameters) {
        ExecutionParameters executionParameters = this.executionParametersService != null ? this.executionParametersService.newExecutionParameters(parameters) : new ExecutionParameters(parameters);
        return FixtureScript.ExecutionContext.create(executionParameters, this);
    }

    protected FixtureScript findFixtureScriptFor(String qualifiedName) {
        List<FixtureScript> fixtureScripts = this.getFixtureScriptList();
        for (FixtureScript fs : fixtureScripts) {
            if (!fs.getQualifiedName().contains(qualifiedName)) continue;
            return fs;
        }
        return null;
    }

    String mementoFor(FixtureScript fs) {
        FixtureScriptMemento memento = new FixtureScriptMemento();
        memento.setPath(fs.getParentPath());
        return this.jaxbService.toXml(memento);
    }

    void initOf(String xml, FixtureScript fs) {
        FixtureScriptMemento memento = this.jaxbService.fromXml(FixtureScriptMemento.class, xml);
        fs.setParentPath(memento.getPath());
    }

    @Programmatic
    FixtureResult newFixtureResult(FixtureScript script, String subkey, Object object, boolean firstTime) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof ViewModel) && !this.repositoryService.isPersistent(object)) {
            switch (this.getNonPersistedObjectsStrategy()) {
                case PERSIST: {
                    this.transactionService.flushTransaction();
                    break;
                }
                case IGNORE: {
                    return null;
                }
                default: {
                    throw _Exceptions.unmatchedCase((Object)((Object)this.getNonPersistedObjectsStrategy()));
                }
            }
        }
        FixtureResult fixtureResult = new FixtureResult();
        fixtureResult.setFixtureScriptClassName(firstTime ? script.getClass().getName() : null);
        fixtureResult.setFixtureScriptQualifiedName(script.getQualifiedName());
        fixtureResult.setKey(script.pathWith(subkey));
        fixtureResult.setObject(object);
        return fixtureResult;
    }

    @Programmatic
    String titleOf(FixtureResult fixtureResult) {
        Object object = fixtureResult.getObject();
        return object != null ? this.titleService.titleOf(object) : "(null)";
    }

    @XmlRootElement(name="fixtureScript")
    public static class FixtureScriptMemento {
        private String path;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static enum MultipleExecutionStrategy {
        EXECUTE_ONCE_BY_CLASS,
        EXECUTE_ONCE_BY_VALUE,
        EXECUTE;


        public boolean isExecuteOnceByClass() {
            return this == EXECUTE_ONCE_BY_CLASS;
        }

        public boolean isExecuteOnceByValue() {
            return this == EXECUTE_ONCE_BY_VALUE;
        }

        public boolean isExecute() {
            return this == EXECUTE;
        }
    }

    public static enum NonPersistedObjectsStrategy {
        PERSIST,
        IGNORE;

    }
}

