/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.isis.applib.AbstractViewModel;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.applib.annotation.ViewModelLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.fixtures.FixtureType;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.fixturescripts.BuilderScriptAbstract;
import org.apache.isis.applib.fixturescripts.ExecutionParameters;
import org.apache.isis.applib.fixturescripts.FixtureResult;
import org.apache.isis.applib.fixturescripts.FixtureResultList;
import org.apache.isis.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.fixturescripts.PersonaWithBuilderScript;
import org.apache.isis.applib.fixturescripts.WithPrereqs;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.sessmgmt.SessionManagementService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@ViewModelLayout(named="Script")
public abstract class FixtureScript
extends AbstractViewModel
implements InstallableFixture {
    protected static final String PATH_SEPARATOR = "/";
    private PrintStream tracePrintStream;
    private String friendlyName;
    private String localName;
    private String parentPath;
    private Discoverability discoverability;
    private ExecutionContext executionContext;
    @Inject
    protected FixtureScripts fixtureScripts;
    @Inject
    protected FactoryService factoryService;
    @Inject
    protected ServiceRegistry serviceRegistry;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected UserService userService;
    @Inject
    protected WrapperFactory wrapperFactory;
    @Inject
    protected TransactionService transactionService;
    @Inject
    protected SessionManagementService sessionManagementService;

    public FixtureScript() {
        this(null, null);
    }

    public FixtureScript(String friendlyName, String localName) {
        this(friendlyName, localName, Discoverability.NON_DISCOVERABLE);
    }

    public FixtureScript(String friendlyName, String localName, PrintStream printStream) {
        this(friendlyName, localName, Discoverability.NON_DISCOVERABLE, printStream);
    }

    public FixtureScript(String friendlyName, String localName, Discoverability discoverability) {
        this(friendlyName, localName, discoverability, null);
    }

    public FixtureScript(String friendlyName, String localName, Discoverability discoverability, PrintStream printStream) {
        this.localName = this.localNameElseDerived(localName);
        this.friendlyName = this.friendlyNameElseDerived(friendlyName);
        this.parentPath = "";
        this.discoverability = discoverability;
        this.withTracing(printStream);
    }

    protected String localNameElseDerived(String str) {
        return str != null ? str : _Strings.asLowerDashed.apply(this.friendlyNameElseDerived(str));
    }

    protected String friendlyNameElseDerived(String str) {
        return str != null ? str : _Strings.asNaturalName2.apply(this.getClass().getSimpleName());
    }

    @Programmatic
    public FixtureScript withTracing(PrintStream tracePrintStream) {
        this.tracePrintStream = tracePrintStream;
        return this;
    }

    @Programmatic
    public FixtureScript withTracing() {
        return this.withTracing(System.out);
    }

    @Override
    @Programmatic
    public String viewModelMemento() {
        return this.fixtureScripts.mementoFor(this);
    }

    @Override
    @Programmatic
    public void viewModelInit(String mementoStr) {
        this.fixtureScripts.initOf(mementoStr, this);
    }

    @Programmatic
    public String getQualifiedName() {
        return this.getParentPath() + this.getLocalName();
    }

    @Title
    @PropertyLayout(hidden=Where.EVERYWHERE)
    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Programmatic
    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Programmatic
    public String getParentPath() {
        return this.parentPath;
    }

    @Programmatic
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @Programmatic
    public boolean isDiscoverable() {
        return this.discoverability == Discoverability.DISCOVERABLE;
    }

    @Programmatic
    public FixtureScript withDiscoverability(Discoverability discoverability) {
        this.discoverability = discoverability;
        return this;
    }

    protected <T> T defaultParam(String parameterName, ExecutionContext ec, T defaultValue) {
        T value = this.valueFor(parameterName, ec, defaultValue);
        this.setParam(parameterName, value);
        return value;
    }

    private <T> T valueFor(String parameterName, ExecutionContext ec, T defaultValue) {
        Class cls = (Class)_Casts.uncheckedCast(defaultValue.getClass());
        T value = this.readParam(parameterName, ec, cls);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    protected <T> T checkParam(String parameterName, ExecutionContext ec, Class<T> cls) {
        T value = this.readParam(parameterName, ec, cls);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException(String.format("No value for '%s'", parameterName));
    }

    private <T> T readParam(String parameterName, ExecutionContext ec, Class<T> cls) {
        Method method;
        Object value = ec.getParameterAsT(parameterName, cls);
        if (value != null) {
            return value;
        }
        try {
            method = this.getClass().getMethod("get" + this.uppercase(parameterName), new Class[0]);
            value = _Casts.uncheckedCast((Object)method.invoke((Object)this, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            try {
                method = this.getClass().getMethod("is" + this.uppercase(parameterName), new Class[0]);
                value = _Casts.uncheckedCast((Object)method.invoke((Object)this, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    private <T> void setParam(String parameterName, T value) {
        Method[] methods;
        String mutator = "set" + this.uppercase(parameterName);
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().equals(mutator) || method.getParameterTypes().length != 1) continue;
            try {
                method.invoke((Object)this, value);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
            break;
        }
    }

    private String uppercase(String parameterName) {
        return parameterName.substring(0, 1).toUpperCase() + parameterName.substring(1);
    }

    final List<FixtureResult> run(String parameters) {
        this.executionContext = this.fixtureScripts.newExecutionContext(parameters).withTracing(this.tracePrintStream);
        this.executionContext.executeChildIfNotAlready(this);
        return this.executionContext.getResults();
    }

    @Programmatic
    public String validateRun(String parameters) {
        return null;
    }

    @Programmatic
    protected abstract void execute(ExecutionContext var1);

    @Override
    @Programmatic
    public FixtureType getType() {
        return FixtureType.DOMAIN_OBJECTS;
    }

    @Override
    @Programmatic
    public final void install() {
        this.run(null);
    }

    @SafeVarargs
    protected static <T> T coalesce(T ... ts) {
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    protected <T> T wrap(T domainObject) {
        return this.wrapperFactory.wrap(domainObject);
    }

    protected <T> T w(T domainObject) {
        return this.wrap(domainObject);
    }

    protected <T> T wrap(T domainObject, WrapperFactory.ExecutionMode executionMode) {
        return this.wrapperFactory.wrap(domainObject, executionMode);
    }

    protected <T> T unwrap(T possibleWrappedDomainObject) {
        return this.wrapperFactory.unwrap(possibleWrappedDomainObject);
    }

    protected <T> T mixin(Class<T> mixinClass, Object mixedIn) {
        return this.factoryService.mixin(mixinClass, mixedIn);
    }

    protected <T> T m(Class<T> mixinClass, Object mixedIn) {
        return this.factoryService.m(mixinClass, mixedIn);
    }

    protected <T> T wrapMixin(Class<T> mixinClass, Object mixedIn) {
        return this.wrap(this.mixin(mixinClass, mixedIn));
    }

    protected <T> T wm(Class<T> mixinClass, Object mixedIn) {
        return this.wrapMixin(mixinClass, mixedIn);
    }

    protected void nextTransaction() {
        this.transactionService.nextTransaction();
    }

    @Programmatic
    String pathWith(String subkey) {
        return (this.getQualifiedName() != null ? this.getQualifiedName() + PATH_SEPARATOR : "") + subkey;
    }

    public static class ExecutionContext {
        public static final ExecutionContext NOOP = new ExecutionContext((String)null, null){

            @Override
            public <T> T addResult(FixtureScript script, T object) {
                return object;
            }

            @Override
            public <T> T addResult(FixtureScript script, String key, T object) {
                return object;
            }

            @Override
            public List<FixtureResult> getResults() {
                return Collections.emptyList();
            }
        };
        private final ExecutionParameters executionParameters;
        private final FixtureScripts fixtureScripts;
        private final FixtureResultList fixtureResultList;
        private final List<FixtureScript> previouslyExecuted = _Lists.newArrayList();
        private final Map<Class<? extends FixtureScript>, FixtureScript> fixtureScriptByClass = _Maps.newLinkedHashMap();
        private final Map<FixtureScript, FixtureScript> fixtureScriptByValue = _Maps.newLinkedHashMap();
        private int traceHighwatermark = 40;
        private PrintStream tracePrintStream;
        private Map<Class<?>, Object> userData = _Maps.newHashMap();

        public ExecutionContext(String parameters, FixtureScripts fixtureScripts) {
            this(new ExecutionParameters(parameters), fixtureScripts);
        }

        @Programmatic
        public static ExecutionContext create(ExecutionParameters executionParameters, FixtureScripts fixtureScripts) {
            return new ExecutionContext(executionParameters, fixtureScripts);
        }

        private ExecutionContext(ExecutionParameters executionParameters, FixtureScripts fixtureScripts) {
            this.fixtureScripts = fixtureScripts;
            this.fixtureResultList = new FixtureResultList(fixtureScripts, this);
            this.executionParameters = executionParameters;
        }

        @Programmatic
        public String getParameters() {
            return this.executionParameters.getParameters();
        }

        @Programmatic
        public Map<String, String> getParameterMap() {
            return this.executionParameters.getParameterMap();
        }

        @Programmatic
        public String getParameter(String parameterName) {
            return this.executionParameters.getParameter(parameterName);
        }

        @Programmatic
        public <T> T getParameterAsT(String parameterName, Class<T> cls) {
            return this.executionParameters.getParameterAsT(parameterName, cls);
        }

        @Programmatic
        public Boolean getParameterAsBoolean(String parameterName) {
            return this.executionParameters.getParameterAsBoolean(parameterName);
        }

        @Programmatic
        public Byte getParameterAsByte(String parameterName) {
            return this.executionParameters.getParameterAsByte(parameterName);
        }

        @Programmatic
        public Short getParameterAsShort(String parameterName) {
            return this.executionParameters.getParameterAsShort(parameterName);
        }

        @Programmatic
        public Integer getParameterAsInteger(String parameterName) {
            return this.executionParameters.getParameterAsInteger(parameterName);
        }

        @Programmatic
        public Long getParameterAsLong(String parameterName) {
            return this.executionParameters.getParameterAsLong(parameterName);
        }

        @Programmatic
        public Float getParameterAsFloat(String parameterName) {
            return this.executionParameters.getParameterAsFloat(parameterName);
        }

        @Programmatic
        public Double getParameterAsDouble(String parameterName) {
            return this.executionParameters.getParameterAsDouble(parameterName);
        }

        @Programmatic
        public Character getParameterAsCharacter(String parameterName) {
            return this.executionParameters.getParameterAsCharacter(parameterName);
        }

        @Programmatic
        public BigInteger getParameterAsBigInteger(String parameterName) {
            return this.executionParameters.getParameterAsBigInteger(parameterName);
        }

        @Programmatic
        public BigDecimal getParameterAsBigDecimal(String parameterName) {
            return this.executionParameters.getParameterAsBigDecimal(parameterName);
        }

        @Programmatic
        public LocalDate getParameterAsLocalDate(String parameterName) {
            return this.executionParameters.getParameterAsLocalDate(parameterName);
        }

        @Programmatic
        public LocalDateTime getParameterAsLocalDateTime(String parameterName) {
            return this.executionParameters.getParameterAsLocalDateTime(parameterName);
        }

        @Programmatic
        public <T extends Enum<T>> T getParameterAsEnum(String parameterName, Class<T> enumClass) {
            return this.executionParameters.getParameterAsEnum(parameterName, enumClass);
        }

        @Programmatic
        public void setParameterIfNotPresent(String parameterName, String parameterValue) {
            this.executionParameters.setParameterIfNotPresent(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Boolean parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Byte parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Short parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Integer parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Long parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Float parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Double parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Character parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, BigInteger parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, java.util.Date parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Date parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, LocalDate parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, LocalDateTime parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, DateTime parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, BigDecimal parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, Enum<?> parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public void setParameter(String parameterName, String parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public List<FixtureResult> getResults() {
            return this.fixtureResultList.getResults();
        }

        @Programmatic
        public <T> T addResult(FixtureScript script, T object) {
            this.fixtureResultList.add(script, object);
            return object;
        }

        @Programmatic
        public <T> T addResult(FixtureScript script, String key, T object) {
            this.fixtureResultList.add(script, key, object);
            return object;
        }

        @Programmatic
        public <T> T lookup(String key, Class<T> cls) {
            return this.fixtureResultList.lookup(key, cls);
        }

        @Programmatic
        public void executeChild(FixtureScript callingFixtureScript, PersonaWithBuilderScript<?, ?> personaWithBuilderScript) {
            this.executeChildren(callingFixtureScript, personaWithBuilderScript);
        }

        @Programmatic
        public <T, F extends BuilderScriptAbstract<T, F>> T executeChildT(FixtureScript callingFixtureScript, PersonaWithBuilderScript<T, F> personaWithBuilderScript) {
            BuilderScriptAbstract f = (BuilderScriptAbstract)this.executeChildT(callingFixtureScript, (T)personaWithBuilderScript.builder());
            return f.getObject();
        }

        @Programmatic
        public void executeChild(FixtureScript callingFixtureScript, FixtureScript childFixtureScript) {
            this.executeChildT(callingFixtureScript, childFixtureScript);
        }

        @Programmatic
        public void executeChildren(FixtureScript callingFixtureScript, PersonaWithBuilderScript<?, ?> ... personaWithBuilderScripts) {
            for (PersonaWithBuilderScript<?, ?> builder : personaWithBuilderScripts) {
                this.executeChild(callingFixtureScript, (FixtureScript)builder.builder());
            }
        }

        @Programmatic
        public <T extends Enum<?>> void executeChildren(FixtureScript callingFixtureScript, Class<T> personaClass) {
            this.executeChildren(callingFixtureScript, (PersonaWithBuilderScript[])personaClass.getEnumConstants());
        }

        @Programmatic
        public void executeChildren(FixtureScript callingFixtureScript, FixtureScript ... fixtureScripts) {
            for (FixtureScript fixtureScript : fixtureScripts) {
                this.executeChild(callingFixtureScript, fixtureScript);
            }
        }

        @Programmatic
        public <T extends FixtureScript> T executeChildT(FixtureScript callingFixtureScript, T childFixtureScript) {
            return this.executeChildT(callingFixtureScript, null, childFixtureScript);
        }

        @Programmatic
        public void executeChild(FixtureScript callingFixtureScript, String localNameOverride, FixtureScript childFixtureScript) {
            if (childFixtureScript == null) {
                return;
            }
            this.executeChildT(callingFixtureScript, localNameOverride, childFixtureScript);
        }

        @Programmatic
        public <T extends FixtureScript> T executeChildT(FixtureScript callingFixtureScript, String localNameOverride, T childFixtureScript) {
            childFixtureScript.setParentPath(callingFixtureScript.pathWith(""));
            childFixtureScript.withTracing(callingFixtureScript.tracePrintStream);
            if (localNameOverride != null) {
                childFixtureScript.setLocalName(localNameOverride);
            }
            callingFixtureScript.serviceRegistry.injectServicesInto(childFixtureScript);
            T childOrPreviouslyExecuted = this.executeChildIfNotAlready(childFixtureScript);
            return childOrPreviouslyExecuted;
        }

        private <T extends FixtureScript> T executeChildIfNotAlready(T childFixtureScript) {
            FixtureScripts.MultipleExecutionStrategy executionStrategy = this.determineExecutionStrategy(childFixtureScript);
            switch (executionStrategy) {
                case EXECUTE_ONCE_BY_CLASS: {
                    FixtureScript previouslyExecutedScript = this.fixtureScriptByClass.get(childFixtureScript.getClass());
                    if (previouslyExecutedScript == null && childFixtureScript instanceof WithPrereqs) {
                        WithPrereqs withPrereqs = (WithPrereqs)((Object)childFixtureScript);
                        withPrereqs.execPrereqs(this);
                    }
                    if ((previouslyExecutedScript = this.fixtureScriptByClass.get(childFixtureScript.getClass())) == null) {
                        this.trace(childFixtureScript, As.EXEC);
                        childFixtureScript.execute(this);
                        this.previouslyExecuted.add(childFixtureScript);
                        this.fixtureScriptByClass.put(childFixtureScript.getClass(), childFixtureScript);
                        return childFixtureScript;
                    }
                    this.trace(childFixtureScript, As.SKIP);
                    return (T)((FixtureScript)_Casts.uncheckedCast((Object)previouslyExecutedScript));
                }
                case EXECUTE_ONCE_BY_VALUE: {
                    return this.executeChildIfNotAlreadyWithValueSemantics(childFixtureScript);
                }
                case EXECUTE: {
                    this.trace(childFixtureScript, As.EXEC);
                    childFixtureScript.execute(this);
                    this.previouslyExecuted.add(childFixtureScript);
                    return childFixtureScript;
                }
            }
            throw _Exceptions.unmatchedCase((String)"Execution strategy: '%s' not recognized", (Object)((Object)executionStrategy));
        }

        private <T extends FixtureScript> FixtureScripts.MultipleExecutionStrategy determineExecutionStrategy(T childFixtureScript) {
            FixtureScripts.MultipleExecutionStrategy executionStrategy;
            if (childFixtureScript instanceof FixtureScriptWithExecutionStrategy) {
                FixtureScriptWithExecutionStrategy fixtureScriptWithExecutionStrategy = (FixtureScriptWithExecutionStrategy)((Object)childFixtureScript);
                executionStrategy = fixtureScriptWithExecutionStrategy.getMultipleExecutionStrategy();
            } else {
                executionStrategy = this.fixtureScripts.getMultipleExecutionStrategy();
            }
            return executionStrategy;
        }

        private <T extends FixtureScript> T executeChildIfNotAlreadyWithValueSemantics(T childFixtureScript) {
            FixtureScript previouslyExecutedScript = this.fixtureScriptByValue.get(childFixtureScript);
            if (previouslyExecutedScript == null && childFixtureScript instanceof WithPrereqs) {
                WithPrereqs withPrereqs = (WithPrereqs)((Object)childFixtureScript);
                withPrereqs.execPrereqs(this);
            }
            if ((previouslyExecutedScript = this.fixtureScriptByValue.get(childFixtureScript)) == null) {
                this.trace(childFixtureScript, As.EXEC);
                childFixtureScript.execute(this);
                this.previouslyExecuted.add(childFixtureScript);
                this.fixtureScriptByValue.put(childFixtureScript, childFixtureScript);
                return childFixtureScript;
            }
            this.trace(childFixtureScript, As.SKIP);
            return (T)((FixtureScript)_Casts.uncheckedCast((Object)previouslyExecutedScript));
        }

        @Programmatic
        public List<FixtureScript> getPreviouslyExecuted() {
            return Collections.unmodifiableList(this.previouslyExecuted);
        }

        @Programmatic
        public ExecutionContext withTracing(PrintStream tracePrintStream) {
            this.tracePrintStream = tracePrintStream;
            return this;
        }

        private void trace(FixtureScript fixtureScript, As as) {
            if (this.tracePrintStream == null) {
                return;
            }
            String qualifiedName = fixtureScript.getQualifiedName();
            String trace = String.format("%1s: %2s %3s\n", new Object[]{this.pad(qualifiedName), as, fixtureScript.getClass().getName()});
            this.tracePrintStream.print(trace);
            this.tracePrintStream.flush();
        }

        void trace(FixtureResult fixtureResult) {
            if (this.tracePrintStream == null) {
                return;
            }
            String key = fixtureResult.getKey();
            String trace = String.format("%1s: %2s\n", this.pad(key), this.fixtureScripts.titleOf(fixtureResult));
            this.tracePrintStream.print(trace);
            this.tracePrintStream.flush();
        }

        private String pad(String key) {
            this.traceHighwatermark = Math.max(key.length(), this.traceHighwatermark);
            return _Strings.padEnd((String)key, (int)ExecutionContext.roundup(this.traceHighwatermark, 20), (char)' ');
        }

        static int roundup(int n, int roundTo) {
            return (n / roundTo + 1) * roundTo;
        }

        @Programmatic
        public void setUserData(Object object) {
            this.userData.put(object.getClass(), object);
        }

        @Programmatic
        public <T> T getUserData(Class<T> cls) {
            return (T)_Casts.uncheckedCast((Object)this.userData.get(cls));
        }

        @Programmatic
        public <T> T clearUserData(Class<T> cls) {
            return (T)_Casts.uncheckedCast((Object)this.userData.remove(cls));
        }

        static enum As {
            EXEC,
            SKIP;

        }
    }

    public static enum Discoverability {
        DISCOVERABLE,
        NON_DISCOVERABLE;

    }
}

