/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts;

import java.util.List;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.fixturescripts.PersonaWithBuilderScript;
import org.apache.isis.applib.fixturescripts.PersonaWithFinder;
import org.apache.isis.applib.fixturescripts.WithPrereqs;
import org.apache.isis.commons.internal.collections._Lists;

@Programmatic
public abstract class BuilderScriptAbstract<T, F extends BuilderScriptAbstract<T, F>>
extends FixtureScript
implements WithPrereqs<T, F>,
FixtureScriptWithExecutionStrategy {
    private final FixtureScripts.MultipleExecutionStrategy executionStrategy;
    private final List<WithPrereqs.Block<T, F>> prereqs = _Lists.newArrayList();

    protected BuilderScriptAbstract() {
        this(FixtureScripts.MultipleExecutionStrategy.EXECUTE_ONCE_BY_VALUE);
    }

    protected BuilderScriptAbstract(FixtureScripts.MultipleExecutionStrategy executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    @Override
    public FixtureScripts.MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return this.executionStrategy;
    }

    @Programmatic
    public F build(FixtureScript parentFixtureScript, FixtureScript.ExecutionContext executionContext) {
        F onFixture = this.self();
        parentFixtureScript.serviceRegistry.injectServicesInto(onFixture);
        this.execPrereqs(executionContext);
        return executionContext.executeChildT(parentFixtureScript, this).self();
    }

    @Override
    public void execPrereqs(FixtureScript.ExecutionContext executionContext) {
        F onFixture = this.self();
        for (WithPrereqs.Block<T, F> prereq : this.prereqs) {
            prereq.execute(onFixture, executionContext);
        }
    }

    @Override
    protected abstract void execute(FixtureScript.ExecutionContext var1);

    public abstract T getObject();

    public <P extends PersonaWithBuilderScript<T, F>> T objectFor(P persona, FixtureScript.ExecutionContext ec) {
        if (persona == null) {
            return null;
        }
        F fixtureScript = persona.builder();
        return ((BuilderScriptAbstract)ec.executeChildT((FixtureScript)this, fixtureScript)).getObject();
    }

    public <P extends PersonaWithFinder<T>> T findUsing(P persona) {
        if (persona == null) {
            return null;
        }
        return persona.findUsing(this.serviceRegistry);
    }

    @Override
    public F setPrereq(WithPrereqs.Block<T, F> prereq) {
        this.prereqs.add(prereq);
        return this.self();
    }

    protected F self() {
        return (F)this;
    }
}

