/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.conmap;

import java.sql.Timestamp;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.conmap.spi.CommandDtoProcessorService;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.applib.services.command.CommandWithDto;
import org.apache.isis.applib.services.conmap.ContentMappingService;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.schema.cmd.v1.CommandDto;
import org.apache.isis.schema.common.v1.PeriodDto;
import org.apache.isis.schema.utils.CommandDtoUtils;
import org.apache.isis.schema.utils.jaxbadapters.JavaSqlTimestampXmlGregorianCalendarAdapter;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ContentMappingServiceForCommandDto
implements ContentMappingService {
    @Inject
    MetaModelService metaModelService;
    @Inject
    List<CommandDtoProcessorService> commandDtoProcessorServices;

    @Override
    @Programmatic
    public Object map(Object object, List<MediaType> acceptableMediaTypes) {
        boolean supported = ContentMappingService.Util.isSupported(CommandDto.class, acceptableMediaTypes);
        if (!supported) {
            return null;
        }
        return this.asProcessedDto(object);
    }

    @Programmatic
    public CommandDto map(CommandWithDto commandWithDto) {
        return this.asProcessedDto(commandWithDto);
    }

    CommandDto asProcessedDto(Object object) {
        if (!(object instanceof CommandWithDto)) {
            return null;
        }
        CommandWithDto commandWithDto = (CommandWithDto)object;
        return this.asProcessedDto(commandWithDto);
    }

    private CommandDto asProcessedDto(CommandWithDto commandWithDto) {
        if (commandWithDto == null) {
            return null;
        }
        CommandDto commandDto = commandWithDto.asDto();
        for (CommandDtoProcessorService commandDtoProcessorService : this.commandDtoProcessorServices) {
            commandDto = commandDtoProcessorService.process(commandWithDto, commandDto);
            if (commandDto != null) continue;
            return null;
        }
        CommandDtoProcessor commandDtoProcessor = this.metaModelService.commandDtoProcessorFor(commandDto.getMember().getLogicalMemberIdentifier());
        if (commandDtoProcessor == null) {
            return commandDto;
        }
        return commandDtoProcessor.process(commandWithDto, commandDto);
    }

    @DomainService(nature=NatureOfService.DOMAIN, menuOrder="1000")
    public static class CopyOverFromCommand
    implements CommandDtoProcessorService {
        @Override
        public CommandDto process(Command command, CommandDto commandDto) {
            commandDto.setUser(command.getUser());
            if (commandDto.getTimestamp() == null) {
                Timestamp timestamp = command.getTimestamp();
                commandDto.setTimestamp(JavaSqlTimestampXmlGregorianCalendarAdapter.print((Timestamp)timestamp));
            }
            CommandDtoUtils.setUserData(commandDto, "targetClass", command.getTargetClass());
            CommandDtoUtils.setUserData(commandDto, "targetAction", command.getTargetAction());
            CommandDtoUtils.setUserData(commandDto, "arguments", command.getArguments());
            Bookmark result = command.getResult();
            CommandDtoUtils.setUserData(commandDto, "returnValue", result != null ? result.toString() : null);
            CommandDtoUtils.setUserData(commandDto, "exception", command.getException());
            PeriodDto timings = CommandDtoUtils.timingsFor(commandDto);
            timings.setStartedAt(JavaSqlTimestampXmlGregorianCalendarAdapter.print((Timestamp)command.getStartedAt()));
            timings.setCompletedAt(JavaSqlTimestampXmlGregorianCalendarAdapter.print((Timestamp)command.getCompletedAt()));
            return commandDto;
        }
    }
}

