/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.client.auth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.xml.bind.DatatypeConverter;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.base._With;

@Priority(value=100)
public class BasicAuthFilter
implements ClientRequestFilter {
    private Credentials credentials = Credentials.empty();

    public static BasicAuthFilter of(Credentials credentials) {
        BasicAuthFilter filter = new BasicAuthFilter();
        filter.setCredentials(credentials);
        return filter;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = (Credentials)_With.requires((Object)credentials, (String)"credentials");
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        requestContext.getHeaders().add((Object)"Authorization", (Object)this.getAuthorizationValue());
    }

    private String getAuthorizationValue() {
        try {
            return "Basic " + DatatypeConverter.printBase64Binary((byte[])this.credentials.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Cannot encode with UTF-8", ex);
        }
    }

    public static class Credentials {
        final String user;
        final String pass;

        public static Credentials empty() {
            return new Credentials("anonymous", null);
        }

        public static Credentials of(String user, String pass) {
            if (_Strings.isNullOrEmpty((CharSequence)user)) {
                return Credentials.empty();
            }
            return new Credentials(user, pass);
        }

        private Credentials(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        public String toString() {
            return "" + this.user + ":" + this.pass;
        }
    }
}

