/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.client;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.client.RestfulClientException;
import org.apache.isis.commons.internal.base._Strings;

public class ResponseDigest<T> {
    private final Response response;
    private final Class<T> entityType;
    private T entity;
    private Exception failureCause;

    public static <T> ResponseDigest<T> of(Response response, Class<T> entityType) {
        return super.digest();
    }

    public static <T> ResponseDigest<T> ofAsyncFailure(Future<Response> asyncResponse, Class<T> entityType, Exception failure) {
        Response response;
        try {
            response = asyncResponse.isDone() ? asyncResponse.get() : null;
        }
        catch (Exception e) {
            response = null;
        }
        ResponseDigest<T> failureDigest = new ResponseDigest<T>(response, entityType);
        return super.digestAsyncFailure(asyncResponse.isCancelled(), failure);
    }

    protected ResponseDigest(Response response, Class<T> entityType) {
        this.response = response;
        this.entityType = entityType;
    }

    public boolean isSuccess() {
        return !this.isFailure();
    }

    public boolean isFailure() {
        return this.failureCause != null;
    }

    public T get() {
        return this.entity;
    }

    public Exception getFailureCause() {
        return this.failureCause;
    }

    public T ifSuccessGetOrElseMap(Function<Exception, T> failureMapper) {
        return this.isSuccess() ? this.get() : failureMapper.apply(this.getFailureCause());
    }

    public <X> X ifSuccessMapOrElseMap(Function<T, X> successMapper, Function<Exception, X> failureMapper) {
        return this.isSuccess() ? successMapper.apply(this.get()) : failureMapper.apply(this.getFailureCause());
    }

    private ResponseDigest<T> digest() {
        if (this.response == null) {
            this.entity = null;
            this.failureCause = new NoSuchElementException();
            return this;
        }
        if (!this.response.hasEntity()) {
            this.entity = null;
            this.failureCause = new NoSuchElementException(this.defaultFailureMessage(this.response));
            return this;
        }
        if (this.response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            this.entity = null;
            this.failureCause = new RestfulClientException(this.defaultFailureMessage(this.response));
            return this;
        }
        try {
            this.entity = this.response.readEntity(this.entityType);
        }
        catch (Exception e) {
            this.entity = null;
            this.failureCause = new RestfulClientException("failed to read JAX-RS response content", e);
        }
        return this;
    }

    private ResponseDigest<T> digestAsyncFailure(boolean isCancelled, Exception failure) {
        this.entity = null;
        if (isCancelled) {
            this.failureCause = new RestfulClientException("Async JAX-RS request was canceled", failure);
            return this;
        }
        if (this.response == null) {
            this.failureCause = new RestfulClientException("Async JAX-RS request failed", failure);
            return this;
        }
        this.failureCause = new RestfulClientException("Async JAX-RS request failed " + this.defaultFailureMessage(this.response), failure);
        return this;
    }

    private String defaultFailureMessage(Response response) {
        String failureMessage = "non-successful JAX-RS response: " + String.format("%s (Http-Status-Code: %d)", response.getStatusInfo().getReasonPhrase(), response.getStatus());
        if (response.hasEntity()) {
            try {
                String jsonContent = _Strings.read((InputStream)((InputStream)response.getEntity()), (Charset)StandardCharsets.UTF_8);
                return failureMessage + "\nContent:\n" + jsonContent;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return failureMessage;
    }
}

