/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public final class PropertyResource {
    private final Class<?> resourceContext;
    private final String resourceName;

    public static PropertyResource ofClassContext(Class<?> resourceContext, String resourceName) {
        return new PropertyResource(resourceContext, resourceName);
    }

    PropertyResource(Class<?> resourceContext, String resourceName) {
        this.resourceContext = resourceContext;
        this.resourceName = resourceName;
    }

    public Class<?> getResourceContext() {
        return this.resourceContext;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    void loadPropsInto(Map<String, String> props) {
        Properties properties = new Properties();
        try (InputStream stream = this.resourceContext.getResourceAsStream(this.resourceName);){
            properties.load(stream);
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                if (!(key instanceof String) || !(value instanceof String)) continue;
                props.put((String)key, (String)value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to load '%s' file relative to %s", this.getResourceName(), this.getResourceContext().getName()), e);
        }
    }
}

