/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.PropertyResource;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Sets;

abstract class ModuleOrBuilderAbstract<B extends ModuleOrBuilderAbstract<B>> {
    final Set<Class<?>> additionalModules = _Sets.newLinkedHashSet();
    final Set<Class<?>> additionalServices = _Sets.newLinkedHashSet();
    final Map<String, String> individualConfigProps = _Maps.newLinkedHashMap();
    final Map<String, String> fallbackConfigProps = _Maps.newLinkedHashMap();
    final List<PropertyResource> propertyResources = _Lists.newArrayList();

    ModuleOrBuilderAbstract() {
    }

    public B withAdditionalDependency(Module dependency) {
        this.withTransitiveFrom(dependency);
        return this.self();
    }

    public B withAdditionalDependencies(Set<Module> dependencies) {
        for (Module dependency : dependencies) {
            this.withAdditionalDependency(dependency);
        }
        return this.self();
    }

    public B withAdditionalDependencies(Module ... dependencies) {
        return this.withAdditionalDependencies(_Sets.of((Object[])dependencies));
    }

    void withTransitiveFrom(Module module) {
        this.withAdditionalModules(ModuleOrBuilderAbstract.asClasses(Module.Util.transitiveDependenciesOf(module)));
        this.withAdditionalModules(Module.Util.transitiveAdditionalModulesOf(module));
        this.withAdditionalServices(Module.Util.transitiveAdditionalServicesOf(module));
        this.withConfigurationPropertyResources(Module.Util.transitivePropertyResourcesOf(module));
        this.withConfigurationProperties(Module.Util.transitiveIndividualConfigPropsOf(module));
        this.withFallbackConfigurationProperties(Module.Util.transitiveFallbackConfigPropsOf(module));
    }

    private static Class<? extends Module>[] asClasses(List<Module> dependencies) {
        ArrayList list = new ArrayList();
        for (Module dependency : dependencies) {
            Class<?> aClass = dependency.getClass();
            list.add(aClass);
        }
        return (Class[])_Casts.uncheckedCast((Object)list.toArray(_Constants.emptyClasses));
    }

    public B withAdditionalModules(Class<?> ... modules) {
        return this.withAdditionalModules(Arrays.asList(modules));
    }

    public B withAdditionalModules(Collection<Class<?>> modules) {
        if (modules == null) {
            return this.self();
        }
        this.additionalModules.addAll(modules);
        return this.self();
    }

    public B withAdditionalServices(Class<?> ... additionalServices) {
        return this.withAdditionalServices(Arrays.asList(additionalServices));
    }

    public B withAdditionalServices(Collection<Class<?>> additionalServices) {
        if (additionalServices == null) {
            return this.self();
        }
        this.additionalServices.addAll(additionalServices);
        return this.self();
    }

    public B withConfigurationProperties(Map<String, String> configurationProperties) {
        configurationProperties.forEach(this::withConfigurationProperty);
        return this.self();
    }

    public B withFallbackConfigurationProperties(Map<String, String> fallbackConfigurationProperties) {
        fallbackConfigurationProperties.forEach(this::withFallbackConfigurationProperty);
        return this.self();
    }

    public B withConfigurationPropertiesFile(String propertiesFile) {
        return this.withConfigurationPropertiesFile(this.getClass(), propertiesFile, new String[0]);
    }

    public B withConfigurationPropertyResources(List<PropertyResource> propertyResources) {
        for (PropertyResource propertyResource : propertyResources) {
            this.withConfigurationPropertyResource(propertyResource);
        }
        return this.self();
    }

    public B withConfigurationPropertyResource(PropertyResource propertyResource) {
        this.addPropertyResource(propertyResource);
        return this.self();
    }

    public B withConfigurationPropertiesFile(Class<?> propertiesFileContext, String propertiesFile, String ... furtherPropertiesFiles) {
        this.addPropertyResource(propertiesFileContext, propertiesFile);
        for (String otherFile : furtherPropertiesFiles) {
            this.addPropertyResource(propertiesFileContext, otherFile);
        }
        return this.self();
    }

    private void addPropertyResource(Class<?> propertiesFileContext, String propertiesFile) {
        this.addPropertyResource(new PropertyResource(propertiesFileContext, propertiesFile));
    }

    private void addPropertyResource(PropertyResource propertyResource) {
        this.propertyResources.add(propertyResource);
    }

    public B withConfigurationProperty(String key, String value) {
        this.individualConfigProps.put(key, value);
        return this.self();
    }

    public B withConfigurationProperty(Map.Entry<String, String> keyValue) {
        return this.withConfigurationProperty(keyValue.getKey(), keyValue.getValue());
    }

    @XmlTransient
    public Map<String, String> getIndividualConfigProps() {
        return this.individualConfigProps;
    }

    public B withFallbackConfigurationProperty(String key, String value) {
        this.fallbackConfigProps.put(key, value);
        return this.self();
    }

    @XmlTransient
    public Map<String, String> getFallbackConfigProps() {
        return this.fallbackConfigProps;
    }

    @XmlTransient
    public List<PropertyResource> getPropertyResources() {
        return this.propertyResources;
    }

    protected B self() {
        return (B)((ModuleOrBuilderAbstract)_Casts.uncheckedCast((Object)this));
    }
}

