/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.ModuleOrBuilderAbstract;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Sets;

public abstract class ModuleAbstract
extends ModuleOrBuilderAbstract<ModuleAbstract>
implements Module {
    @Override
    @XmlTransient
    public Set<Module> getDependencies() {
        return _Sets.newLinkedHashSet();
    }

    @XmlElement(name="module", required=true)
    private Set<ModuleAbstract> getModuleDependencies() {
        return _NullSafe.stream(this.getDependencies()).filter(module -> module instanceof ModuleAbstract).map(module -> (ModuleAbstract)module).collect(Collectors.toSet());
    }

    @Override
    @XmlTransient
    public Set<Class<?>> getAdditionalModules() {
        return this.additionalModules;
    }

    @Override
    @XmlTransient
    public FixtureScript getRefDataSetupFixture() {
        return null;
    }

    @Override
    @XmlTransient
    public FixtureScript getTeardownFixture() {
        return null;
    }

    @Override
    @XmlTransient
    public Set<Class<?>> getAdditionalServices() {
        return this.additionalServices;
    }

    @XmlAttribute(required=true)
    public String getName() {
        return this.getClass().getSimpleName();
    }

    private String getFullName() {
        return this.getClass().getName();
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleAbstract)) {
            return false;
        }
        ModuleAbstract other = (ModuleAbstract)o;
        return Objects.equals(this.getFullName(), other.getFullName());
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }
}

