/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.isis.applib.PropertyResource;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Sets;

public interface Module {
    public Set<Module> getDependencies();

    public Set<Class<?>> getAdditionalModules();

    public FixtureScript getRefDataSetupFixture();

    public FixtureScript getTeardownFixture();

    public Set<Class<?>> getAdditionalServices();

    public Map<String, String> getIndividualConfigProps();

    public Map<String, String> getFallbackConfigProps();

    public List<PropertyResource> getPropertyResources();

    public static class Util {
        private Util() {
        }

        static List<Module> transitiveDependenciesOf(Module module) {
            ArrayList ordered = _Lists.newArrayList();
            ArrayList visited = _Lists.newArrayList();
            Util.appendDependenciesTo(ordered, module, visited);
            LinkedHashSet sequencedSet = _Sets.newLinkedHashSet((Collection)ordered);
            return _Lists.newArrayList((Collection)sequencedSet);
        }

        static List<Class<?>> transitiveAdditionalModulesOf(Module module) {
            HashSet modules = _Sets.newHashSet();
            List<Module> transitiveDependencies = Util.transitiveDependenciesOf(module);
            for (Module transitiveDependency : transitiveDependencies) {
                Set<Class<?>> additionalModules = transitiveDependency.getAdditionalModules();
                if (additionalModules == null || additionalModules.isEmpty()) continue;
                for (Class<?> clazz : additionalModules) {
                    if (!Module.class.isAssignableFrom(clazz)) continue;
                    throw new IllegalArgumentException("Module " + transitiveDependency + " has returned " + clazz + " from getAdditionalModules().  This class implements 'Module' interface so should instead be returned from getDependencies()");
                }
                modules.addAll(additionalModules);
            }
            return _Lists.newArrayList((Collection)modules);
        }

        static List<Class<?>> transitiveAdditionalServicesOf(Module module) {
            HashSet services = _Sets.newHashSet();
            List<Module> transitiveDependencies = Util.transitiveDependenciesOf(module);
            for (Module transitiveDependency : transitiveDependencies) {
                Set<Class<?>> additionalServices = transitiveDependency.getAdditionalServices();
                if (additionalServices == null || additionalServices.isEmpty()) continue;
                services.addAll(additionalServices);
            }
            return _Lists.newArrayList((Collection)services);
        }

        private static void appendDependenciesTo(List<Module> ordered, Module module, List<Module> visited) {
            if (visited.contains(module)) {
                throw new IllegalStateException(String.format("Cyclic dependency detected; visited: %s", visited));
            }
            visited.add(module);
            Set<Module> dependencies = module.getDependencies();
            if (dependencies.isEmpty() || ordered.containsAll(dependencies)) {
                ordered.add(module);
                visited.clear();
            } else {
                for (Module dependency : dependencies) {
                    Util.appendDependenciesTo(ordered, dependency, visited);
                }
            }
            if (!ordered.contains(module)) {
                ordered.add(module);
            }
        }

        static Map<String, String> transitiveIndividualConfigPropsOf(Module module) {
            LinkedHashMap props = _Maps.newLinkedHashMap();
            Util.transitiveDependenciesOf(module).stream().map(Module::getIndividualConfigProps).forEach(props::putAll);
            return props;
        }

        static Map<String, String> transitiveFallbackConfigPropsOf(Module module) {
            LinkedHashMap props = _Maps.newLinkedHashMap();
            Util.transitiveDependenciesOf(module).stream().map(Module::getFallbackConfigProps).forEach(props::putAll);
            return props;
        }

        static List<PropertyResource> transitivePropertyResourcesOf(Module module) {
            return Util.transitiveDependenciesOf(module).stream().map(Module::getPropertyResources).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }
}

