/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.title.TitleService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.services.xactn.TransactionService;

@DomainServiceLayout(menuOrder="1")
public abstract class AbstractSubscriber {
    @Inject
    protected MessageService messageService;
    @Inject
    protected TitleService titleService;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected FactoryService factoryService;
    @Inject
    protected UserService userService;
    @Inject
    protected TransactionService transactionService;
    @Inject
    protected EventBusService eventBusService;

    @PostConstruct
    public void postConstruct() {
        this.eventBusService.register(this);
    }

    @Programmatic
    public void preDestroy() {
        this.eventBusService.unregister(this);
    }
}

