/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.resource;

import java.io.InputStream;
import org.apache.isis.core.commons.lang.PathUtils;
import org.apache.isis.core.commons.resource.ResourceStreamSourceAbstract;

public class ResourceStreamSourceContextLoaderClassPath
extends ResourceStreamSourceAbstract {
    private final String prefix;

    public static ResourceStreamSourceContextLoaderClassPath create() {
        return ResourceStreamSourceContextLoaderClassPath.create("");
    }

    public static ResourceStreamSourceContextLoaderClassPath create(String prefix) {
        return new ResourceStreamSourceContextLoaderClassPath(prefix);
    }

    private ResourceStreamSourceContextLoaderClassPath(String prefix) {
        this.prefix = prefix;
    }

    @Override
    protected InputStream doReadResource(String resourcePath) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = PathUtils.combine(this.prefix, resourcePath);
        return classLoader.getResourceAsStream(path);
    }

    @Override
    public String getName() {
        return "context loader classpath";
    }
}

