/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class Resources {
    public static URL getResourceURL(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(resource);
        if (url != null) {
            return url;
        }
        classLoader = Resources.class.getClassLoader();
        url = classLoader.getResource(resource);
        if (url != null) {
            return url;
        }
        try {
            return ClassLoader.getSystemResource(resource);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream(resource);
        if (is != null) {
            return is;
        }
        classLoader = Resources.class.getClassLoader();
        is = classLoader.getResourceAsStream(resource);
        if (is != null) {
            return is;
        }
        try {
            return ClassLoader.getSystemResourceAsStream(resource);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    public static File getResourceAsFile(String resource) {
        URL url = Resources.getResourceURL(resource);
        if (url == null) {
            return null;
        }
        return new File(url.getFile());
    }

    public static Properties getResourceAsProperties(String resource) {
        InputStream is = Resources.getResourceAsStream(resource);
        if (is == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
        return props;
    }
}

