/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

public final class NameUtils {
    private static final char SPACE = ' ';

    private NameUtils() {
    }

    public static String javaBaseName(String javaName) {
        int pos;
        int len = javaName.length();
        for (pos = 0; pos < len && javaName.charAt(pos) != '_' && Character.isLowerCase(javaName.charAt(pos)); ++pos) {
        }
        if (pos >= len) {
            return "";
        }
        if (javaName.charAt(pos) == '_') {
            ++pos;
        }
        if (pos >= len) {
            return "";
        }
        String baseName = javaName.substring(pos);
        char firstChar = baseName.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return Character.toUpperCase(firstChar) + baseName.substring(1);
        }
        return baseName;
    }

    public static String javaBaseNameStripAccessorPrefixIfRequired(String javaName) {
        if (javaName.startsWith("is") || javaName.startsWith("get")) {
            return NameUtils.javaBaseName(javaName);
        }
        return NameUtils.capitalizeName(javaName);
    }

    public static String capitalizeName(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static boolean startsWith(String fullMethodName, String prefix) {
        int length = prefix.length();
        if (length >= fullMethodName.length()) {
            return false;
        }
        char startingCharacter = fullMethodName.charAt(length);
        return fullMethodName.startsWith(prefix) && Character.isUpperCase(startingCharacter);
    }

    public static String simpleName(String name) {
        int len = name.length();
        StringBuffer sb = new StringBuffer(len);
        for (int pos = 0; pos < len; ++pos) {
            char ch = name.charAt(pos);
            if (ch == ' ') continue;
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    public static String naturalName(String name) {
        int length = name.length();
        if (length <= 1) {
            return name.toUpperCase();
        }
        StringBuffer naturalName = new StringBuffer(length);
        char character = Character.toUpperCase(name.charAt(0));
        naturalName.append(character);
        char nextCharacter = name.charAt(1);
        for (int pos = 2; pos < length; ++pos) {
            char previousCharacter = character;
            character = nextCharacter;
            nextCharacter = name.charAt(pos);
            if (previousCharacter != ' ') {
                if (Character.isUpperCase(character) && !Character.isUpperCase(previousCharacter)) {
                    naturalName.append(' ');
                }
                if (Character.isUpperCase(character) && Character.isLowerCase(nextCharacter) && Character.isUpperCase(previousCharacter)) {
                    naturalName.append(' ');
                }
                if (Character.isDigit(character) && !Character.isDigit(previousCharacter)) {
                    naturalName.append(' ');
                }
            }
            naturalName.append(character);
        }
        naturalName.append(nextCharacter);
        return naturalName.toString();
    }

    public static String pluralName(String name) {
        String pluralName = name.endsWith("y") ? name.substring(0, name.length() - 1) + "ies" : (name.endsWith("s") || name.endsWith("x") ? name + "es" : name + 's');
        return pluralName;
    }
}

