/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class ListUtils {
    private static final String DEFAULT_DELIMITER = ",";

    private ListUtils() {
    }

    public static <T> List<T> combine(List<T> list, List<T> list2) {
        ArrayList<T> combinedList = new ArrayList<T>();
        combinedList.addAll(list);
        combinedList.addAll(list2);
        return combinedList;
    }

    public static <T> List<T> merge(List<T> list1, List<T> list2) {
        for (T obj : list2) {
            if (list1.contains(obj)) continue;
            list1.add(obj);
        }
        return list1;
    }

    public static List<String> merge(String[] array1, String[] array2) {
        ArrayList<String> prefixes = new ArrayList<String>();
        ListUtils.addNoDuplicates(array1, prefixes);
        ListUtils.addNoDuplicates(array2, prefixes);
        return prefixes;
    }

    private static void addNoDuplicates(String[] array, List<String> list) {
        for (int i = 0; i < array.length; ++i) {
            if (list.contains(array[i])) continue;
            list.add(array[i]);
        }
    }

    public static List<Object> asList(Object[] objectArray) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object element : objectArray) {
            if (Collection.class.isAssignableFrom(element.getClass())) {
                Collection collection = (Collection)element;
                list.addAll(ListUtils.asList(collection.toArray()));
                continue;
            }
            list.add(element);
        }
        return list;
    }

    public static String listToString(List<String> list) {
        return ListUtils.listToString(list, DEFAULT_DELIMITER);
    }

    public static String listToString(List<String> list, String delimiter) {
        if (list.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String str : list) {
            if (first) {
                first = false;
            } else {
                buf.append(delimiter);
            }
            buf.append(str);
        }
        return buf.toString();
    }

    public static List<String> stringToList(String commaSeparated) {
        return ListUtils.appendDelimitedStringToList(commaSeparated, new ArrayList<String>());
    }

    public static List<String> stringToList(String delimited, String delimiter) {
        return ListUtils.appendDelimitedStringToList(delimited, delimiter, new ArrayList<String>());
    }

    public static List<String> appendDelimitedStringToList(String commaSeparated, List<String> list) {
        return ListUtils.appendDelimitedStringToList(commaSeparated, DEFAULT_DELIMITER, list);
    }

    public static List<String> appendDelimitedStringToList(String delimited, String delimiter, List<String> list) {
        if (delimited == null) {
            return list;
        }
        String[] optionValues = delimited.split(delimiter);
        list.addAll(Arrays.asList(optionValues));
        return list;
    }
}

