/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.isis.core.commons.exceptions.IsisException;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static Object newInstance(Class<?> type, Class<?> constructorParamType, Object constructorArg) {
        return ClassUtil.newInstance(type, new Class[]{constructorParamType}, new Object[]{constructorArg});
    }

    public static Object newInstance(Class<?> type, Class<?>[] constructorParamTypes, Object[] constructorArgs) {
        try {
            try {
                Constructor<?> constructor = type.getConstructor(constructorParamTypes);
                return constructor.newInstance(constructorArgs);
            }
            catch (NoSuchMethodException ex) {
                try {
                    Constructor<?> constructor = type.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IsisException(e);
                }
            }
        }
        catch (SecurityException ex) {
            throw new IsisException(ex);
        }
        catch (IllegalArgumentException e) {
            throw new IsisException(e);
        }
        catch (InstantiationException e) {
            throw new IsisException(e);
        }
        catch (IllegalAccessException e) {
            throw new IsisException(e);
        }
        catch (InvocationTargetException e) {
            throw new IsisException(e);
        }
    }
}

