/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static Object[] convertCharToCharacterArray(Object originalArray) {
        char[] original = (char[])originalArray;
        int len = original.length;
        Object[] converted = new Character[len];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = Character.valueOf(original[i]);
        }
        return converted;
    }

    public static <T> T[] combine(T[] ... arrays) {
        ArrayList<T> combinedList = new ArrayList<T>();
        T[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] array;
            for (T t : array = arr$[i$]) {
                combinedList.add(t);
            }
        }
        return combinedList.toArray(arrays[0]);
    }

    public static <T> List<T> asList(T[] items) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static <T> Set<T> asOrderedSet(T[] items) {
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        if (items != null) {
            for (T item : items) {
                list.add(item);
            }
        }
        return list;
    }

    public static <T> List<T> concat(T[] elements, T ... elementsToAppend) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : elements) {
            result.add(element);
        }
        for (T element : elementsToAppend) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static String[] append(String[] args, String ... moreArgs) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.addAll(Arrays.asList(args));
        argList.addAll(Arrays.asList(moreArgs));
        return argList.toArray(new String[0]);
    }

    public static <T> List<T> concat(T[] elements, List<T> elementsToAppend) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : elements) {
            result.add(element);
        }
        for (T element : elementsToAppend) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static <D, S> D[] copy(S[] source, Class<D> cls) {
        if (source == null) {
            throw new IllegalArgumentException("Source array cannot be null");
        }
        Object[] destination = (Object[])Array.newInstance(cls, source.length);
        System.arraycopy(source, 0, destination, 0, source.length);
        return destination;
    }
}

