/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ArrayUtils;
import org.apache.isis.core.commons.lang.WrapperUtils;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static Object[] getObjectAsObjectArray(Object option) {
        Class<?> arrayType = option.getClass().getComponentType();
        if (!arrayType.isPrimitive()) {
            return (Object[])option;
        }
        if (arrayType == Character.TYPE) {
            return ArrayUtils.convertCharToCharacterArray(option);
        }
        return ArrayUtil.convertPrimitiveToObjectArray(arrayType, option);
    }

    private static Object[] convertPrimitiveToObjectArray(Class<?> arrayType, Object originalArray) {
        Object[] convertedArray;
        try {
            Class<?> wrapperClass = WrapperUtils.wrap(arrayType);
            Constructor<?> constructor = wrapperClass.getConstructor(String.class);
            int len = Array.getLength(originalArray);
            convertedArray = (Object[])Array.newInstance(wrapperClass, len);
            for (int i = 0; i < len; ++i) {
                convertedArray[i] = constructor.newInstance(Array.get(originalArray, i).toString());
            }
        }
        catch (NoSuchMethodException e) {
            throw new IsisException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IsisException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IsisException(e);
        }
        catch (InstantiationException e) {
            throw new IsisException(e);
        }
        catch (IllegalAccessException e) {
            throw new IsisException(e);
        }
        catch (InvocationTargetException e) {
            throw new IsisException(e);
        }
        return convertedArray;
    }
}

