/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class IsisException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static boolean THROWABLE_SUPPORTS_CAUSE;
    private final Throwable cause;

    public IsisException() {
        super("");
        this.cause = null;
    }

    public IsisException(String message) {
        super(message);
        this.cause = null;
    }

    public IsisException(String messageFormat, Object ... args) {
        super(MessageFormat.format(messageFormat, args));
        this.cause = null;
    }

    public IsisException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public IsisException(Throwable cause) {
        super(cause == null ? null : cause.toString());
        this.cause = cause;
    }

    @Override
    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        if (THROWABLE_SUPPORTS_CAUSE) {
            super.printStackTrace(s);
        } else {
            PrintStream printStream = s;
            synchronized (printStream) {
                super.printStackTrace(s);
                Throwable c = this.getCause();
                if (c != null) {
                    s.print("Root cause: ");
                    c.printStackTrace(s);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        if (THROWABLE_SUPPORTS_CAUSE) {
            super.printStackTrace(s);
        } else {
            PrintWriter printWriter = s;
            synchronized (printWriter) {
                super.printStackTrace(s);
                Throwable c = this.getCause();
                if (c != null) {
                    s.println("Root cause: ");
                    c.printStackTrace(s);
                }
            }
        }
    }

    static {
        Class<Throwable> c = Throwable.class;
        try {
            THROWABLE_SUPPORTS_CAUSE = c.getMethod("getCause", new Class[0]) != null;
        }
        catch (Exception ignore) {
            THROWABLE_SUPPORTS_CAUSE = false;
        }
    }
}

