/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.debug;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebugString;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;

public class DebugList {
    private final List<DebuggableWithTitle> debuggableList = Lists.newArrayList();
    private final DebugBuilder summary = new DebugString();

    public DebugList(final String name) {
        this.debuggableList.add(new DebuggableWithTitle(){

            @Override
            public void debugData(DebugBuilder debug) {
                debug.append(DebugList.this.summary.toString());
            }

            @Override
            public String debugTitle() {
                return name;
            }
        });
    }

    public void add(String name, Object object) {
        boolean b = object instanceof DebuggableWithTitle;
        if (b) {
            this.debuggableList.add((DebuggableWithTitle)object);
        }
        if (object != null) {
            this.summary.appendln(name + (b ? "*" : ""), object.toString());
        }
    }

    public DebuggableWithTitle[] debug() {
        return this.debuggableList.toArray(new DebuggableWithTitle[this.debuggableList.size()]);
    }
}

