/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.config;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderAware;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.config.NotFoundPolicy;
import org.apache.isis.core.commons.config.PropertiesReader;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceComposite;
import org.apache.isis.core.commons.resource.ResourceStreamSourceFileSystem;
import org.apache.log4j.Logger;

public class IsisConfigurationBuilderResourceStreams
implements IsisConfigurationBuilder {
    private static final Logger LOG = Logger.getLogger(IsisConfigurationBuilderResourceStreams.class);
    private final ResourceStreamSource resourceStreamSource;
    private final List<ConfigurationResourceAndPolicy> configurationResources = new ArrayList<ConfigurationResourceAndPolicy>();
    private final Properties additionalProperties = new Properties();
    private boolean includeSystemProperties = false;
    private IsisConfiguration cachedConfiguration;

    private static ResourceStreamSource createComposite(ResourceStreamSource ... resourceStreamSources) {
        ResourceStreamSourceComposite composite = new ResourceStreamSourceComposite(new ResourceStreamSource[0]);
        for (ResourceStreamSource rss : resourceStreamSources) {
            if (rss == null) continue;
            composite.addResourceStreamSource(rss);
        }
        return composite;
    }

    public IsisConfigurationBuilderResourceStreams() {
        this(ResourceStreamSourceFileSystem.create("config"));
    }

    public IsisConfigurationBuilderResourceStreams(ResourceStreamSource ... resourceStreamSources) {
        this(IsisConfigurationBuilderResourceStreams.createComposite(resourceStreamSources));
    }

    public IsisConfigurationBuilderResourceStreams(ResourceStreamSource resourceStreamSource) {
        this.resourceStreamSource = resourceStreamSource;
        this.addDefaultConfigurationResources();
    }

    protected void addDefaultConfigurationResources() {
        this.addConfigurationResource("isis.properties", NotFoundPolicy.FAIL_FAST);
        this.addConfigurationResource("web.properties", NotFoundPolicy.CONTINUE);
    }

    @Override
    public ResourceStreamSource getResourceStreamSource() {
        return this.resourceStreamSource;
    }

    @Override
    public synchronized void addConfigurationResource(String configurationResource, NotFoundPolicy notFoundPolicy) {
        this.configurationResources.add(new ConfigurationResourceAndPolicy(configurationResource, notFoundPolicy));
        this.invalidateCache();
    }

    public synchronized void setIncludeSystemProperties(boolean includeSystemProperties) {
        this.includeSystemProperties = includeSystemProperties;
        this.invalidateCache();
    }

    @Override
    public synchronized void add(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.additionalProperties.setProperty(key, value);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("added " + key + "=" + value));
        }
        this.invalidateCache();
    }

    @Override
    public synchronized void add(Properties properties) {
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.add(key, properties.getProperty(key));
        }
        this.invalidateCache();
    }

    @Override
    public synchronized IsisConfiguration getConfiguration() {
        if (this.cachedConfiguration != null) {
            return this.cachedConfiguration;
        }
        IsisConfigurationDefault configuration = new IsisConfigurationDefault(this.getResourceStreamSource());
        this.loadConfigurationResources(configuration);
        this.addShowExplorationOptionsIfNotSpecified(configuration);
        this.addSystemPropertiesIfRequested(configuration);
        this.addAdditionalProperties(configuration);
        this.cachedConfiguration = configuration;
        return this.cachedConfiguration;
    }

    private void loadConfigurationResources(IsisConfigurationDefault configuration) {
        for (ConfigurationResourceAndPolicy configResourceAndPolicy : this.configurationResources) {
            this.loadConfigurationResource(configuration, configResourceAndPolicy);
        }
    }

    private void loadConfigurationResource(IsisConfigurationDefault configuration, ConfigurationResourceAndPolicy configResourceAndPolicy) {
        String configurationResource = configResourceAndPolicy.getConfigurationResource();
        NotFoundPolicy notFoundPolicy = configResourceAndPolicy.getNotFoundPolicy();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("loading configuration resource: " + configurationResource + ", notFoundPolicy: " + (Object)((Object)notFoundPolicy)));
        }
        this.loadConfigurationResource(configuration, configurationResource, notFoundPolicy);
    }

    protected void loadConfigurationResource(IsisConfigurationDefault configuration, String configurationResource, NotFoundPolicy notFoundPolicy) {
        try {
            PropertiesReader propertiesReader = this.loadConfigurationResource(this.resourceStreamSource, configurationResource);
            this.addProperties(configuration, propertiesReader.getProperties());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("'" + configurationResource + "' FOUND"));
            }
            return;
        }
        catch (IOException ex) {
            if (notFoundPolicy == NotFoundPolicy.FAIL_FAST) {
                throw new IsisException("failed to load '" + configurationResource + "'; tried using: " + this.resourceStreamSource.getName());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("'" + configurationResource + "' not found, but not needed"));
            }
            return;
        }
    }

    private PropertiesReader loadConfigurationResource(ResourceStreamSource resourceStreamSource, String configurationResource) throws IOException {
        return new PropertiesReader(resourceStreamSource, configurationResource);
    }

    private void addShowExplorationOptionsIfNotSpecified(IsisConfigurationDefault configuration) {
        if (configuration.getString("isis.exploration.show") == null) {
            configuration.add("isis.exploration.show", "yes");
        }
    }

    private void addSystemPropertiesIfRequested(IsisConfigurationDefault configuration) {
        if (this.includeSystemProperties) {
            this.addProperties(configuration, System.getProperties());
        }
    }

    private void addAdditionalProperties(IsisConfigurationDefault configuration) {
        this.addProperties(configuration, this.additionalProperties);
    }

    protected void addProperties(IsisConfigurationDefault configuration, Properties properties) {
        configuration.add(properties);
    }

    private void invalidateCache() {
        this.cachedConfiguration = null;
    }

    @Override
    public void injectInto(Object candidate) {
        if (IsisConfigurationBuilderAware.class.isAssignableFrom(candidate.getClass())) {
            IsisConfigurationBuilderAware cast = (IsisConfigurationBuilderAware)IsisConfigurationBuilderAware.class.cast(candidate);
            cast.setConfigurationBuilder(this);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("resourceStream", (Object)this.resourceStreamSource).add("configResources", this.configurationResources).toString();
    }

    static class ConfigurationResourceAndPolicy {
        private final String configurationResource;
        private final NotFoundPolicy notFoundPolicy;

        public ConfigurationResourceAndPolicy(String configurationResource, NotFoundPolicy notFoundPolicy) {
            this.configurationResource = configurationResource;
            this.notFoundPolicy = notFoundPolicy;
        }

        public String getConfigurationResource() {
            return this.configurationResource;
        }

        public NotFoundPolicy getNotFoundPolicy() {
            return this.notFoundPolicy;
        }

        public String toString() {
            return String.format("%s{%s}", new Object[]{this.configurationResource, this.notFoundPolicy});
        }
    }
}

