/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.File;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.HiveTableBaseTest;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestHiveCommits
extends HiveTableBaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuppressUnlockExceptions() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assert.assertEquals((long)2L, (long)ops.current().schema().columns().size());
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        ArgumentCaptor lockId = ArgumentCaptor.forClass(Long.class);
        ((HiveTableOperations)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)spyOps)).doUnlock(((Long)lockId.capture()).longValue());
        try {
            spyOps.commit(metadataV2, metadataV1);
        }
        finally {
            ops.doUnlock(((Long)lockId.getValue()).longValue());
        }
        ops.refresh();
        Assert.assertEquals((long)1L, (long)ops.current().schema().columns().size());
    }

    @Test
    public void testThriftExceptionUnknownStateIfNotInHistoryFailureOnCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assert.assertEquals((long)2L, (long)ops.current().schema().columns().size());
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        this.failCommitAndThrowException(spyOps);
        AssertHelpers.assertThrows((String)"We should assume commit state is unknown if the new location is not found in history in commit state check", CommitStateUnknownException.class, (String)"Datacenter on fire", () -> spyOps.commit(metadataV2, metadataV1));
        ops.refresh();
        Assert.assertEquals((String)"Current metadata should not have changed", (Object)metadataV2, (Object)ops.current());
        Assert.assertTrue((String)"Current metadata should still exist", (boolean)this.metadataFileExists(metadataV2));
        Assert.assertEquals((String)"New metadata files should still exist, new location not in history but the commit may still succeed", (long)3L, (long)this.metadataFileCount(ops.current()));
    }

    @Test
    public void testThriftExceptionSuccessOnCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assert.assertEquals((long)2L, (long)ops.current().schema().columns().size());
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        this.commitAndThrowException(ops, spyOps);
        spyOps.commit(metadataV2, metadataV1);
        ops.refresh();
        Assert.assertNotEquals((String)"Current metadata should have changed", (Object)metadataV2, (Object)ops.current());
        Assert.assertTrue((String)"Current metadata file should still exist", (boolean)this.metadataFileExists(ops.current()));
        Assert.assertEquals((String)"Commit should have been successful and new metadata file should be made", (long)3L, (long)this.metadataFileCount(ops.current()));
    }

    @Test
    public void testThriftExceptionUnknownFailedCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assert.assertEquals((long)2L, (long)ops.current().schema().columns().size());
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        this.failCommitAndThrowException(spyOps);
        this.breakFallbackCatalogCommitCheck(spyOps);
        AssertHelpers.assertThrows((String)"Should throw CommitStateUnknownException since the catalog check was blocked", CommitStateUnknownException.class, (String)"Datacenter on fire", () -> spyOps.commit(metadataV2, metadataV1));
        ops.refresh();
        Assert.assertEquals((String)"Current metadata should not have changed", (Object)metadataV2, (Object)ops.current());
        Assert.assertTrue((String)"Current metadata file should still exist", (boolean)this.metadataFileExists(ops.current()));
        Assert.assertEquals((String)"Client could not determine outcome so new metadata file should also exist", (long)3L, (long)this.metadataFileCount(ops.current()));
    }

    @Test
    public void testThriftExceptionsUnknownSuccessCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assert.assertEquals((long)2L, (long)ops.current().schema().columns().size());
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        this.commitAndThrowException(ops, spyOps);
        this.breakFallbackCatalogCommitCheck(spyOps);
        AssertHelpers.assertThrows((String)"Should throw CommitStateUnknownException since the catalog check was blocked", CommitStateUnknownException.class, (String)"Datacenter on fire", () -> spyOps.commit(metadataV2, metadataV1));
        ops.refresh();
        Assert.assertFalse((String)"Current metadata should have changed", (boolean)ops.current().equals(metadataV2));
        Assert.assertTrue((String)"Current metadata file should still exist", (boolean)this.metadataFileExists(ops.current()));
    }

    @Test
    public void testThriftExceptionConcurrentCommit() throws TException, InterruptedException, UnknownHostException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assert.assertEquals((long)2L, (long)ops.current().schema().columns().size());
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        AtomicLong lockId = new AtomicLong();
        ((HiveTableOperations)Mockito.doAnswer(i -> {
            lockId.set(ops.acquireLock());
            return lockId.get();
        }).when((Object)spyOps)).acquireLock();
        this.concurrentCommitAndThrowException(ops, spyOps, table, lockId);
        spyOps.commit(metadataV2, metadataV1);
        ops.refresh();
        Assert.assertNotEquals((String)"Current metadata should have changed", (Object)metadataV2, (Object)ops.current());
        Assert.assertTrue((String)"Current metadata file should still exist", (boolean)this.metadataFileExists(ops.current()));
        Assert.assertEquals((String)"The column addition from the concurrent commit should have been successful", (long)2L, (long)ops.current().schema().columns().size());
    }

    @Test
    public void testInvalidObjectException() {
        TableIdentifier badTi = TableIdentifier.of((String[])new String[]{"hivedb", "`tbl`"});
        Assert.assertThrows((String)String.format("Invalid table name for %s.%s", "hivedb", "`tbl`"), ValidationException.class, () -> catalog.createTable(badTi, schema, PartitionSpec.unpartitioned()));
    }

    @Test
    public void testAlreadyExistsException() {
        Assert.assertThrows((String)String.format("Table already exists: %s.%s", "hivedb", "tbl"), AlreadyExistsException.class, () -> catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned()));
    }

    private void commitAndThrowException(HiveTableOperations realOperations, HiveTableOperations spyOperations) throws TException, InterruptedException {
        ((HiveTableOperations)Mockito.doAnswer(i -> {
            org.apache.hadoop.hive.metastore.api.Table tbl = (org.apache.hadoop.hive.metastore.api.Table)i.getArgument(0, org.apache.hadoop.hive.metastore.api.Table.class);
            realOperations.persistTable(tbl, true);
            throw new TException("Datacenter on fire");
        }).when((Object)spyOperations)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Matchers.any(), Matchers.anyBoolean());
    }

    private void concurrentCommitAndThrowException(HiveTableOperations realOperations, HiveTableOperations spyOperations, Table table, AtomicLong lockId) throws TException, InterruptedException {
        ((HiveTableOperations)Mockito.doAnswer(i -> {
            org.apache.hadoop.hive.metastore.api.Table tbl = (org.apache.hadoop.hive.metastore.api.Table)i.getArgument(0, org.apache.hadoop.hive.metastore.api.Table.class);
            realOperations.persistTable(tbl, true);
            realOperations.doUnlock(lockId.get());
            table.refresh();
            table.updateSchema().addColumn("newCol", (Type)Types.IntegerType.get()).commit();
            throw new TException("Datacenter on fire");
        }).when((Object)spyOperations)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Matchers.any(), Matchers.anyBoolean());
    }

    private void failCommitAndThrowException(HiveTableOperations spyOperations) throws TException, InterruptedException {
        ((HiveTableOperations)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Datacenter on fire")}).when((Object)spyOperations)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Matchers.any(), Matchers.anyBoolean());
    }

    private void breakFallbackCatalogCommitCheck(HiveTableOperations spyOperations) {
        Mockito.when((Object)spyOperations.refresh()).thenThrow(new Throwable[]{new RuntimeException("Still on fire")});
    }

    private boolean metadataFileExists(TableMetadata metadata) {
        return new File(metadata.metadataFileLocation().replace("file:", "")).exists();
    }

    private int metadataFileCount(TableMetadata metadata) {
        return new File(metadata.metadataFileLocation().replace("file:", "")).getParentFile().listFiles(file -> file.getName().endsWith("metadata.json")).length;
    }
}

