/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class HiveMetastoreTest {
    protected static final String DB_NAME = "hivedb";
    protected static final long EVICTION_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    protected static HiveMetaStoreClient metastoreClient;
    protected static HiveCatalog catalog;
    protected static HiveConf hiveConf;
    protected static TestHiveMetastore metastore;

    @BeforeClass
    public static void startMetastore() throws Exception {
        metastore = new TestHiveMetastore();
        metastore.start();
        hiveConf = metastore.hiveConf();
        metastoreClient = new HiveMetaStoreClient(hiveConf);
        String dbPath = metastore.getDatabasePath(DB_NAME);
        Database db = new Database(DB_NAME, "description", dbPath, (Map)Maps.newHashMap());
        metastoreClient.createDatabase(db);
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client.pool.cache.eviction-interval-ms", (Object)String.valueOf(EVICTION_INTERVAL)), (Object)hiveConf);
    }

    @AfterClass
    public static void stopMetastore() throws Exception {
        catalog = null;
        metastoreClient.close();
        metastoreClient = null;
        metastore.stop();
        metastore = null;
    }
}

