/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.function.Consumer;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.iceberg.exceptions.ServiceUnavailableException;
import org.apache.iceberg.rest.responses.ErrorResponse;

public class ErrorHandlers {
    private ErrorHandlers() {
    }

    public static Consumer<ErrorResponse> namespaceErrorHandler() {
        return ErrorHandlers.baseNamespaceErrorHandler().andThen(ErrorHandlers.defaultErrorHandler());
    }

    public static Consumer<ErrorResponse> tableErrorHandler() {
        return ErrorHandlers.baseTableErrorHandler().andThen(ErrorHandlers.defaultErrorHandler());
    }

    public static Consumer<ErrorResponse> tableCommitHandler() {
        return ErrorHandlers.baseCommitErrorHandler().andThen(ErrorHandlers.defaultErrorHandler());
    }

    private static Consumer<ErrorResponse> baseCommitErrorHandler() {
        return error -> {
            switch (error.code()) {
                case 404: {
                    throw new NoSuchTableException("%s", new Object[]{error.message()});
                }
                case 409: {
                    throw new CommitFailedException("Commit failed: %s", new Object[]{error.message()});
                }
                case 500: 
                case 504: {
                    throw new CommitStateUnknownException((Throwable)new ServiceFailureException("Service failed: %s: %s", new Object[]{error.code(), error.message()}));
                }
            }
        };
    }

    private static Consumer<ErrorResponse> baseTableErrorHandler() {
        return error -> {
            switch (error.code()) {
                case 404: {
                    if (NoSuchNamespaceException.class.getSimpleName().equals(error.type())) {
                        throw new NoSuchNamespaceException("%s", new Object[]{error.message()});
                    }
                    throw new NoSuchTableException("%s", new Object[]{error.message()});
                }
                case 409: {
                    throw new AlreadyExistsException("%s", new Object[]{error.message()});
                }
            }
        };
    }

    private static Consumer<ErrorResponse> baseNamespaceErrorHandler() {
        return error -> {
            switch (error.code()) {
                case 404: {
                    throw new NoSuchNamespaceException("%s", new Object[]{error.message()});
                }
                case 409: {
                    throw new AlreadyExistsException("%s", new Object[]{error.message()});
                }
                case 422: {
                    throw new RESTException("Unable to process: %s", new Object[]{error.message()});
                }
            }
        };
    }

    public static Consumer<ErrorResponse> defaultErrorHandler() {
        return error -> {
            switch (error.code()) {
                case 400: {
                    throw new BadRequestException("Malformed request: %s", new Object[]{error.message()});
                }
                case 401: {
                    throw new NotAuthorizedException("Not authorized: %s", new Object[]{error.message()});
                }
                case 403: {
                    throw new ForbiddenException("Forbidden: %s", new Object[]{error.message()});
                }
                case 405: 
                case 406: {
                    break;
                }
                case 500: {
                    throw new ServiceFailureException("Server error: %s: %s", new Object[]{error.type(), error.message()});
                }
                case 501: {
                    throw new UnsupportedOperationException(error.message());
                }
                case 503: {
                    throw new ServiceUnavailableException("Service unavailable: %s", new Object[]{error.message()});
                }
            }
            throw new RESTException("Unable to process: %s", new Object[]{error.message()});
        };
    }
}

