/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.CharSequenceWrapper;

class SortedPosDeleteWriter<T>
implements FileWriter<PositionDelete<T>, DeleteWriteResult> {
    private static final long DEFAULT_RECORDS_NUM_THRESHOLD = 100000L;
    private final Map<CharSequenceWrapper, List<PosRow<T>>> posDeletes = Maps.newHashMap();
    private final List<DeleteFile> completedFiles = Lists.newArrayList();
    private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
    private final CharSequenceWrapper wrapper = CharSequenceWrapper.wrap(null);
    private final FileAppenderFactory<T> appenderFactory;
    private final OutputFileFactory fileFactory;
    private final FileFormat format;
    private final StructLike partition;
    private final long recordsNumThreshold;
    private int records = 0;
    private boolean closed = false;
    private Throwable failure;

    SortedPosDeleteWriter(FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileFormat format, StructLike partition, long recordsNumThreshold) {
        this.appenderFactory = appenderFactory;
        this.fileFactory = fileFactory;
        this.format = format;
        this.partition = partition;
        this.recordsNumThreshold = recordsNumThreshold;
    }

    SortedPosDeleteWriter(FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileFormat format, StructLike partition) {
        this(appenderFactory, fileFactory, format, partition, 100000L);
    }

    protected void setFailure(Throwable throwable) {
        if (this.failure == null) {
            this.failure = throwable;
        }
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement length");
    }

    @Override
    public void write(PositionDelete<T> payload) {
        this.delete(payload.path(), payload.pos(), payload.row());
    }

    public void delete(CharSequence path, long pos) {
        this.delete(path, pos, null);
    }

    public void delete(CharSequence path, long pos, T row) {
        List<PosRow<T>> posRows = this.posDeletes.get(this.wrapper.set(path));
        if (posRows != null) {
            posRows.add(PosRow.of(pos, row));
        } else {
            this.posDeletes.put(CharSequenceWrapper.wrap((CharSequence)path), Lists.newArrayList((Object[])new PosRow[]{PosRow.of(pos, row)}));
        }
        ++this.records;
        if ((long)this.records >= this.recordsNumThreshold) {
            this.flushDeletes();
        }
    }

    public List<DeleteFile> complete() throws IOException {
        this.close();
        Preconditions.checkState((this.failure == null ? 1 : 0) != 0, (String)"Cannot return results from failed writer", (Object)this.failure);
        return this.completedFiles;
    }

    public CharSequenceSet referencedDataFiles() {
        return this.referencedDataFiles;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.flushDeletes();
        }
    }

    @Override
    public DeleteWriteResult result() {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot get result from unclosed writer");
        return new DeleteWriteResult(this.completedFiles, this.referencedDataFiles);
    }

    private void flushDeletes() {
        if (this.posDeletes.isEmpty()) {
            return;
        }
        EncryptedOutputFile outputFile = this.partition == null ? this.fileFactory.newOutputFile() : this.fileFactory.newOutputFile(this.partition);
        PositionDeleteWriter writer = this.appenderFactory.newPosDeleteWriter(outputFile, this.format, this.partition);
        try (PositionDeleteWriter closeableWriter = writer;){
            ArrayList paths = Lists.newArrayListWithCapacity((int)this.posDeletes.keySet().size());
            for (CharSequenceWrapper charSequenceWrapper : this.posDeletes.keySet()) {
                paths.add(charSequenceWrapper.get());
            }
            paths.sort(Comparators.charSequences());
            for (CharSequence path : paths) {
                List<PosRow<PosRow>> positions = this.posDeletes.get(this.wrapper.set(path));
                positions.sort(Comparator.comparingLong(PosRow::pos));
                positions.forEach(posRow -> closeableWriter.delete(path, posRow.pos(), posRow.row()));
            }
        }
        catch (IOException e) {
            this.setFailure(e);
            throw new UncheckedIOException("Failed to write the sorted path/pos pairs to pos-delete file: " + outputFile.encryptingOutputFile().location(), e);
        }
        this.posDeletes.clear();
        this.records = 0;
        this.referencedDataFiles.addAll((Collection)writer.referencedDataFiles());
        this.completedFiles.add(writer.toDeleteFile());
    }

    private static class PosRow<R> {
        private final long pos;
        private final R row;

        static <R> PosRow<R> of(long pos, R row) {
            return new PosRow<R>(pos, row);
        }

        private PosRow(long pos, R row) {
            this.pos = pos;
            this.row = row;
        }

        long pos() {
            return this.pos;
        }

        R row() {
            return this.row;
        }
    }
}

