/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.FileIOMetricsContext;
import org.apache.iceberg.metrics.MetricsContext;

public class HadoopMetricsContext
implements FileIOMetricsContext {
    public static final String SCHEME = "io.metrics-scheme";
    private String scheme;
    private volatile transient FileSystem.Statistics statistics;

    public HadoopMetricsContext(String scheme) {
        ValidationException.check((scheme != null ? 1 : 0) != 0, (String)"Scheme is required for Hadoop FileSystem metrics reporting", (Object[])new Object[0]);
        this.scheme = scheme;
    }

    public void initialize(Map<String, String> properties) {
        this.scheme = properties.getOrDefault(SCHEME, this.scheme);
        this.statistics = FileSystem.getStatistics((String)this.scheme, null);
    }

    public <T extends Number> MetricsContext.Counter<T> counter(String name, Class<T> type, MetricsContext.Unit unit) {
        switch (name) {
            case "read.bytes": {
                ValidationException.check((type == Long.class ? 1 : 0) != 0, (String)"'%s' requires Long type", (Object[])new Object[]{"read.bytes"});
                return this.longCounter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementBytesRead(arg_0));
            }
            case "read.operations": {
                ValidationException.check((type == Integer.class ? 1 : 0) != 0, (String)"'%s' requires Integer type", (Object[])new Object[]{"read.operations"});
                return this.integerCounter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementReadOps(arg_0));
            }
            case "write.bytes": {
                ValidationException.check((type == Long.class ? 1 : 0) != 0, (String)"'%s' requires Long type", (Object[])new Object[]{"write.bytes"});
                return this.longCounter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementBytesWritten(arg_0));
            }
            case "write.operations": {
                ValidationException.check((type == Integer.class ? 1 : 0) != 0, (String)"'%s' requires Integer type", (Object[])new Object[]{"write.operations"});
                return this.integerCounter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementWriteOps(arg_0));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported counter: '%s'", name));
    }

    private MetricsContext.Counter<Long> longCounter(final Consumer<Long> consumer) {
        return new MetricsContext.Counter<Long>(){

            public void increment() {
                this.increment(1L);
            }

            public void increment(Long amount) {
                consumer.accept(amount);
            }
        };
    }

    private MetricsContext.Counter<Integer> integerCounter(final Consumer<Integer> consumer) {
        return new MetricsContext.Counter<Integer>(){

            public void increment() {
                this.increment(1);
            }

            public void increment(Integer amount) {
                consumer.accept(amount);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem.Statistics statistics() {
        if (this.statistics == null) {
            HadoopMetricsContext hadoopMetricsContext = this;
            synchronized (hadoopMetricsContext) {
                if (this.statistics == null) {
                    this.statistics = FileSystem.getStatistics((String)this.scheme, null);
                }
            }
        }
        return this.statistics;
    }
}

