/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SupportsPrefixOperations;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.util.SerializableSupplier;

public class HadoopFileIO
implements FileIO,
HadoopConfigurable,
SupportsPrefixOperations {
    private SerializableSupplier<Configuration> hadoopConf;

    public HadoopFileIO() {
    }

    public HadoopFileIO(Configuration hadoopConf) {
        this(new SerializableConfiguration(hadoopConf)::get);
    }

    public HadoopFileIO(SerializableSupplier<Configuration> hadoopConf) {
        this.hadoopConf = hadoopConf;
    }

    public Configuration conf() {
        return (Configuration)this.hadoopConf.get();
    }

    public InputFile newInputFile(String path) {
        return HadoopInputFile.fromLocation((CharSequence)path, (Configuration)this.hadoopConf.get());
    }

    public InputFile newInputFile(String path, long length) {
        return HadoopInputFile.fromLocation((CharSequence)path, length, (Configuration)this.hadoopConf.get());
    }

    public OutputFile newOutputFile(String path) {
        return HadoopOutputFile.fromPath(new Path(path), (Configuration)this.hadoopConf.get());
    }

    public void deleteFile(String path) {
        Path toDelete = new Path(path);
        FileSystem fs = Util.getFs(toDelete, (Configuration)this.hadoopConf.get());
        try {
            fs.delete(toDelete, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to delete file: %s", new Object[]{path});
        }
    }

    public Map<String, String> properties() {
        return ImmutableMap.of();
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = new SerializableConfiguration(conf)::get;
    }

    public Configuration getConf() {
        return (Configuration)this.hadoopConf.get();
    }

    @Override
    public void serializeConfWith(Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        this.hadoopConf = confSerializer.apply(this.getConf());
    }

    public Iterable<FileInfo> listPrefix(String prefix) {
        Path prefixToList = new Path(prefix);
        FileSystem fs = Util.getFs(prefixToList, (Configuration)this.hadoopConf.get());
        return () -> {
            try {
                return Streams.stream(new AdaptingIterator(fs.listFiles(prefixToList, true))).map(fileStatus -> new FileInfo(fileStatus.getPath().toString(), fileStatus.getLen(), fileStatus.getModificationTime())).iterator();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public void deletePrefix(String prefix) {
        Path prefixToDelete = new Path(prefix);
        FileSystem fs = Util.getFs(prefixToDelete, (Configuration)this.hadoopConf.get());
        try {
            fs.delete(prefixToDelete, true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class AdaptingIterator<E>
    implements Iterator<E>,
    RemoteIterator<E> {
        private final RemoteIterator<E> delegate;

        AdaptingIterator(RemoteIterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public E next() {
            try {
                return (E)this.delegate.next();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

