/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.transforms.PartitionSpecVisitor;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class Partitioning {
    private Partitioning() {
    }

    public static boolean hasBucketField(PartitionSpec spec) {
        List bucketList = PartitionSpecVisitor.visit((PartitionSpec)spec, (PartitionSpecVisitor)new PartitionSpecVisitor<Boolean>(){

            public Boolean identity(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean bucket(int fieldId, String sourceName, int sourceId, int width) {
                return true;
            }

            public Boolean truncate(int fieldId, String sourceName, int sourceId, int width) {
                return false;
            }

            public Boolean year(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean month(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean day(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean hour(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean alwaysNull(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            public Boolean unknown(int fieldId, String sourceName, int sourceId, String transform) {
                return false;
            }
        });
        return bucketList.stream().anyMatch(Boolean::booleanValue);
    }

    public static SortOrder sortOrderFor(PartitionSpec spec) {
        if (spec.isUnpartitioned()) {
            return SortOrder.unsorted();
        }
        SortOrder.Builder builder = SortOrder.builderFor((Schema)spec.schema());
        SpecToOrderVisitor converter = new SpecToOrderVisitor(builder);
        PartitionSpecVisitor.visit((PartitionSpec)spec, (PartitionSpecVisitor)converter);
        String bucketColumn = converter.bucketColumn();
        if (bucketColumn != null) {
            builder.asc(bucketColumn);
        }
        return builder.build();
    }

    public static Types.StructType partitionType(Table table) {
        List<Transform<?, ?>> unknownTransforms = Partitioning.collectUnknownTransforms(table);
        ValidationException.check((boolean)unknownTransforms.isEmpty(), (String)"Cannot build table partition type, unknown transforms: %s", (Object[])new Object[]{unknownTransforms});
        if (table.specs().size() == 1) {
            return table.spec().partitionType();
        }
        HashMap fieldMap = Maps.newHashMap();
        HashMap typeMap = Maps.newHashMap();
        HashMap nameMap = Maps.newHashMap();
        List specIds = table.specs().keySet().stream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
        for (Integer specId : specIds) {
            PartitionSpec spec = (PartitionSpec)table.specs().get(specId);
            for (PartitionField field : spec.fields()) {
                int fieldId2 = field.fieldId();
                Types.NestedField structField = spec.partitionType().field(fieldId2);
                PartitionField existingField = (PartitionField)fieldMap.get(fieldId2);
                if (existingField == null) {
                    fieldMap.put(fieldId2, field);
                    typeMap.put(fieldId2, structField.type());
                    nameMap.put(fieldId2, structField.name());
                    continue;
                }
                ValidationException.check((boolean)Partitioning.equivalentIgnoringNames(field, existingField), (String)"Conflicting partition fields: ['%s', '%s']", (Object[])new Object[]{field, existingField});
                if (!Partitioning.isVoidTransform(existingField) || Partitioning.isVoidTransform(field)) continue;
                fieldMap.put(fieldId2, field);
                typeMap.put(fieldId2, structField.type());
            }
        }
        List sortedStructFields = fieldMap.keySet().stream().sorted(Comparator.naturalOrder()).map(fieldId -> Types.NestedField.optional((int)fieldId, (String)((String)nameMap.get(fieldId)), (Type)((Type)typeMap.get(fieldId)))).collect(Collectors.toList());
        return Types.StructType.of(sortedStructFields);
    }

    private static boolean isVoidTransform(PartitionField field) {
        return field.transform().equals(Transforms.alwaysNull());
    }

    private static List<Transform<?, ?>> collectUnknownTransforms(Table table) {
        ArrayList unknownTransforms = Lists.newArrayList();
        table.specs().values().forEach(spec -> spec.fields().stream().map(PartitionField::transform).filter(transform -> transform instanceof UnknownTransform).forEach(unknownTransforms::add));
        return unknownTransforms;
    }

    private static boolean equivalentIgnoringNames(PartitionField field, PartitionField anotherField) {
        return field.fieldId() == anotherField.fieldId() && field.sourceId() == anotherField.sourceId() && Partitioning.compatibleTransforms(field.transform(), anotherField.transform());
    }

    private static boolean compatibleTransforms(Transform<?, ?> t1, Transform<?, ?> t2) {
        return t1.equals(t2) || t1.equals((Object)Transforms.alwaysNull()) || t2.equals((Object)Transforms.alwaysNull());
    }

    private static class SpecToOrderVisitor
    implements PartitionSpecVisitor<Void> {
        private final SortOrder.Builder builder;
        private String bucketColumn = null;
        private int highestNumBuckets = 0;

        private SpecToOrderVisitor(SortOrder.Builder builder) {
            this.builder = builder;
        }

        String bucketColumn() {
            return this.bucketColumn;
        }

        public Void identity(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(sourceName);
            return null;
        }

        public Void bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
            if (numBuckets > this.highestNumBuckets) {
                this.highestNumBuckets = numBuckets;
                this.bucketColumn = sourceName;
            }
            this.builder.asc((Term)Expressions.bucket((String)sourceName, (int)numBuckets));
            return null;
        }

        public Void truncate(int fieldId, String sourceName, int sourceId, int width) {
            this.builder.asc((Term)Expressions.truncate((String)sourceName, (int)width));
            return null;
        }

        public Void year(int fieldId, String sourceName, int sourceId) {
            this.builder.asc((Term)Expressions.year((String)sourceName));
            return null;
        }

        public Void month(int fieldId, String sourceName, int sourceId) {
            this.builder.asc((Term)Expressions.month((String)sourceName));
            return null;
        }

        public Void day(int fieldId, String sourceName, int sourceId) {
            this.builder.asc((Term)Expressions.day((String)sourceName));
            return null;
        }

        public Void hour(int fieldId, String sourceName, int sourceId) {
            this.builder.asc((Term)Expressions.hour((String)sourceName));
            return null;
        }

        public Void alwaysNull(int fieldId, String sourceName, int sourceId) {
            return null;
        }
    }
}

