/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface TxnStore {
    public static final String INITIATED_RESPONSE = "initiated";
    public static final String WORKING_RESPONSE = "working";
    public static final String CLEANING_RESPONSE = "ready for cleaning";
    public static final String FAILED_RESPONSE = "failed";
    public static final String SUCCEEDED_RESPONSE = "succeeded";
    public static final String ATTEMPTED_RESPONSE = "attempted";
    public static final int TIMED_OUT_TXN_ABORT_BATCH_SIZE = 1000;

    public void setConf(HiveConf var1);

    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException;

    public GetOpenTxnsResponse getOpenTxns() throws MetaException;

    public void countOpenTxns() throws MetaException;

    public OpenTxnsResponse openTxns(OpenTxnRequest var1) throws MetaException;

    public void abortTxn(AbortTxnRequest var1) throws NoSuchTxnException, MetaException;

    public void abortTxns(AbortTxnsRequest var1) throws NoSuchTxnException, MetaException;

    public void commitTxn(CommitTxnRequest var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    public LockResponse lock(LockRequest var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    public LockResponse checkLock(CheckLockRequest var1) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException;

    public void unlock(UnlockRequest var1) throws NoSuchLockException, TxnOpenException, MetaException;

    public ShowLocksResponse showLocks(ShowLocksRequest var1) throws MetaException;

    public void heartbeat(HeartbeatRequest var1) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException;

    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest var1) throws MetaException;

    public long compact(CompactionRequest var1) throws MetaException;

    public ShowCompactResponse showCompact(ShowCompactRequest var1) throws MetaException;

    public void addDynamicPartitions(AddDynamicPartitions var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    public void cleanupRecords(HiveObjectType var1, Database var2, Table var3, Iterator<Partition> var4) throws MetaException;

    public void performTimeOuts();

    public Set<CompactionInfo> findPotentialCompactions(int var1) throws MetaException;

    public void setRunAs(long var1, String var3) throws MetaException;

    public CompactionInfo findNextToCompact(String var1) throws MetaException;

    public void markCompacted(CompactionInfo var1) throws MetaException;

    public List<CompactionInfo> findReadyToClean() throws MetaException;

    public void markCleaned(CompactionInfo var1) throws MetaException;

    public void markFailed(CompactionInfo var1) throws MetaException;

    public void cleanEmptyAbortedTxns() throws MetaException;

    public void revokeFromLocalWorkers(String var1) throws MetaException;

    public void revokeTimedoutWorkers(long var1) throws MetaException;

    public List<String> findColumnsWithStats(CompactionInfo var1) throws MetaException;

    public void setCompactionHighestTxnId(CompactionInfo var1, long var2) throws MetaException;

    public void purgeCompactionHistory() throws MetaException;

    public void performWriteSetGC();

    public boolean checkFailedCompactions(CompactionInfo var1) throws MetaException;

    @VisibleForTesting
    public int numLocksInLockTable() throws SQLException, MetaException;

    @VisibleForTesting
    public long setTimeout(long var1);

    public MutexAPI getMutexAPI();

    public static interface MutexAPI {
        public LockHandle acquireLock(String var1) throws MetaException;

        public void acquireLock(String var1, LockHandle var2) throws MetaException;

        public static interface LockHandle {
            public void releaseLocks();
        }
    }

    public static enum MUTEX_KEY {
        Initiator,
        Cleaner,
        HouseKeeper,
        CompactionHistory,
        CheckLock,
        WriteSetCleaner;

    }
}

