/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.txn.compactor.HouseKeeperServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidOpenTxnsCounterService
extends HouseKeeperServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(AcidOpenTxnsCounterService.class);

    @Override
    protected long getStartDelayMs() {
        return 100L;
    }

    @Override
    protected long getIntervalMs() {
        return this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_COUNT_OPEN_TXNS_INTERVAL, TimeUnit.MILLISECONDS);
    }

    @Override
    protected Runnable getScheduedAction(HiveConf hiveConf, AtomicInteger isAliveCounter) {
        return new OpenTxnsCounter(hiveConf, isAliveCounter);
    }

    @Override
    public String getServiceDescription() {
        return "Count number of open transactions";
    }

    private static final class OpenTxnsCounter
    implements Runnable {
        private final TxnStore txnHandler;
        private final AtomicInteger isAliveCounter;

        private OpenTxnsCounter(HiveConf hiveConf, AtomicInteger isAliveCounter) {
            this.txnHandler = TxnUtils.getTxnStore(hiveConf);
            this.isAliveCounter = isAliveCounter;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                this.txnHandler.countOpenTxns();
                int count = this.isAliveCounter.incrementAndGet();
                LOG.info("OpenTxnsCounter ran for " + (System.currentTimeMillis() - startTime) / 1000L + "seconds.  isAliveCounter=" + count);
            }
            catch (Throwable t) {
                LOG.error("Serious error in {}", new Object[]{Thread.currentThread().getName(), ": {}" + t.getMessage(), t});
            }
        }
    }
}

