/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Stacks;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRexUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveReduceExpressionsRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveReduceExpressionsRule.class);
    public static final Pattern EXCLUSION_PATTERN = Pattern.compile("Reduce(Expressions|Values)Rule.*");
    public static final HiveReduceExpressionsRule FILTER_INSTANCE = new FilterReduceExpressionsRule(HiveFilter.class, HiveRelFactories.HIVE_BUILDER);
    public static final HiveReduceExpressionsRule PROJECT_INSTANCE = new ProjectReduceExpressionsRule(HiveProject.class, HiveRelFactories.HIVE_BUILDER);
    public static final HiveReduceExpressionsRule JOIN_INSTANCE = new JoinReduceExpressionsRule(HiveJoin.class, HiveRelFactories.HIVE_BUILDER);

    protected HiveReduceExpressionsRule(Class<? extends RelNode> clazz, RelBuilderFactory relBuilderFactory, String desc) {
        super(HiveReduceExpressionsRule.operand(clazz, (RelOptRuleOperandChildren)HiveReduceExpressionsRule.any()), relBuilderFactory, desc);
    }

    protected static boolean reduceExpressions(RelNode rel, List<RexNode> expList, RelOptPredicateList predicates) {
        return HiveReduceExpressionsRule.reduceExpressions(rel, expList, predicates, false);
    }

    protected static boolean reduceExpressions(RelNode rel, List<RexNode> expList, RelOptPredicateList predicates, boolean unknownAsFalse) {
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        boolean reduced = HiveReduceExpressionsRule.reduceExpressionsInternal(rel, expList, predicates);
        HiveRexUtil.ExprSimplifier simplifier = new HiveRexUtil.ExprSimplifier(rexBuilder, unknownAsFalse);
        ArrayList<RexNode> expList2 = Lists.newArrayList(expList);
        simplifier.mutate(expList2);
        boolean simplified = false;
        for (int i = 0; i < expList.size(); ++i) {
            if (((RexNode)expList2.get(i)).toString().equals(expList.get(i).toString())) continue;
            expList.remove(i);
            expList.add(i, (RexNode)expList2.get(i));
            simplified = true;
        }
        return reduced || simplified;
    }

    protected static boolean reduceExpressionsInternal(RelNode rel, List<RexNode> expList, RelOptPredicateList predicates) {
        RelOptPlanner.Executor executor;
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        new CaseShuttle().mutate(expList);
        ArrayList<RexNode> constExps = Lists.newArrayList();
        List<Boolean> addCasts = Lists.newArrayList();
        ArrayList<RexNode> removableCasts = Lists.newArrayList();
        ImmutableMap<RexNode, RexNode> constants = HiveReduceExpressionsRule.predicateConstants(RexNode.class, rexBuilder, predicates);
        HiveReduceExpressionsRule.findReducibleExps(rel.getCluster().getTypeFactory(), expList, constants, constExps, addCasts, removableCasts);
        if (constExps.isEmpty() && removableCasts.isEmpty()) {
            return false;
        }
        if (!removableCasts.isEmpty()) {
            ArrayList<RexNode> reducedExprs = Lists.newArrayList();
            for (RexNode exp : removableCasts) {
                RexCall call = (RexCall)exp;
                reducedExprs.add((RexNode)call.getOperands().get(0));
            }
            RexReplacer replacer = new RexReplacer(rexBuilder, removableCasts, reducedExprs, Collections.nCopies(removableCasts.size(), false));
            replacer.mutate(expList);
        }
        if (constExps.isEmpty()) {
            return true;
        }
        ArrayList<RexNode> constExps2 = Lists.newArrayList(constExps);
        if (!constants.isEmpty()) {
            ArrayList pairs = Lists.newArrayList(constants.entrySet());
            RexReplacer replacer = new RexReplacer(rexBuilder, Pair.left(pairs), Pair.right(pairs), Collections.nCopies(pairs.size(), false));
            replacer.mutate(constExps2);
        }
        if ((executor = rel.getCluster().getPlanner().getExecutor()) == null) {
            return false;
        }
        ArrayList<RexNode> reducedValues = Lists.newArrayList();
        executor.reduce(rexBuilder, constExps2, reducedValues);
        if (Lists.transform(constExps, HiveCalciteUtil.REX_STR_FN).equals(Lists.transform(reducedValues, HiveCalciteUtil.REX_STR_FN))) {
            return false;
        }
        if (rel instanceof Project) {
            addCasts = Collections.nCopies(reducedValues.size(), true);
        }
        RexReplacer replacer = new RexReplacer(rexBuilder, constExps, reducedValues, addCasts);
        replacer.mutate(expList);
        return true;
    }

    protected static void findReducibleExps(RelDataTypeFactory typeFactory, List<RexNode> exps, ImmutableMap<RexNode, RexNode> constants, List<RexNode> constExps, List<Boolean> addCasts, List<RexNode> removableCasts) {
        ReducibleExprLocator gardener = new ReducibleExprLocator(typeFactory, constants, constExps, addCasts, removableCasts);
        for (RexNode exp : exps) {
            gardener.analyze(exp);
        }
        assert (constExps.size() == addCasts.size());
    }

    public static <C extends RexNode> ImmutableMap<RexNode, C> predicateConstants(Class<C> clazz, RexBuilder rexBuilder, RelOptPredicateList predicates) {
        HashMap map = new HashMap();
        HashSet<RexNode> excludeSet = new HashSet<RexNode>();
        for (RexNode predicate : predicates.pulledUpPredicates) {
            HiveReduceExpressionsRule.gatherConstraints(clazz, predicate, map, excludeSet, rexBuilder);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            RexNode rexNode = (RexNode)entry.getKey();
            if (HiveReduceExpressionsRule.overlap(rexNode, excludeSet)) continue;
            builder.put(rexNode, entry.getValue());
        }
        return builder.build();
    }

    private static <C extends RexNode> void gatherConstraints(Class<C> clazz, RexNode predicate, Map<RexNode, C> map, Set<RexNode> excludeSet, RexBuilder rexBuilder) {
        RexNode right;
        RexNode left;
        if (predicate.getKind() != SqlKind.EQUALS && predicate.getKind() != SqlKind.IS_NULL) {
            HiveReduceExpressionsRule.decompose(excludeSet, predicate);
            return;
        }
        List operands = ((RexCall)predicate).getOperands();
        if (operands.size() != 2 && predicate.getKind() == SqlKind.EQUALS) {
            HiveReduceExpressionsRule.decompose(excludeSet, predicate);
            return;
        }
        if (predicate.getKind() == SqlKind.EQUALS) {
            left = (RexNode)operands.get(0);
            right = (RexNode)operands.get(1);
        } else {
            left = (RexNode)operands.get(0);
            right = rexBuilder.makeNullLiteral(left.getType().getSqlTypeName());
        }
        HiveReduceExpressionsRule.gatherConstraint(clazz, left, right, map, excludeSet, rexBuilder);
        HiveReduceExpressionsRule.gatherConstraint(clazz, right, left, map, excludeSet, rexBuilder);
    }

    private static boolean canAssignFrom(RelDataType type1, RelDataType type2) {
        SqlTypeName name1 = type1.getSqlTypeName();
        SqlTypeName name2 = type2.getSqlTypeName();
        if (name1.getFamily() == name2.getFamily()) {
            switch (name1.getFamily()) {
                case NUMERIC: {
                    return name1.compareTo((Enum)name2) >= 0;
                }
            }
            return true;
        }
        return false;
    }

    private static <C extends RexNode> void gatherConstraint(Class<C> clazz, RexNode left, RexNode right, Map<RexNode, C> map, Set<RexNode> excludeSet, RexBuilder rexBuilder) {
        if (!clazz.isInstance(right)) {
            return;
        }
        if (!RexUtil.isConstant((RexNode)right)) {
            return;
        }
        RexNode constant = (RexNode)clazz.cast(right);
        if (excludeSet.contains(left)) {
            return;
        }
        RexNode existedValue = (RexNode)map.get(left);
        if (existedValue == null) {
            switch (left.getKind()) {
                case CAST: {
                    RexNode castRight;
                    RexNode operand = (RexNode)((RexCall)left).getOperands().get(0);
                    if (!HiveReduceExpressionsRule.canAssignFrom(left.getType(), operand.getType()) || !((castRight = rexBuilder.makeCast(operand.getType(), constant)) instanceof RexLiteral)) break;
                    left = operand;
                    constant = (RexNode)clazz.cast(castRight);
                }
            }
            map.put(left, constant);
        } else if (existedValue instanceof RexLiteral && constant instanceof RexLiteral && !((RexLiteral)existedValue).getValue().equals(((RexLiteral)constant).getValue())) {
            map.remove(left);
            excludeSet.add(left);
        }
    }

    private static boolean overlap(RexNode rexNode, Set<RexNode> set) {
        if (rexNode instanceof RexCall) {
            for (RexNode r : ((RexCall)rexNode).getOperands()) {
                if (!HiveReduceExpressionsRule.overlap(r, set)) continue;
                return true;
            }
            return false;
        }
        return set.contains(rexNode);
    }

    private static void decompose(Set<RexNode> set, RexNode rexNode) {
        if (rexNode instanceof RexCall) {
            for (RexNode r : ((RexCall)rexNode).getOperands()) {
                HiveReduceExpressionsRule.decompose(set, r);
            }
        } else if (!(rexNode instanceof RexLiteral)) {
            set.add(rexNode);
        }
    }

    protected static RexCall pushPredicateIntoCase(RexCall call) {
        if (call.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
            return call;
        }
        switch (call.getKind()) {
            case CASE: 
            case AND: 
            case OR: {
                return call;
            }
        }
        int caseOrdinal = -1;
        List operands = call.getOperands();
        for (int i = 0; i < operands.size(); ++i) {
            RexNode operand = (RexNode)operands.get(i);
            switch (operand.getKind()) {
                case CASE: {
                    caseOrdinal = i;
                }
            }
        }
        if (caseOrdinal < 0) {
            return call;
        }
        RexCall case_ = (RexCall)operands.get(caseOrdinal);
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        for (int i = 0; i < case_.getOperands().size(); ++i) {
            RexNode node = (RexNode)case_.getOperands().get(i);
            if (!RexUtil.isCasePredicate((RexCall)case_, (int)i)) {
                node = HiveReduceExpressionsRule.substitute(call, caseOrdinal, node);
            }
            nodes.add(node);
        }
        return case_.clone(call.getType(), nodes);
    }

    protected static RexNode substitute(RexCall call, int ordinal, RexNode node) {
        ArrayList<RexNode> newOperands = Lists.newArrayList(call.getOperands());
        newOperands.set(ordinal, node);
        return call.clone(call.getType(), newOperands);
    }

    protected static class CaseShuttle
    extends RexShuttle {
        protected CaseShuttle() {
        }

        public RexNode visitCall(RexCall call) {
            RexCall old;
            do {
                old = call = (RexCall)super.visitCall(call);
            } while ((call = HiveReduceExpressionsRule.pushPredicateIntoCase(call)) != old);
            return call;
        }
    }

    protected static class ReducibleExprLocator
    extends RexVisitorImpl<Void> {
        private final RelDataTypeFactory typeFactory;
        private final List<Constancy> stack;
        private final ImmutableMap<RexNode, RexNode> constants;
        private final List<RexNode> constExprs;
        private final List<Boolean> addCasts;
        private final List<RexNode> removableCasts;
        private final List<SqlOperator> parentCallTypeStack;

        ReducibleExprLocator(RelDataTypeFactory typeFactory, ImmutableMap<RexNode, RexNode> constants, List<RexNode> constExprs, List<Boolean> addCasts, List<RexNode> removableCasts) {
            super(true);
            this.typeFactory = typeFactory;
            this.constants = constants;
            this.constExprs = constExprs;
            this.addCasts = addCasts;
            this.removableCasts = removableCasts;
            this.stack = Lists.newArrayList();
            this.parentCallTypeStack = Lists.newArrayList();
        }

        public void analyze(RexNode exp) {
            assert (this.stack.isEmpty());
            exp.accept((RexVisitor)this);
            assert (this.stack.size() == 1);
            assert (this.parentCallTypeStack.isEmpty());
            Constancy rootConstancy = this.stack.get(0);
            if (rootConstancy == Constancy.REDUCIBLE_CONSTANT) {
                this.addResult(exp);
            }
            this.stack.clear();
        }

        private Void pushVariable() {
            this.stack.add(Constancy.NON_CONSTANT);
            return null;
        }

        private void addResult(RexNode exp) {
            RexCall cast;
            RexNode operand;
            if (exp.getKind() == SqlKind.CAST && (operand = (RexNode)(cast = (RexCall)exp).getOperands().get(0)) instanceof RexLiteral) {
                return;
            }
            this.constExprs.add(exp);
            if (this.parentCallTypeStack.isEmpty()) {
                this.addCasts.add(false);
            } else {
                this.addCasts.add(this.isUdf((SqlOperator)Stacks.peek(this.parentCallTypeStack)));
            }
        }

        private Boolean isUdf(SqlOperator operator) {
            return false;
        }

        public Void visitInputRef(RexInputRef inputRef) {
            if (this.constants.containsKey(inputRef)) {
                this.stack.add(Constancy.REDUCIBLE_CONSTANT);
                return null;
            }
            return this.pushVariable();
        }

        public Void visitLiteral(RexLiteral literal) {
            this.stack.add(Constancy.IRREDUCIBLE_CONSTANT);
            return null;
        }

        public Void visitOver(RexOver over) {
            this.analyzeCall((RexCall)over, Constancy.NON_CONSTANT);
            return null;
        }

        public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.pushVariable();
        }

        public Void visitCall(RexCall call) {
            this.analyzeCall(call, Constancy.REDUCIBLE_CONSTANT);
            return null;
        }

        private void analyzeCall(RexCall call, Constancy callConstancy) {
            Stacks.push(this.parentCallTypeStack, (Object)call.getOperator());
            super.visitCall(call);
            int operandCount = call.getOperands().size();
            List operandStack = Util.last(this.stack, (int)operandCount);
            for (Constancy operandConstancy : operandStack) {
                if (operandConstancy != Constancy.NON_CONSTANT) continue;
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (!call.getOperator().isDeterministic()) {
                callConstancy = Constancy.NON_CONSTANT;
            } else if (call.getOperator().isDynamicFunction()) {
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (callConstancy == Constancy.REDUCIBLE_CONSTANT && call.getOperator() instanceof SqlRowOperator) {
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (callConstancy == Constancy.NON_CONSTANT) {
                for (int iOperand = 0; iOperand < operandCount; ++iOperand) {
                    Constancy constancy = (Constancy)((Object)operandStack.get(iOperand));
                    if (constancy != Constancy.REDUCIBLE_CONSTANT) continue;
                    this.addResult((RexNode)call.getOperands().get(iOperand));
                }
                if (call.getOperator() == SqlStdOperatorTable.CAST) {
                    this.reduceCasts(call);
                }
            }
            operandStack.clear();
            Stacks.pop(this.parentCallTypeStack, (Object)call.getOperator());
            this.stack.add(callConstancy);
        }

        private void reduceCasts(RexCall outerCast) {
            RelDataType innerTypeNullable;
            List operands = outerCast.getOperands();
            if (operands.size() != 1) {
                return;
            }
            RelDataType outerCastType = outerCast.getType();
            RelDataType operandType = ((RexNode)operands.get(0)).getType();
            if (operandType.equals(outerCastType)) {
                this.removableCasts.add((RexNode)outerCast);
                return;
            }
            if (!(operands.get(0) instanceof RexCall)) {
                return;
            }
            RexCall innerCast = (RexCall)operands.get(0);
            if (innerCast.getOperator() != SqlStdOperatorTable.CAST) {
                return;
            }
            if (innerCast.getOperands().size() != 1) {
                return;
            }
            RelDataType outerTypeNullable = this.typeFactory.createTypeWithNullability(outerCastType, true);
            if (outerTypeNullable != (innerTypeNullable = this.typeFactory.createTypeWithNullability(operandType, true))) {
                return;
            }
            if (operandType.isNullable()) {
                this.removableCasts.add((RexNode)innerCast);
            }
        }

        public Void visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.pushVariable();
        }

        public Void visitRangeRef(RexRangeRef rangeRef) {
            return this.pushVariable();
        }

        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.pushVariable();
        }

        static enum Constancy {
            NON_CONSTANT,
            REDUCIBLE_CONSTANT,
            IRREDUCIBLE_CONSTANT;

        }
    }

    protected static class RexReplacer
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final List<RexNode> reducibleExps;
        private final List<RexNode> reducedValues;
        private final List<Boolean> addCasts;

        RexReplacer(RexBuilder rexBuilder, List<RexNode> reducibleExps, List<RexNode> reducedValues, List<Boolean> addCasts) {
            this.rexBuilder = rexBuilder;
            this.reducibleExps = reducibleExps;
            this.reducedValues = reducedValues;
            this.addCasts = addCasts;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            RexNode node = this.visit((RexNode)inputRef);
            if (node == null) {
                return super.visitInputRef(inputRef);
            }
            return node;
        }

        public RexNode visitCall(RexCall call) {
            RexNode node = this.visit((RexNode)call);
            if (node != null) {
                return node;
            }
            node = super.visitCall(call);
            if (node != call) {
                node = HiveRexUtil.simplify(this.rexBuilder, node);
            }
            return node;
        }

        private RexNode visit(RexNode call) {
            int i = this.reducibleExps.indexOf(call);
            if (i == -1) {
                return null;
            }
            RexNode replacement = this.reducedValues.get(i);
            if (this.addCasts.get(i).booleanValue() && replacement.getType() != call.getType()) {
                replacement = this.rexBuilder.makeAbstractCast(call.getType(), replacement);
            }
            return replacement;
        }
    }

    public static class JoinReduceExpressionsRule
    extends HiveReduceExpressionsRule {
        public JoinReduceExpressionsRule(Class<? extends HiveJoin> joinClass, RelBuilderFactory relBuilderFactory) {
            super(joinClass, relBuilderFactory, "HiveReduceExpressionsRule(HiveJoin)");
        }

        public void onMatch(RelOptRuleCall call) {
            RelOptPredicateList rightPredicates;
            HiveJoin join = (HiveJoin)call.rel(0);
            ArrayList<RexNode> expList = Lists.newArrayList(join.getCondition());
            int fieldCount = join.getLeft().getRowType().getFieldCount();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList leftPredicates = mq.getPulledUpPredicates(join.getLeft());
            RelOptPredicateList predicates = leftPredicates.union((rightPredicates = mq.getPulledUpPredicates(join.getRight())).shift(fieldCount));
            if (!JoinReduceExpressionsRule.reduceExpressions(join, expList, predicates)) {
                return;
            }
            JoinInfo joinInfo = JoinInfo.of((RelNode)join.getLeft(), (RelNode)join.getRight(), (RexNode)((RexNode)expList.get(0)));
            if (!joinInfo.isEqui()) {
                return;
            }
            call.transformTo((RelNode)join.copy(join.getTraitSet(), (RexNode)expList.get(0), join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone()));
            call.getPlanner().setImportance((RelNode)join, 0.0);
        }
    }

    public static class ProjectReduceExpressionsRule
    extends HiveReduceExpressionsRule {
        public ProjectReduceExpressionsRule(Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
            super(projectClass, relBuilderFactory, "HiveReduceExpressionsRule(Project)");
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            RelOptPredicateList predicates = RelMetadataQuery.instance().getPulledUpPredicates(project.getInput());
            ArrayList<RexNode> expList = Lists.newArrayList(project.getProjects());
            if (ProjectReduceExpressionsRule.reduceExpressions((RelNode)project, expList, predicates)) {
                RelNode newProject = call.builder().push(project.getInput()).project(expList, (Iterable)project.getRowType().getFieldNames()).build();
                call.transformTo(newProject);
                call.getPlanner().setImportance((RelNode)project, 0.0);
            }
        }
    }

    public static class FilterReduceExpressionsRule
    extends HiveReduceExpressionsRule {
        public FilterReduceExpressionsRule(Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory) {
            super(filterClass, relBuilderFactory, "HiveReduceExpressionsRule(Filter)");
        }

        public void onMatch(RelOptRuleCall call) {
            boolean reduced;
            RexNode newConditionExp;
            RelOptPredicateList predicates;
            ArrayList<RexNode> expList;
            Filter filter = (Filter)call.rel(0);
            if (FilterReduceExpressionsRule.reduceExpressions((RelNode)filter, expList = Lists.newArrayList(filter.getCondition()), predicates = RelMetadataQuery.instance().getPulledUpPredicates(filter.getInput()), true)) {
                assert (expList.size() == 1);
                newConditionExp = (RexNode)expList.get(0);
                reduced = true;
            } else {
                newConditionExp = filter.getCondition();
                reduced = false;
            }
            if (newConditionExp.isAlwaysTrue()) {
                call.transformTo(filter.getInput());
            } else if (reduced) {
                call.transformTo(call.builder().push(filter.getInput()).filter(new RexNode[]{newConditionExp}).build());
            } else {
                return;
            }
            call.getPlanner().setImportance((RelNode)filter, 0.0);
        }
    }
}

