/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.orc.CompressionCodec;
import org.apache.orc.FileMetaInfo;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.StripeStatistics;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.InStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderImpl
extends org.apache.orc.impl.ReaderImpl
implements Reader {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderImpl.class);
    private static final int DIRECTORY_SIZE_GUESS = 16384;
    private final ObjectInspector inspector;
    private ByteBuffer footerByteBuffer;
    private ByteBuffer footerMetaAndPsBuffer;

    @Override
    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    @Override
    public CompressionKind getCompression() {
        for (CompressionKind value : CompressionKind.values()) {
            if (value.getUnderlying() != this.compressionKind) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown compression kind " + (Object)((Object)this.compressionKind));
    }

    public ReaderImpl(Path path, OrcFile.ReaderOptions options) throws IOException {
        super(path, options);
        FileMetadata fileMetadata = options.getFileMetadata();
        if (fileMetadata != null) {
            this.inspector = OrcStruct.createObjectInspector(0, fileMetadata.getTypes());
        } else {
            FileMetaInfo footerMetaData = options.getFileMetaInfo() != null ? options.getFileMetaInfo() : ReaderImpl.extractMetaInfoFromFooter(this.fileSystem, path, options.getMaxLength());
            this.footerMetaAndPsBuffer = footerMetaData.footerMetaAndPsBuffer;
            MetaInfoObjExtractor rInfo = new MetaInfoObjExtractor(footerMetaData.compressionType, footerMetaData.bufferSize, footerMetaData.metadataSize, footerMetaData.footerBuffer);
            this.footerByteBuffer = footerMetaData.footerBuffer;
            this.inspector = rInfo.inspector;
        }
    }

    public static FooterInfo extractMetaInfoFromFooter(ByteBuffer bb, Path srcPath) throws IOException {
        int baseOffset = bb.position();
        int lastByteAbsPos = baseOffset + bb.remaining() - 1;
        int psLen = bb.get(lastByteAbsPos) & 0xFF;
        int psAbsPos = lastByteAbsPos - psLen;
        OrcProto.PostScript ps = ReaderImpl.extractPostScript(bb, srcPath, psLen, psAbsPos);
        assert (baseOffset == bb.position());
        int footerSize = (int)ps.getFooterLength();
        int metadataSize = (int)ps.getMetadataLength();
        int footerAbsPos = psAbsPos - footerSize;
        int metadataAbsPos = footerAbsPos - metadataSize;
        String compressionType = ps.getCompression().toString();
        CompressionCodec codec = WriterImpl.createCodec(org.apache.orc.CompressionKind.valueOf(compressionType));
        int bufferSize = (int)ps.getCompressionBlockSize();
        bb.position(metadataAbsPos);
        bb.mark();
        OrcProto.Metadata metadata = ReaderImpl.extractMetadata(bb, metadataAbsPos, metadataSize, codec, bufferSize);
        ArrayList<StripeStatistics> stats = new ArrayList<StripeStatistics>(metadata.getStripeStatsCount());
        for (OrcProto.StripeStatistics ss : metadata.getStripeStatsList()) {
            stats.add(new StripeStatistics(ss.getColStatsList()));
        }
        OrcProto.Footer footer = ReaderImpl.extractFooter(bb, footerAbsPos, footerSize, codec, bufferSize);
        bb.position(metadataAbsPos);
        bb.limit(psAbsPos);
        FileMetaInfo fmi = new FileMetaInfo(compressionType, bufferSize, metadataSize, bb, ReaderImpl.extractWriterVersion(ps));
        return new FooterInfo(stats, footer, fmi);
    }

    private static OrcProto.Footer extractFooter(ByteBuffer bb, int footerAbsPos, int footerSize, CompressionCodec codec, int bufferSize) throws IOException {
        bb.position(footerAbsPos);
        bb.limit(footerAbsPos + footerSize);
        return OrcProto.Footer.parseFrom(InStream.createCodedInputStream("footer", Lists.newArrayList(new BufferChunk(bb, 0L)), footerSize, codec, bufferSize));
    }

    private static OrcProto.Metadata extractMetadata(ByteBuffer bb, int metadataAbsPos, int metadataSize, CompressionCodec codec, int bufferSize) throws IOException {
        bb.position(metadataAbsPos);
        bb.limit(metadataAbsPos + metadataSize);
        return OrcProto.Metadata.parseFrom(InStream.createCodedInputStream("metadata", Lists.newArrayList(new BufferChunk(bb, 0L)), metadataSize, codec, bufferSize));
    }

    private static OrcProto.PostScript extractPostScript(ByteBuffer bb, Path path, int psLen, int psAbsOffset) throws IOException {
        assert (bb.hasArray());
        CodedInputStream in = CodedInputStream.newInstance(bb.array(), bb.arrayOffset() + psAbsOffset, psLen);
        OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(in);
        ReaderImpl.checkOrcVersion(LOG, path, ps.getVersionList());
        switch (ps.getCompression()) {
            case NONE: {
                break;
            }
            case ZLIB: {
                break;
            }
            case SNAPPY: {
                break;
            }
            case LZO: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compression");
            }
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileMetaInfo extractMetaInfoFromFooter(FileSystem fs, Path path, long maxFileLength) throws IOException {
        FSDataInputStream file = fs.open(path);
        ByteBuffer buffer = null;
        ByteBuffer fullFooterBuffer = null;
        OrcProto.PostScript ps = null;
        OrcFile.WriterVersion writerVersion = null;
        try {
            long size = maxFileLength == Long.MAX_VALUE ? fs.getFileStatus(path).getLen() : maxFileLength;
            int readSize = (int)Math.min(size, 16384L);
            buffer = ByteBuffer.allocate(readSize);
            assert (buffer.position() == 0);
            file.readFully(size - (long)readSize, buffer.array(), buffer.arrayOffset(), readSize);
            buffer.position(0);
            int psLen = buffer.get(readSize - 1) & 0xFF;
            ReaderImpl.ensureOrcFooter(file, path, psLen, buffer);
            int psOffset = readSize - 1 - psLen;
            ps = ReaderImpl.extractPostScript(buffer, path, psLen, psOffset);
            int footerSize = (int)ps.getFooterLength();
            int metadataSize = (int)ps.getMetadataLength();
            writerVersion = ReaderImpl.extractWriterVersion(ps);
            int extra = Math.max(0, psLen + 1 + footerSize + metadataSize - readSize);
            if (extra > 0) {
                ByteBuffer extraBuf = ByteBuffer.allocate(extra + readSize);
                file.readFully(size - (long)readSize - (long)extra, extraBuf.array(), extraBuf.arrayOffset() + extraBuf.position(), extra);
                extraBuf.position(extra);
                extraBuf.put(buffer);
                buffer = extraBuf;
                buffer.position(0);
                fullFooterBuffer = buffer.slice();
                buffer.limit(footerSize + metadataSize);
            } else {
                buffer.position(psOffset - footerSize - metadataSize);
                fullFooterBuffer = buffer.slice();
                buffer.limit(psOffset);
            }
            buffer.mark();
        }
        finally {
            try {
                file.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close the file after another error", (Throwable)ex);
            }
        }
        return new FileMetaInfo(ps.getCompression().toString(), (int)ps.getCompressionBlockSize(), (int)ps.getMetadataLength(), buffer, ps.getVersionList(), writerVersion, fullFooterBuffer);
    }

    public FileMetaInfo getFileMetaInfo() {
        return new FileMetaInfo(this.compressionKind.toString(), this.bufferSize, this.getMetadataSize(), this.footerByteBuffer, this.getVersionList(), this.getWriterVersion(), this.footerMetaAndPsBuffer);
    }

    @Override
    public ByteBuffer getSerializedFileFooter() {
        return this.footerMetaAndPsBuffer;
    }

    @Override
    public RecordReader rows() throws IOException {
        return this.rowsOptions(new Reader.Options());
    }

    @Override
    public RecordReader rowsOptions(Reader.Options options) throws IOException {
        LOG.info("Reading ORC rows from " + this.path + " with " + options);
        boolean[] include = options.getInclude();
        if (include == null) {
            include = new boolean[this.types.size()];
            Arrays.fill(include, true);
            options.include(include);
        }
        return new RecordReaderImpl(this, options);
    }

    @Override
    public RecordReader rows(boolean[] include) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include));
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include).range(offset, length));
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include, SearchArgument sarg, String[] columnNames) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include).range(offset, length).searchArgument(sarg, columnNames));
    }

    @Override
    public String toString() {
        return "Hive " + super.toString();
    }

    public static final class FooterInfo {
        private final OrcProto.Footer footer;
        private final List<StripeStatistics> metadata;
        private final List<StripeInformation> stripes;
        private final FileMetaInfo fileMetaInfo;

        private FooterInfo(List<StripeStatistics> metadata, OrcProto.Footer footer, FileMetaInfo fileMetaInfo) {
            this.metadata = metadata;
            this.footer = footer;
            this.fileMetaInfo = fileMetaInfo;
            this.stripes = ReaderImpl.convertProtoStripesToStripes(footer.getStripesList());
        }

        public OrcProto.Footer getFooter() {
            return this.footer;
        }

        public List<StripeStatistics> getMetadata() {
            return this.metadata;
        }

        public FileMetaInfo getFileMetaInfo() {
            return this.fileMetaInfo;
        }

        public List<StripeInformation> getStripes() {
            return this.stripes;
        }
    }

    private static class MetaInfoObjExtractor {
        final org.apache.orc.CompressionKind compressionKind;
        final CompressionCodec codec;
        final int bufferSize;
        final int metadataSize;
        final OrcProto.Metadata metadata;
        final OrcProto.Footer footer;
        final ObjectInspector inspector;

        MetaInfoObjExtractor(String codecStr, int bufferSize, int metadataSize, ByteBuffer footerBuffer) throws IOException {
            this.compressionKind = org.apache.orc.CompressionKind.valueOf(codecStr.toUpperCase());
            this.bufferSize = bufferSize;
            this.codec = WriterImpl.createCodec(this.compressionKind);
            this.metadataSize = metadataSize;
            int position = footerBuffer.position();
            int footerBufferSize = footerBuffer.limit() - footerBuffer.position() - metadataSize;
            this.metadata = ReaderImpl.extractMetadata(footerBuffer, position, metadataSize, this.codec, bufferSize);
            this.footer = ReaderImpl.extractFooter(footerBuffer, position + metadataSize, footerBufferSize, this.codec, bufferSize);
            footerBuffer.position(position);
            this.inspector = OrcStruct.createObjectInspector(0, this.footer.getTypesList());
        }
    }
}

