/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.orc.FileMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalCache
implements OrcInputFormat.FooterCache {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCache.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    private final Cache<Path, OrcInputFormat.FileInfo> cache;

    public LocalCache(int numThreads, int cacheStripeDetailsSize) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(numThreads).initialCapacity(cacheStripeDetailsSize).maximumSize(cacheStripeDetailsSize).softValues().build();
    }

    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    @Override
    public void getAndValidate(List<HadoopShims.HdfsFileStatusWithId> files, boolean isOriginal, OrcInputFormat.FileInfo[] result, ByteBuffer[] ppdResult) throws IOException {
        assert (result.length == files.size());
        int i = -1;
        for (HadoopShims.HdfsFileStatusWithId fileWithId : files) {
            ++i;
            FileStatus file = fileWithId.getFileStatus();
            Path path = file.getPath();
            Long fileId = fileWithId.getFileId();
            OrcInputFormat.FileInfo fileInfo = this.cache.getIfPresent(path);
            if (isDebugEnabled) {
                LOG.debug("Info " + (fileInfo == null ? "not " : "") + "cached for path: " + path);
            }
            if (fileInfo == null) continue;
            if (fileId != null && fileInfo.fileId != null && fileId == fileInfo.fileId || fileInfo.modificationTime == file.getModificationTime() && fileInfo.size == file.getLen()) {
                result[i] = fileInfo;
                continue;
            }
            this.cache.invalidate(path);
            if (!isDebugEnabled) continue;
            LOG.debug("Meta-Info for : " + path + " changed. CachedModificationTime: " + fileInfo.modificationTime + ", CurrentModificationTime: " + file.getModificationTime() + ", CachedLength: " + fileInfo.size + ", CurrentLength: " + file.getLen());
        }
    }

    public void put(Path path, OrcInputFormat.FileInfo fileInfo) {
        this.cache.put(path, fileInfo);
    }

    @Override
    public void put(Long fileId, FileStatus file, FileMetaInfo fileMetaInfo, Reader orcReader) throws IOException {
        this.cache.put(file.getPath(), new OrcInputFormat.FileInfo(file.getModificationTime(), file.getLen(), orcReader.getStripes(), orcReader.getStripeStatistics(), orcReader.getTypes(), orcReader.getOrcProtoFileStatistics(), fileMetaInfo, orcReader.getWriterVersion(), fileId));
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public boolean hasPpd() {
        return false;
    }
}

