/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.CombineHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    private static final String CLASS_NAME = CombineHiveInputFormat.class.getName();
    public static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final int MAX_CHECK_NONCOMBINABLE_THREAD_NUM = 50;
    private static final int DEFAULT_NUM_PATH_PER_THREAD = 100;

    /*
     * WARNING - void declaration
     */
    private InputSplit[] getCombineSplits(JobConf job, int numSplits, Map<String, PartitionDesc> pathToPartitionInfo) throws IOException {
        void var16_19;
        this.init(job);
        LinkedHashMap<String, ArrayList<String>> pathToAliases = this.mrwork.getPathToAliases();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = this.mrwork.getAliasToWork();
        HadoopShims.CombineFileInputFormatShim combine = ShimLoader.getHadoopShims().getCombineFileInputFormat();
        InputSplit[] splits = null;
        if (combine == null) {
            splits = super.getSplits(job, numSplits);
            return splits;
        }
        if (combine.getInputPathsShim(job).length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<CombineHiveInputSplit> result = new ArrayList<CombineHiveInputSplit>();
        Path[] paths = combine.getInputPathsShim(job);
        ArrayList<Path> inpDirs = new ArrayList<Path>();
        ArrayList<Path> inpFiles = new ArrayList<Path>();
        HashMap<CombinePathInputFormat, CombineFilter> poolMap = new HashMap<CombinePathInputFormat, CombineFilter>();
        HashSet<Path> poolSet = new HashSet<Path>();
        Path[] arr$ = paths;
        int len$ = arr$.length;
        boolean bl = false;
        while (var16_19 < len$) {
            Path path = arr$[var16_19];
            PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, path, IOPrepareCache.get().allocatePartitionDescMap());
            TableDesc tableDesc = part.getTableDesc();
            if (tableDesc != null && tableDesc.isNonNative()) {
                return super.getSplits(job, numSplits);
            }
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            String inputFormatClassName = inputFormatClass.getName();
            InputFormat<WritableComparable, Writable> inputFormat = CombineHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            String deserializerClassName = null;
            try {
                deserializerClassName = part.getDeserializer((Configuration)job).getClass().getName();
            }
            catch (Exception e) {
                // empty catch block
            }
            FileSystem inpFs = path.getFileSystem((Configuration)job);
            if (inputFormat instanceof SymlinkTextInputFormat) {
                splits = super.getSplits(job, numSplits);
                return splits;
            }
            Path filterPath = path;
            CombineFilter f = null;
            List<Operator<? extends OperatorDesc>> opList = null;
            if (!this.mrwork.isMapperCannotSpanPartns()) {
                opList = HiveFileFormatUtils.doGetWorksFromPath(pathToAliases, aliasToWork, filterPath);
                CombinePathInputFormat combinePathInputFormat = new CombinePathInputFormat(opList, inputFormatClassName, deserializerClassName);
                f = (CombineFilter)poolMap.get(combinePathInputFormat);
                if (f == null) {
                    f = new CombineFilter(filterPath);
                    LOG.info("CombineHiveInputSplit creating pool for " + path + "; using filter path " + filterPath);
                    combine.createPool(job, f);
                    poolMap.put(combinePathInputFormat, f);
                } else {
                    LOG.info("CombineHiveInputSplit: pool is already created for " + path + "; using filter path " + filterPath);
                    f.addPath(filterPath);
                }
            } else if (!path.getFileSystem((Configuration)job).getFileStatus(path).isDir()) {
                filterPath = path.getParent();
                inpFiles.add(path);
                poolSet.add(filterPath);
            } else {
                inpDirs.add(path);
            }
            ++var16_19;
        }
        List<Object> iss = new ArrayList();
        if (!this.mrwork.isMapperCannotSpanPartns()) {
            iss = Arrays.asList(combine.getSplits(job, 1));
        } else {
            for (Path path : inpDirs) {
                this.processPaths(job, combine, iss, path);
            }
            if (inpFiles.size() > 0) {
                for (Path path : poolSet) {
                    combine.createPool(job, new CombineFilter(path));
                }
                this.processPaths(job, combine, iss, inpFiles.toArray(new Path[0]));
            }
        }
        if (this.mrwork.getNameToSplitSample() != null && !this.mrwork.getNameToSplitSample().isEmpty()) {
            iss = this.sampleSplits(iss);
        }
        for (CombineFileSplit combineFileSplit : iss) {
            CombineHiveInputSplit csplit = new CombineHiveInputSplit(job, combineFileSplit, pathToPartitionInfo);
            result.add(csplit);
        }
        LOG.info("number of splits " + result.size());
        return (InputSplit[])result.toArray(new CombineHiveInputSplit[result.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "getSplits");
        this.init(job);
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        Path[] paths = this.getInputPaths(job);
        ArrayList<Path> nonCombinablePaths = new ArrayList<Path>(paths.length / 2);
        ArrayList<Path> combinablePaths = new ArrayList<Path>(paths.length / 2);
        int numThreads = Math.min(50, (int)Math.ceil((double)paths.length / 100.0));
        int numPathPerThread = (int)Math.ceil((double)paths.length / (double)numThreads);
        if (numThreads > 0) {
            LOG.info("Total number of paths: " + paths.length + ", launching " + numThreads + " threads to check non-combinable ones.");
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<Set<Integer>>> futureList = new ArrayList<Future<Set<Integer>>>(numThreads);
            try {
                for (int i = 0; i < numThreads; ++i) {
                    int start = i * numPathPerThread;
                    int n = i != numThreads - 1 ? numPathPerThread : paths.length - start;
                    futureList.add(executor.submit(new CheckNonCombinablePathCallable(paths, start, n, job)));
                }
                HashSet nonCombinablePathIndices = new HashSet();
                for (Future future : futureList) {
                    nonCombinablePathIndices.addAll((Collection)future.get());
                }
                for (int i = 0; i < paths.length; ++i) {
                    if (nonCombinablePathIndices.contains(i)) {
                        nonCombinablePaths.add(paths[i]);
                        continue;
                    }
                    combinablePaths.add(paths[i]);
                }
            }
            catch (Exception e) {
                LOG.error("Error checking non-combinable path", (Throwable)e);
                perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
                throw new IOException(e);
            }
            finally {
                executor.shutdownNow();
            }
        }
        String oldPaths = job.get("mapreduce.input.fileinputformat.inputdir");
        if (LOG.isDebugEnabled()) {
            LOG.debug("The received input paths are: [" + oldPaths + "] against the property " + "mapreduce.input.fileinputformat.inputdir");
        }
        if (nonCombinablePaths.size() > 0) {
            void var14_22;
            InputSplit[] splits;
            FileInputFormat.setInputPaths((JobConf)job, (Path[])nonCombinablePaths.toArray(new Path[nonCombinablePaths.size()]));
            InputSplit[] arr$ = splits = super.getSplits(job, numSplits);
            int len$ = arr$.length;
            boolean bl = false;
            while (var14_22 < len$) {
                InputSplit split = arr$[var14_22];
                result.add(split);
                ++var14_22;
            }
        }
        if (combinablePaths.size() > 0) {
            InputSplit[] splits;
            FileInputFormat.setInputPaths((JobConf)job, (Path[])combinablePaths.toArray(new Path[combinablePaths.size()]));
            LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = this.pathToPartitionInfo != null ? this.pathToPartitionInfo : Utilities.getMapWork((Configuration)job).getPathToPartitionInfo();
            for (InputSplit split : splits = this.getCombineSplits(job, numSplits, pathToPartitionInfo)) {
                result.add(split);
            }
        }
        if (oldPaths != null) {
            job.set("mapreduce.input.fileinputformat.inputdir", oldPaths);
        }
        Utilities.clearWorkMapForConf((Configuration)job);
        LOG.info("Number of all splits " + result.size());
        perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
        return result.toArray(new InputSplit[result.size()]);
    }

    private void processPaths(JobConf job, HadoopShims.CombineFileInputFormatShim combine, List<CombineFileSplit> iss, Path ... path) throws IOException {
        JobConf currJob = new JobConf((Configuration)job);
        FileInputFormat.setInputPaths((JobConf)currJob, (Path[])path);
        iss.addAll(Arrays.asList(combine.getSplits(currJob, 1)));
    }

    private List<CombineFileSplit> sampleSplits(List<CombineFileSplit> splits) {
        HashMap<String, SplitSample> nameToSamples = this.mrwork.getNameToSplitSample();
        ArrayList<CombineFileSplit> retLists = new ArrayList<CombineFileSplit>();
        HashMap aliasToSplitList = new HashMap();
        LinkedHashMap<String, ArrayList<String>> pathToAliases = this.mrwork.getPathToAliases();
        Map<String, ArrayList<String>> pathToAliasesNoScheme = this.removeScheme(pathToAliases);
        for (CombineFileSplit combineFileSplit : splits) {
            String alias = null;
            for (Path path : combineFileSplit.getPaths()) {
                boolean schemeless = path.toUri().getScheme() == null;
                List<String> l = HiveFileFormatUtils.doGetAliasesFromPath(schemeless ? pathToAliasesNoScheme : pathToAliases, path);
                if (l.size() != 1 || !nameToSamples.containsKey(l.get(0)) || alias != null && l.get(0) != alias) {
                    alias = null;
                    break;
                }
                alias = l.get(0);
            }
            if (alias != null) {
                if (!aliasToSplitList.containsKey(alias)) {
                    aliasToSplitList.put(alias, new ArrayList());
                }
                ((ArrayList)aliasToSplitList.get(alias)).add(combineFileSplit);
                continue;
            }
            retLists.add(combineFileSplit);
        }
        block2: for (Map.Entry entry : aliasToSplitList.entrySet()) {
            ArrayList splitList = (ArrayList)entry.getValue();
            long totalSize = 0L;
            for (CombineFileSplit split : splitList) {
                totalSize += split.getLength();
            }
            SplitSample splitSample = nameToSamples.get(entry.getKey());
            long targetSize = splitSample.getTargetSize(totalSize);
            int startIndex = splitSample.getSeedNum() % splitList.size();
            long size = 0L;
            for (int i = 0; i < splitList.size(); ++i) {
                CombineFileSplit split = (CombineFileSplit)splitList.get((startIndex + i) % splitList.size());
                retLists.add(split);
                long splitgLength = split.getLength();
                if (size + splitgLength >= targetSize) {
                    LOG.info("Sample alias " + entry.getValue() + " using " + (i + 1) + "splits");
                    if (size + splitgLength <= targetSize) continue block2;
                    ((HadoopShimsSecure.InputSplitShim)split).shrinkSplit(targetSize - size);
                    continue block2;
                }
                size += splitgLength;
            }
        }
        return retLists;
    }

    Map<String, ArrayList<String>> removeScheme(Map<String, ArrayList<String>> pathToAliases) {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, ArrayList<String>> entry : pathToAliases.entrySet()) {
            String newKey = new Path(entry.getKey()).toUri().getPath();
            result.put(newKey, entry.getValue());
        }
        return result;
    }

    @Override
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (!(split instanceof CombineHiveInputSplit)) {
            return super.getRecordReader(split, job, reporter);
        }
        CombineHiveInputSplit hsplit = (CombineHiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        this.pushProjectionsAndFilters(job, inputFormatClass, hsplit.getPath(0).toString(), hsplit.getPath(0).toUri().getPath());
        return ShimLoader.getHadoopShims().getCombineFileInputFormat().getRecordReader(job, (CombineFileSplit)split, reporter, CombineHiveRecordReader.class);
    }

    public static interface AvoidSplitCombination {
        public boolean shouldSkipCombine(Path var1, Configuration var2) throws IOException;
    }

    static class CombineFilter
    implements PathFilter {
        private final Set<String> pStrings = new HashSet<String>();

        public CombineFilter(Path p) {
            this.addPath(p);
        }

        public void addPath(Path p) {
            String pString = p.toUri().getPath();
            this.pStrings.add(pString);
        }

        public boolean accept(Path path) {
            boolean find = false;
            while (path != null && !find) {
                if (this.pStrings.contains(path.toUri().getPath())) {
                    find = true;
                    break;
                }
                path = path.getParent();
            }
            return find;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("PathFilter: ");
            for (String pString : this.pStrings) {
                s.append(pString + " ");
            }
            return s.toString();
        }
    }

    private static class CombinePathInputFormat {
        private final List<Operator<? extends OperatorDesc>> opList;
        private final String inputFormatClassName;
        private final String deserializerClassName;

        public CombinePathInputFormat(List<Operator<? extends OperatorDesc>> opList, String inputFormatClassName, String deserializerClassName) {
            this.opList = opList;
            this.inputFormatClassName = inputFormatClassName;
            this.deserializerClassName = deserializerClassName;
        }

        public boolean equals(Object o) {
            if (o instanceof CombinePathInputFormat) {
                CombinePathInputFormat mObj = (CombinePathInputFormat)o;
                return this.opList.equals(mObj.opList) && this.inputFormatClassName.equals(mObj.inputFormatClassName) && (this.deserializerClassName == null ? mObj.deserializerClassName == null : this.deserializerClassName.equals(mObj.deserializerClassName));
            }
            return false;
        }

        public int hashCode() {
            return this.opList == null ? 0 : this.opList.hashCode();
        }
    }

    public static class CombineHiveInputSplit
    extends HadoopShimsSecure.InputSplitShim {
        private String inputFormatClassName;
        private CombineFileSplit inputSplitShim;
        private Map<String, PartitionDesc> pathToPartitionInfo;

        public CombineHiveInputSplit() throws IOException {
            this(ShimLoader.getHadoopShims().getCombineFileInputFormat().getInputSplitShim());
        }

        public CombineHiveInputSplit(CombineFileSplit inputSplitShim) throws IOException {
            this(inputSplitShim.getJob(), inputSplitShim);
        }

        public CombineHiveInputSplit(JobConf job, CombineFileSplit inputSplitShim) throws IOException {
            this(job, inputSplitShim, null);
        }

        public CombineHiveInputSplit(JobConf job, CombineFileSplit inputSplitShim, Map<String, PartitionDesc> pathToPartitionInfo) throws IOException {
            this.inputSplitShim = inputSplitShim;
            this.pathToPartitionInfo = pathToPartitionInfo;
            if (job != null) {
                Path[] ipaths;
                if (this.pathToPartitionInfo == null) {
                    this.pathToPartitionInfo = Utilities.getMapWork((Configuration)job).getPathToPartitionInfo();
                }
                if ((ipaths = inputSplitShim.getPaths()).length > 0) {
                    PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(this.pathToPartitionInfo, ipaths[0], IOPrepareCache.get().getPartitionDescMap());
                    this.inputFormatClassName = part.getInputFileFormatClass().getName();
                }
            }
        }

        public CombineFileSplit getInputSplitShim() {
            return this.inputSplitShim;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public void setInputFormatClassName(String inputFormatClassName) {
            this.inputFormatClassName = inputFormatClassName;
        }

        public JobConf getJob() {
            return this.inputSplitShim.getJob();
        }

        public long getLength() {
            return this.inputSplitShim.getLength();
        }

        public long[] getStartOffsets() {
            return this.inputSplitShim.getStartOffsets();
        }

        public long[] getLengths() {
            return this.inputSplitShim.getLengths();
        }

        public long getOffset(int i) {
            return this.inputSplitShim.getOffset(i);
        }

        public long getLength(int i) {
            return this.inputSplitShim.getLength(i);
        }

        public int getNumPaths() {
            return this.inputSplitShim.getNumPaths();
        }

        public Path getPath(int i) {
            return this.inputSplitShim.getPath(i);
        }

        public Path[] getPaths() {
            return this.inputSplitShim.getPaths();
        }

        public String[] getLocations() throws IOException {
            return this.inputSplitShim.getLocations();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.inputSplitShim.toString());
            sb.append("InputFormatClass: " + this.inputFormatClassName);
            sb.append("\n");
            return sb.toString();
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.inputSplitShim.readFields(in);
            this.inputFormatClassName = in.readUTF();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.inputSplitShim.write(out);
            if (this.inputFormatClassName == null) {
                if (this.pathToPartitionInfo == null) {
                    this.pathToPartitionInfo = Utilities.getMapWork((Configuration)this.getJob()).getPathToPartitionInfo();
                }
                PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(this.pathToPartitionInfo, this.inputSplitShim.getPath(0), IOPrepareCache.get().getPartitionDescMap());
                this.inputFormatClassName = part.getInputFileFormatClass().getName();
            }
            out.writeUTF(this.inputFormatClassName);
        }
    }

    private class CheckNonCombinablePathCallable
    implements Callable<Set<Integer>> {
        private final Path[] paths;
        private final int start;
        private final int length;
        private final JobConf conf;

        public CheckNonCombinablePathCallable(Path[] paths, int start, int length, JobConf conf) {
            this.paths = paths;
            this.start = start;
            this.length = length;
            this.conf = conf;
        }

        @Override
        public Set<Integer> call() throws Exception {
            HashSet<Integer> nonCombinablePathIndices = new HashSet<Integer>();
            for (int i = 0; i < this.length; ++i) {
                PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(CombineHiveInputFormat.this.pathToPartitionInfo, this.paths[i + this.start], IOPrepareCache.get().allocatePartitionDescMap());
                Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
                InputFormat<WritableComparable, Writable> inputFormat = HiveInputFormat.getInputFormatFromCache(inputFormatClass, this.conf);
                if (!(inputFormat instanceof AvoidSplitCombination) || !((AvoidSplitCombination)inputFormat).shouldSkipCombine(this.paths[i + this.start], (Configuration)this.conf)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The path [" + this.paths[i + this.start] + "] is being parked for HiveInputFormat.getSplits");
                }
                nonCombinablePathIndices.add(i);
            }
            return nonCombinablePathIndices;
        }
    }
}

