/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.DateTimeMath;

public class IntervalDayTimeColAddTimestampScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private Timestamp value;
    private int outputColumn;
    private DateTimeMath dtm = new DateTimeMath();

    public IntervalDayTimeColAddTimestampScalar(int colNum, Timestamp value, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
    }

    public IntervalDayTimeColAddTimestampScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        IntervalDayTimeColumnVector inputColVector1 = (IntervalDayTimeColumnVector)batch.cols[this.colNum];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector1.noNulls;
        outputColVector.isRepeating = inputColVector1.isRepeating;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (inputColVector1.isRepeating) {
            this.dtm.add(inputColVector1.asScratchIntervalDayTime(0), this.value, outputColVector.getScratchTimestamp());
            outputColVector.setFromScratchTimestamp(0);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector1.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.add(inputColVector1.asScratchIntervalDayTime(i), this.value, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.add(inputColVector1.asScratchIntervalDayTime(i), this.value, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.dtm.add(inputColVector1.asScratchIntervalDayTime(i), this.value, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.dtm.add(inputColVector1.asScratchIntervalDayTime(i), this.value, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
        NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("timestamp")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

