/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterTimestampColNotEqualDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;

    public FilterTimestampColNotEqualDoubleColumn(int colNum1, int colNum2) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public FilterTimestampColNotEqualDoubleColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.cols[this.colNum1];
        DoubleColumnVector inputColVector2 = (DoubleColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        boolean[] nullPos1 = inputColVector1.isNull;
        boolean[] nullPos2 = inputColVector2.isNull;
        int n = batch.size;
        double[] vector2 = inputColVector2.vector;
        if (n == 0) {
            return;
        }
        int newSize = NullUtil.filterNulls(batch.cols[this.colNum1], batch.selectedInUse, sel, n);
        if (newSize < n) {
            n = batch.size = newSize;
            batch.selectedInUse = true;
        }
        if ((newSize = NullUtil.filterNulls(batch.cols[this.colNum2], batch.selectedInUse, sel, n)) < n) {
            n = batch.size = newSize;
            batch.selectedInUse = true;
        }
        if (n != 0 && inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (inputColVector1.getDouble(0) == vector2[0]) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            double value1 = inputColVector1.getDouble(0);
            if (batch.selectedInUse) {
                newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (value1 == vector2[i]) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (value1 == vector2[i]) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            double value2 = vector2[0];
            if (batch.selectedInUse) {
                newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inputColVector1.getDouble(i) == value2) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (inputColVector1.getDouble(i) == value2) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (inputColVector1.getDouble(i) == vector2[i]) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (inputColVector1.getDouble(i) == vector2[i]) continue;
                sel[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("timestamp"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

