/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public abstract class VectorUDFTimestampFieldDate
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    protected int outputColumn;
    protected int field;
    protected final transient Calendar calendar = Calendar.getInstance();

    public VectorUDFTimestampFieldDate(int field, int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        this.field = field;
    }

    public VectorUDFTimestampFieldDate() {
    }

    protected long getDateField(long days) {
        this.calendar.setTimeInMillis(DateWritable.daysToMillis((int)days));
        return this.calendar.get(this.field);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        boolean selectedInUse;
        Preconditions.checkState(this.inputTypes[0] == VectorExpression.Type.DATE);
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        ColumnVector inputColVec = batch.cols[this.colNum];
        int n = inputColVec.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean bl = selectedInUse = !inputColVec.isRepeating && batch.selectedInUse;
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = inputColVec.isRepeating;
        LongColumnVector longColVector = (LongColumnVector)inputColVec;
        if (inputColVec.noNulls) {
            outV.noNulls = true;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outV.vector[i] = this.getDateField(longColVector.vector[i]);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outV.vector[i] = this.getDateField(longColVector.vector[i]);
                }
            }
        } else {
            outV.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inputColVec.isNull[i];
                    if (inputColVec.isNull[i]) continue;
                    outV.vector[i] = this.getDateField(longColVector.vector[i]);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outV.isNull[i] = inputColVec.isNull[i];
                    if (inputColVec.isNull[i]) continue;
                    outV.vector[i] = this.getDateField(longColVector.vector[i]);
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public int getField() {
        return this.field;
    }

    public void setField(int field) {
        this.field = field;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DATE).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

