/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.vector.expressions.AbstractFilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFLike;

public class FilterStringColLikeStringScalar
extends AbstractFilterStringColLikeStringScalar {
    private static final long serialVersionUID = 1L;
    private static final transient List<AbstractFilterStringColLikeStringScalar.CheckerFactory> checkerFactories = Arrays.asList(new BeginCheckerFactory(), new EndCheckerFactory(), new MiddleCheckerFactory(), new NoneCheckerFactory(), new ChainedCheckerFactory(), new ComplexCheckerFactory());

    public FilterStringColLikeStringScalar() {
    }

    public FilterStringColLikeStringScalar(int colNum, byte[] likePattern) throws HiveException {
        super(colNum, null);
        try {
            super.setPattern(new String(likePattern, "UTF-8"));
        }
        catch (Exception ex) {
            throw new HiveException(ex);
        }
    }

    @Override
    protected List<AbstractFilterStringColLikeStringScalar.CheckerFactory> getCheckerFactories() {
        return checkerFactories;
    }

    private static class ComplexCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private ComplexCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            return new AbstractFilterStringColLikeStringScalar.ComplexChecker(UDFLike.likePatternToRegExp(pattern));
        }
    }

    private static class ChainedCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern CHAIN_PATTERN = Pattern.compile("(%?[^%_\\\\]+%?)+");

        private ChainedCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = CHAIN_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.ChainedChecker(pattern);
            }
            return null;
        }
    }

    private static class NoneCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern NONE_PATTERN = Pattern.compile("[^%_]+");

        private NoneCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = NONE_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.NoneChecker(pattern);
            }
            return null;
        }
    }

    private static class MiddleCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern MIDDLE_PATTERN = Pattern.compile("%([^_%]+)%");

        private MiddleCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = MIDDLE_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.MiddleChecker(matcher.group(1));
            }
            return null;
        }
    }

    private static class EndCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern END_PATTERN = Pattern.compile("%([^_%]+)");

        private EndCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = END_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.EndChecker(matcher.group(1));
            }
            return null;
        }
    }

    private static class BeginCheckerFactory
    implements AbstractFilterStringColLikeStringScalar.CheckerFactory {
        private static final Pattern BEGIN_PATTERN = Pattern.compile("([^_%]+)%");

        private BeginCheckerFactory() {
        }

        @Override
        public AbstractFilterStringColLikeStringScalar.Checker tryCreate(String pattern) {
            Matcher matcher = BEGIN_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractFilterStringColLikeStringScalar.BeginChecker(matcher.group(1));
            }
            return null;
        }
    }
}

