// $ANTLR 3.4 org/apache/hadoop/hive/ql/parse/HiveParser.g 2015-05-14 15:09:51

package org.apache.hadoop.hive.ql.parse;

import java.util.Collection;
import java.util.HashMap;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/**
   Licensed to the Apache Software Foundation (ASF) under one or more 
   contributor license agreements.  See the NOTICE file distributed with 
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with 
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
@SuppressWarnings({"all", "warnings", "unchecked"})
public class HiveParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "AMPERSAND", "BITWISEOR", "BITWISEXOR", "BigintLiteral", "ByteLengthLiteral", "COLON", "COMMA", "COMMENT", "CharSetLiteral", "CharSetName", "DIV", "DIVIDE", "DOLLAR", "DOT", "DecimalLiteral", "Digit", "EQUAL", "EQUAL_NS", "Exponent", "GREATERTHAN", "GREATERTHANOREQUALTO", "HexDigit", "Identifier", "KW_ADD", "KW_ADMIN", "KW_AFTER", "KW_ALL", "KW_ALTER", "KW_ANALYZE", "KW_AND", "KW_ARCHIVE", "KW_ARRAY", "KW_AS", "KW_ASC", "KW_AUTHORIZATION", "KW_BEFORE", "KW_BETWEEN", "KW_BIGINT", "KW_BINARY", "KW_BOOLEAN", "KW_BOTH", "KW_BUCKET", "KW_BUCKETS", "KW_BY", "KW_CASCADE", "KW_CASE", "KW_CAST", "KW_CHANGE", "KW_CHAR", "KW_CLUSTER", "KW_CLUSTERED", "KW_CLUSTERSTATUS", "KW_COLLECTION", "KW_COLUMN", "KW_COLUMNS", "KW_COMMENT", "KW_COMPACT", "KW_COMPACTIONS", "KW_COMPUTE", "KW_CONCATENATE", "KW_CONF", "KW_CONTINUE", "KW_CREATE", "KW_CROSS", "KW_CUBE", "KW_CURRENT", "KW_CURSOR", "KW_DATA", "KW_DATABASE", "KW_DATABASES", "KW_DATE", "KW_DATETIME", "KW_DBPROPERTIES", "KW_DECIMAL", "KW_DEFAULT", "KW_DEFERRED", "KW_DEFINED", "KW_DELETE", "KW_DELIMITED", "KW_DEPENDENCY", "KW_DESC", "KW_DESCRIBE", "KW_DIRECTORIES", "KW_DIRECTORY", "KW_DISABLE", "KW_DISTINCT", "KW_DISTRIBUTE", "KW_DOUBLE", "KW_DROP", "KW_ELEM_TYPE", "KW_ELSE", "KW_ENABLE", "KW_END", "KW_ESCAPED", "KW_EXCHANGE", "KW_EXCLUSIVE", "KW_EXISTS", "KW_EXPLAIN", "KW_EXPORT", "KW_EXTENDED", "KW_EXTERNAL", "KW_FALSE", "KW_FETCH", "KW_FIELDS", "KW_FILE", "KW_FILEFORMAT", "KW_FIRST", "KW_FLOAT", "KW_FOLLOWING", "KW_FOR", "KW_FORMAT", "KW_FORMATTED", "KW_FROM", "KW_FULL", "KW_FUNCTION", "KW_FUNCTIONS", "KW_GRANT", "KW_GROUP", "KW_GROUPING", "KW_HAVING", "KW_HOLD_DDLTIME", "KW_IDXPROPERTIES", "KW_IF", "KW_IGNORE", "KW_IMPORT", "KW_IN", "KW_INDEX", "KW_INDEXES", "KW_INNER", "KW_INPATH", "KW_INPUTDRIVER", "KW_INPUTFORMAT", "KW_INSERT", "KW_INT", "KW_INTERSECT", "KW_INTO", "KW_IS", "KW_ITEMS", "KW_JAR", "KW_JOIN", "KW_KEYS", "KW_KEY_TYPE", "KW_LATERAL", "KW_LEFT", "KW_LESS", "KW_LIKE", "KW_LIMIT", "KW_LINES", "KW_LOAD", "KW_LOCAL", "KW_LOCATION", "KW_LOCK", "KW_LOCKS", "KW_LOGICAL", "KW_LONG", "KW_MACRO", "KW_MAP", "KW_MAPJOIN", "KW_MATERIALIZED", "KW_MINUS", "KW_MORE", "KW_MSCK", "KW_NONE", "KW_NOSCAN", "KW_NOT", "KW_NO_DROP", "KW_NULL", "KW_OF", "KW_OFFLINE", "KW_ON", "KW_OPTION", "KW_OR", "KW_ORDER", "KW_OUT", "KW_OUTER", "KW_OUTPUTDRIVER", "KW_OUTPUTFORMAT", "KW_OVER", "KW_OVERWRITE", "KW_OWNER", "KW_PARTIALSCAN", "KW_PARTITION", "KW_PARTITIONED", "KW_PARTITIONS", "KW_PERCENT", "KW_PLUS", "KW_PRECEDING", "KW_PRESERVE", "KW_PRETTY", "KW_PRINCIPALS", "KW_PROCEDURE", "KW_PROTECTION", "KW_PURGE", "KW_RANGE", "KW_READ", "KW_READONLY", "KW_READS", "KW_REBUILD", "KW_RECORDREADER", "KW_RECORDWRITER", "KW_REDUCE", "KW_REGEXP", "KW_RENAME", "KW_REPAIR", "KW_REPLACE", "KW_RESTRICT", "KW_REVOKE", "KW_REWRITE", "KW_RIGHT", "KW_RLIKE", "KW_ROLE", "KW_ROLES", "KW_ROLLUP", "KW_ROW", "KW_ROWS", "KW_SCHEMA", "KW_SCHEMAS", "KW_SELECT", "KW_SEMI", "KW_SERDE", "KW_SERDEPROPERTIES", "KW_SERVER", "KW_SET", "KW_SETS", "KW_SHARED", "KW_SHOW", "KW_SHOW_DATABASE", "KW_SKEWED", "KW_SMALLINT", "KW_SORT", "KW_SORTED", "KW_SSL", "KW_STATISTICS", "KW_STORED", "KW_STREAMTABLE", "KW_STRING", "KW_STRUCT", "KW_TABLE", "KW_TABLES", "KW_TABLESAMPLE", "KW_TBLPROPERTIES", "KW_TEMPORARY", "KW_TERMINATED", "KW_THEN", "KW_TIMESTAMP", "KW_TINYINT", "KW_TO", "KW_TOUCH", "KW_TRANSACTIONS", "KW_TRANSFORM", "KW_TRIGGER", "KW_TRUE", "KW_TRUNCATE", "KW_UNARCHIVE", "KW_UNBOUNDED", "KW_UNDO", "KW_UNION", "KW_UNIONTYPE", "KW_UNIQUEJOIN", "KW_UNLOCK", "KW_UNSET", "KW_UNSIGNED", "KW_UPDATE", "KW_URI", "KW_USE", "KW_USER", "KW_USING", "KW_UTC", "KW_UTCTIMESTAMP", "KW_VALUES", "KW_VALUE_TYPE", "KW_VARCHAR", "KW_VIEW", "KW_WHEN", "KW_WHERE", "KW_WHILE", "KW_WINDOW", "KW_WITH", "LCURLY", "LESSTHAN", "LESSTHANOREQUALTO", "LPAREN", "LSQUARE", "Letter", "MINUS", "MOD", "NOTEQUAL", "Number", "PLUS", "QUESTION", "QuotedIdentifier", "RCURLY", "RPAREN", "RSQUARE", "RegexComponent", "SEMICOLON", "STAR", "SmallintLiteral", "StringLiteral", "TILDE", "TinyintLiteral", "WS", "TOK_ADMIN_OPTION_FOR", "TOK_ALIASLIST", "TOK_ALLCOLREF", "TOK_ALTERDATABASE_OWNER", "TOK_ALTERDATABASE_PROPERTIES", "TOK_ALTERINDEX_PROPERTIES", "TOK_ALTERINDEX_REBUILD", "TOK_ALTERTABLE", "TOK_ALTERTABLE_ADDCOLS", "TOK_ALTERTABLE_ADDPARTS", "TOK_ALTERTABLE_ARCHIVE", "TOK_ALTERTABLE_BUCKETS", "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION", "TOK_ALTERTABLE_CLUSTER_SORT", "TOK_ALTERTABLE_COMPACT", "TOK_ALTERTABLE_DROPPARTS", "TOK_ALTERTABLE_DROPPROPERTIES", "TOK_ALTERTABLE_EXCHANGEPARTITION", "TOK_ALTERTABLE_FILEFORMAT", "TOK_ALTERTABLE_LOCATION", "TOK_ALTERTABLE_MERGEFILES", "TOK_ALTERTABLE_PARTCOLTYPE", "TOK_ALTERTABLE_PROPERTIES", "TOK_ALTERTABLE_PROTECTMODE", "TOK_ALTERTABLE_RENAME", "TOK_ALTERTABLE_RENAMECOL", "TOK_ALTERTABLE_RENAMEPART", "TOK_ALTERTABLE_REPLACECOLS", "TOK_ALTERTABLE_SERDEPROPERTIES", "TOK_ALTERTABLE_SERIALIZER", "TOK_ALTERTABLE_SKEWED", "TOK_ALTERTABLE_SKEWED_LOCATION", "TOK_ALTERTABLE_TOUCH", "TOK_ALTERTABLE_UNARCHIVE", "TOK_ALTERTABLE_UPDATECOLSTATS", "TOK_ALTERVIEW", "TOK_ALTERVIEW_ADDPARTS", "TOK_ALTERVIEW_DROPPARTS", "TOK_ALTERVIEW_DROPPROPERTIES", "TOK_ALTERVIEW_PROPERTIES", "TOK_ALTERVIEW_RENAME", "TOK_ANALYZE", "TOK_ANONYMOUS", "TOK_ARCHIVE", "TOK_BIGINT", "TOK_BINARY", "TOK_BOOLEAN", "TOK_CASCADE", "TOK_CHAR", "TOK_CHARSETLITERAL", "TOK_CLUSTERBY", "TOK_COLTYPELIST", "TOK_COL_NAME", "TOK_CREATEDATABASE", "TOK_CREATEFUNCTION", "TOK_CREATEINDEX", "TOK_CREATEINDEX_INDEXTBLNAME", "TOK_CREATEMACRO", "TOK_CREATEROLE", "TOK_CREATETABLE", "TOK_CREATEVIEW", "TOK_CROSSJOIN", "TOK_CTE", "TOK_CUBE_GROUPBY", "TOK_DATABASECOMMENT", "TOK_DATABASELOCATION", "TOK_DATABASEPROPERTIES", "TOK_DATE", "TOK_DATELITERAL", "TOK_DATETIME", "TOK_DBPROPLIST", "TOK_DB_TYPE", "TOK_DECIMAL", "TOK_DEFERRED_REBUILDINDEX", "TOK_DELETE_FROM", "TOK_DESCDATABASE", "TOK_DESCFUNCTION", "TOK_DESCTABLE", "TOK_DESTINATION", "TOK_DIR", "TOK_DISABLE", "TOK_DISTRIBUTEBY", "TOK_DOUBLE", "TOK_DROPDATABASE", "TOK_DROPFUNCTION", "TOK_DROPINDEX", "TOK_DROPMACRO", "TOK_DROPROLE", "TOK_DROPTABLE", "TOK_DROPVIEW", "TOK_ENABLE", "TOK_EXPLAIN", "TOK_EXPLAIN_SQ_REWRITE", "TOK_EXPLIST", "TOK_EXPORT", "TOK_FALSE", "TOK_FILE", "TOK_FILEFORMAT_GENERIC", "TOK_FLOAT", "TOK_FROM", "TOK_FULLOUTERJOIN", "TOK_FUNCTION", "TOK_FUNCTIONDI", "TOK_FUNCTIONSTAR", "TOK_GRANT", "TOK_GRANT_OPTION_FOR", "TOK_GRANT_ROLE", "TOK_GRANT_WITH_ADMIN_OPTION", "TOK_GRANT_WITH_OPTION", "TOK_GROUP", "TOK_GROUPBY", "TOK_GROUPING_SETS", "TOK_GROUPING_SETS_EXPRESSION", "TOK_HAVING", "TOK_HINT", "TOK_HINTARGLIST", "TOK_HINTLIST", "TOK_HOLD_DDLTIME", "TOK_IFEXISTS", "TOK_IFNOTEXISTS", "TOK_IGNOREPROTECTION", "TOK_IMPORT", "TOK_INDEXCOMMENT", "TOK_INDEXPROPERTIES", "TOK_INDEXPROPLIST", "TOK_INSERT", "TOK_INSERT_INTO", "TOK_INT", "TOK_ISNOTNULL", "TOK_ISNULL", "TOK_JAR", "TOK_JOIN", "TOK_LATERAL_VIEW", "TOK_LATERAL_VIEW_OUTER", "TOK_LEFTOUTERJOIN", "TOK_LEFTSEMIJOIN", "TOK_LENGTH", "TOK_LIKETABLE", "TOK_LIMIT", "TOK_LIST", "TOK_LOAD", "TOK_LOCAL_DIR", "TOK_LOCKDB", "TOK_LOCKTABLE", "TOK_MAP", "TOK_MAPJOIN", "TOK_MSCK", "TOK_NOT_CLUSTERED", "TOK_NOT_SORTED", "TOK_NO_DROP", "TOK_NULL", "TOK_OFFLINE", "TOK_OP_ADD", "TOK_OP_AND", "TOK_OP_BITAND", "TOK_OP_BITNOT", "TOK_OP_BITOR", "TOK_OP_BITXOR", "TOK_OP_DIV", "TOK_OP_EQ", "TOK_OP_GE", "TOK_OP_GT", "TOK_OP_LE", "TOK_OP_LIKE", "TOK_OP_LT", "TOK_OP_MOD", "TOK_OP_MUL", "TOK_OP_NE", "TOK_OP_NOT", "TOK_OP_OR", "TOK_OP_SUB", "TOK_ORDERBY", "TOK_ORREPLACE", "TOK_PARTITIONINGSPEC", "TOK_PARTITIONLOCATION", "TOK_PARTSPEC", "TOK_PARTVAL", "TOK_PERCENT", "TOK_PRINCIPAL_NAME", "TOK_PRIVILEGE", "TOK_PRIVILEGE_LIST", "TOK_PRIV_ALL", "TOK_PRIV_ALTER_DATA", "TOK_PRIV_ALTER_METADATA", "TOK_PRIV_CREATE", "TOK_PRIV_DELETE", "TOK_PRIV_DROP", "TOK_PRIV_INDEX", "TOK_PRIV_INSERT", "TOK_PRIV_LOCK", "TOK_PRIV_OBJECT", "TOK_PRIV_OBJECT_COL", "TOK_PRIV_SELECT", "TOK_PRIV_SHOW_DATABASE", "TOK_PTBLFUNCTION", "TOK_QUERY", "TOK_READONLY", "TOK_RECORDREADER", "TOK_RECORDWRITER", "TOK_RESOURCE_ALL", "TOK_RESOURCE_LIST", "TOK_RESOURCE_URI", "TOK_RESTRICT", "TOK_REVOKE", "TOK_REVOKE_ROLE", "TOK_RIGHTOUTERJOIN", "TOK_ROLE", "TOK_ROLLUP_GROUPBY", "TOK_ROWCOUNT", "TOK_SELECT", "TOK_SELECTDI", "TOK_SELEXPR", "TOK_SERDE", "TOK_SERDENAME", "TOK_SERDEPROPS", "TOK_SERVER_TYPE", "TOK_SET_COLUMNS_CLAUSE", "TOK_SHOWCOLUMNS", "TOK_SHOWCONF", "TOK_SHOWDATABASES", "TOK_SHOWDBLOCKS", "TOK_SHOWFUNCTIONS", "TOK_SHOWINDEXES", "TOK_SHOWLOCKS", "TOK_SHOWPARTITIONS", "TOK_SHOWTABLES", "TOK_SHOW_COMPACTIONS", "TOK_SHOW_CREATETABLE", "TOK_SHOW_GRANT", "TOK_SHOW_ROLES", "TOK_SHOW_ROLE_GRANT", "TOK_SHOW_ROLE_PRINCIPALS", "TOK_SHOW_SET_ROLE", "TOK_SHOW_TABLESTATUS", "TOK_SHOW_TBLPROPERTIES", "TOK_SHOW_TRANSACTIONS", "TOK_SKEWED_LOCATIONS", "TOK_SKEWED_LOCATION_LIST", "TOK_SKEWED_LOCATION_MAP", "TOK_SMALLINT", "TOK_SORTBY", "TOK_STORAGEHANDLER", "TOK_STOREDASDIRS", "TOK_STREAMTABLE", "TOK_STRING", "TOK_STRINGLITERALSEQUENCE", "TOK_STRUCT", "TOK_SUBQUERY", "TOK_SUBQUERY_EXPR", "TOK_SUBQUERY_OP", "TOK_SUBQUERY_OP_NOTEXISTS", "TOK_SUBQUERY_OP_NOTIN", "TOK_SWITCHDATABASE", "TOK_TAB", "TOK_TABALIAS", "TOK_TABCOL", "TOK_TABCOLLIST", "TOK_TABCOLNAME", "TOK_TABCOLVALUE", "TOK_TABCOLVALUES", "TOK_TABCOLVALUE_PAIR", "TOK_TABLEBUCKETSAMPLE", "TOK_TABLECOMMENT", "TOK_TABLEFILEFORMAT", "TOK_TABLELOCATION", "TOK_TABLEPARTCOLS", "TOK_TABLEPROPERTIES", "TOK_TABLEPROPERTY", "TOK_TABLEPROPLIST", "TOK_TABLEROWFORMAT", "TOK_TABLEROWFORMATCOLLITEMS", "TOK_TABLEROWFORMATFIELD", "TOK_TABLEROWFORMATLINES", "TOK_TABLEROWFORMATMAPKEYS", "TOK_TABLEROWFORMATNULL", "TOK_TABLESERIALIZER", "TOK_TABLESKEWED", "TOK_TABLESPLITSAMPLE", "TOK_TABLE_OR_COL", "TOK_TABLE_PARTITION", "TOK_TABLE_TYPE", "TOK_TABNAME", "TOK_TABREF", "TOK_TABSORTCOLNAMEASC", "TOK_TABSORTCOLNAMEDESC", "TOK_TABSRC", "TOK_TABTYPE", "TOK_TEMPORARY", "TOK_TIMESTAMP", "TOK_TIMESTAMPLITERAL", "TOK_TINYINT", "TOK_TMP_FILE", "TOK_TRANSFORM", "TOK_TRUE", "TOK_TRUNCATETABLE", "TOK_UNION", "TOK_UNIONTYPE", "TOK_UNIQUEJOIN", "TOK_UNLOCKDB", "TOK_UNLOCKTABLE", "TOK_UPDATE_TABLE", "TOK_URI_TYPE", "TOK_USER", "TOK_USERSCRIPTCOLNAMES", "TOK_USERSCRIPTCOLSCHEMA", "TOK_VALUES_TABLE", "TOK_VALUE_ROW", "TOK_VARCHAR", "TOK_VIEWPARTCOLS", "TOK_VIRTUAL_TABLE", "TOK_VIRTUAL_TABREF", "TOK_WHERE", "TOK_WINDOWDEF", "TOK_WINDOWRANGE", "TOK_WINDOWSPEC", "TOK_WINDOWVALUES", "898"
    };

    public static final int EOF=-1;
    public static final int AMPERSAND=4;
    public static final int BITWISEOR=5;
    public static final int BITWISEXOR=6;
    public static final int BigintLiteral=7;
    public static final int ByteLengthLiteral=8;
    public static final int COLON=9;
    public static final int COMMA=10;
    public static final int COMMENT=11;
    public static final int CharSetLiteral=12;
    public static final int CharSetName=13;
    public static final int DIV=14;
    public static final int DIVIDE=15;
    public static final int DOLLAR=16;
    public static final int DOT=17;
    public static final int DecimalLiteral=18;
    public static final int Digit=19;
    public static final int EQUAL=20;
    public static final int EQUAL_NS=21;
    public static final int Exponent=22;
    public static final int GREATERTHAN=23;
    public static final int GREATERTHANOREQUALTO=24;
    public static final int HexDigit=25;
    public static final int Identifier=26;
    public static final int KW_ADD=27;
    public static final int KW_ADMIN=28;
    public static final int KW_AFTER=29;
    public static final int KW_ALL=30;
    public static final int KW_ALTER=31;
    public static final int KW_ANALYZE=32;
    public static final int KW_AND=33;
    public static final int KW_ARCHIVE=34;
    public static final int KW_ARRAY=35;
    public static final int KW_AS=36;
    public static final int KW_ASC=37;
    public static final int KW_AUTHORIZATION=38;
    public static final int KW_BEFORE=39;
    public static final int KW_BETWEEN=40;
    public static final int KW_BIGINT=41;
    public static final int KW_BINARY=42;
    public static final int KW_BOOLEAN=43;
    public static final int KW_BOTH=44;
    public static final int KW_BUCKET=45;
    public static final int KW_BUCKETS=46;
    public static final int KW_BY=47;
    public static final int KW_CASCADE=48;
    public static final int KW_CASE=49;
    public static final int KW_CAST=50;
    public static final int KW_CHANGE=51;
    public static final int KW_CHAR=52;
    public static final int KW_CLUSTER=53;
    public static final int KW_CLUSTERED=54;
    public static final int KW_CLUSTERSTATUS=55;
    public static final int KW_COLLECTION=56;
    public static final int KW_COLUMN=57;
    public static final int KW_COLUMNS=58;
    public static final int KW_COMMENT=59;
    public static final int KW_COMPACT=60;
    public static final int KW_COMPACTIONS=61;
    public static final int KW_COMPUTE=62;
    public static final int KW_CONCATENATE=63;
    public static final int KW_CONF=64;
    public static final int KW_CONTINUE=65;
    public static final int KW_CREATE=66;
    public static final int KW_CROSS=67;
    public static final int KW_CUBE=68;
    public static final int KW_CURRENT=69;
    public static final int KW_CURSOR=70;
    public static final int KW_DATA=71;
    public static final int KW_DATABASE=72;
    public static final int KW_DATABASES=73;
    public static final int KW_DATE=74;
    public static final int KW_DATETIME=75;
    public static final int KW_DBPROPERTIES=76;
    public static final int KW_DECIMAL=77;
    public static final int KW_DEFAULT=78;
    public static final int KW_DEFERRED=79;
    public static final int KW_DEFINED=80;
    public static final int KW_DELETE=81;
    public static final int KW_DELIMITED=82;
    public static final int KW_DEPENDENCY=83;
    public static final int KW_DESC=84;
    public static final int KW_DESCRIBE=85;
    public static final int KW_DIRECTORIES=86;
    public static final int KW_DIRECTORY=87;
    public static final int KW_DISABLE=88;
    public static final int KW_DISTINCT=89;
    public static final int KW_DISTRIBUTE=90;
    public static final int KW_DOUBLE=91;
    public static final int KW_DROP=92;
    public static final int KW_ELEM_TYPE=93;
    public static final int KW_ELSE=94;
    public static final int KW_ENABLE=95;
    public static final int KW_END=96;
    public static final int KW_ESCAPED=97;
    public static final int KW_EXCHANGE=98;
    public static final int KW_EXCLUSIVE=99;
    public static final int KW_EXISTS=100;
    public static final int KW_EXPLAIN=101;
    public static final int KW_EXPORT=102;
    public static final int KW_EXTENDED=103;
    public static final int KW_EXTERNAL=104;
    public static final int KW_FALSE=105;
    public static final int KW_FETCH=106;
    public static final int KW_FIELDS=107;
    public static final int KW_FILE=108;
    public static final int KW_FILEFORMAT=109;
    public static final int KW_FIRST=110;
    public static final int KW_FLOAT=111;
    public static final int KW_FOLLOWING=112;
    public static final int KW_FOR=113;
    public static final int KW_FORMAT=114;
    public static final int KW_FORMATTED=115;
    public static final int KW_FROM=116;
    public static final int KW_FULL=117;
    public static final int KW_FUNCTION=118;
    public static final int KW_FUNCTIONS=119;
    public static final int KW_GRANT=120;
    public static final int KW_GROUP=121;
    public static final int KW_GROUPING=122;
    public static final int KW_HAVING=123;
    public static final int KW_HOLD_DDLTIME=124;
    public static final int KW_IDXPROPERTIES=125;
    public static final int KW_IF=126;
    public static final int KW_IGNORE=127;
    public static final int KW_IMPORT=128;
    public static final int KW_IN=129;
    public static final int KW_INDEX=130;
    public static final int KW_INDEXES=131;
    public static final int KW_INNER=132;
    public static final int KW_INPATH=133;
    public static final int KW_INPUTDRIVER=134;
    public static final int KW_INPUTFORMAT=135;
    public static final int KW_INSERT=136;
    public static final int KW_INT=137;
    public static final int KW_INTERSECT=138;
    public static final int KW_INTO=139;
    public static final int KW_IS=140;
    public static final int KW_ITEMS=141;
    public static final int KW_JAR=142;
    public static final int KW_JOIN=143;
    public static final int KW_KEYS=144;
    public static final int KW_KEY_TYPE=145;
    public static final int KW_LATERAL=146;
    public static final int KW_LEFT=147;
    public static final int KW_LESS=148;
    public static final int KW_LIKE=149;
    public static final int KW_LIMIT=150;
    public static final int KW_LINES=151;
    public static final int KW_LOAD=152;
    public static final int KW_LOCAL=153;
    public static final int KW_LOCATION=154;
    public static final int KW_LOCK=155;
    public static final int KW_LOCKS=156;
    public static final int KW_LOGICAL=157;
    public static final int KW_LONG=158;
    public static final int KW_MACRO=159;
    public static final int KW_MAP=160;
    public static final int KW_MAPJOIN=161;
    public static final int KW_MATERIALIZED=162;
    public static final int KW_MINUS=163;
    public static final int KW_MORE=164;
    public static final int KW_MSCK=165;
    public static final int KW_NONE=166;
    public static final int KW_NOSCAN=167;
    public static final int KW_NOT=168;
    public static final int KW_NO_DROP=169;
    public static final int KW_NULL=170;
    public static final int KW_OF=171;
    public static final int KW_OFFLINE=172;
    public static final int KW_ON=173;
    public static final int KW_OPTION=174;
    public static final int KW_OR=175;
    public static final int KW_ORDER=176;
    public static final int KW_OUT=177;
    public static final int KW_OUTER=178;
    public static final int KW_OUTPUTDRIVER=179;
    public static final int KW_OUTPUTFORMAT=180;
    public static final int KW_OVER=181;
    public static final int KW_OVERWRITE=182;
    public static final int KW_OWNER=183;
    public static final int KW_PARTIALSCAN=184;
    public static final int KW_PARTITION=185;
    public static final int KW_PARTITIONED=186;
    public static final int KW_PARTITIONS=187;
    public static final int KW_PERCENT=188;
    public static final int KW_PLUS=189;
    public static final int KW_PRECEDING=190;
    public static final int KW_PRESERVE=191;
    public static final int KW_PRETTY=192;
    public static final int KW_PRINCIPALS=193;
    public static final int KW_PROCEDURE=194;
    public static final int KW_PROTECTION=195;
    public static final int KW_PURGE=196;
    public static final int KW_RANGE=197;
    public static final int KW_READ=198;
    public static final int KW_READONLY=199;
    public static final int KW_READS=200;
    public static final int KW_REBUILD=201;
    public static final int KW_RECORDREADER=202;
    public static final int KW_RECORDWRITER=203;
    public static final int KW_REDUCE=204;
    public static final int KW_REGEXP=205;
    public static final int KW_RENAME=206;
    public static final int KW_REPAIR=207;
    public static final int KW_REPLACE=208;
    public static final int KW_RESTRICT=209;
    public static final int KW_REVOKE=210;
    public static final int KW_REWRITE=211;
    public static final int KW_RIGHT=212;
    public static final int KW_RLIKE=213;
    public static final int KW_ROLE=214;
    public static final int KW_ROLES=215;
    public static final int KW_ROLLUP=216;
    public static final int KW_ROW=217;
    public static final int KW_ROWS=218;
    public static final int KW_SCHEMA=219;
    public static final int KW_SCHEMAS=220;
    public static final int KW_SELECT=221;
    public static final int KW_SEMI=222;
    public static final int KW_SERDE=223;
    public static final int KW_SERDEPROPERTIES=224;
    public static final int KW_SERVER=225;
    public static final int KW_SET=226;
    public static final int KW_SETS=227;
    public static final int KW_SHARED=228;
    public static final int KW_SHOW=229;
    public static final int KW_SHOW_DATABASE=230;
    public static final int KW_SKEWED=231;
    public static final int KW_SMALLINT=232;
    public static final int KW_SORT=233;
    public static final int KW_SORTED=234;
    public static final int KW_SSL=235;
    public static final int KW_STATISTICS=236;
    public static final int KW_STORED=237;
    public static final int KW_STREAMTABLE=238;
    public static final int KW_STRING=239;
    public static final int KW_STRUCT=240;
    public static final int KW_TABLE=241;
    public static final int KW_TABLES=242;
    public static final int KW_TABLESAMPLE=243;
    public static final int KW_TBLPROPERTIES=244;
    public static final int KW_TEMPORARY=245;
    public static final int KW_TERMINATED=246;
    public static final int KW_THEN=247;
    public static final int KW_TIMESTAMP=248;
    public static final int KW_TINYINT=249;
    public static final int KW_TO=250;
    public static final int KW_TOUCH=251;
    public static final int KW_TRANSACTIONS=252;
    public static final int KW_TRANSFORM=253;
    public static final int KW_TRIGGER=254;
    public static final int KW_TRUE=255;
    public static final int KW_TRUNCATE=256;
    public static final int KW_UNARCHIVE=257;
    public static final int KW_UNBOUNDED=258;
    public static final int KW_UNDO=259;
    public static final int KW_UNION=260;
    public static final int KW_UNIONTYPE=261;
    public static final int KW_UNIQUEJOIN=262;
    public static final int KW_UNLOCK=263;
    public static final int KW_UNSET=264;
    public static final int KW_UNSIGNED=265;
    public static final int KW_UPDATE=266;
    public static final int KW_URI=267;
    public static final int KW_USE=268;
    public static final int KW_USER=269;
    public static final int KW_USING=270;
    public static final int KW_UTC=271;
    public static final int KW_UTCTIMESTAMP=272;
    public static final int KW_VALUES=273;
    public static final int KW_VALUE_TYPE=274;
    public static final int KW_VARCHAR=275;
    public static final int KW_VIEW=276;
    public static final int KW_WHEN=277;
    public static final int KW_WHERE=278;
    public static final int KW_WHILE=279;
    public static final int KW_WINDOW=280;
    public static final int KW_WITH=281;
    public static final int LCURLY=282;
    public static final int LESSTHAN=283;
    public static final int LESSTHANOREQUALTO=284;
    public static final int LPAREN=285;
    public static final int LSQUARE=286;
    public static final int Letter=287;
    public static final int MINUS=288;
    public static final int MOD=289;
    public static final int NOTEQUAL=290;
    public static final int Number=291;
    public static final int PLUS=292;
    public static final int QUESTION=293;
    public static final int QuotedIdentifier=294;
    public static final int RCURLY=295;
    public static final int RPAREN=296;
    public static final int RSQUARE=297;
    public static final int RegexComponent=298;
    public static final int SEMICOLON=299;
    public static final int STAR=300;
    public static final int SmallintLiteral=301;
    public static final int StringLiteral=302;
    public static final int TILDE=303;
    public static final int TinyintLiteral=304;
    public static final int WS=305;
    public static final int TOK_ADMIN_OPTION_FOR=582;
    public static final int TOK_ALIASLIST=583;
    public static final int TOK_ALLCOLREF=584;
    public static final int TOK_ALTERDATABASE_OWNER=585;
    public static final int TOK_ALTERDATABASE_PROPERTIES=586;
    public static final int TOK_ALTERINDEX_PROPERTIES=587;
    public static final int TOK_ALTERINDEX_REBUILD=588;
    public static final int TOK_ALTERTABLE=589;
    public static final int TOK_ALTERTABLE_ADDCOLS=590;
    public static final int TOK_ALTERTABLE_ADDPARTS=591;
    public static final int TOK_ALTERTABLE_ARCHIVE=592;
    public static final int TOK_ALTERTABLE_BUCKETS=593;
    public static final int TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION=594;
    public static final int TOK_ALTERTABLE_CLUSTER_SORT=595;
    public static final int TOK_ALTERTABLE_COMPACT=596;
    public static final int TOK_ALTERTABLE_DROPPARTS=597;
    public static final int TOK_ALTERTABLE_DROPPROPERTIES=598;
    public static final int TOK_ALTERTABLE_EXCHANGEPARTITION=599;
    public static final int TOK_ALTERTABLE_FILEFORMAT=600;
    public static final int TOK_ALTERTABLE_LOCATION=601;
    public static final int TOK_ALTERTABLE_MERGEFILES=602;
    public static final int TOK_ALTERTABLE_PARTCOLTYPE=603;
    public static final int TOK_ALTERTABLE_PROPERTIES=604;
    public static final int TOK_ALTERTABLE_PROTECTMODE=605;
    public static final int TOK_ALTERTABLE_RENAME=606;
    public static final int TOK_ALTERTABLE_RENAMECOL=607;
    public static final int TOK_ALTERTABLE_RENAMEPART=608;
    public static final int TOK_ALTERTABLE_REPLACECOLS=609;
    public static final int TOK_ALTERTABLE_SERDEPROPERTIES=610;
    public static final int TOK_ALTERTABLE_SERIALIZER=611;
    public static final int TOK_ALTERTABLE_SKEWED=612;
    public static final int TOK_ALTERTABLE_SKEWED_LOCATION=613;
    public static final int TOK_ALTERTABLE_TOUCH=614;
    public static final int TOK_ALTERTABLE_UNARCHIVE=615;
    public static final int TOK_ALTERTABLE_UPDATECOLSTATS=616;
    public static final int TOK_ALTERVIEW=617;
    public static final int TOK_ALTERVIEW_ADDPARTS=618;
    public static final int TOK_ALTERVIEW_DROPPARTS=619;
    public static final int TOK_ALTERVIEW_DROPPROPERTIES=620;
    public static final int TOK_ALTERVIEW_PROPERTIES=621;
    public static final int TOK_ALTERVIEW_RENAME=622;
    public static final int TOK_ANALYZE=623;
    public static final int TOK_ANONYMOUS=624;
    public static final int TOK_ARCHIVE=625;
    public static final int TOK_BIGINT=626;
    public static final int TOK_BINARY=627;
    public static final int TOK_BOOLEAN=628;
    public static final int TOK_CASCADE=629;
    public static final int TOK_CHAR=630;
    public static final int TOK_CHARSETLITERAL=631;
    public static final int TOK_CLUSTERBY=632;
    public static final int TOK_COLTYPELIST=633;
    public static final int TOK_COL_NAME=634;
    public static final int TOK_CREATEDATABASE=635;
    public static final int TOK_CREATEFUNCTION=636;
    public static final int TOK_CREATEINDEX=637;
    public static final int TOK_CREATEINDEX_INDEXTBLNAME=638;
    public static final int TOK_CREATEMACRO=639;
    public static final int TOK_CREATEROLE=640;
    public static final int TOK_CREATETABLE=641;
    public static final int TOK_CREATEVIEW=642;
    public static final int TOK_CROSSJOIN=643;
    public static final int TOK_CTE=644;
    public static final int TOK_CUBE_GROUPBY=645;
    public static final int TOK_DATABASECOMMENT=646;
    public static final int TOK_DATABASELOCATION=647;
    public static final int TOK_DATABASEPROPERTIES=648;
    public static final int TOK_DATE=649;
    public static final int TOK_DATELITERAL=650;
    public static final int TOK_DATETIME=651;
    public static final int TOK_DBPROPLIST=652;
    public static final int TOK_DB_TYPE=653;
    public static final int TOK_DECIMAL=654;
    public static final int TOK_DEFERRED_REBUILDINDEX=655;
    public static final int TOK_DELETE_FROM=656;
    public static final int TOK_DESCDATABASE=657;
    public static final int TOK_DESCFUNCTION=658;
    public static final int TOK_DESCTABLE=659;
    public static final int TOK_DESTINATION=660;
    public static final int TOK_DIR=661;
    public static final int TOK_DISABLE=662;
    public static final int TOK_DISTRIBUTEBY=663;
    public static final int TOK_DOUBLE=664;
    public static final int TOK_DROPDATABASE=665;
    public static final int TOK_DROPFUNCTION=666;
    public static final int TOK_DROPINDEX=667;
    public static final int TOK_DROPMACRO=668;
    public static final int TOK_DROPROLE=669;
    public static final int TOK_DROPTABLE=670;
    public static final int TOK_DROPVIEW=671;
    public static final int TOK_ENABLE=672;
    public static final int TOK_EXPLAIN=673;
    public static final int TOK_EXPLAIN_SQ_REWRITE=674;
    public static final int TOK_EXPLIST=675;
    public static final int TOK_EXPORT=676;
    public static final int TOK_FALSE=677;
    public static final int TOK_FILE=678;
    public static final int TOK_FILEFORMAT_GENERIC=679;
    public static final int TOK_FLOAT=680;
    public static final int TOK_FROM=681;
    public static final int TOK_FULLOUTERJOIN=682;
    public static final int TOK_FUNCTION=683;
    public static final int TOK_FUNCTIONDI=684;
    public static final int TOK_FUNCTIONSTAR=685;
    public static final int TOK_GRANT=686;
    public static final int TOK_GRANT_OPTION_FOR=687;
    public static final int TOK_GRANT_ROLE=688;
    public static final int TOK_GRANT_WITH_ADMIN_OPTION=689;
    public static final int TOK_GRANT_WITH_OPTION=690;
    public static final int TOK_GROUP=691;
    public static final int TOK_GROUPBY=692;
    public static final int TOK_GROUPING_SETS=693;
    public static final int TOK_GROUPING_SETS_EXPRESSION=694;
    public static final int TOK_HAVING=695;
    public static final int TOK_HINT=696;
    public static final int TOK_HINTARGLIST=697;
    public static final int TOK_HINTLIST=698;
    public static final int TOK_HOLD_DDLTIME=699;
    public static final int TOK_IFEXISTS=700;
    public static final int TOK_IFNOTEXISTS=701;
    public static final int TOK_IGNOREPROTECTION=702;
    public static final int TOK_IMPORT=703;
    public static final int TOK_INDEXCOMMENT=704;
    public static final int TOK_INDEXPROPERTIES=705;
    public static final int TOK_INDEXPROPLIST=706;
    public static final int TOK_INSERT=707;
    public static final int TOK_INSERT_INTO=708;
    public static final int TOK_INT=709;
    public static final int TOK_ISNOTNULL=710;
    public static final int TOK_ISNULL=711;
    public static final int TOK_JAR=712;
    public static final int TOK_JOIN=713;
    public static final int TOK_LATERAL_VIEW=714;
    public static final int TOK_LATERAL_VIEW_OUTER=715;
    public static final int TOK_LEFTOUTERJOIN=716;
    public static final int TOK_LEFTSEMIJOIN=717;
    public static final int TOK_LENGTH=718;
    public static final int TOK_LIKETABLE=719;
    public static final int TOK_LIMIT=720;
    public static final int TOK_LIST=721;
    public static final int TOK_LOAD=722;
    public static final int TOK_LOCAL_DIR=723;
    public static final int TOK_LOCKDB=724;
    public static final int TOK_LOCKTABLE=725;
    public static final int TOK_MAP=726;
    public static final int TOK_MAPJOIN=727;
    public static final int TOK_MSCK=728;
    public static final int TOK_NOT_CLUSTERED=729;
    public static final int TOK_NOT_SORTED=730;
    public static final int TOK_NO_DROP=731;
    public static final int TOK_NULL=732;
    public static final int TOK_OFFLINE=733;
    public static final int TOK_OP_ADD=734;
    public static final int TOK_OP_AND=735;
    public static final int TOK_OP_BITAND=736;
    public static final int TOK_OP_BITNOT=737;
    public static final int TOK_OP_BITOR=738;
    public static final int TOK_OP_BITXOR=739;
    public static final int TOK_OP_DIV=740;
    public static final int TOK_OP_EQ=741;
    public static final int TOK_OP_GE=742;
    public static final int TOK_OP_GT=743;
    public static final int TOK_OP_LE=744;
    public static final int TOK_OP_LIKE=745;
    public static final int TOK_OP_LT=746;
    public static final int TOK_OP_MOD=747;
    public static final int TOK_OP_MUL=748;
    public static final int TOK_OP_NE=749;
    public static final int TOK_OP_NOT=750;
    public static final int TOK_OP_OR=751;
    public static final int TOK_OP_SUB=752;
    public static final int TOK_ORDERBY=753;
    public static final int TOK_ORREPLACE=754;
    public static final int TOK_PARTITIONINGSPEC=755;
    public static final int TOK_PARTITIONLOCATION=756;
    public static final int TOK_PARTSPEC=757;
    public static final int TOK_PARTVAL=758;
    public static final int TOK_PERCENT=759;
    public static final int TOK_PRINCIPAL_NAME=760;
    public static final int TOK_PRIVILEGE=761;
    public static final int TOK_PRIVILEGE_LIST=762;
    public static final int TOK_PRIV_ALL=763;
    public static final int TOK_PRIV_ALTER_DATA=764;
    public static final int TOK_PRIV_ALTER_METADATA=765;
    public static final int TOK_PRIV_CREATE=766;
    public static final int TOK_PRIV_DELETE=767;
    public static final int TOK_PRIV_DROP=768;
    public static final int TOK_PRIV_INDEX=769;
    public static final int TOK_PRIV_INSERT=770;
    public static final int TOK_PRIV_LOCK=771;
    public static final int TOK_PRIV_OBJECT=772;
    public static final int TOK_PRIV_OBJECT_COL=773;
    public static final int TOK_PRIV_SELECT=774;
    public static final int TOK_PRIV_SHOW_DATABASE=775;
    public static final int TOK_PTBLFUNCTION=776;
    public static final int TOK_QUERY=777;
    public static final int TOK_READONLY=778;
    public static final int TOK_RECORDREADER=779;
    public static final int TOK_RECORDWRITER=780;
    public static final int TOK_RESOURCE_ALL=781;
    public static final int TOK_RESOURCE_LIST=782;
    public static final int TOK_RESOURCE_URI=783;
    public static final int TOK_RESTRICT=784;
    public static final int TOK_REVOKE=785;
    public static final int TOK_REVOKE_ROLE=786;
    public static final int TOK_RIGHTOUTERJOIN=787;
    public static final int TOK_ROLE=788;
    public static final int TOK_ROLLUP_GROUPBY=789;
    public static final int TOK_ROWCOUNT=790;
    public static final int TOK_SELECT=791;
    public static final int TOK_SELECTDI=792;
    public static final int TOK_SELEXPR=793;
    public static final int TOK_SERDE=794;
    public static final int TOK_SERDENAME=795;
    public static final int TOK_SERDEPROPS=796;
    public static final int TOK_SERVER_TYPE=797;
    public static final int TOK_SET_COLUMNS_CLAUSE=798;
    public static final int TOK_SHOWCOLUMNS=799;
    public static final int TOK_SHOWCONF=800;
    public static final int TOK_SHOWDATABASES=801;
    public static final int TOK_SHOWDBLOCKS=802;
    public static final int TOK_SHOWFUNCTIONS=803;
    public static final int TOK_SHOWINDEXES=804;
    public static final int TOK_SHOWLOCKS=805;
    public static final int TOK_SHOWPARTITIONS=806;
    public static final int TOK_SHOWTABLES=807;
    public static final int TOK_SHOW_COMPACTIONS=808;
    public static final int TOK_SHOW_CREATETABLE=809;
    public static final int TOK_SHOW_GRANT=810;
    public static final int TOK_SHOW_ROLES=811;
    public static final int TOK_SHOW_ROLE_GRANT=812;
    public static final int TOK_SHOW_ROLE_PRINCIPALS=813;
    public static final int TOK_SHOW_SET_ROLE=814;
    public static final int TOK_SHOW_TABLESTATUS=815;
    public static final int TOK_SHOW_TBLPROPERTIES=816;
    public static final int TOK_SHOW_TRANSACTIONS=817;
    public static final int TOK_SKEWED_LOCATIONS=818;
    public static final int TOK_SKEWED_LOCATION_LIST=819;
    public static final int TOK_SKEWED_LOCATION_MAP=820;
    public static final int TOK_SMALLINT=821;
    public static final int TOK_SORTBY=822;
    public static final int TOK_STORAGEHANDLER=823;
    public static final int TOK_STOREDASDIRS=824;
    public static final int TOK_STREAMTABLE=825;
    public static final int TOK_STRING=826;
    public static final int TOK_STRINGLITERALSEQUENCE=827;
    public static final int TOK_STRUCT=828;
    public static final int TOK_SUBQUERY=829;
    public static final int TOK_SUBQUERY_EXPR=830;
    public static final int TOK_SUBQUERY_OP=831;
    public static final int TOK_SUBQUERY_OP_NOTEXISTS=832;
    public static final int TOK_SUBQUERY_OP_NOTIN=833;
    public static final int TOK_SWITCHDATABASE=834;
    public static final int TOK_TAB=835;
    public static final int TOK_TABALIAS=836;
    public static final int TOK_TABCOL=837;
    public static final int TOK_TABCOLLIST=838;
    public static final int TOK_TABCOLNAME=839;
    public static final int TOK_TABCOLVALUE=840;
    public static final int TOK_TABCOLVALUES=841;
    public static final int TOK_TABCOLVALUE_PAIR=842;
    public static final int TOK_TABLEBUCKETSAMPLE=843;
    public static final int TOK_TABLECOMMENT=844;
    public static final int TOK_TABLEFILEFORMAT=845;
    public static final int TOK_TABLELOCATION=846;
    public static final int TOK_TABLEPARTCOLS=847;
    public static final int TOK_TABLEPROPERTIES=848;
    public static final int TOK_TABLEPROPERTY=849;
    public static final int TOK_TABLEPROPLIST=850;
    public static final int TOK_TABLEROWFORMAT=851;
    public static final int TOK_TABLEROWFORMATCOLLITEMS=852;
    public static final int TOK_TABLEROWFORMATFIELD=853;
    public static final int TOK_TABLEROWFORMATLINES=854;
    public static final int TOK_TABLEROWFORMATMAPKEYS=855;
    public static final int TOK_TABLEROWFORMATNULL=856;
    public static final int TOK_TABLESERIALIZER=857;
    public static final int TOK_TABLESKEWED=858;
    public static final int TOK_TABLESPLITSAMPLE=859;
    public static final int TOK_TABLE_OR_COL=860;
    public static final int TOK_TABLE_PARTITION=861;
    public static final int TOK_TABLE_TYPE=862;
    public static final int TOK_TABNAME=863;
    public static final int TOK_TABREF=864;
    public static final int TOK_TABSORTCOLNAMEASC=865;
    public static final int TOK_TABSORTCOLNAMEDESC=866;
    public static final int TOK_TABSRC=867;
    public static final int TOK_TABTYPE=868;
    public static final int TOK_TEMPORARY=869;
    public static final int TOK_TIMESTAMP=870;
    public static final int TOK_TIMESTAMPLITERAL=871;
    public static final int TOK_TINYINT=872;
    public static final int TOK_TMP_FILE=873;
    public static final int TOK_TRANSFORM=874;
    public static final int TOK_TRUE=875;
    public static final int TOK_TRUNCATETABLE=876;
    public static final int TOK_UNION=877;
    public static final int TOK_UNIONTYPE=878;
    public static final int TOK_UNIQUEJOIN=879;
    public static final int TOK_UNLOCKDB=880;
    public static final int TOK_UNLOCKTABLE=881;
    public static final int TOK_UPDATE_TABLE=882;
    public static final int TOK_URI_TYPE=883;
    public static final int TOK_USER=884;
    public static final int TOK_USERSCRIPTCOLNAMES=885;
    public static final int TOK_USERSCRIPTCOLSCHEMA=886;
    public static final int TOK_VALUES_TABLE=887;
    public static final int TOK_VALUE_ROW=888;
    public static final int TOK_VARCHAR=889;
    public static final int TOK_VIEWPARTCOLS=890;
    public static final int TOK_VIRTUAL_TABLE=891;
    public static final int TOK_VIRTUAL_TABREF=892;
    public static final int TOK_WHERE=893;
    public static final int TOK_WINDOWDEF=894;
    public static final int TOK_WINDOWRANGE=895;
    public static final int TOK_WINDOWSPEC=896;
    public static final int TOK_WINDOWVALUES=897;

    // delegates
    public HiveParser_SelectClauseParser gSelectClauseParser;
    public HiveParser_FromClauseParser gFromClauseParser;
    public HiveParser_IdentifiersParser gIdentifiersParser;
    public Parser[] getDelegates() {
        return new Parser[] {gSelectClauseParser, gFromClauseParser, gIdentifiersParser};
    }

    // delegators


    public HiveParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public HiveParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
        gSelectClauseParser = new HiveParser_SelectClauseParser(input, state, this);
        gFromClauseParser = new HiveParser_FromClauseParser(input, state, this);
        gIdentifiersParser = new HiveParser_IdentifiersParser(input, state, this);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
    gSelectClauseParser.setTreeAdaptor(this.adaptor);gFromClauseParser.setTreeAdaptor(this.adaptor);gIdentifiersParser.setTreeAdaptor(this.adaptor);
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return HiveParser.tokenNames; }
    public String getGrammarFileName() { return "org/apache/hadoop/hive/ql/parse/HiveParser.g"; }


      ArrayList<ParseError> errors = new ArrayList<ParseError>();
      Stack msgs = new Stack<String>();

      private static HashMap<String, String> xlateMap;
      static {
        xlateMap = new HashMap<String, String>();

        // Keywords
        xlateMap.put("KW_TRUE", "TRUE");
        xlateMap.put("KW_FALSE", "FALSE");
        xlateMap.put("KW_ALL", "ALL");
        xlateMap.put("KW_NONE", "NONE");
        xlateMap.put("KW_DEFAULT", "DEFAULT");
        xlateMap.put("KW_AND", "AND");
        xlateMap.put("KW_OR", "OR");
        xlateMap.put("KW_NOT", "NOT");
        xlateMap.put("KW_LIKE", "LIKE");

        xlateMap.put("KW_ASC", "ASC");
        xlateMap.put("KW_DESC", "DESC");
        xlateMap.put("KW_ORDER", "ORDER");
        xlateMap.put("KW_BY", "BY");
        xlateMap.put("KW_GROUP", "GROUP");
        xlateMap.put("KW_WHERE", "WHERE");
        xlateMap.put("KW_FROM", "FROM");
        xlateMap.put("KW_AS", "AS");
        xlateMap.put("KW_SELECT", "SELECT");
        xlateMap.put("KW_DISTINCT", "DISTINCT");
        xlateMap.put("KW_INSERT", "INSERT");
        xlateMap.put("KW_OVERWRITE", "OVERWRITE");
        xlateMap.put("KW_OUTER", "OUTER");
        xlateMap.put("KW_JOIN", "JOIN");
        xlateMap.put("KW_LEFT", "LEFT");
        xlateMap.put("KW_RIGHT", "RIGHT");
        xlateMap.put("KW_FULL", "FULL");
        xlateMap.put("KW_ON", "ON");
        xlateMap.put("KW_PARTITION", "PARTITION");
        xlateMap.put("KW_PARTITIONS", "PARTITIONS");
        xlateMap.put("KW_TABLE", "TABLE");
        xlateMap.put("KW_TABLES", "TABLES");
        xlateMap.put("KW_TBLPROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_SHOW", "SHOW");
        xlateMap.put("KW_MSCK", "MSCK");
        xlateMap.put("KW_DIRECTORY", "DIRECTORY");
        xlateMap.put("KW_LOCAL", "LOCAL");
        xlateMap.put("KW_TRANSFORM", "TRANSFORM");
        xlateMap.put("KW_USING", "USING");
        xlateMap.put("KW_CLUSTER", "CLUSTER");
        xlateMap.put("KW_DISTRIBUTE", "DISTRIBUTE");
        xlateMap.put("KW_SORT", "SORT");
        xlateMap.put("KW_UNION", "UNION");
        xlateMap.put("KW_LOAD", "LOAD");
        xlateMap.put("KW_DATA", "DATA");
        xlateMap.put("KW_INPATH", "INPATH");
        xlateMap.put("KW_IS", "IS");
        xlateMap.put("KW_NULL", "NULL");
        xlateMap.put("KW_CREATE", "CREATE");
        xlateMap.put("KW_EXTERNAL", "EXTERNAL");
        xlateMap.put("KW_ALTER", "ALTER");
        xlateMap.put("KW_DESCRIBE", "DESCRIBE");
        xlateMap.put("KW_DROP", "DROP");
        xlateMap.put("KW_RENAME", "RENAME");
        xlateMap.put("KW_TO", "TO");
        xlateMap.put("KW_COMMENT", "COMMENT");
        xlateMap.put("KW_BOOLEAN", "BOOLEAN");
        xlateMap.put("KW_TINYINT", "TINYINT");
        xlateMap.put("KW_SMALLINT", "SMALLINT");
        xlateMap.put("KW_INT", "INT");
        xlateMap.put("KW_BIGINT", "BIGINT");
        xlateMap.put("KW_FLOAT", "FLOAT");
        xlateMap.put("KW_DOUBLE", "DOUBLE");
        xlateMap.put("KW_DATE", "DATE");
        xlateMap.put("KW_DATETIME", "DATETIME");
        xlateMap.put("KW_TIMESTAMP", "TIMESTAMP");
        xlateMap.put("KW_STRING", "STRING");
        xlateMap.put("KW_BINARY", "BINARY");
        xlateMap.put("KW_ARRAY", "ARRAY");
        xlateMap.put("KW_MAP", "MAP");
        xlateMap.put("KW_REDUCE", "REDUCE");
        xlateMap.put("KW_PARTITIONED", "PARTITIONED");
        xlateMap.put("KW_CLUSTERED", "CLUSTERED");
        xlateMap.put("KW_SORTED", "SORTED");
        xlateMap.put("KW_INTO", "INTO");
        xlateMap.put("KW_BUCKETS", "BUCKETS");
        xlateMap.put("KW_ROW", "ROW");
        xlateMap.put("KW_FORMAT", "FORMAT");
        xlateMap.put("KW_DELIMITED", "DELIMITED");
        xlateMap.put("KW_FIELDS", "FIELDS");
        xlateMap.put("KW_TERMINATED", "TERMINATED");
        xlateMap.put("KW_COLLECTION", "COLLECTION");
        xlateMap.put("KW_ITEMS", "ITEMS");
        xlateMap.put("KW_KEYS", "KEYS");
        xlateMap.put("KW_KEY_TYPE", "$KEY$");
        xlateMap.put("KW_LINES", "LINES");
        xlateMap.put("KW_STORED", "STORED");
        xlateMap.put("KW_SEQUENCEFILE", "SEQUENCEFILE");
        xlateMap.put("KW_TEXTFILE", "TEXTFILE");
        xlateMap.put("KW_INPUTFORMAT", "INPUTFORMAT");
        xlateMap.put("KW_OUTPUTFORMAT", "OUTPUTFORMAT");
        xlateMap.put("KW_LOCATION", "LOCATION");
        xlateMap.put("KW_TABLESAMPLE", "TABLESAMPLE");
        xlateMap.put("KW_BUCKET", "BUCKET");
        xlateMap.put("KW_OUT", "OUT");
        xlateMap.put("KW_OF", "OF");
        xlateMap.put("KW_CAST", "CAST");
        xlateMap.put("KW_ADD", "ADD");
        xlateMap.put("KW_REPLACE", "REPLACE");
        xlateMap.put("KW_COLUMNS", "COLUMNS");
        xlateMap.put("KW_RLIKE", "RLIKE");
        xlateMap.put("KW_REGEXP", "REGEXP");
        xlateMap.put("KW_TEMPORARY", "TEMPORARY");
        xlateMap.put("KW_FUNCTION", "FUNCTION");
        xlateMap.put("KW_EXPLAIN", "EXPLAIN");
        xlateMap.put("KW_EXTENDED", "EXTENDED");
        xlateMap.put("KW_SERDE", "SERDE");
        xlateMap.put("KW_WITH", "WITH");
        xlateMap.put("KW_SERDEPROPERTIES", "SERDEPROPERTIES");
        xlateMap.put("KW_LIMIT", "LIMIT");
        xlateMap.put("KW_SET", "SET");
        xlateMap.put("KW_PROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_VALUE_TYPE", "$VALUE$");
        xlateMap.put("KW_ELEM_TYPE", "$ELEM$");
        xlateMap.put("KW_DEFINED", "DEFINED");
        xlateMap.put("KW_SUBQUERY", "SUBQUERY");
        xlateMap.put("KW_REWRITE", "REWRITE");
        xlateMap.put("KW_UPDATE", "UPDATE");
        xlateMap.put("KW_VALUES", "VALUES");
        xlateMap.put("KW_PURGE", "PURGE");


        // Operators
        xlateMap.put("DOT", ".");
        xlateMap.put("COLON", ":");
        xlateMap.put("COMMA", ",");
        xlateMap.put("SEMICOLON", ");");

        xlateMap.put("LPAREN", "(");
        xlateMap.put("RPAREN", ")");
        xlateMap.put("LSQUARE", "[");
        xlateMap.put("RSQUARE", "]");

        xlateMap.put("EQUAL", "=");
        xlateMap.put("NOTEQUAL", "<>");
        xlateMap.put("EQUAL_NS", "<=>");
        xlateMap.put("LESSTHANOREQUALTO", "<=");
        xlateMap.put("LESSTHAN", "<");
        xlateMap.put("GREATERTHANOREQUALTO", ">=");
        xlateMap.put("GREATERTHAN", ">");

        xlateMap.put("DIVIDE", "/");
        xlateMap.put("PLUS", "+");
        xlateMap.put("MINUS", "-");
        xlateMap.put("STAR", "*");
        xlateMap.put("MOD", "%");

        xlateMap.put("AMPERSAND", "&");
        xlateMap.put("TILDE", "~");
        xlateMap.put("BITWISEOR", "|");
        xlateMap.put("BITWISEXOR", "^");
        xlateMap.put("CharSetLiteral", "\\'");
      }

      public static Collection<String> getKeywords() {
        return xlateMap.values();
      }

      private static String xlate(String name) {

        String ret = xlateMap.get(name);
        if (ret == null) {
          ret = name;
        }

        return ret;
      }

      @Override
      public Object recoverFromMismatchedSet(IntStream input,
          RecognitionException re, BitSet follow) throws RecognitionException {
        throw re;
      }

      @Override
      public void displayRecognitionError(String[] tokenNames,
          RecognitionException e) {
        errors.add(new ParseError(this, e, tokenNames));
      }

      @Override
      public String getErrorHeader(RecognitionException e) {
        String header = null;
        if (e.charPositionInLine < 0 && input.LT(-1) != null) {
          Token t = input.LT(-1);
          header = "line " + t.getLine() + ":" + t.getCharPositionInLine();
        } else {
          header = super.getErrorHeader(e);
        }

        return header;
      }
      
      @Override
      public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        String msg = null;

        // Translate the token names to something that the user can understand
        String[] xlateNames = new String[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
          xlateNames[i] = HiveParser.xlate(tokenNames[i]);
        }

        if (e instanceof NoViableAltException) {
          @SuppressWarnings("unused")
          NoViableAltException nvae = (NoViableAltException) e;
          // for development, can add
          // "decision=<<"+nvae.grammarDecisionDescription+">>"
          // and "(decision="+nvae.decisionNumber+") and
          // "state "+nvae.stateNumber
          msg = "cannot recognize input near"
                  + (input.LT(1) != null ? " " + getTokenErrorDisplay(input.LT(1)) : "")
                  + (input.LT(2) != null ? " " + getTokenErrorDisplay(input.LT(2)) : "")
                  + (input.LT(3) != null ? " " + getTokenErrorDisplay(input.LT(3)) : "");
        } else if (e instanceof MismatchedTokenException) {
          MismatchedTokenException mte = (MismatchedTokenException) e;
          msg = super.getErrorMessage(e, xlateNames) + (input.LT(-1) == null ? "":" near '" + input.LT(-1).getText()) + "'";
        } else if (e instanceof FailedPredicateException) {
          FailedPredicateException fpe = (FailedPredicateException) e;
          msg = "Failed to recognize predicate '" + fpe.token.getText() + "'. Failed rule: '" + fpe.ruleName + "'";
        } else {
          msg = super.getErrorMessage(e, xlateNames);
        }

        if (msgs.size() > 0) {
          msg = msg + " in " + msgs.peek();
        }
        return msg;
      }
      
      public void pushMsg(String msg, RecognizerSharedState state) {
        // ANTLR generated code does not wrap the @init code wit this backtracking check,
        //  even if the matching @after has it. If we have parser rules with that are doing
        // some lookahead with syntactic predicates this can cause the push() and pop() calls
        // to become unbalanced, so make sure both push/pop check the backtracking state.
        if (state.backtracking == 0) {
          msgs.push(msg);
        }
      }

      public void popMsg(RecognizerSharedState state) {
        if (state.backtracking == 0) {
          msgs.pop();
        }
      }

      // counter to generate unique union aliases
      private int aliasCounter;
      
      private String generateUnionAlias() {
        return "_u" + (++aliasCounter);
      }


    public static class statement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:629:1: statement : ( explainStatement EOF | execStatement EOF );
    public final HiveParser.statement_return statement() throws RecognitionException {
        HiveParser.statement_return retval = new HiveParser.statement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token EOF2=null;
        Token EOF4=null;
        HiveParser.explainStatement_return explainStatement1 =null;

        HiveParser.execStatement_return execStatement3 =null;


        CommonTree EOF2_tree=null;
        CommonTree EOF4_tree=null;

        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:630:2: ( explainStatement EOF | execStatement EOF )
            int alt1=2;
            switch ( input.LA(1) ) {
            case KW_EXPLAIN:
                {
                alt1=1;
                }
                break;
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_CREATE:
            case KW_DELETE:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_EXPORT:
            case KW_FROM:
            case KW_GRANT:
            case KW_IMPORT:
            case KW_INSERT:
            case KW_LOAD:
            case KW_LOCK:
            case KW_MAP:
            case KW_MSCK:
            case KW_REDUCE:
            case KW_REVOKE:
            case KW_SELECT:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_UPDATE:
            case KW_USE:
            case KW_WITH:
                {
                alt1=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 1, 0, input);

                throw nvae;

            }

            switch (alt1) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:630:4: explainStatement EOF
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_explainStatement_in_statement1031);
                    explainStatement1=explainStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, explainStatement1.getTree());

                    EOF2=(Token)match(input,EOF,FOLLOW_EOF_in_statement1033); 
                    EOF2_tree = 
                    (CommonTree)adaptor.create(EOF2)
                    ;
                    adaptor.addChild(root_0, EOF2_tree);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:631:4: execStatement EOF
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_execStatement_in_statement1038);
                    execStatement3=execStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, execStatement3.getTree());

                    EOF4=(Token)match(input,EOF,FOLLOW_EOF_in_statement1040); 
                    EOF4_tree = 
                    (CommonTree)adaptor.create(EOF4)
                    ;
                    adaptor.addChild(root_0, EOF4_tree);


                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class explainStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "explainStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:634:1: explainStatement : KW_EXPLAIN ( ( explainOption )* execStatement -> ^( TOK_EXPLAIN execStatement ( explainOption )* ) | KW_REWRITE queryStatementExpression[true] -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression ) ) ;
    public final HiveParser.explainStatement_return explainStatement() throws RecognitionException {
        HiveParser.explainStatement_return retval = new HiveParser.explainStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_EXPLAIN5=null;
        Token KW_REWRITE8=null;
        HiveParser.explainOption_return explainOption6 =null;

        HiveParser.execStatement_return execStatement7 =null;

        HiveParser.queryStatementExpression_return queryStatementExpression9 =null;


        CommonTree KW_EXPLAIN5_tree=null;
        CommonTree KW_REWRITE8_tree=null;
        RewriteRuleTokenStream stream_KW_REWRITE=new RewriteRuleTokenStream(adaptor,"token KW_REWRITE");
        RewriteRuleTokenStream stream_KW_EXPLAIN=new RewriteRuleTokenStream(adaptor,"token KW_EXPLAIN");
        RewriteRuleSubtreeStream stream_execStatement=new RewriteRuleSubtreeStream(adaptor,"rule execStatement");
        RewriteRuleSubtreeStream stream_explainOption=new RewriteRuleSubtreeStream(adaptor,"rule explainOption");
        RewriteRuleSubtreeStream stream_queryStatementExpression=new RewriteRuleSubtreeStream(adaptor,"rule queryStatementExpression");
         pushMsg("explain statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:637:2: ( KW_EXPLAIN ( ( explainOption )* execStatement -> ^( TOK_EXPLAIN execStatement ( explainOption )* ) | KW_REWRITE queryStatementExpression[true] -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression ) ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:637:4: KW_EXPLAIN ( ( explainOption )* execStatement -> ^( TOK_EXPLAIN execStatement ( explainOption )* ) | KW_REWRITE queryStatementExpression[true] -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression ) )
            {
            KW_EXPLAIN5=(Token)match(input,KW_EXPLAIN,FOLLOW_KW_EXPLAIN_in_explainStatement1061);  
            stream_KW_EXPLAIN.add(KW_EXPLAIN5);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:637:15: ( ( explainOption )* execStatement -> ^( TOK_EXPLAIN execStatement ( explainOption )* ) | KW_REWRITE queryStatementExpression[true] -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression ) )
            int alt3=2;
            switch ( input.LA(1) ) {
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_AUTHORIZATION:
            case KW_CREATE:
            case KW_DELETE:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_EXPORT:
            case KW_EXTENDED:
            case KW_FORMATTED:
            case KW_FROM:
            case KW_GRANT:
            case KW_IMPORT:
            case KW_INSERT:
            case KW_LOAD:
            case KW_LOCK:
            case KW_LOGICAL:
            case KW_MAP:
            case KW_MSCK:
            case KW_REDUCE:
            case KW_REVOKE:
            case KW_SELECT:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_UPDATE:
            case KW_USE:
            case KW_WITH:
                {
                alt3=1;
                }
                break;
            case KW_REWRITE:
                {
                alt3=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:638:6: ( explainOption )* execStatement
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:638:6: ( explainOption )*
                    loop2:
                    do {
                        int alt2=2;
                        switch ( input.LA(1) ) {
                        case KW_AUTHORIZATION:
                        case KW_DEPENDENCY:
                        case KW_EXTENDED:
                        case KW_FORMATTED:
                        case KW_LOGICAL:
                            {
                            alt2=1;
                            }
                            break;

                        }

                        switch (alt2) {
                    	case 1 :
                    	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:638:6: explainOption
                    	    {
                    	    pushFollow(FOLLOW_explainOption_in_explainStatement1070);
                    	    explainOption6=explainOption();

                    	    state._fsp--;

                    	    stream_explainOption.add(explainOption6.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop2;
                        }
                    } while (true);


                    pushFollow(FOLLOW_execStatement_in_explainStatement1073);
                    execStatement7=execStatement();

                    state._fsp--;

                    stream_execStatement.add(execStatement7.getTree());

                    // AST REWRITE
                    // elements: execStatement, explainOption
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 638:35: -> ^( TOK_EXPLAIN execStatement ( explainOption )* )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:638:38: ^( TOK_EXPLAIN execStatement ( explainOption )* )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_EXPLAIN, "TOK_EXPLAIN")
                        , root_1);

                        adaptor.addChild(root_1, stream_execStatement.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:638:66: ( explainOption )*
                        while ( stream_explainOption.hasNext() ) {
                            adaptor.addChild(root_1, stream_explainOption.nextTree());

                        }
                        stream_explainOption.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:640:9: KW_REWRITE queryStatementExpression[true]
                    {
                    KW_REWRITE8=(Token)match(input,KW_REWRITE,FOLLOW_KW_REWRITE_in_explainStatement1104);  
                    stream_KW_REWRITE.add(KW_REWRITE8);


                    pushFollow(FOLLOW_queryStatementExpression_in_explainStatement1106);
                    queryStatementExpression9=queryStatementExpression(true);

                    state._fsp--;

                    stream_queryStatementExpression.add(queryStatementExpression9.getTree());

                    // AST REWRITE
                    // elements: queryStatementExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 640:51: -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:640:54: ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_EXPLAIN_SQ_REWRITE, "TOK_EXPLAIN_SQ_REWRITE")
                        , root_1);

                        adaptor.addChild(root_1, stream_queryStatementExpression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "explainStatement"


    public static class explainOption_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "explainOption"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:643:1: explainOption : ( KW_EXTENDED | KW_FORMATTED | KW_DEPENDENCY | KW_LOGICAL | KW_AUTHORIZATION );
    public final HiveParser.explainOption_return explainOption() throws RecognitionException {
        HiveParser.explainOption_return retval = new HiveParser.explainOption_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token set10=null;

        CommonTree set10_tree=null;

         msgs.push("explain option"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:646:5: ( KW_EXTENDED | KW_FORMATTED | KW_DEPENDENCY | KW_LOGICAL | KW_AUTHORIZATION )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:
            {
            root_0 = (CommonTree)adaptor.nil();


            set10=(Token)input.LT(1);

            if ( input.LA(1)==KW_AUTHORIZATION||input.LA(1)==KW_DEPENDENCY||input.LA(1)==KW_EXTENDED||input.LA(1)==KW_FORMATTED||input.LA(1)==KW_LOGICAL ) {
                input.consume();
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(set10)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "explainOption"


    public static class execStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "execStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:649:1: execStatement : ( queryStatementExpression[true] | loadStatement | exportStatement | importStatement | ddlStatement | deleteStatement | updateStatement );
    public final HiveParser.execStatement_return execStatement() throws RecognitionException {
        HiveParser.execStatement_return retval = new HiveParser.execStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.queryStatementExpression_return queryStatementExpression11 =null;

        HiveParser.loadStatement_return loadStatement12 =null;

        HiveParser.exportStatement_return exportStatement13 =null;

        HiveParser.importStatement_return importStatement14 =null;

        HiveParser.ddlStatement_return ddlStatement15 =null;

        HiveParser.deleteStatement_return deleteStatement16 =null;

        HiveParser.updateStatement_return updateStatement17 =null;



         pushMsg("statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:652:5: ( queryStatementExpression[true] | loadStatement | exportStatement | importStatement | ddlStatement | deleteStatement | updateStatement )
            int alt4=7;
            switch ( input.LA(1) ) {
            case KW_FROM:
            case KW_INSERT:
            case KW_MAP:
            case KW_REDUCE:
            case KW_SELECT:
            case KW_WITH:
                {
                alt4=1;
                }
                break;
            case KW_LOAD:
                {
                alt4=2;
                }
                break;
            case KW_EXPORT:
                {
                alt4=3;
                }
                break;
            case KW_IMPORT:
                {
                alt4=4;
                }
                break;
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_CREATE:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_GRANT:
            case KW_LOCK:
            case KW_MSCK:
            case KW_REVOKE:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_USE:
                {
                alt4=5;
                }
                break;
            case KW_DELETE:
                {
                alt4=6;
                }
                break;
            case KW_UPDATE:
                {
                alt4=7;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;

            }

            switch (alt4) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:652:7: queryStatementExpression[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_queryStatementExpression_in_execStatement1175);
                    queryStatementExpression11=queryStatementExpression(true);

                    state._fsp--;

                    adaptor.addChild(root_0, queryStatementExpression11.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:653:7: loadStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_loadStatement_in_execStatement1184);
                    loadStatement12=loadStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, loadStatement12.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:654:7: exportStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_exportStatement_in_execStatement1192);
                    exportStatement13=exportStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, exportStatement13.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:655:7: importStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_importStatement_in_execStatement1200);
                    importStatement14=importStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, importStatement14.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:656:7: ddlStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_ddlStatement_in_execStatement1208);
                    ddlStatement15=ddlStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, ddlStatement15.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:657:7: deleteStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_deleteStatement_in_execStatement1216);
                    deleteStatement16=deleteStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, deleteStatement16.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:658:7: updateStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_updateStatement_in_execStatement1224);
                    updateStatement17=updateStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, updateStatement17.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "execStatement"


    public static class loadStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "loadStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:661:1: loadStatement : KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition ) -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? ) ;
    public final HiveParser.loadStatement_return loadStatement() throws RecognitionException {
        HiveParser.loadStatement_return retval = new HiveParser.loadStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token islocal=null;
        Token path=null;
        Token isoverwrite=null;
        Token KW_LOAD18=null;
        Token KW_DATA19=null;
        Token KW_INPATH20=null;
        Token KW_INTO21=null;
        Token KW_TABLE22=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;


        CommonTree islocal_tree=null;
        CommonTree path_tree=null;
        CommonTree isoverwrite_tree=null;
        CommonTree KW_LOAD18_tree=null;
        CommonTree KW_DATA19_tree=null;
        CommonTree KW_INPATH20_tree=null;
        CommonTree KW_INTO21_tree=null;
        CommonTree KW_TABLE22_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INPATH=new RewriteRuleTokenStream(adaptor,"token KW_INPATH");
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_KW_LOCAL=new RewriteRuleTokenStream(adaptor,"token KW_LOCAL");
        RewriteRuleTokenStream stream_KW_OVERWRITE=new RewriteRuleTokenStream(adaptor,"token KW_OVERWRITE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_LOAD=new RewriteRuleTokenStream(adaptor,"token KW_LOAD");
        RewriteRuleTokenStream stream_KW_DATA=new RewriteRuleTokenStream(adaptor,"token KW_DATA");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
         pushMsg("load statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:5: ( KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition ) -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:7: KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition )
            {
            KW_LOAD18=(Token)match(input,KW_LOAD,FOLLOW_KW_LOAD_in_loadStatement1251);  
            stream_KW_LOAD.add(KW_LOAD18);


            KW_DATA19=(Token)match(input,KW_DATA,FOLLOW_KW_DATA_in_loadStatement1253);  
            stream_KW_DATA.add(KW_DATA19);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:23: (islocal= KW_LOCAL )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case KW_LOCAL:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:24: islocal= KW_LOCAL
                    {
                    islocal=(Token)match(input,KW_LOCAL,FOLLOW_KW_LOCAL_in_loadStatement1258);  
                    stream_KW_LOCAL.add(islocal);


                    }
                    break;

            }


            KW_INPATH20=(Token)match(input,KW_INPATH,FOLLOW_KW_INPATH_in_loadStatement1262);  
            stream_KW_INPATH.add(KW_INPATH20);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:53: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:54: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_loadStatement1267);  
            stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:74: (isoverwrite= KW_OVERWRITE )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case KW_OVERWRITE:
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:75: isoverwrite= KW_OVERWRITE
                    {
                    isoverwrite=(Token)match(input,KW_OVERWRITE,FOLLOW_KW_OVERWRITE_in_loadStatement1273);  
                    stream_KW_OVERWRITE.add(isoverwrite);


                    }
                    break;

            }


            KW_INTO21=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_loadStatement1277);  
            stream_KW_INTO.add(KW_INTO21);


            KW_TABLE22=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_loadStatement1279);  
            stream_KW_TABLE.add(KW_TABLE22);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:119: (tab= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:120: tab= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_loadStatement1284);
            tab=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(tab.getTree());

            }


            // AST REWRITE
            // elements: isoverwrite, islocal, path, tab
            // token labels: islocal, isoverwrite, path
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_islocal=new RewriteRuleTokenStream(adaptor,"token islocal",islocal);
            RewriteRuleTokenStream stream_isoverwrite=new RewriteRuleTokenStream(adaptor,"token isoverwrite",isoverwrite);
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 665:5: -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:665:8: ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOAD, "TOK_LOAD")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextNode());

                adaptor.addChild(root_1, stream_tab.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:665:31: ( $islocal)?
                if ( stream_islocal.hasNext() ) {
                    adaptor.addChild(root_1, stream_islocal.nextNode());

                }
                stream_islocal.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:665:41: ( $isoverwrite)?
                if ( stream_isoverwrite.hasNext() ) {
                    adaptor.addChild(root_1, stream_isoverwrite.nextNode());

                }
                stream_isoverwrite.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "loadStatement"


    public static class exportStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "exportStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:668:1: exportStatement : KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) -> ^( TOK_EXPORT $tab $path) ;
    public final HiveParser.exportStatement_return exportStatement() throws RecognitionException {
        HiveParser.exportStatement_return retval = new HiveParser.exportStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token path=null;
        Token KW_EXPORT23=null;
        Token KW_TABLE24=null;
        Token KW_TO25=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;


        CommonTree path_tree=null;
        CommonTree KW_EXPORT23_tree=null;
        CommonTree KW_TABLE24_tree=null;
        CommonTree KW_TO25_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_EXPORT=new RewriteRuleTokenStream(adaptor,"token KW_EXPORT");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
         pushMsg("export statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:671:5: ( KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) -> ^( TOK_EXPORT $tab $path) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:671:7: KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral )
            {
            KW_EXPORT23=(Token)match(input,KW_EXPORT,FOLLOW_KW_EXPORT_in_exportStatement1336);  
            stream_KW_EXPORT.add(KW_EXPORT23);


            KW_TABLE24=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_exportStatement1338);  
            stream_KW_TABLE.add(KW_TABLE24);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:671:26: (tab= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:671:27: tab= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_exportStatement1343);
            tab=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(tab.getTree());

            }


            KW_TO25=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_exportStatement1346);  
            stream_KW_TO.add(KW_TO25);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:671:55: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:671:56: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_exportStatement1351);  
            stream_StringLiteral.add(path);


            }


            // AST REWRITE
            // elements: path, tab
            // token labels: path
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 672:5: -> ^( TOK_EXPORT $tab $path)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:672:8: ^( TOK_EXPORT $tab $path)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_EXPORT, "TOK_EXPORT")
                , root_1);

                adaptor.addChild(root_1, stream_tab.nextTree());

                adaptor.addChild(root_1, stream_path.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "exportStatement"


    public static class importStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "importStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:675:1: importStatement : KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )? -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? ) ;
    public final HiveParser.importStatement_return importStatement() throws RecognitionException {
        HiveParser.importStatement_return retval = new HiveParser.importStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token ext=null;
        Token path=null;
        Token KW_IMPORT26=null;
        Token KW_TABLE27=null;
        Token KW_FROM28=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;

        HiveParser.tableLocation_return tableLocation29 =null;


        CommonTree ext_tree=null;
        CommonTree path_tree=null;
        CommonTree KW_IMPORT26_tree=null;
        CommonTree KW_TABLE27_tree=null;
        CommonTree KW_FROM28_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_IMPORT=new RewriteRuleTokenStream(adaptor,"token KW_IMPORT");
        RewriteRuleTokenStream stream_KW_EXTERNAL=new RewriteRuleTokenStream(adaptor,"token KW_EXTERNAL");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
         pushMsg("import statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:2: ( KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )? -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:4: KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )?
            {
            KW_IMPORT26=(Token)match(input,KW_IMPORT,FOLLOW_KW_IMPORT_in_importStatement1392);  
            stream_KW_IMPORT.add(KW_IMPORT26);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:14: ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case KW_EXTERNAL:
                case KW_TABLE:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:15: (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:15: (ext= KW_EXTERNAL )?
                    int alt7=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTERNAL:
                            {
                            alt7=1;
                            }
                            break;
                    }

                    switch (alt7) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:16: ext= KW_EXTERNAL
                            {
                            ext=(Token)match(input,KW_EXTERNAL,FOLLOW_KW_EXTERNAL_in_importStatement1398);  
                            stream_KW_EXTERNAL.add(ext);


                            }
                            break;

                    }


                    KW_TABLE27=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_importStatement1402);  
                    stream_KW_TABLE.add(KW_TABLE27);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:43: (tab= tableOrPartition )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:44: tab= tableOrPartition
                    {
                    pushFollow(FOLLOW_tableOrPartition_in_importStatement1407);
                    tab=tableOrPartition();

                    state._fsp--;

                    stream_tableOrPartition.add(tab.getTree());

                    }


                    }
                    break;

            }


            KW_FROM28=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_importStatement1412);  
            stream_KW_FROM.add(KW_FROM28);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:76: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:77: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_importStatement1417);  
            stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:97: ( tableLocation )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:97: tableLocation
                    {
                    pushFollow(FOLLOW_tableLocation_in_importStatement1420);
                    tableLocation29=tableLocation();

                    state._fsp--;

                    stream_tableLocation.add(tableLocation29.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: tableLocation, tab, path, ext
            // token labels: path, ext
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleTokenStream stream_ext=new RewriteRuleTokenStream(adaptor,"token ext",ext);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 679:5: -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:8: ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IMPORT, "TOK_IMPORT")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextNode());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:28: ( $tab)?
                if ( stream_tab.hasNext() ) {
                    adaptor.addChild(root_1, stream_tab.nextTree());

                }
                stream_tab.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:34: ( $ext)?
                if ( stream_ext.hasNext() ) {
                    adaptor.addChild(root_1, stream_ext.nextNode());

                }
                stream_ext.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:39: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "importStatement"


    public static class ddlStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ddlStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:682:1: ddlStatement : ( createDatabaseStatement | switchDatabaseStatement | dropDatabaseStatement | createTableStatement | dropTableStatement | truncateTableStatement | alterStatement | descStatement | showStatement | metastoreCheck | createViewStatement | dropViewStatement | createFunctionStatement | createMacroStatement | createIndexStatement | dropIndexStatement | dropFunctionStatement | dropMacroStatement | analyzeStatement | lockStatement | unlockStatement | lockDatabase | unlockDatabase | createRoleStatement | dropRoleStatement | grantPrivileges | revokePrivileges | showGrants | showRoleGrants | showRolePrincipals | showRoles | grantRole | revokeRole | setRole | showCurrentRole );
    public final HiveParser.ddlStatement_return ddlStatement() throws RecognitionException {
        HiveParser.ddlStatement_return retval = new HiveParser.ddlStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.createDatabaseStatement_return createDatabaseStatement30 =null;

        HiveParser.switchDatabaseStatement_return switchDatabaseStatement31 =null;

        HiveParser.dropDatabaseStatement_return dropDatabaseStatement32 =null;

        HiveParser.createTableStatement_return createTableStatement33 =null;

        HiveParser.dropTableStatement_return dropTableStatement34 =null;

        HiveParser.truncateTableStatement_return truncateTableStatement35 =null;

        HiveParser.alterStatement_return alterStatement36 =null;

        HiveParser.descStatement_return descStatement37 =null;

        HiveParser.showStatement_return showStatement38 =null;

        HiveParser.metastoreCheck_return metastoreCheck39 =null;

        HiveParser.createViewStatement_return createViewStatement40 =null;

        HiveParser.dropViewStatement_return dropViewStatement41 =null;

        HiveParser.createFunctionStatement_return createFunctionStatement42 =null;

        HiveParser.createMacroStatement_return createMacroStatement43 =null;

        HiveParser.createIndexStatement_return createIndexStatement44 =null;

        HiveParser.dropIndexStatement_return dropIndexStatement45 =null;

        HiveParser.dropFunctionStatement_return dropFunctionStatement46 =null;

        HiveParser.dropMacroStatement_return dropMacroStatement47 =null;

        HiveParser.analyzeStatement_return analyzeStatement48 =null;

        HiveParser.lockStatement_return lockStatement49 =null;

        HiveParser.unlockStatement_return unlockStatement50 =null;

        HiveParser.lockDatabase_return lockDatabase51 =null;

        HiveParser.unlockDatabase_return unlockDatabase52 =null;

        HiveParser.createRoleStatement_return createRoleStatement53 =null;

        HiveParser.dropRoleStatement_return dropRoleStatement54 =null;

        HiveParser.grantPrivileges_return grantPrivileges55 =null;

        HiveParser.revokePrivileges_return revokePrivileges56 =null;

        HiveParser.showGrants_return showGrants57 =null;

        HiveParser.showRoleGrants_return showRoleGrants58 =null;

        HiveParser.showRolePrincipals_return showRolePrincipals59 =null;

        HiveParser.showRoles_return showRoles60 =null;

        HiveParser.grantRole_return grantRole61 =null;

        HiveParser.revokeRole_return revokeRole62 =null;

        HiveParser.setRole_return setRole63 =null;

        HiveParser.showCurrentRole_return showCurrentRole64 =null;



         pushMsg("ddl statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:685:5: ( createDatabaseStatement | switchDatabaseStatement | dropDatabaseStatement | createTableStatement | dropTableStatement | truncateTableStatement | alterStatement | descStatement | showStatement | metastoreCheck | createViewStatement | dropViewStatement | createFunctionStatement | createMacroStatement | createIndexStatement | dropIndexStatement | dropFunctionStatement | dropMacroStatement | analyzeStatement | lockStatement | unlockStatement | lockDatabase | unlockDatabase | createRoleStatement | dropRoleStatement | grantPrivileges | revokePrivileges | showGrants | showRoleGrants | showRolePrincipals | showRoles | grantRole | revokeRole | setRole | showCurrentRole )
            int alt10=35;
            alt10 = dfa10.predict(input);
            switch (alt10) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:685:7: createDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createDatabaseStatement_in_ddlStatement1472);
                    createDatabaseStatement30=createDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createDatabaseStatement30.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:686:7: switchDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_switchDatabaseStatement_in_ddlStatement1480);
                    switchDatabaseStatement31=switchDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, switchDatabaseStatement31.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:687:7: dropDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropDatabaseStatement_in_ddlStatement1488);
                    dropDatabaseStatement32=dropDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropDatabaseStatement32.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:688:7: createTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createTableStatement_in_ddlStatement1496);
                    createTableStatement33=createTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createTableStatement33.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:689:7: dropTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropTableStatement_in_ddlStatement1504);
                    dropTableStatement34=dropTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropTableStatement34.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:690:7: truncateTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_truncateTableStatement_in_ddlStatement1512);
                    truncateTableStatement35=truncateTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, truncateTableStatement35.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:691:7: alterStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatement_in_ddlStatement1520);
                    alterStatement36=alterStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatement36.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:692:7: descStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_descStatement_in_ddlStatement1528);
                    descStatement37=descStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, descStatement37.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:693:7: showStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showStatement_in_ddlStatement1536);
                    showStatement38=showStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, showStatement38.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:694:7: metastoreCheck
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_metastoreCheck_in_ddlStatement1544);
                    metastoreCheck39=metastoreCheck();

                    state._fsp--;

                    adaptor.addChild(root_0, metastoreCheck39.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:695:7: createViewStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createViewStatement_in_ddlStatement1552);
                    createViewStatement40=createViewStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createViewStatement40.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:696:7: dropViewStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropViewStatement_in_ddlStatement1560);
                    dropViewStatement41=dropViewStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropViewStatement41.getTree());

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:697:7: createFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createFunctionStatement_in_ddlStatement1568);
                    createFunctionStatement42=createFunctionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createFunctionStatement42.getTree());

                    }
                    break;
                case 14 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:698:7: createMacroStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createMacroStatement_in_ddlStatement1576);
                    createMacroStatement43=createMacroStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createMacroStatement43.getTree());

                    }
                    break;
                case 15 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:699:7: createIndexStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createIndexStatement_in_ddlStatement1584);
                    createIndexStatement44=createIndexStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createIndexStatement44.getTree());

                    }
                    break;
                case 16 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:700:7: dropIndexStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropIndexStatement_in_ddlStatement1592);
                    dropIndexStatement45=dropIndexStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropIndexStatement45.getTree());

                    }
                    break;
                case 17 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:701:7: dropFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropFunctionStatement_in_ddlStatement1600);
                    dropFunctionStatement46=dropFunctionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropFunctionStatement46.getTree());

                    }
                    break;
                case 18 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:702:7: dropMacroStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropMacroStatement_in_ddlStatement1608);
                    dropMacroStatement47=dropMacroStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropMacroStatement47.getTree());

                    }
                    break;
                case 19 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:7: analyzeStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_analyzeStatement_in_ddlStatement1616);
                    analyzeStatement48=analyzeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, analyzeStatement48.getTree());

                    }
                    break;
                case 20 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:704:7: lockStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lockStatement_in_ddlStatement1624);
                    lockStatement49=lockStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, lockStatement49.getTree());

                    }
                    break;
                case 21 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:705:7: unlockStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_unlockStatement_in_ddlStatement1632);
                    unlockStatement50=unlockStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, unlockStatement50.getTree());

                    }
                    break;
                case 22 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:706:7: lockDatabase
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lockDatabase_in_ddlStatement1640);
                    lockDatabase51=lockDatabase();

                    state._fsp--;

                    adaptor.addChild(root_0, lockDatabase51.getTree());

                    }
                    break;
                case 23 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:707:7: unlockDatabase
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_unlockDatabase_in_ddlStatement1648);
                    unlockDatabase52=unlockDatabase();

                    state._fsp--;

                    adaptor.addChild(root_0, unlockDatabase52.getTree());

                    }
                    break;
                case 24 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:708:7: createRoleStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createRoleStatement_in_ddlStatement1656);
                    createRoleStatement53=createRoleStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createRoleStatement53.getTree());

                    }
                    break;
                case 25 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:709:7: dropRoleStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropRoleStatement_in_ddlStatement1664);
                    dropRoleStatement54=dropRoleStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropRoleStatement54.getTree());

                    }
                    break;
                case 26 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:710:7: grantPrivileges
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_grantPrivileges_in_ddlStatement1672);
                    grantPrivileges55=grantPrivileges();

                    state._fsp--;

                    adaptor.addChild(root_0, grantPrivileges55.getTree());

                    }
                    break;
                case 27 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:711:7: revokePrivileges
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_revokePrivileges_in_ddlStatement1680);
                    revokePrivileges56=revokePrivileges();

                    state._fsp--;

                    adaptor.addChild(root_0, revokePrivileges56.getTree());

                    }
                    break;
                case 28 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:712:7: showGrants
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showGrants_in_ddlStatement1688);
                    showGrants57=showGrants();

                    state._fsp--;

                    adaptor.addChild(root_0, showGrants57.getTree());

                    }
                    break;
                case 29 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:713:7: showRoleGrants
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRoleGrants_in_ddlStatement1696);
                    showRoleGrants58=showRoleGrants();

                    state._fsp--;

                    adaptor.addChild(root_0, showRoleGrants58.getTree());

                    }
                    break;
                case 30 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:714:7: showRolePrincipals
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRolePrincipals_in_ddlStatement1704);
                    showRolePrincipals59=showRolePrincipals();

                    state._fsp--;

                    adaptor.addChild(root_0, showRolePrincipals59.getTree());

                    }
                    break;
                case 31 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:715:7: showRoles
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRoles_in_ddlStatement1712);
                    showRoles60=showRoles();

                    state._fsp--;

                    adaptor.addChild(root_0, showRoles60.getTree());

                    }
                    break;
                case 32 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:716:7: grantRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_grantRole_in_ddlStatement1720);
                    grantRole61=grantRole();

                    state._fsp--;

                    adaptor.addChild(root_0, grantRole61.getTree());

                    }
                    break;
                case 33 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:717:7: revokeRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_revokeRole_in_ddlStatement1728);
                    revokeRole62=revokeRole();

                    state._fsp--;

                    adaptor.addChild(root_0, revokeRole62.getTree());

                    }
                    break;
                case 34 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:718:7: setRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_setRole_in_ddlStatement1736);
                    setRole63=setRole();

                    state._fsp--;

                    adaptor.addChild(root_0, setRole63.getTree());

                    }
                    break;
                case 35 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:719:7: showCurrentRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showCurrentRole_in_ddlStatement1744);
                    showCurrentRole64=showCurrentRole();

                    state._fsp--;

                    adaptor.addChild(root_0, showCurrentRole64.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ddlStatement"


    public static class ifExists_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ifExists"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:722:1: ifExists : KW_IF KW_EXISTS -> ^( TOK_IFEXISTS ) ;
    public final HiveParser.ifExists_return ifExists() throws RecognitionException {
        HiveParser.ifExists_return retval = new HiveParser.ifExists_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IF65=null;
        Token KW_EXISTS66=null;

        CommonTree KW_IF65_tree=null;
        CommonTree KW_EXISTS66_tree=null;
        RewriteRuleTokenStream stream_KW_IF=new RewriteRuleTokenStream(adaptor,"token KW_IF");
        RewriteRuleTokenStream stream_KW_EXISTS=new RewriteRuleTokenStream(adaptor,"token KW_EXISTS");

         pushMsg("if exists clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:725:5: ( KW_IF KW_EXISTS -> ^( TOK_IFEXISTS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:725:7: KW_IF KW_EXISTS
            {
            KW_IF65=(Token)match(input,KW_IF,FOLLOW_KW_IF_in_ifExists1771);  
            stream_KW_IF.add(KW_IF65);


            KW_EXISTS66=(Token)match(input,KW_EXISTS,FOLLOW_KW_EXISTS_in_ifExists1773);  
            stream_KW_EXISTS.add(KW_EXISTS66);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 726:5: -> ^( TOK_IFEXISTS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:726:8: ^( TOK_IFEXISTS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IFEXISTS, "TOK_IFEXISTS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ifExists"


    public static class restrictOrCascade_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "restrictOrCascade"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:729:1: restrictOrCascade : ( KW_RESTRICT -> ^( TOK_RESTRICT ) | KW_CASCADE -> ^( TOK_CASCADE ) );
    public final HiveParser.restrictOrCascade_return restrictOrCascade() throws RecognitionException {
        HiveParser.restrictOrCascade_return retval = new HiveParser.restrictOrCascade_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RESTRICT67=null;
        Token KW_CASCADE68=null;

        CommonTree KW_RESTRICT67_tree=null;
        CommonTree KW_CASCADE68_tree=null;
        RewriteRuleTokenStream stream_KW_CASCADE=new RewriteRuleTokenStream(adaptor,"token KW_CASCADE");
        RewriteRuleTokenStream stream_KW_RESTRICT=new RewriteRuleTokenStream(adaptor,"token KW_RESTRICT");

         pushMsg("restrict or cascade clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:732:5: ( KW_RESTRICT -> ^( TOK_RESTRICT ) | KW_CASCADE -> ^( TOK_CASCADE ) )
            int alt11=2;
            switch ( input.LA(1) ) {
            case KW_RESTRICT:
                {
                alt11=1;
                }
                break;
            case KW_CASCADE:
                {
                alt11=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;

            }

            switch (alt11) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:732:7: KW_RESTRICT
                    {
                    KW_RESTRICT67=(Token)match(input,KW_RESTRICT,FOLLOW_KW_RESTRICT_in_restrictOrCascade1810);  
                    stream_KW_RESTRICT.add(KW_RESTRICT67);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 733:5: -> ^( TOK_RESTRICT )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:733:8: ^( TOK_RESTRICT )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_RESTRICT, "TOK_RESTRICT")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:7: KW_CASCADE
                    {
                    KW_CASCADE68=(Token)match(input,KW_CASCADE,FOLLOW_KW_CASCADE_in_restrictOrCascade1828);  
                    stream_KW_CASCADE.add(KW_CASCADE68);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 735:5: -> ^( TOK_CASCADE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:735:8: ^( TOK_CASCADE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_CASCADE, "TOK_CASCADE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "restrictOrCascade"


    public static class ifNotExists_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ifNotExists"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:738:1: ifNotExists : KW_IF KW_NOT KW_EXISTS -> ^( TOK_IFNOTEXISTS ) ;
    public final HiveParser.ifNotExists_return ifNotExists() throws RecognitionException {
        HiveParser.ifNotExists_return retval = new HiveParser.ifNotExists_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IF69=null;
        Token KW_NOT70=null;
        Token KW_EXISTS71=null;

        CommonTree KW_IF69_tree=null;
        CommonTree KW_NOT70_tree=null;
        CommonTree KW_EXISTS71_tree=null;
        RewriteRuleTokenStream stream_KW_IF=new RewriteRuleTokenStream(adaptor,"token KW_IF");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_EXISTS=new RewriteRuleTokenStream(adaptor,"token KW_EXISTS");

         pushMsg("if not exists clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:5: ( KW_IF KW_NOT KW_EXISTS -> ^( TOK_IFNOTEXISTS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:7: KW_IF KW_NOT KW_EXISTS
            {
            KW_IF69=(Token)match(input,KW_IF,FOLLOW_KW_IF_in_ifNotExists1865);  
            stream_KW_IF.add(KW_IF69);


            KW_NOT70=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_ifNotExists1867);  
            stream_KW_NOT.add(KW_NOT70);


            KW_EXISTS71=(Token)match(input,KW_EXISTS,FOLLOW_KW_EXISTS_in_ifNotExists1869);  
            stream_KW_EXISTS.add(KW_EXISTS71);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 742:5: -> ^( TOK_IFNOTEXISTS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:742:8: ^( TOK_IFNOTEXISTS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IFNOTEXISTS, "TOK_IFNOTEXISTS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ifNotExists"


    public static class storedAsDirs_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "storedAsDirs"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:745:1: storedAsDirs : KW_STORED KW_AS KW_DIRECTORIES -> ^( TOK_STOREDASDIRS ) ;
    public final HiveParser.storedAsDirs_return storedAsDirs() throws RecognitionException {
        HiveParser.storedAsDirs_return retval = new HiveParser.storedAsDirs_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_STORED72=null;
        Token KW_AS73=null;
        Token KW_DIRECTORIES74=null;

        CommonTree KW_STORED72_tree=null;
        CommonTree KW_AS73_tree=null;
        CommonTree KW_DIRECTORIES74_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_STORED=new RewriteRuleTokenStream(adaptor,"token KW_STORED");
        RewriteRuleTokenStream stream_KW_DIRECTORIES=new RewriteRuleTokenStream(adaptor,"token KW_DIRECTORIES");

         pushMsg("stored as directories", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:5: ( KW_STORED KW_AS KW_DIRECTORIES -> ^( TOK_STOREDASDIRS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:7: KW_STORED KW_AS KW_DIRECTORIES
            {
            KW_STORED72=(Token)match(input,KW_STORED,FOLLOW_KW_STORED_in_storedAsDirs1906);  
            stream_KW_STORED.add(KW_STORED72);


            KW_AS73=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_storedAsDirs1908);  
            stream_KW_AS.add(KW_AS73);


            KW_DIRECTORIES74=(Token)match(input,KW_DIRECTORIES,FOLLOW_KW_DIRECTORIES_in_storedAsDirs1910);  
            stream_KW_DIRECTORIES.add(KW_DIRECTORIES74);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 749:5: -> ^( TOK_STOREDASDIRS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:749:8: ^( TOK_STOREDASDIRS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_STOREDASDIRS, "TOK_STOREDASDIRS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "storedAsDirs"


    public static class orReplace_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orReplace"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:752:1: orReplace : KW_OR KW_REPLACE -> ^( TOK_ORREPLACE ) ;
    public final HiveParser.orReplace_return orReplace() throws RecognitionException {
        HiveParser.orReplace_return retval = new HiveParser.orReplace_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_OR75=null;
        Token KW_REPLACE76=null;

        CommonTree KW_OR75_tree=null;
        CommonTree KW_REPLACE76_tree=null;
        RewriteRuleTokenStream stream_KW_REPLACE=new RewriteRuleTokenStream(adaptor,"token KW_REPLACE");
        RewriteRuleTokenStream stream_KW_OR=new RewriteRuleTokenStream(adaptor,"token KW_OR");

         pushMsg("or replace clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:755:5: ( KW_OR KW_REPLACE -> ^( TOK_ORREPLACE ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:755:7: KW_OR KW_REPLACE
            {
            KW_OR75=(Token)match(input,KW_OR,FOLLOW_KW_OR_in_orReplace1947);  
            stream_KW_OR.add(KW_OR75);


            KW_REPLACE76=(Token)match(input,KW_REPLACE,FOLLOW_KW_REPLACE_in_orReplace1949);  
            stream_KW_REPLACE.add(KW_REPLACE76);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 756:5: -> ^( TOK_ORREPLACE )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:756:8: ^( TOK_ORREPLACE )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ORREPLACE, "TOK_ORREPLACE")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orReplace"


    public static class ignoreProtection_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ignoreProtection"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:759:1: ignoreProtection : KW_IGNORE KW_PROTECTION -> ^( TOK_IGNOREPROTECTION ) ;
    public final HiveParser.ignoreProtection_return ignoreProtection() throws RecognitionException {
        HiveParser.ignoreProtection_return retval = new HiveParser.ignoreProtection_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IGNORE77=null;
        Token KW_PROTECTION78=null;

        CommonTree KW_IGNORE77_tree=null;
        CommonTree KW_PROTECTION78_tree=null;
        RewriteRuleTokenStream stream_KW_PROTECTION=new RewriteRuleTokenStream(adaptor,"token KW_PROTECTION");
        RewriteRuleTokenStream stream_KW_IGNORE=new RewriteRuleTokenStream(adaptor,"token KW_IGNORE");

         pushMsg("ignore protection clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:762:9: ( KW_IGNORE KW_PROTECTION -> ^( TOK_IGNOREPROTECTION ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:762:11: KW_IGNORE KW_PROTECTION
            {
            KW_IGNORE77=(Token)match(input,KW_IGNORE,FOLLOW_KW_IGNORE_in_ignoreProtection1990);  
            stream_KW_IGNORE.add(KW_IGNORE77);


            KW_PROTECTION78=(Token)match(input,KW_PROTECTION,FOLLOW_KW_PROTECTION_in_ignoreProtection1992);  
            stream_KW_PROTECTION.add(KW_PROTECTION78);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 763:9: -> ^( TOK_IGNOREPROTECTION )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:763:12: ^( TOK_IGNOREPROTECTION )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IGNOREPROTECTION, "TOK_IGNOREPROTECTION")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ignoreProtection"


    public static class createDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:766:1: createDatabaseStatement : KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )? -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? ) ;
    public final HiveParser.createDatabaseStatement_return createDatabaseStatement() throws RecognitionException {
        HiveParser.createDatabaseStatement_return retval = new HiveParser.createDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE79=null;
        Token KW_DATABASE80=null;
        Token KW_SCHEMA81=null;
        Token KW_WITH85=null;
        Token KW_DBPROPERTIES86=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.dbProperties_return dbprops =null;

        HiveParser.ifNotExists_return ifNotExists82 =null;

        HiveParser.databaseComment_return databaseComment83 =null;

        HiveParser.dbLocation_return dbLocation84 =null;


        CommonTree KW_CREATE79_tree=null;
        CommonTree KW_DATABASE80_tree=null;
        CommonTree KW_SCHEMA81_tree=null;
        CommonTree KW_WITH85_tree=null;
        CommonTree KW_DBPROPERTIES86_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_DBPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_DBPROPERTIES");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleSubtreeStream stream_dbProperties=new RewriteRuleSubtreeStream(adaptor,"rule dbProperties");
        RewriteRuleSubtreeStream stream_dbLocation=new RewriteRuleSubtreeStream(adaptor,"rule dbLocation");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_databaseComment=new RewriteRuleSubtreeStream(adaptor,"rule databaseComment");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("create database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:769:5: ( KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )? -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:769:7: KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )?
            {
            KW_CREATE79=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createDatabaseStatement2037);  
            stream_KW_CREATE.add(KW_CREATE79);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:769:17: ( KW_DATABASE | KW_SCHEMA )
            int alt12=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt12=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt12=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;

            }

            switch (alt12) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:769:18: KW_DATABASE
                    {
                    KW_DATABASE80=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_createDatabaseStatement2040);  
                    stream_KW_DATABASE.add(KW_DATABASE80);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:769:30: KW_SCHEMA
                    {
                    KW_SCHEMA81=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_createDatabaseStatement2042);  
                    stream_KW_SCHEMA.add(KW_SCHEMA81);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:770:9: ( ifNotExists )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:770:9: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createDatabaseStatement2053);
                    ifNotExists82=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists82.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_createDatabaseStatement2066);
            name=identifier();

            state._fsp--;

            stream_identifier.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:772:9: ( databaseComment )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:772:9: databaseComment
                    {
                    pushFollow(FOLLOW_databaseComment_in_createDatabaseStatement2076);
                    databaseComment83=databaseComment();

                    state._fsp--;

                    stream_databaseComment.add(databaseComment83.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:773:9: ( dbLocation )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:773:9: dbLocation
                    {
                    pushFollow(FOLLOW_dbLocation_in_createDatabaseStatement2087);
                    dbLocation84=dbLocation();

                    state._fsp--;

                    stream_dbLocation.add(dbLocation84.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:774:9: ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )?
            int alt16=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt16=1;
                    }
                    break;
            }

            switch (alt16) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:774:10: KW_WITH KW_DBPROPERTIES dbprops= dbProperties
                    {
                    KW_WITH85=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_createDatabaseStatement2099);  
                    stream_KW_WITH.add(KW_WITH85);


                    KW_DBPROPERTIES86=(Token)match(input,KW_DBPROPERTIES,FOLLOW_KW_DBPROPERTIES_in_createDatabaseStatement2101);  
                    stream_KW_DBPROPERTIES.add(KW_DBPROPERTIES86);


                    pushFollow(FOLLOW_dbProperties_in_createDatabaseStatement2105);
                    dbprops=dbProperties();

                    state._fsp--;

                    stream_dbProperties.add(dbprops.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: dbLocation, databaseComment, dbprops, ifNotExists, name
            // token labels: 
            // rule labels: retval, name, dbprops
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_dbprops=new RewriteRuleSubtreeStream(adaptor,"rule dbprops",dbprops!=null?dbprops.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 775:5: -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:775:8: ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEDATABASE, "TOK_CREATEDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:775:35: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:775:48: ( dbLocation )?
                if ( stream_dbLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_dbLocation.nextTree());

                }
                stream_dbLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:775:60: ( databaseComment )?
                if ( stream_databaseComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_databaseComment.nextTree());

                }
                stream_databaseComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:775:78: ( $dbprops)?
                if ( stream_dbprops.hasNext() ) {
                    adaptor.addChild(root_1, stream_dbprops.nextTree());

                }
                stream_dbprops.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createDatabaseStatement"


    public static class dbLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:778:1: dbLocation : KW_LOCATION locn= StringLiteral -> ^( TOK_DATABASELOCATION $locn) ;
    public final HiveParser.dbLocation_return dbLocation() throws RecognitionException {
        HiveParser.dbLocation_return retval = new HiveParser.dbLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token locn=null;
        Token KW_LOCATION87=null;

        CommonTree locn_tree=null;
        CommonTree KW_LOCATION87_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

         pushMsg("database location specification", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:781:5: ( KW_LOCATION locn= StringLiteral -> ^( TOK_DATABASELOCATION $locn) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:7: KW_LOCATION locn= StringLiteral
            {
            KW_LOCATION87=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_dbLocation2166);  
            stream_KW_LOCATION.add(KW_LOCATION87);


            locn=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_dbLocation2170);  
            stream_StringLiteral.add(locn);


            // AST REWRITE
            // elements: locn
            // token labels: locn
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_locn=new RewriteRuleTokenStream(adaptor,"token locn",locn);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 782:38: -> ^( TOK_DATABASELOCATION $locn)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:41: ^( TOK_DATABASELOCATION $locn)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASELOCATION, "TOK_DATABASELOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_locn.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbLocation"


    public static class dbProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:785:1: dbProperties : LPAREN dbPropertiesList RPAREN -> ^( TOK_DATABASEPROPERTIES dbPropertiesList ) ;
    public final HiveParser.dbProperties_return dbProperties() throws RecognitionException {
        HiveParser.dbProperties_return retval = new HiveParser.dbProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN88=null;
        Token RPAREN90=null;
        HiveParser.dbPropertiesList_return dbPropertiesList89 =null;


        CommonTree LPAREN88_tree=null;
        CommonTree RPAREN90_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_dbPropertiesList=new RewriteRuleSubtreeStream(adaptor,"rule dbPropertiesList");
         pushMsg("dbproperties", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:788:5: ( LPAREN dbPropertiesList RPAREN -> ^( TOK_DATABASEPROPERTIES dbPropertiesList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:789:7: LPAREN dbPropertiesList RPAREN
            {
            LPAREN88=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_dbProperties2212);  
            stream_LPAREN.add(LPAREN88);


            pushFollow(FOLLOW_dbPropertiesList_in_dbProperties2214);
            dbPropertiesList89=dbPropertiesList();

            state._fsp--;

            stream_dbPropertiesList.add(dbPropertiesList89.getTree());

            RPAREN90=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_dbProperties2216);  
            stream_RPAREN.add(RPAREN90);


            // AST REWRITE
            // elements: dbPropertiesList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 789:38: -> ^( TOK_DATABASEPROPERTIES dbPropertiesList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:789:41: ^( TOK_DATABASEPROPERTIES dbPropertiesList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASEPROPERTIES, "TOK_DATABASEPROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_dbPropertiesList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbProperties"


    public static class dbPropertiesList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbPropertiesList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:792:1: dbPropertiesList : keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_DBPROPLIST ( keyValueProperty )+ ) ;
    public final HiveParser.dbPropertiesList_return dbPropertiesList() throws RecognitionException {
        HiveParser.dbPropertiesList_return retval = new HiveParser.dbPropertiesList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA92=null;
        HiveParser.keyValueProperty_return keyValueProperty91 =null;

        HiveParser.keyValueProperty_return keyValueProperty93 =null;


        CommonTree COMMA92_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_keyValueProperty=new RewriteRuleSubtreeStream(adaptor,"rule keyValueProperty");
         pushMsg("database properties list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:795:5: ( keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_DBPROPLIST ( keyValueProperty )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:7: keyValueProperty ( COMMA keyValueProperty )*
            {
            pushFollow(FOLLOW_keyValueProperty_in_dbPropertiesList2257);
            keyValueProperty91=keyValueProperty();

            state._fsp--;

            stream_keyValueProperty.add(keyValueProperty91.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:24: ( COMMA keyValueProperty )*
            loop17:
            do {
                int alt17=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt17=1;
                    }
                    break;

                }

                switch (alt17) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:25: COMMA keyValueProperty
            	    {
            	    COMMA92=(Token)match(input,COMMA,FOLLOW_COMMA_in_dbPropertiesList2260);  
            	    stream_COMMA.add(COMMA92);


            	    pushFollow(FOLLOW_keyValueProperty_in_dbPropertiesList2262);
            	    keyValueProperty93=keyValueProperty();

            	    state._fsp--;

            	    stream_keyValueProperty.add(keyValueProperty93.getTree());

            	    }
            	    break;

            	default :
            	    break loop17;
                }
            } while (true);


            // AST REWRITE
            // elements: keyValueProperty
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 796:50: -> ^( TOK_DBPROPLIST ( keyValueProperty )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:53: ^( TOK_DBPROPLIST ( keyValueProperty )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DBPROPLIST, "TOK_DBPROPLIST")
                , root_1);

                if ( !(stream_keyValueProperty.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_keyValueProperty.hasNext() ) {
                    adaptor.addChild(root_1, stream_keyValueProperty.nextTree());

                }
                stream_keyValueProperty.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbPropertiesList"


    public static class switchDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "switchDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:800:1: switchDatabaseStatement : KW_USE identifier -> ^( TOK_SWITCHDATABASE identifier ) ;
    public final HiveParser.switchDatabaseStatement_return switchDatabaseStatement() throws RecognitionException {
        HiveParser.switchDatabaseStatement_return retval = new HiveParser.switchDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_USE94=null;
        HiveParser_IdentifiersParser.identifier_return identifier95 =null;


        CommonTree KW_USE94_tree=null;
        RewriteRuleTokenStream stream_KW_USE=new RewriteRuleTokenStream(adaptor,"token KW_USE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("switch database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:803:5: ( KW_USE identifier -> ^( TOK_SWITCHDATABASE identifier ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:803:7: KW_USE identifier
            {
            KW_USE94=(Token)match(input,KW_USE,FOLLOW_KW_USE_in_switchDatabaseStatement2301);  
            stream_KW_USE.add(KW_USE94);


            pushFollow(FOLLOW_identifier_in_switchDatabaseStatement2303);
            identifier95=identifier();

            state._fsp--;

            stream_identifier.add(identifier95.getTree());

            // AST REWRITE
            // elements: identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 804:5: -> ^( TOK_SWITCHDATABASE identifier )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:804:8: ^( TOK_SWITCHDATABASE identifier )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SWITCHDATABASE, "TOK_SWITCHDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "switchDatabaseStatement"


    public static class dropDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:807:1: dropDatabaseStatement : KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )? -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? ) ;
    public final HiveParser.dropDatabaseStatement_return dropDatabaseStatement() throws RecognitionException {
        HiveParser.dropDatabaseStatement_return retval = new HiveParser.dropDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP96=null;
        Token KW_DATABASE97=null;
        Token KW_SCHEMA98=null;
        HiveParser.ifExists_return ifExists99 =null;

        HiveParser_IdentifiersParser.identifier_return identifier100 =null;

        HiveParser.restrictOrCascade_return restrictOrCascade101 =null;


        CommonTree KW_DROP96_tree=null;
        CommonTree KW_DATABASE97_tree=null;
        CommonTree KW_SCHEMA98_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleSubtreeStream stream_restrictOrCascade=new RewriteRuleSubtreeStream(adaptor,"rule restrictOrCascade");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("drop database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:5: ( KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )? -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:7: KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )?
            {
            KW_DROP96=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropDatabaseStatement2342);  
            stream_KW_DROP.add(KW_DROP96);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:15: ( KW_DATABASE | KW_SCHEMA )
            int alt18=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt18=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt18=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;

            }

            switch (alt18) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:16: KW_DATABASE
                    {
                    KW_DATABASE97=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_dropDatabaseStatement2345);  
                    stream_KW_DATABASE.add(KW_DATABASE97);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:28: KW_SCHEMA
                    {
                    KW_SCHEMA98=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_dropDatabaseStatement2347);  
                    stream_KW_SCHEMA.add(KW_SCHEMA98);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:39: ( ifExists )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:39: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropDatabaseStatement2350);
                    ifExists99=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists99.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropDatabaseStatement2353);
            identifier100=identifier();

            state._fsp--;

            stream_identifier.add(identifier100.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:60: ( restrictOrCascade )?
            int alt20=2;
            switch ( input.LA(1) ) {
                case KW_CASCADE:
                case KW_RESTRICT:
                    {
                    alt20=1;
                    }
                    break;
            }

            switch (alt20) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:810:60: restrictOrCascade
                    {
                    pushFollow(FOLLOW_restrictOrCascade_in_dropDatabaseStatement2355);
                    restrictOrCascade101=restrictOrCascade();

                    state._fsp--;

                    stream_restrictOrCascade.add(restrictOrCascade101.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: identifier, restrictOrCascade, ifExists
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 811:5: -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:811:8: ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPDATABASE, "TOK_DROPDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:811:38: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:811:48: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropDatabaseStatement"


    public static class databaseComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "databaseComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:814:1: databaseComment : KW_COMMENT comment= StringLiteral -> ^( TOK_DATABASECOMMENT $comment) ;
    public final HiveParser.databaseComment_return databaseComment() throws RecognitionException {
        HiveParser.databaseComment_return retval = new HiveParser.databaseComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT102=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT102_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         pushMsg("database's comment", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:817:5: ( KW_COMMENT comment= StringLiteral -> ^( TOK_DATABASECOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:817:7: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT102=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_databaseComment2401);  
            stream_KW_COMMENT.add(KW_COMMENT102);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_databaseComment2405);  
            stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 818:5: -> ^( TOK_DATABASECOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:818:8: ^( TOK_DATABASECOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASECOMMENT, "TOK_DATABASECOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "databaseComment"


    public static class createTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:821:1: createTableStatement : KW_CREATE (temp= KW_TEMPORARY )? (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? ) -> ^( TOK_CREATETABLE $name ( $temp)? ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? ) ;
    public final HiveParser.createTableStatement_return createTableStatement() throws RecognitionException {
        HiveParser.createTableStatement_return retval = new HiveParser.createTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token temp=null;
        Token ext=null;
        Token like=null;
        Token KW_CREATE103=null;
        Token KW_TABLE104=null;
        Token LPAREN110=null;
        Token RPAREN112=null;
        Token KW_AS121=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser_FromClauseParser.tableName_return likeName =null;

        HiveParser.ifNotExists_return ifNotExists105 =null;

        HiveParser.tableRowFormat_return tableRowFormat106 =null;

        HiveParser.tableFileFormat_return tableFileFormat107 =null;

        HiveParser.tableLocation_return tableLocation108 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed109 =null;

        HiveParser.columnNameTypeList_return columnNameTypeList111 =null;

        HiveParser.tableComment_return tableComment113 =null;

        HiveParser.tablePartition_return tablePartition114 =null;

        HiveParser.tableBuckets_return tableBuckets115 =null;

        HiveParser.tableSkewed_return tableSkewed116 =null;

        HiveParser.tableRowFormat_return tableRowFormat117 =null;

        HiveParser.tableFileFormat_return tableFileFormat118 =null;

        HiveParser.tableLocation_return tableLocation119 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed120 =null;

        HiveParser.selectStatementWithCTE_return selectStatementWithCTE122 =null;


        CommonTree temp_tree=null;
        CommonTree ext_tree=null;
        CommonTree like_tree=null;
        CommonTree KW_CREATE103_tree=null;
        CommonTree KW_TABLE104_tree=null;
        CommonTree LPAREN110_tree=null;
        CommonTree RPAREN112_tree=null;
        CommonTree KW_AS121_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_LIKE=new RewriteRuleTokenStream(adaptor,"token KW_LIKE");
        RewriteRuleTokenStream stream_KW_EXTERNAL=new RewriteRuleTokenStream(adaptor,"token KW_EXTERNAL");
        RewriteRuleTokenStream stream_KW_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token KW_TEMPORARY");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_selectStatementWithCTE=new RewriteRuleSubtreeStream(adaptor,"rule selectStatementWithCTE");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
        RewriteRuleSubtreeStream stream_tableBuckets=new RewriteRuleSubtreeStream(adaptor,"rule tableBuckets");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_tablePartition=new RewriteRuleSubtreeStream(adaptor,"rule tablePartition");
        RewriteRuleSubtreeStream stream_tableRowFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableRowFormat");
        RewriteRuleSubtreeStream stream_tableFileFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableFileFormat");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_tableComment=new RewriteRuleSubtreeStream(adaptor,"rule tableComment");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_tableSkewed=new RewriteRuleSubtreeStream(adaptor,"rule tableSkewed");
         pushMsg("create table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:824:5: ( KW_CREATE (temp= KW_TEMPORARY )? (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? ) -> ^( TOK_CREATETABLE $name ( $temp)? ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:824:7: KW_CREATE (temp= KW_TEMPORARY )? (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? )
            {
            KW_CREATE103=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createTableStatement2445);  
            stream_KW_CREATE.add(KW_CREATE103);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:824:17: (temp= KW_TEMPORARY )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case KW_TEMPORARY:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:824:18: temp= KW_TEMPORARY
                    {
                    temp=(Token)match(input,KW_TEMPORARY,FOLLOW_KW_TEMPORARY_in_createTableStatement2450);  
                    stream_KW_TEMPORARY.add(temp);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:824:38: (ext= KW_EXTERNAL )?
            int alt22=2;
            switch ( input.LA(1) ) {
                case KW_EXTERNAL:
                    {
                    alt22=1;
                    }
                    break;
            }

            switch (alt22) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:824:39: ext= KW_EXTERNAL
                    {
                    ext=(Token)match(input,KW_EXTERNAL,FOLLOW_KW_EXTERNAL_in_createTableStatement2457);  
                    stream_KW_EXTERNAL.add(ext);


                    }
                    break;

            }


            KW_TABLE104=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_createTableStatement2461);  
            stream_KW_TABLE.add(KW_TABLE104);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:824:66: ( ifNotExists )?
            int alt23=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt23=1;
                    }
                    break;
            }

            switch (alt23) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:824:66: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createTableStatement2463);
                    ifNotExists105=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists105.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_createTableStatement2468);
            name=tableName();

            state._fsp--;

            stream_tableName.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:825:7: (like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? )
            int alt38=2;
            switch ( input.LA(1) ) {
            case KW_LIKE:
                {
                alt38=1;
                }
                break;
            case EOF:
            case KW_AS:
            case KW_CLUSTERED:
            case KW_COMMENT:
            case KW_LOCATION:
            case KW_PARTITIONED:
            case KW_ROW:
            case KW_SKEWED:
            case KW_STORED:
            case KW_TBLPROPERTIES:
            case LPAREN:
                {
                alt38=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 38, 0, input);

                throw nvae;

            }

            switch (alt38) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:825:10: like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )?
                    {
                    like=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_createTableStatement2481);  
                    stream_KW_LIKE.add(like);


                    pushFollow(FOLLOW_tableName_in_createTableStatement2485);
                    likeName=tableName();

                    state._fsp--;

                    stream_tableName.add(likeName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:826:10: ( tableRowFormat )?
                    int alt24=2;
                    switch ( input.LA(1) ) {
                        case KW_ROW:
                            {
                            alt24=1;
                            }
                            break;
                    }

                    switch (alt24) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:826:10: tableRowFormat
                            {
                            pushFollow(FOLLOW_tableRowFormat_in_createTableStatement2496);
                            tableRowFormat106=tableRowFormat();

                            state._fsp--;

                            stream_tableRowFormat.add(tableRowFormat106.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:827:10: ( tableFileFormat )?
                    int alt25=2;
                    switch ( input.LA(1) ) {
                        case KW_STORED:
                            {
                            alt25=1;
                            }
                            break;
                    }

                    switch (alt25) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:827:10: tableFileFormat
                            {
                            pushFollow(FOLLOW_tableFileFormat_in_createTableStatement2508);
                            tableFileFormat107=tableFileFormat();

                            state._fsp--;

                            stream_tableFileFormat.add(tableFileFormat107.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:828:10: ( tableLocation )?
                    int alt26=2;
                    switch ( input.LA(1) ) {
                        case KW_LOCATION:
                            {
                            alt26=1;
                            }
                            break;
                    }

                    switch (alt26) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:828:10: tableLocation
                            {
                            pushFollow(FOLLOW_tableLocation_in_createTableStatement2520);
                            tableLocation108=tableLocation();

                            state._fsp--;

                            stream_tableLocation.add(tableLocation108.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:10: ( tablePropertiesPrefixed )?
                    int alt27=2;
                    switch ( input.LA(1) ) {
                        case KW_TBLPROPERTIES:
                            {
                            alt27=1;
                            }
                            break;
                    }

                    switch (alt27) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:10: tablePropertiesPrefixed
                            {
                            pushFollow(FOLLOW_tablePropertiesPrefixed_in_createTableStatement2532);
                            tablePropertiesPrefixed109=tablePropertiesPrefixed();

                            state._fsp--;

                            stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed109.getTree());

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:830:10: ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )?
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:830:10: ( LPAREN columnNameTypeList RPAREN )?
                    int alt28=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt28=1;
                            }
                            break;
                    }

                    switch (alt28) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:830:11: LPAREN columnNameTypeList RPAREN
                            {
                            LPAREN110=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createTableStatement2545);  
                            stream_LPAREN.add(LPAREN110);


                            pushFollow(FOLLOW_columnNameTypeList_in_createTableStatement2547);
                            columnNameTypeList111=columnNameTypeList();

                            state._fsp--;

                            stream_columnNameTypeList.add(columnNameTypeList111.getTree());

                            RPAREN112=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createTableStatement2549);  
                            stream_RPAREN.add(RPAREN112);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:831:10: ( tableComment )?
                    int alt29=2;
                    switch ( input.LA(1) ) {
                        case KW_COMMENT:
                            {
                            alt29=1;
                            }
                            break;
                    }

                    switch (alt29) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:831:10: tableComment
                            {
                            pushFollow(FOLLOW_tableComment_in_createTableStatement2562);
                            tableComment113=tableComment();

                            state._fsp--;

                            stream_tableComment.add(tableComment113.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:832:10: ( tablePartition )?
                    int alt30=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITIONED:
                            {
                            alt30=1;
                            }
                            break;
                    }

                    switch (alt30) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:832:10: tablePartition
                            {
                            pushFollow(FOLLOW_tablePartition_in_createTableStatement2574);
                            tablePartition114=tablePartition();

                            state._fsp--;

                            stream_tablePartition.add(tablePartition114.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:833:10: ( tableBuckets )?
                    int alt31=2;
                    switch ( input.LA(1) ) {
                        case KW_CLUSTERED:
                            {
                            alt31=1;
                            }
                            break;
                    }

                    switch (alt31) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:833:10: tableBuckets
                            {
                            pushFollow(FOLLOW_tableBuckets_in_createTableStatement2586);
                            tableBuckets115=tableBuckets();

                            state._fsp--;

                            stream_tableBuckets.add(tableBuckets115.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:834:10: ( tableSkewed )?
                    int alt32=2;
                    switch ( input.LA(1) ) {
                        case KW_SKEWED:
                            {
                            alt32=1;
                            }
                            break;
                    }

                    switch (alt32) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:834:10: tableSkewed
                            {
                            pushFollow(FOLLOW_tableSkewed_in_createTableStatement2598);
                            tableSkewed116=tableSkewed();

                            state._fsp--;

                            stream_tableSkewed.add(tableSkewed116.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:835:10: ( tableRowFormat )?
                    int alt33=2;
                    switch ( input.LA(1) ) {
                        case KW_ROW:
                            {
                            alt33=1;
                            }
                            break;
                    }

                    switch (alt33) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:835:10: tableRowFormat
                            {
                            pushFollow(FOLLOW_tableRowFormat_in_createTableStatement2610);
                            tableRowFormat117=tableRowFormat();

                            state._fsp--;

                            stream_tableRowFormat.add(tableRowFormat117.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:836:10: ( tableFileFormat )?
                    int alt34=2;
                    switch ( input.LA(1) ) {
                        case KW_STORED:
                            {
                            alt34=1;
                            }
                            break;
                    }

                    switch (alt34) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:836:10: tableFileFormat
                            {
                            pushFollow(FOLLOW_tableFileFormat_in_createTableStatement2622);
                            tableFileFormat118=tableFileFormat();

                            state._fsp--;

                            stream_tableFileFormat.add(tableFileFormat118.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:837:10: ( tableLocation )?
                    int alt35=2;
                    switch ( input.LA(1) ) {
                        case KW_LOCATION:
                            {
                            alt35=1;
                            }
                            break;
                    }

                    switch (alt35) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:837:10: tableLocation
                            {
                            pushFollow(FOLLOW_tableLocation_in_createTableStatement2634);
                            tableLocation119=tableLocation();

                            state._fsp--;

                            stream_tableLocation.add(tableLocation119.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:838:10: ( tablePropertiesPrefixed )?
                    int alt36=2;
                    switch ( input.LA(1) ) {
                        case KW_TBLPROPERTIES:
                            {
                            alt36=1;
                            }
                            break;
                    }

                    switch (alt36) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:838:10: tablePropertiesPrefixed
                            {
                            pushFollow(FOLLOW_tablePropertiesPrefixed_in_createTableStatement2646);
                            tablePropertiesPrefixed120=tablePropertiesPrefixed();

                            state._fsp--;

                            stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed120.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:839:10: ( KW_AS selectStatementWithCTE )?
                    int alt37=2;
                    switch ( input.LA(1) ) {
                        case KW_AS:
                            {
                            alt37=1;
                            }
                            break;
                    }

                    switch (alt37) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:839:11: KW_AS selectStatementWithCTE
                            {
                            KW_AS121=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createTableStatement2659);  
                            stream_KW_AS.add(KW_AS121);


                            pushFollow(FOLLOW_selectStatementWithCTE_in_createTableStatement2661);
                            selectStatementWithCTE122=selectStatementWithCTE();

                            state._fsp--;

                            stream_selectStatementWithCTE.add(selectStatementWithCTE122.getTree());

                            }
                            break;

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: tablePropertiesPrefixed, ext, tablePartition, tableFileFormat, columnNameTypeList, ifNotExists, selectStatementWithCTE, temp, tableRowFormat, tableLocation, likeName, name, tableSkewed, tableBuckets, tableComment
            // token labels: temp, ext
            // rule labels: retval, name, likeName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_temp=new RewriteRuleTokenStream(adaptor,"token temp",temp);
            RewriteRuleTokenStream stream_ext=new RewriteRuleTokenStream(adaptor,"token ext",ext);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_likeName=new RewriteRuleSubtreeStream(adaptor,"rule likeName",likeName!=null?likeName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 841:5: -> ^( TOK_CREATETABLE $name ( $temp)? ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:841:8: ^( TOK_CREATETABLE $name ( $temp)? ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATETABLE, "TOK_CREATETABLE")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:841:33: ( $temp)?
                if ( stream_temp.hasNext() ) {
                    adaptor.addChild(root_1, stream_temp.nextNode());

                }
                stream_temp.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:841:40: ( $ext)?
                if ( stream_ext.hasNext() ) {
                    adaptor.addChild(root_1, stream_ext.nextNode());

                }
                stream_ext.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:841:45: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:842:10: ^( TOK_LIKETABLE ( $likeName)? )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LIKETABLE, "TOK_LIKETABLE")
                , root_2);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:842:27: ( $likeName)?
                if ( stream_likeName.hasNext() ) {
                    adaptor.addChild(root_2, stream_likeName.nextTree());

                }
                stream_likeName.reset();

                adaptor.addChild(root_1, root_2);
                }

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:843:10: ( columnNameTypeList )?
                if ( stream_columnNameTypeList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                }
                stream_columnNameTypeList.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:844:10: ( tableComment )?
                if ( stream_tableComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableComment.nextTree());

                }
                stream_tableComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:845:10: ( tablePartition )?
                if ( stream_tablePartition.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePartition.nextTree());

                }
                stream_tablePartition.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:846:10: ( tableBuckets )?
                if ( stream_tableBuckets.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableBuckets.nextTree());

                }
                stream_tableBuckets.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:847:10: ( tableSkewed )?
                if ( stream_tableSkewed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableSkewed.nextTree());

                }
                stream_tableSkewed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:848:10: ( tableRowFormat )?
                if ( stream_tableRowFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableRowFormat.nextTree());

                }
                stream_tableRowFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:849:10: ( tableFileFormat )?
                if ( stream_tableFileFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableFileFormat.nextTree());

                }
                stream_tableFileFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:850:10: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:851:10: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:852:10: ( selectStatementWithCTE )?
                if ( stream_selectStatementWithCTE.hasNext() ) {
                    adaptor.addChild(root_1, stream_selectStatementWithCTE.nextTree());

                }
                stream_selectStatementWithCTE.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createTableStatement"


    public static class truncateTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "truncateTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:856:1: truncateTableStatement : KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )? -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? ) ;
    public final HiveParser.truncateTableStatement_return truncateTableStatement() throws RecognitionException {
        HiveParser.truncateTableStatement_return retval = new HiveParser.truncateTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_TRUNCATE123=null;
        Token KW_TABLE124=null;
        Token KW_COLUMNS126=null;
        Token LPAREN127=null;
        Token RPAREN129=null;
        HiveParser.tablePartitionPrefix_return tablePartitionPrefix125 =null;

        HiveParser.columnNameList_return columnNameList128 =null;


        CommonTree KW_TRUNCATE123_tree=null;
        CommonTree KW_TABLE124_tree=null;
        CommonTree KW_COLUMNS126_tree=null;
        CommonTree LPAREN127_tree=null;
        CommonTree RPAREN129_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_TRUNCATE=new RewriteRuleTokenStream(adaptor,"token KW_TRUNCATE");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_tablePartitionPrefix=new RewriteRuleSubtreeStream(adaptor,"rule tablePartitionPrefix");
         pushMsg("truncate table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:859:5: ( KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )? -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:859:7: KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )?
            {
            KW_TRUNCATE123=(Token)match(input,KW_TRUNCATE,FOLLOW_KW_TRUNCATE_in_truncateTableStatement2868);  
            stream_KW_TRUNCATE.add(KW_TRUNCATE123);


            KW_TABLE124=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_truncateTableStatement2870);  
            stream_KW_TABLE.add(KW_TABLE124);


            pushFollow(FOLLOW_tablePartitionPrefix_in_truncateTableStatement2872);
            tablePartitionPrefix125=tablePartitionPrefix();

            state._fsp--;

            stream_tablePartitionPrefix.add(tablePartitionPrefix125.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:859:49: ( KW_COLUMNS LPAREN columnNameList RPAREN )?
            int alt39=2;
            switch ( input.LA(1) ) {
                case KW_COLUMNS:
                    {
                    alt39=1;
                    }
                    break;
            }

            switch (alt39) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:859:50: KW_COLUMNS LPAREN columnNameList RPAREN
                    {
                    KW_COLUMNS126=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_truncateTableStatement2875);  
                    stream_KW_COLUMNS.add(KW_COLUMNS126);


                    LPAREN127=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_truncateTableStatement2877);  
                    stream_LPAREN.add(LPAREN127);


                    pushFollow(FOLLOW_columnNameList_in_truncateTableStatement2879);
                    columnNameList128=columnNameList();

                    state._fsp--;

                    stream_columnNameList.add(columnNameList128.getTree());

                    RPAREN129=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_truncateTableStatement2881);  
                    stream_RPAREN.add(RPAREN129);


                    }
                    break;

            }


            // AST REWRITE
            // elements: tablePartitionPrefix, columnNameList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 859:92: -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:859:95: ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TRUNCATETABLE, "TOK_TRUNCATETABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tablePartitionPrefix.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:859:136: ( columnNameList )?
                if ( stream_columnNameList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameList.nextTree());

                }
                stream_columnNameList.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "truncateTableStatement"


    public static class createIndexStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createIndexStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:861:1: createIndexStatement : KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? ) ;
    public final HiveParser.createIndexStatement_return createIndexStatement() throws RecognitionException {
        HiveParser.createIndexStatement_return retval = new HiveParser.createIndexStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token typeName=null;
        Token KW_CREATE130=null;
        Token KW_INDEX131=null;
        Token KW_ON132=null;
        Token KW_TABLE133=null;
        Token LPAREN134=null;
        Token RPAREN135=null;
        Token KW_AS136=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tab =null;

        HiveParser.columnNameList_return indexedCols =null;

        HiveParser.autoRebuild_return autoRebuild137 =null;

        HiveParser.indexPropertiesPrefixed_return indexPropertiesPrefixed138 =null;

        HiveParser.indexTblName_return indexTblName139 =null;

        HiveParser.tableRowFormat_return tableRowFormat140 =null;

        HiveParser.tableFileFormat_return tableFileFormat141 =null;

        HiveParser.tableLocation_return tableLocation142 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed143 =null;

        HiveParser.indexComment_return indexComment144 =null;


        CommonTree typeName_tree=null;
        CommonTree KW_CREATE130_tree=null;
        CommonTree KW_INDEX131_tree=null;
        CommonTree KW_ON132_tree=null;
        CommonTree KW_TABLE133_tree=null;
        CommonTree LPAREN134_tree=null;
        CommonTree RPAREN135_tree=null;
        CommonTree KW_AS136_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_indexPropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule indexPropertiesPrefixed");
        RewriteRuleSubtreeStream stream_tableRowFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableRowFormat");
        RewriteRuleSubtreeStream stream_tableFileFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableFileFormat");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_autoRebuild=new RewriteRuleSubtreeStream(adaptor,"rule autoRebuild");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_indexTblName=new RewriteRuleSubtreeStream(adaptor,"rule indexTblName");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_indexComment=new RewriteRuleSubtreeStream(adaptor,"rule indexComment");
         pushMsg("create index statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:864:5: ( KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:864:7: KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )?
            {
            KW_CREATE130=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createIndexStatement2916);  
            stream_KW_CREATE.add(KW_CREATE130);


            KW_INDEX131=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_createIndexStatement2918);  
            stream_KW_INDEX.add(KW_INDEX131);


            pushFollow(FOLLOW_identifier_in_createIndexStatement2922);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            KW_ON132=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_createIndexStatement2930);  
            stream_KW_ON.add(KW_ON132);


            KW_TABLE133=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_createIndexStatement2932);  
            stream_KW_TABLE.add(KW_TABLE133);


            pushFollow(FOLLOW_tableName_in_createIndexStatement2936);
            tab=tableName();

            state._fsp--;

            stream_tableName.add(tab.getTree());

            LPAREN134=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createIndexStatement2938);  
            stream_LPAREN.add(LPAREN134);


            pushFollow(FOLLOW_columnNameList_in_createIndexStatement2942);
            indexedCols=columnNameList();

            state._fsp--;

            stream_columnNameList.add(indexedCols.getTree());

            RPAREN135=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createIndexStatement2944);  
            stream_RPAREN.add(RPAREN135);


            KW_AS136=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createIndexStatement2952);  
            stream_KW_AS.add(KW_AS136);


            typeName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_createIndexStatement2956);  
            stream_StringLiteral.add(typeName);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:867:7: ( autoRebuild )?
            int alt40=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt40=1;
                    }
                    break;
            }

            switch (alt40) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:867:7: autoRebuild
                    {
                    pushFollow(FOLLOW_autoRebuild_in_createIndexStatement2964);
                    autoRebuild137=autoRebuild();

                    state._fsp--;

                    stream_autoRebuild.add(autoRebuild137.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:868:7: ( indexPropertiesPrefixed )?
            int alt41=2;
            switch ( input.LA(1) ) {
                case KW_IDXPROPERTIES:
                    {
                    alt41=1;
                    }
                    break;
            }

            switch (alt41) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:868:7: indexPropertiesPrefixed
                    {
                    pushFollow(FOLLOW_indexPropertiesPrefixed_in_createIndexStatement2973);
                    indexPropertiesPrefixed138=indexPropertiesPrefixed();

                    state._fsp--;

                    stream_indexPropertiesPrefixed.add(indexPropertiesPrefixed138.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:869:7: ( indexTblName )?
            int alt42=2;
            switch ( input.LA(1) ) {
                case KW_IN:
                    {
                    alt42=1;
                    }
                    break;
            }

            switch (alt42) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:869:7: indexTblName
                    {
                    pushFollow(FOLLOW_indexTblName_in_createIndexStatement2982);
                    indexTblName139=indexTblName();

                    state._fsp--;

                    stream_indexTblName.add(indexTblName139.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:870:7: ( tableRowFormat )?
            int alt43=2;
            switch ( input.LA(1) ) {
                case KW_ROW:
                    {
                    alt43=1;
                    }
                    break;
            }

            switch (alt43) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:870:7: tableRowFormat
                    {
                    pushFollow(FOLLOW_tableRowFormat_in_createIndexStatement2991);
                    tableRowFormat140=tableRowFormat();

                    state._fsp--;

                    stream_tableRowFormat.add(tableRowFormat140.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:871:7: ( tableFileFormat )?
            int alt44=2;
            switch ( input.LA(1) ) {
                case KW_STORED:
                    {
                    alt44=1;
                    }
                    break;
            }

            switch (alt44) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:871:7: tableFileFormat
                    {
                    pushFollow(FOLLOW_tableFileFormat_in_createIndexStatement3000);
                    tableFileFormat141=tableFileFormat();

                    state._fsp--;

                    stream_tableFileFormat.add(tableFileFormat141.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:872:7: ( tableLocation )?
            int alt45=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt45=1;
                    }
                    break;
            }

            switch (alt45) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:872:7: tableLocation
                    {
                    pushFollow(FOLLOW_tableLocation_in_createIndexStatement3009);
                    tableLocation142=tableLocation();

                    state._fsp--;

                    stream_tableLocation.add(tableLocation142.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:873:7: ( tablePropertiesPrefixed )?
            int alt46=2;
            switch ( input.LA(1) ) {
                case KW_TBLPROPERTIES:
                    {
                    alt46=1;
                    }
                    break;
            }

            switch (alt46) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:873:7: tablePropertiesPrefixed
                    {
                    pushFollow(FOLLOW_tablePropertiesPrefixed_in_createIndexStatement3018);
                    tablePropertiesPrefixed143=tablePropertiesPrefixed();

                    state._fsp--;

                    stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed143.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:874:7: ( indexComment )?
            int alt47=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt47=1;
                    }
                    break;
            }

            switch (alt47) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:874:7: indexComment
                    {
                    pushFollow(FOLLOW_indexComment_in_createIndexStatement3027);
                    indexComment144=indexComment();

                    state._fsp--;

                    stream_indexComment.add(indexComment144.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: tab, tableFileFormat, indexName, indexTblName, autoRebuild, indexedCols, tablePropertiesPrefixed, tableRowFormat, indexComment, typeName, tableLocation, indexPropertiesPrefixed
            // token labels: typeName
            // rule labels: indexedCols, retval, indexName, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_typeName=new RewriteRuleTokenStream(adaptor,"token typeName",typeName);
            RewriteRuleSubtreeStream stream_indexedCols=new RewriteRuleSubtreeStream(adaptor,"rule indexedCols",indexedCols!=null?indexedCols.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 875:5: -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:875:7: ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEINDEX, "TOK_CREATEINDEX")
                , root_1);

                adaptor.addChild(root_1, stream_indexName.nextTree());

                adaptor.addChild(root_1, stream_typeName.nextNode());

                adaptor.addChild(root_1, stream_tab.nextTree());

                adaptor.addChild(root_1, stream_indexedCols.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:876:9: ( autoRebuild )?
                if ( stream_autoRebuild.hasNext() ) {
                    adaptor.addChild(root_1, stream_autoRebuild.nextTree());

                }
                stream_autoRebuild.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:9: ( indexPropertiesPrefixed )?
                if ( stream_indexPropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexPropertiesPrefixed.nextTree());

                }
                stream_indexPropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:878:9: ( indexTblName )?
                if ( stream_indexTblName.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexTblName.nextTree());

                }
                stream_indexTblName.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:879:9: ( tableRowFormat )?
                if ( stream_tableRowFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableRowFormat.nextTree());

                }
                stream_tableRowFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:880:9: ( tableFileFormat )?
                if ( stream_tableFileFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableFileFormat.nextTree());

                }
                stream_tableFileFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:881:9: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:882:9: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:883:9: ( indexComment )?
                if ( stream_indexComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexComment.nextTree());

                }
                stream_indexComment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createIndexStatement"


    public static class indexComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:886:1: indexComment : KW_COMMENT comment= StringLiteral -> ^( TOK_INDEXCOMMENT $comment) ;
    public final HiveParser.indexComment_return indexComment() throws RecognitionException {
        HiveParser.indexComment_return retval = new HiveParser.indexComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT145=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT145_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         pushMsg("comment on an index", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:889:9: ( KW_COMMENT comment= StringLiteral -> ^( TOK_INDEXCOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:890:17: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT145=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_indexComment3184);  
            stream_KW_COMMENT.add(KW_COMMENT145);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_indexComment3188);  
            stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 890:51: -> ^( TOK_INDEXCOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:890:54: ^( TOK_INDEXCOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXCOMMENT, "TOK_INDEXCOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexComment"


    public static class autoRebuild_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "autoRebuild"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:893:1: autoRebuild : KW_WITH KW_DEFERRED KW_REBUILD -> ^( TOK_DEFERRED_REBUILDINDEX ) ;
    public final HiveParser.autoRebuild_return autoRebuild() throws RecognitionException {
        HiveParser.autoRebuild_return retval = new HiveParser.autoRebuild_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_WITH146=null;
        Token KW_DEFERRED147=null;
        Token KW_REBUILD148=null;

        CommonTree KW_WITH146_tree=null;
        CommonTree KW_DEFERRED147_tree=null;
        CommonTree KW_REBUILD148_tree=null;
        RewriteRuleTokenStream stream_KW_REBUILD=new RewriteRuleTokenStream(adaptor,"token KW_REBUILD");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_DEFERRED=new RewriteRuleTokenStream(adaptor,"token KW_DEFERRED");

         pushMsg("auto rebuild index", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:896:5: ( KW_WITH KW_DEFERRED KW_REBUILD -> ^( TOK_DEFERRED_REBUILDINDEX ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:896:7: KW_WITH KW_DEFERRED KW_REBUILD
            {
            KW_WITH146=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_autoRebuild3229);  
            stream_KW_WITH.add(KW_WITH146);


            KW_DEFERRED147=(Token)match(input,KW_DEFERRED,FOLLOW_KW_DEFERRED_in_autoRebuild3231);  
            stream_KW_DEFERRED.add(KW_DEFERRED147);


            KW_REBUILD148=(Token)match(input,KW_REBUILD,FOLLOW_KW_REBUILD_in_autoRebuild3233);  
            stream_KW_REBUILD.add(KW_REBUILD148);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 897:5: -> ^( TOK_DEFERRED_REBUILDINDEX )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:897:7: ^( TOK_DEFERRED_REBUILDINDEX )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DEFERRED_REBUILDINDEX, "TOK_DEFERRED_REBUILDINDEX")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "autoRebuild"


    public static class indexTblName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexTblName"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:900:1: indexTblName : KW_IN KW_TABLE indexTbl= tableName -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl) ;
    public final HiveParser.indexTblName_return indexTblName() throws RecognitionException {
        HiveParser.indexTblName_return retval = new HiveParser.indexTblName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IN149=null;
        Token KW_TABLE150=null;
        HiveParser_FromClauseParser.tableName_return indexTbl =null;


        CommonTree KW_IN149_tree=null;
        CommonTree KW_TABLE150_tree=null;
        RewriteRuleTokenStream stream_KW_IN=new RewriteRuleTokenStream(adaptor,"token KW_IN");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("index table name", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:903:5: ( KW_IN KW_TABLE indexTbl= tableName -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:903:7: KW_IN KW_TABLE indexTbl= tableName
            {
            KW_IN149=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_indexTblName3269);  
            stream_KW_IN.add(KW_IN149);


            KW_TABLE150=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_indexTblName3271);  
            stream_KW_TABLE.add(KW_TABLE150);


            pushFollow(FOLLOW_tableName_in_indexTblName3275);
            indexTbl=tableName();

            state._fsp--;

            stream_tableName.add(indexTbl.getTree());

            // AST REWRITE
            // elements: indexTbl
            // token labels: 
            // rule labels: retval, indexTbl
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexTbl=new RewriteRuleSubtreeStream(adaptor,"rule indexTbl",indexTbl!=null?indexTbl.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 904:5: -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:904:7: ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEINDEX_INDEXTBLNAME, "TOK_CREATEINDEX_INDEXTBLNAME")
                , root_1);

                adaptor.addChild(root_1, stream_indexTbl.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexTblName"


    public static class indexPropertiesPrefixed_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexPropertiesPrefixed"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:907:1: indexPropertiesPrefixed : KW_IDXPROPERTIES ! indexProperties ;
    public final HiveParser.indexPropertiesPrefixed_return indexPropertiesPrefixed() throws RecognitionException {
        HiveParser.indexPropertiesPrefixed_return retval = new HiveParser.indexPropertiesPrefixed_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IDXPROPERTIES151=null;
        HiveParser.indexProperties_return indexProperties152 =null;


        CommonTree KW_IDXPROPERTIES151_tree=null;

         pushMsg("table properties with prefix", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:910:5: ( KW_IDXPROPERTIES ! indexProperties )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:911:9: KW_IDXPROPERTIES ! indexProperties
            {
            root_0 = (CommonTree)adaptor.nil();


            KW_IDXPROPERTIES151=(Token)match(input,KW_IDXPROPERTIES,FOLLOW_KW_IDXPROPERTIES_in_indexPropertiesPrefixed3322); 

            pushFollow(FOLLOW_indexProperties_in_indexPropertiesPrefixed3325);
            indexProperties152=indexProperties();

            state._fsp--;

            adaptor.addChild(root_0, indexProperties152.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexPropertiesPrefixed"


    public static class indexProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:914:1: indexProperties : LPAREN indexPropertiesList RPAREN -> ^( TOK_INDEXPROPERTIES indexPropertiesList ) ;
    public final HiveParser.indexProperties_return indexProperties() throws RecognitionException {
        HiveParser.indexProperties_return retval = new HiveParser.indexProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN153=null;
        Token RPAREN155=null;
        HiveParser.indexPropertiesList_return indexPropertiesList154 =null;


        CommonTree LPAREN153_tree=null;
        CommonTree RPAREN155_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_indexPropertiesList=new RewriteRuleSubtreeStream(adaptor,"rule indexPropertiesList");
         pushMsg("index properties", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:917:5: ( LPAREN indexPropertiesList RPAREN -> ^( TOK_INDEXPROPERTIES indexPropertiesList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:918:7: LPAREN indexPropertiesList RPAREN
            {
            LPAREN153=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_indexProperties3358);  
            stream_LPAREN.add(LPAREN153);


            pushFollow(FOLLOW_indexPropertiesList_in_indexProperties3360);
            indexPropertiesList154=indexPropertiesList();

            state._fsp--;

            stream_indexPropertiesList.add(indexPropertiesList154.getTree());

            RPAREN155=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_indexProperties3362);  
            stream_RPAREN.add(RPAREN155);


            // AST REWRITE
            // elements: indexPropertiesList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 918:41: -> ^( TOK_INDEXPROPERTIES indexPropertiesList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:918:44: ^( TOK_INDEXPROPERTIES indexPropertiesList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXPROPERTIES, "TOK_INDEXPROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_indexPropertiesList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexProperties"


    public static class indexPropertiesList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexPropertiesList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:921:1: indexPropertiesList : keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ ) ;
    public final HiveParser.indexPropertiesList_return indexPropertiesList() throws RecognitionException {
        HiveParser.indexPropertiesList_return retval = new HiveParser.indexPropertiesList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA157=null;
        HiveParser.keyValueProperty_return keyValueProperty156 =null;

        HiveParser.keyValueProperty_return keyValueProperty158 =null;


        CommonTree COMMA157_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_keyValueProperty=new RewriteRuleSubtreeStream(adaptor,"rule keyValueProperty");
         pushMsg("index properties list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:924:5: ( keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:925:7: keyValueProperty ( COMMA keyValueProperty )*
            {
            pushFollow(FOLLOW_keyValueProperty_in_indexPropertiesList3403);
            keyValueProperty156=keyValueProperty();

            state._fsp--;

            stream_keyValueProperty.add(keyValueProperty156.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:925:24: ( COMMA keyValueProperty )*
            loop48:
            do {
                int alt48=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt48=1;
                    }
                    break;

                }

                switch (alt48) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:925:25: COMMA keyValueProperty
            	    {
            	    COMMA157=(Token)match(input,COMMA,FOLLOW_COMMA_in_indexPropertiesList3406);  
            	    stream_COMMA.add(COMMA157);


            	    pushFollow(FOLLOW_keyValueProperty_in_indexPropertiesList3408);
            	    keyValueProperty158=keyValueProperty();

            	    state._fsp--;

            	    stream_keyValueProperty.add(keyValueProperty158.getTree());

            	    }
            	    break;

            	default :
            	    break loop48;
                }
            } while (true);


            // AST REWRITE
            // elements: keyValueProperty
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 925:50: -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:925:53: ^( TOK_INDEXPROPLIST ( keyValueProperty )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXPROPLIST, "TOK_INDEXPROPLIST")
                , root_1);

                if ( !(stream_keyValueProperty.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_keyValueProperty.hasNext() ) {
                    adaptor.addChild(root_1, stream_keyValueProperty.nextTree());

                }
                stream_keyValueProperty.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexPropertiesList"


    public static class dropIndexStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropIndexStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:928:1: dropIndexStatement : KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? ) ;
    public final HiveParser.dropIndexStatement_return dropIndexStatement() throws RecognitionException {
        HiveParser.dropIndexStatement_return retval = new HiveParser.dropIndexStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP159=null;
        Token KW_INDEX160=null;
        Token KW_ON162=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tab =null;

        HiveParser.ifExists_return ifExists161 =null;


        CommonTree KW_DROP159_tree=null;
        CommonTree KW_INDEX160_tree=null;
        CommonTree KW_ON162_tree=null;
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("drop index statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:931:5: ( KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:931:7: KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName
            {
            KW_DROP159=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropIndexStatement3446);  
            stream_KW_DROP.add(KW_DROP159);


            KW_INDEX160=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_dropIndexStatement3448);  
            stream_KW_INDEX.add(KW_INDEX160);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:931:24: ( ifExists )?
            int alt49=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt49=1;
                    }
                    break;
            }

            switch (alt49) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:931:24: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropIndexStatement3450);
                    ifExists161=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists161.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropIndexStatement3455);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            KW_ON162=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_dropIndexStatement3457);  
            stream_KW_ON.add(KW_ON162);


            pushFollow(FOLLOW_tableName_in_dropIndexStatement3461);
            tab=tableName();

            state._fsp--;

            stream_tableName.add(tab.getTree());

            // AST REWRITE
            // elements: ifExists, tab, indexName
            // token labels: 
            // rule labels: retval, indexName, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 932:5: -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:932:7: ^( TOK_DROPINDEX $indexName $tab ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPINDEX, "TOK_DROPINDEX")
                , root_1);

                adaptor.addChild(root_1, stream_indexName.nextTree());

                adaptor.addChild(root_1, stream_tab.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:932:39: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropIndexStatement"


    public static class dropTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:935:1: dropTableStatement : KW_DROP KW_TABLE ( ifExists )? tableName ( KW_PURGE )? -> ^( TOK_DROPTABLE tableName ( ifExists )? ( KW_PURGE )? ) ;
    public final HiveParser.dropTableStatement_return dropTableStatement() throws RecognitionException {
        HiveParser.dropTableStatement_return retval = new HiveParser.dropTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP163=null;
        Token KW_TABLE164=null;
        Token KW_PURGE167=null;
        HiveParser.ifExists_return ifExists165 =null;

        HiveParser_FromClauseParser.tableName_return tableName166 =null;


        CommonTree KW_DROP163_tree=null;
        CommonTree KW_TABLE164_tree=null;
        CommonTree KW_PURGE167_tree=null;
        RewriteRuleTokenStream stream_KW_PURGE=new RewriteRuleTokenStream(adaptor,"token KW_PURGE");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         pushMsg("drop statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:5: ( KW_DROP KW_TABLE ( ifExists )? tableName ( KW_PURGE )? -> ^( TOK_DROPTABLE tableName ( ifExists )? ( KW_PURGE )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:7: KW_DROP KW_TABLE ( ifExists )? tableName ( KW_PURGE )?
            {
            KW_DROP163=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropTableStatement3506);  
            stream_KW_DROP.add(KW_DROP163);


            KW_TABLE164=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_dropTableStatement3508);  
            stream_KW_TABLE.add(KW_TABLE164);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:24: ( ifExists )?
            int alt50=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt50=1;
                    }
                    break;
            }

            switch (alt50) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:24: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropTableStatement3510);
                    ifExists165=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists165.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_dropTableStatement3513);
            tableName166=tableName();

            state._fsp--;

            stream_tableName.add(tableName166.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:44: ( KW_PURGE )?
            int alt51=2;
            switch ( input.LA(1) ) {
                case KW_PURGE:
                    {
                    alt51=1;
                    }
                    break;
            }

            switch (alt51) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:44: KW_PURGE
                    {
                    KW_PURGE167=(Token)match(input,KW_PURGE,FOLLOW_KW_PURGE_in_dropTableStatement3515);  
                    stream_KW_PURGE.add(KW_PURGE167);


                    }
                    break;

            }


            // AST REWRITE
            // elements: KW_PURGE, tableName, ifExists
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 938:54: -> ^( TOK_DROPTABLE tableName ( ifExists )? ( KW_PURGE )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:57: ^( TOK_DROPTABLE tableName ( ifExists )? ( KW_PURGE )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPTABLE, "TOK_DROPTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:83: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:93: ( KW_PURGE )?
                if ( stream_KW_PURGE.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_KW_PURGE.nextNode()
                    );

                }
                stream_KW_PURGE.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropTableStatement"


    public static class alterStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:941:1: alterStatement : ( KW_ALTER KW_TABLE tableName alterTableStatementSuffix -> ^( TOK_ALTERTABLE tableName alterTableStatementSuffix ) | KW_ALTER KW_VIEW tableName ( KW_AS )? alterViewStatementSuffix -> ^( TOK_ALTERVIEW tableName alterViewStatementSuffix ) | KW_ALTER KW_INDEX alterIndexStatementSuffix -> alterIndexStatementSuffix | KW_ALTER ( KW_DATABASE | KW_SCHEMA ) alterDatabaseStatementSuffix -> alterDatabaseStatementSuffix );
    public final HiveParser.alterStatement_return alterStatement() throws RecognitionException {
        HiveParser.alterStatement_return retval = new HiveParser.alterStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALTER168=null;
        Token KW_TABLE169=null;
        Token KW_ALTER172=null;
        Token KW_VIEW173=null;
        Token KW_AS175=null;
        Token KW_ALTER177=null;
        Token KW_INDEX178=null;
        Token KW_ALTER180=null;
        Token KW_DATABASE181=null;
        Token KW_SCHEMA182=null;
        HiveParser_FromClauseParser.tableName_return tableName170 =null;

        HiveParser.alterTableStatementSuffix_return alterTableStatementSuffix171 =null;

        HiveParser_FromClauseParser.tableName_return tableName174 =null;

        HiveParser.alterViewStatementSuffix_return alterViewStatementSuffix176 =null;

        HiveParser.alterIndexStatementSuffix_return alterIndexStatementSuffix179 =null;

        HiveParser.alterDatabaseStatementSuffix_return alterDatabaseStatementSuffix183 =null;


        CommonTree KW_ALTER168_tree=null;
        CommonTree KW_TABLE169_tree=null;
        CommonTree KW_ALTER172_tree=null;
        CommonTree KW_VIEW173_tree=null;
        CommonTree KW_AS175_tree=null;
        CommonTree KW_ALTER177_tree=null;
        CommonTree KW_INDEX178_tree=null;
        CommonTree KW_ALTER180_tree=null;
        CommonTree KW_DATABASE181_tree=null;
        CommonTree KW_SCHEMA182_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_ALTER=new RewriteRuleTokenStream(adaptor,"token KW_ALTER");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_VIEW=new RewriteRuleTokenStream(adaptor,"token KW_VIEW");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_alterTableStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterTableStatementSuffix");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_alterDatabaseStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterDatabaseStatementSuffix");
        RewriteRuleSubtreeStream stream_alterViewStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterViewStatementSuffix");
        RewriteRuleSubtreeStream stream_alterIndexStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterIndexStatementSuffix");
         pushMsg("alter statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:944:5: ( KW_ALTER KW_TABLE tableName alterTableStatementSuffix -> ^( TOK_ALTERTABLE tableName alterTableStatementSuffix ) | KW_ALTER KW_VIEW tableName ( KW_AS )? alterViewStatementSuffix -> ^( TOK_ALTERVIEW tableName alterViewStatementSuffix ) | KW_ALTER KW_INDEX alterIndexStatementSuffix -> alterIndexStatementSuffix | KW_ALTER ( KW_DATABASE | KW_SCHEMA ) alterDatabaseStatementSuffix -> alterDatabaseStatementSuffix )
            int alt54=4;
            switch ( input.LA(1) ) {
            case KW_ALTER:
                {
                switch ( input.LA(2) ) {
                case KW_TABLE:
                    {
                    alt54=1;
                    }
                    break;
                case KW_VIEW:
                    {
                    alt54=2;
                    }
                    break;
                case KW_INDEX:
                    {
                    alt54=3;
                    }
                    break;
                case KW_DATABASE:
                case KW_SCHEMA:
                    {
                    alt54=4;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 54, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 54, 0, input);

                throw nvae;

            }

            switch (alt54) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:944:7: KW_ALTER KW_TABLE tableName alterTableStatementSuffix
                    {
                    KW_ALTER168=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3557);  
                    stream_KW_ALTER.add(KW_ALTER168);


                    KW_TABLE169=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_alterStatement3559);  
                    stream_KW_TABLE.add(KW_TABLE169);


                    pushFollow(FOLLOW_tableName_in_alterStatement3561);
                    tableName170=tableName();

                    state._fsp--;

                    stream_tableName.add(tableName170.getTree());

                    pushFollow(FOLLOW_alterTableStatementSuffix_in_alterStatement3563);
                    alterTableStatementSuffix171=alterTableStatementSuffix();

                    state._fsp--;

                    stream_alterTableStatementSuffix.add(alterTableStatementSuffix171.getTree());

                    // AST REWRITE
                    // elements: alterTableStatementSuffix, tableName
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 944:61: -> ^( TOK_ALTERTABLE tableName alterTableStatementSuffix )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:944:64: ^( TOK_ALTERTABLE tableName alterTableStatementSuffix )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE, "TOK_ALTERTABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        adaptor.addChild(root_1, stream_alterTableStatementSuffix.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:945:7: KW_ALTER KW_VIEW tableName ( KW_AS )? alterViewStatementSuffix
                    {
                    KW_ALTER172=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3581);  
                    stream_KW_ALTER.add(KW_ALTER172);


                    KW_VIEW173=(Token)match(input,KW_VIEW,FOLLOW_KW_VIEW_in_alterStatement3583);  
                    stream_KW_VIEW.add(KW_VIEW173);


                    pushFollow(FOLLOW_tableName_in_alterStatement3585);
                    tableName174=tableName();

                    state._fsp--;

                    stream_tableName.add(tableName174.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:945:34: ( KW_AS )?
                    int alt52=2;
                    switch ( input.LA(1) ) {
                        case KW_AS:
                            {
                            alt52=1;
                            }
                            break;
                    }

                    switch (alt52) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:945:34: KW_AS
                            {
                            KW_AS175=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_alterStatement3587);  
                            stream_KW_AS.add(KW_AS175);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_alterViewStatementSuffix_in_alterStatement3590);
                    alterViewStatementSuffix176=alterViewStatementSuffix();

                    state._fsp--;

                    stream_alterViewStatementSuffix.add(alterViewStatementSuffix176.getTree());

                    // AST REWRITE
                    // elements: alterViewStatementSuffix, tableName
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 945:66: -> ^( TOK_ALTERVIEW tableName alterViewStatementSuffix )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:945:69: ^( TOK_ALTERVIEW tableName alterViewStatementSuffix )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW, "TOK_ALTERVIEW")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        adaptor.addChild(root_1, stream_alterViewStatementSuffix.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:946:7: KW_ALTER KW_INDEX alterIndexStatementSuffix
                    {
                    KW_ALTER177=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3608);  
                    stream_KW_ALTER.add(KW_ALTER177);


                    KW_INDEX178=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_alterStatement3610);  
                    stream_KW_INDEX.add(KW_INDEX178);


                    pushFollow(FOLLOW_alterIndexStatementSuffix_in_alterStatement3612);
                    alterIndexStatementSuffix179=alterIndexStatementSuffix();

                    state._fsp--;

                    stream_alterIndexStatementSuffix.add(alterIndexStatementSuffix179.getTree());

                    // AST REWRITE
                    // elements: alterIndexStatementSuffix
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 946:51: -> alterIndexStatementSuffix
                    {
                        adaptor.addChild(root_0, stream_alterIndexStatementSuffix.nextTree());

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:947:7: KW_ALTER ( KW_DATABASE | KW_SCHEMA ) alterDatabaseStatementSuffix
                    {
                    KW_ALTER180=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3624);  
                    stream_KW_ALTER.add(KW_ALTER180);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:947:16: ( KW_DATABASE | KW_SCHEMA )
                    int alt53=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASE:
                        {
                        alt53=1;
                        }
                        break;
                    case KW_SCHEMA:
                        {
                        alt53=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 53, 0, input);

                        throw nvae;

                    }

                    switch (alt53) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:947:17: KW_DATABASE
                            {
                            KW_DATABASE181=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_alterStatement3627);  
                            stream_KW_DATABASE.add(KW_DATABASE181);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:947:29: KW_SCHEMA
                            {
                            KW_SCHEMA182=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_alterStatement3629);  
                            stream_KW_SCHEMA.add(KW_SCHEMA182);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_alterDatabaseStatementSuffix_in_alterStatement3632);
                    alterDatabaseStatementSuffix183=alterDatabaseStatementSuffix();

                    state._fsp--;

                    stream_alterDatabaseStatementSuffix.add(alterDatabaseStatementSuffix183.getTree());

                    // AST REWRITE
                    // elements: alterDatabaseStatementSuffix
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 947:69: -> alterDatabaseStatementSuffix
                    {
                        adaptor.addChild(root_0, stream_alterDatabaseStatementSuffix.nextTree());

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatement"


    public static class alterTableStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTableStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:950:1: alterTableStatementSuffix : ( alterStatementSuffixRename[true] | alterStatementSuffixUpdateStatsCol | alterStatementSuffixDropPartitions[true] | alterStatementSuffixAddPartitions[true] | alterStatementSuffixTouch | alterStatementSuffixArchive | alterStatementSuffixUnArchive | alterStatementSuffixProperties | alterStatementSuffixSkewedby | alterStatementSuffixExchangePartition | alterStatementPartitionKeyType | ( partitionSpec )? alterTblPartitionStatementSuffix -> alterTblPartitionStatementSuffix ( partitionSpec )? );
    public final HiveParser.alterTableStatementSuffix_return alterTableStatementSuffix() throws RecognitionException {
        HiveParser.alterTableStatementSuffix_return retval = new HiveParser.alterTableStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename184 =null;

        HiveParser.alterStatementSuffixUpdateStatsCol_return alterStatementSuffixUpdateStatsCol185 =null;

        HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions186 =null;

        HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions187 =null;

        HiveParser.alterStatementSuffixTouch_return alterStatementSuffixTouch188 =null;

        HiveParser.alterStatementSuffixArchive_return alterStatementSuffixArchive189 =null;

        HiveParser.alterStatementSuffixUnArchive_return alterStatementSuffixUnArchive190 =null;

        HiveParser.alterStatementSuffixProperties_return alterStatementSuffixProperties191 =null;

        HiveParser.alterStatementSuffixSkewedby_return alterStatementSuffixSkewedby192 =null;

        HiveParser.alterStatementSuffixExchangePartition_return alterStatementSuffixExchangePartition193 =null;

        HiveParser.alterStatementPartitionKeyType_return alterStatementPartitionKeyType194 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec195 =null;

        HiveParser.alterTblPartitionStatementSuffix_return alterTblPartitionStatementSuffix196 =null;


        RewriteRuleSubtreeStream stream_alterTblPartitionStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterTblPartitionStatementSuffix");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("alter table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:953:5: ( alterStatementSuffixRename[true] | alterStatementSuffixUpdateStatsCol | alterStatementSuffixDropPartitions[true] | alterStatementSuffixAddPartitions[true] | alterStatementSuffixTouch | alterStatementSuffixArchive | alterStatementSuffixUnArchive | alterStatementSuffixProperties | alterStatementSuffixSkewedby | alterStatementSuffixExchangePartition | alterStatementPartitionKeyType | ( partitionSpec )? alterTblPartitionStatementSuffix -> alterTblPartitionStatementSuffix ( partitionSpec )? )
            int alt56=12;
            switch ( input.LA(1) ) {
            case KW_RENAME:
                {
                switch ( input.LA(2) ) {
                case KW_TO:
                    {
                    switch ( input.LA(3) ) {
                    case Identifier:
                    case KW_ADD:
                    case KW_ADMIN:
                    case KW_AFTER:
                    case KW_ALL:
                    case KW_ALTER:
                    case KW_ANALYZE:
                    case KW_ARCHIVE:
                    case KW_ARRAY:
                    case KW_AS:
                    case KW_ASC:
                    case KW_AUTHORIZATION:
                    case KW_BEFORE:
                    case KW_BETWEEN:
                    case KW_BIGINT:
                    case KW_BINARY:
                    case KW_BOOLEAN:
                    case KW_BOTH:
                    case KW_BUCKET:
                    case KW_BUCKETS:
                    case KW_BY:
                    case KW_CASCADE:
                    case KW_CHANGE:
                    case KW_CLUSTER:
                    case KW_CLUSTERED:
                    case KW_CLUSTERSTATUS:
                    case KW_COLLECTION:
                    case KW_COLUMNS:
                    case KW_COMMENT:
                    case KW_COMPACT:
                    case KW_COMPACTIONS:
                    case KW_COMPUTE:
                    case KW_CONCATENATE:
                    case KW_CONTINUE:
                    case KW_CREATE:
                    case KW_CUBE:
                    case KW_CURSOR:
                    case KW_DATA:
                    case KW_DATABASES:
                    case KW_DATE:
                    case KW_DATETIME:
                    case KW_DBPROPERTIES:
                    case KW_DECIMAL:
                    case KW_DEFAULT:
                    case KW_DEFERRED:
                    case KW_DEFINED:
                    case KW_DELETE:
                    case KW_DELIMITED:
                    case KW_DEPENDENCY:
                    case KW_DESC:
                    case KW_DESCRIBE:
                    case KW_DIRECTORIES:
                    case KW_DIRECTORY:
                    case KW_DISABLE:
                    case KW_DISTRIBUTE:
                    case KW_DOUBLE:
                    case KW_DROP:
                    case KW_ELEM_TYPE:
                    case KW_ENABLE:
                    case KW_ESCAPED:
                    case KW_EXCLUSIVE:
                    case KW_EXISTS:
                    case KW_EXPLAIN:
                    case KW_EXPORT:
                    case KW_EXTERNAL:
                    case KW_FALSE:
                    case KW_FETCH:
                    case KW_FIELDS:
                    case KW_FILE:
                    case KW_FILEFORMAT:
                    case KW_FIRST:
                    case KW_FLOAT:
                    case KW_FOR:
                    case KW_FORMAT:
                    case KW_FORMATTED:
                    case KW_FULL:
                    case KW_FUNCTIONS:
                    case KW_GRANT:
                    case KW_GROUP:
                    case KW_GROUPING:
                    case KW_HOLD_DDLTIME:
                    case KW_IDXPROPERTIES:
                    case KW_IGNORE:
                    case KW_IMPORT:
                    case KW_IN:
                    case KW_INDEX:
                    case KW_INDEXES:
                    case KW_INNER:
                    case KW_INPATH:
                    case KW_INPUTDRIVER:
                    case KW_INPUTFORMAT:
                    case KW_INSERT:
                    case KW_INT:
                    case KW_INTERSECT:
                    case KW_INTO:
                    case KW_IS:
                    case KW_ITEMS:
                    case KW_JAR:
                    case KW_KEYS:
                    case KW_KEY_TYPE:
                    case KW_LATERAL:
                    case KW_LEFT:
                    case KW_LIKE:
                    case KW_LIMIT:
                    case KW_LINES:
                    case KW_LOAD:
                    case KW_LOCAL:
                    case KW_LOCATION:
                    case KW_LOCK:
                    case KW_LOCKS:
                    case KW_LOGICAL:
                    case KW_LONG:
                    case KW_MAPJOIN:
                    case KW_MATERIALIZED:
                    case KW_MINUS:
                    case KW_MSCK:
                    case KW_NONE:
                    case KW_NOSCAN:
                    case KW_NO_DROP:
                    case KW_NULL:
                    case KW_OF:
                    case KW_OFFLINE:
                    case KW_OPTION:
                    case KW_ORDER:
                    case KW_OUT:
                    case KW_OUTER:
                    case KW_OUTPUTDRIVER:
                    case KW_OUTPUTFORMAT:
                    case KW_OVERWRITE:
                    case KW_OWNER:
                    case KW_PARTITIONED:
                    case KW_PARTITIONS:
                    case KW_PERCENT:
                    case KW_PLUS:
                    case KW_PRETTY:
                    case KW_PRINCIPALS:
                    case KW_PROCEDURE:
                    case KW_PROTECTION:
                    case KW_PURGE:
                    case KW_RANGE:
                    case KW_READ:
                    case KW_READONLY:
                    case KW_READS:
                    case KW_REBUILD:
                    case KW_RECORDREADER:
                    case KW_RECORDWRITER:
                    case KW_REGEXP:
                    case KW_RENAME:
                    case KW_REPAIR:
                    case KW_REPLACE:
                    case KW_RESTRICT:
                    case KW_REVOKE:
                    case KW_REWRITE:
                    case KW_RIGHT:
                    case KW_RLIKE:
                    case KW_ROLE:
                    case KW_ROLES:
                    case KW_ROLLUP:
                    case KW_ROW:
                    case KW_ROWS:
                    case KW_SCHEMA:
                    case KW_SCHEMAS:
                    case KW_SEMI:
                    case KW_SERDE:
                    case KW_SERDEPROPERTIES:
                    case KW_SERVER:
                    case KW_SET:
                    case KW_SETS:
                    case KW_SHARED:
                    case KW_SHOW:
                    case KW_SHOW_DATABASE:
                    case KW_SKEWED:
                    case KW_SMALLINT:
                    case KW_SORT:
                    case KW_SORTED:
                    case KW_SSL:
                    case KW_STATISTICS:
                    case KW_STORED:
                    case KW_STREAMTABLE:
                    case KW_STRING:
                    case KW_STRUCT:
                    case KW_TABLE:
                    case KW_TABLES:
                    case KW_TBLPROPERTIES:
                    case KW_TEMPORARY:
                    case KW_TERMINATED:
                    case KW_TIMESTAMP:
                    case KW_TINYINT:
                    case KW_TO:
                    case KW_TOUCH:
                    case KW_TRANSACTIONS:
                    case KW_TRIGGER:
                    case KW_TRUE:
                    case KW_TRUNCATE:
                    case KW_UNARCHIVE:
                    case KW_UNDO:
                    case KW_UNION:
                    case KW_UNIONTYPE:
                    case KW_UNLOCK:
                    case KW_UNSET:
                    case KW_UNSIGNED:
                    case KW_UPDATE:
                    case KW_URI:
                    case KW_USE:
                    case KW_USER:
                    case KW_USING:
                    case KW_UTC:
                    case KW_UTCTIMESTAMP:
                    case KW_VALUES:
                    case KW_VALUE_TYPE:
                    case KW_VIEW:
                    case KW_WHILE:
                    case KW_WITH:
                        {
                        alt56=1;
                        }
                        break;
                    case KW_PARTITION:
                        {
                        alt56=1;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 56, 22, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 56, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_UPDATE:
                {
                switch ( input.LA(2) ) {
                case KW_STATISTICS:
                    {
                    switch ( input.LA(3) ) {
                    case KW_FOR:
                        {
                        alt56=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 56, 23, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 56, 2, input);

                    throw nvae;

                }

                }
                break;
            case KW_DROP:
                {
                alt56=3;
                }
                break;
            case KW_ADD:
                {
                switch ( input.LA(2) ) {
                case KW_IF:
                case KW_PARTITION:
                    {
                    alt56=4;
                    }
                    break;
                case KW_COLUMNS:
                    {
                    alt56=12;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 56, 4, input);

                    throw nvae;

                }

                }
                break;
            case KW_TOUCH:
                {
                alt56=5;
                }
                break;
            case KW_ARCHIVE:
                {
                alt56=6;
                }
                break;
            case KW_UNARCHIVE:
                {
                alt56=7;
                }
                break;
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_TBLPROPERTIES:
                    {
                    alt56=8;
                    }
                    break;
                case KW_FILEFORMAT:
                case KW_LOCATION:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SKEWED:
                    {
                    alt56=12;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 56, 8, input);

                    throw nvae;

                }

                }
                break;
            case KW_UNSET:
                {
                alt56=8;
                }
                break;
            case KW_SKEWED:
                {
                alt56=9;
                }
                break;
            case KW_NOT:
                {
                switch ( input.LA(2) ) {
                case KW_SKEWED:
                case KW_STORED:
                    {
                    alt56=9;
                    }
                    break;
                case KW_CLUSTERED:
                case KW_SORTED:
                    {
                    alt56=12;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 56, 11, input);

                    throw nvae;

                }

                }
                break;
            case KW_EXCHANGE:
                {
                alt56=10;
                }
                break;
            case KW_PARTITION:
                {
                switch ( input.LA(2) ) {
                case KW_COLUMN:
                    {
                    alt56=11;
                    }
                    break;
                case LPAREN:
                    {
                    alt56=12;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 56, 13, input);

                    throw nvae;

                }

                }
                break;
            case KW_CHANGE:
            case KW_CLUSTERED:
            case KW_COMPACT:
            case KW_CONCATENATE:
            case KW_DISABLE:
            case KW_ENABLE:
            case KW_INTO:
            case KW_REPLACE:
                {
                alt56=12;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;

            }

            switch (alt56) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:953:7: alterStatementSuffixRename[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRename_in_alterTableStatementSuffix3663);
                    alterStatementSuffixRename184=alterStatementSuffixRename(true);

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRename184.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:954:7: alterStatementSuffixUpdateStatsCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixUpdateStatsCol_in_alterTableStatementSuffix3672);
                    alterStatementSuffixUpdateStatsCol185=alterStatementSuffixUpdateStatsCol();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixUpdateStatsCol185.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:955:7: alterStatementSuffixDropPartitions[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixDropPartitions_in_alterTableStatementSuffix3680);
                    alterStatementSuffixDropPartitions186=alterStatementSuffixDropPartitions(true);

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixDropPartitions186.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:7: alterStatementSuffixAddPartitions[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddPartitions_in_alterTableStatementSuffix3689);
                    alterStatementSuffixAddPartitions187=alterStatementSuffixAddPartitions(true);

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixAddPartitions187.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:957:7: alterStatementSuffixTouch
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixTouch_in_alterTableStatementSuffix3698);
                    alterStatementSuffixTouch188=alterStatementSuffixTouch();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixTouch188.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:958:7: alterStatementSuffixArchive
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixArchive_in_alterTableStatementSuffix3706);
                    alterStatementSuffixArchive189=alterStatementSuffixArchive();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixArchive189.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:959:7: alterStatementSuffixUnArchive
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixUnArchive_in_alterTableStatementSuffix3714);
                    alterStatementSuffixUnArchive190=alterStatementSuffixUnArchive();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixUnArchive190.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:960:7: alterStatementSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixProperties_in_alterTableStatementSuffix3722);
                    alterStatementSuffixProperties191=alterStatementSuffixProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixProperties191.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:961:7: alterStatementSuffixSkewedby
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixSkewedby_in_alterTableStatementSuffix3730);
                    alterStatementSuffixSkewedby192=alterStatementSuffixSkewedby();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixSkewedby192.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:962:7: alterStatementSuffixExchangePartition
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixExchangePartition_in_alterTableStatementSuffix3738);
                    alterStatementSuffixExchangePartition193=alterStatementSuffixExchangePartition();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixExchangePartition193.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:963:7: alterStatementPartitionKeyType
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementPartitionKeyType_in_alterTableStatementSuffix3746);
                    alterStatementPartitionKeyType194=alterStatementPartitionKeyType();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementPartitionKeyType194.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:964:7: ( partitionSpec )? alterTblPartitionStatementSuffix
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:964:7: ( partitionSpec )?
                    int alt55=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt55=1;
                            }
                            break;
                    }

                    switch (alt55) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:964:7: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_alterTableStatementSuffix3754);
                            partitionSpec195=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec195.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_alterTblPartitionStatementSuffix_in_alterTableStatementSuffix3757);
                    alterTblPartitionStatementSuffix196=alterTblPartitionStatementSuffix();

                    state._fsp--;

                    stream_alterTblPartitionStatementSuffix.add(alterTblPartitionStatementSuffix196.getTree());

                    // AST REWRITE
                    // elements: alterTblPartitionStatementSuffix, partitionSpec
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 964:55: -> alterTblPartitionStatementSuffix ( partitionSpec )?
                    {
                        adaptor.addChild(root_0, stream_alterTblPartitionStatementSuffix.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:964:91: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_0, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTableStatementSuffix"


    public static class alterTblPartitionStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:967:1: alterTblPartitionStatementSuffix : ( alterStatementSuffixFileFormat | alterStatementSuffixLocation | alterStatementSuffixProtectMode | alterStatementSuffixMergeFiles | alterStatementSuffixSerdeProperties | alterStatementSuffixRenamePart | alterStatementSuffixBucketNum | alterTblPartitionStatementSuffixSkewedLocation | alterStatementSuffixClusterbySortby | alterStatementSuffixCompact | alterStatementSuffixUpdateStatsCol | alterStatementSuffixRenameCol | alterStatementSuffixAddCol );
    public final HiveParser.alterTblPartitionStatementSuffix_return alterTblPartitionStatementSuffix() throws RecognitionException {
        HiveParser.alterTblPartitionStatementSuffix_return retval = new HiveParser.alterTblPartitionStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterStatementSuffixFileFormat_return alterStatementSuffixFileFormat197 =null;

        HiveParser.alterStatementSuffixLocation_return alterStatementSuffixLocation198 =null;

        HiveParser.alterStatementSuffixProtectMode_return alterStatementSuffixProtectMode199 =null;

        HiveParser.alterStatementSuffixMergeFiles_return alterStatementSuffixMergeFiles200 =null;

        HiveParser.alterStatementSuffixSerdeProperties_return alterStatementSuffixSerdeProperties201 =null;

        HiveParser.alterStatementSuffixRenamePart_return alterStatementSuffixRenamePart202 =null;

        HiveParser.alterStatementSuffixBucketNum_return alterStatementSuffixBucketNum203 =null;

        HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return alterTblPartitionStatementSuffixSkewedLocation204 =null;

        HiveParser.alterStatementSuffixClusterbySortby_return alterStatementSuffixClusterbySortby205 =null;

        HiveParser.alterStatementSuffixCompact_return alterStatementSuffixCompact206 =null;

        HiveParser.alterStatementSuffixUpdateStatsCol_return alterStatementSuffixUpdateStatsCol207 =null;

        HiveParser.alterStatementSuffixRenameCol_return alterStatementSuffixRenameCol208 =null;

        HiveParser.alterStatementSuffixAddCol_return alterStatementSuffixAddCol209 =null;



        pushMsg("alter table partition statement suffix", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:970:3: ( alterStatementSuffixFileFormat | alterStatementSuffixLocation | alterStatementSuffixProtectMode | alterStatementSuffixMergeFiles | alterStatementSuffixSerdeProperties | alterStatementSuffixRenamePart | alterStatementSuffixBucketNum | alterTblPartitionStatementSuffixSkewedLocation | alterStatementSuffixClusterbySortby | alterStatementSuffixCompact | alterStatementSuffixUpdateStatsCol | alterStatementSuffixRenameCol | alterStatementSuffixAddCol )
            int alt57=13;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_FILEFORMAT:
                    {
                    alt57=1;
                    }
                    break;
                case KW_LOCATION:
                    {
                    alt57=2;
                    }
                    break;
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                    {
                    alt57=5;
                    }
                    break;
                case KW_SKEWED:
                    {
                    alt57=8;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 57, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_DISABLE:
            case KW_ENABLE:
                {
                alt57=3;
                }
                break;
            case KW_CONCATENATE:
                {
                alt57=4;
                }
                break;
            case KW_RENAME:
                {
                alt57=6;
                }
                break;
            case KW_INTO:
                {
                alt57=7;
                }
                break;
            case KW_CLUSTERED:
            case KW_NOT:
                {
                alt57=9;
                }
                break;
            case KW_COMPACT:
                {
                alt57=10;
                }
                break;
            case KW_UPDATE:
                {
                alt57=11;
                }
                break;
            case KW_CHANGE:
                {
                alt57=12;
                }
                break;
            case KW_ADD:
            case KW_REPLACE:
                {
                alt57=13;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 57, 0, input);

                throw nvae;

            }

            switch (alt57) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:970:5: alterStatementSuffixFileFormat
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixFileFormat_in_alterTblPartitionStatementSuffix3789);
                    alterStatementSuffixFileFormat197=alterStatementSuffixFileFormat();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixFileFormat197.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:971:5: alterStatementSuffixLocation
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixLocation_in_alterTblPartitionStatementSuffix3795);
                    alterStatementSuffixLocation198=alterStatementSuffixLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixLocation198.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:972:5: alterStatementSuffixProtectMode
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixProtectMode_in_alterTblPartitionStatementSuffix3801);
                    alterStatementSuffixProtectMode199=alterStatementSuffixProtectMode();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixProtectMode199.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:973:5: alterStatementSuffixMergeFiles
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixMergeFiles_in_alterTblPartitionStatementSuffix3807);
                    alterStatementSuffixMergeFiles200=alterStatementSuffixMergeFiles();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixMergeFiles200.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:974:5: alterStatementSuffixSerdeProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixSerdeProperties_in_alterTblPartitionStatementSuffix3813);
                    alterStatementSuffixSerdeProperties201=alterStatementSuffixSerdeProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixSerdeProperties201.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:975:5: alterStatementSuffixRenamePart
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRenamePart_in_alterTblPartitionStatementSuffix3819);
                    alterStatementSuffixRenamePart202=alterStatementSuffixRenamePart();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRenamePart202.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:976:5: alterStatementSuffixBucketNum
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixBucketNum_in_alterTblPartitionStatementSuffix3825);
                    alterStatementSuffixBucketNum203=alterStatementSuffixBucketNum();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixBucketNum203.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:977:5: alterTblPartitionStatementSuffixSkewedLocation
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterTblPartitionStatementSuffixSkewedLocation_in_alterTblPartitionStatementSuffix3831);
                    alterTblPartitionStatementSuffixSkewedLocation204=alterTblPartitionStatementSuffixSkewedLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, alterTblPartitionStatementSuffixSkewedLocation204.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:978:5: alterStatementSuffixClusterbySortby
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixClusterbySortby_in_alterTblPartitionStatementSuffix3837);
                    alterStatementSuffixClusterbySortby205=alterStatementSuffixClusterbySortby();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixClusterbySortby205.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:979:5: alterStatementSuffixCompact
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixCompact_in_alterTblPartitionStatementSuffix3843);
                    alterStatementSuffixCompact206=alterStatementSuffixCompact();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixCompact206.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:980:5: alterStatementSuffixUpdateStatsCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixUpdateStatsCol_in_alterTblPartitionStatementSuffix3849);
                    alterStatementSuffixUpdateStatsCol207=alterStatementSuffixUpdateStatsCol();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixUpdateStatsCol207.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:981:5: alterStatementSuffixRenameCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRenameCol_in_alterTblPartitionStatementSuffix3855);
                    alterStatementSuffixRenameCol208=alterStatementSuffixRenameCol();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRenameCol208.getTree());

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:982:5: alterStatementSuffixAddCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddCol_in_alterTblPartitionStatementSuffix3861);
                    alterStatementSuffixAddCol209=alterStatementSuffixAddCol();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixAddCol209.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatementSuffix"


    public static class alterStatementPartitionKeyType_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementPartitionKeyType"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:985:1: alterStatementPartitionKeyType : KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN -> ^( TOK_ALTERTABLE_PARTCOLTYPE columnNameType ) ;
    public final HiveParser.alterStatementPartitionKeyType_return alterStatementPartitionKeyType() throws RecognitionException {
        HiveParser.alterStatementPartitionKeyType_return retval = new HiveParser.alterStatementPartitionKeyType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_PARTITION210=null;
        Token KW_COLUMN211=null;
        Token LPAREN212=null;
        Token RPAREN214=null;
        HiveParser.columnNameType_return columnNameType213 =null;


        CommonTree KW_PARTITION210_tree=null;
        CommonTree KW_COLUMN211_tree=null;
        CommonTree LPAREN212_tree=null;
        CommonTree RPAREN214_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_PARTITION=new RewriteRuleTokenStream(adaptor,"token KW_PARTITION");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_columnNameType=new RewriteRuleSubtreeStream(adaptor,"rule columnNameType");
        msgs.push("alter partition key type"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:988:2: ( KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN -> ^( TOK_ALTERTABLE_PARTCOLTYPE columnNameType ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:988:4: KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN
            {
            KW_PARTITION210=(Token)match(input,KW_PARTITION,FOLLOW_KW_PARTITION_in_alterStatementPartitionKeyType3883);  
            stream_KW_PARTITION.add(KW_PARTITION210);


            KW_COLUMN211=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementPartitionKeyType3885);  
            stream_KW_COLUMN.add(KW_COLUMN211);


            LPAREN212=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_alterStatementPartitionKeyType3887);  
            stream_LPAREN.add(LPAREN212);


            pushFollow(FOLLOW_columnNameType_in_alterStatementPartitionKeyType3889);
            columnNameType213=columnNameType();

            state._fsp--;

            stream_columnNameType.add(columnNameType213.getTree());

            RPAREN214=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_alterStatementPartitionKeyType3891);  
            stream_RPAREN.add(RPAREN214);


            // AST REWRITE
            // elements: columnNameType
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 989:2: -> ^( TOK_ALTERTABLE_PARTCOLTYPE columnNameType )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:989:5: ^( TOK_ALTERTABLE_PARTCOLTYPE columnNameType )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_PARTCOLTYPE, "TOK_ALTERTABLE_PARTCOLTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_columnNameType.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementPartitionKeyType"


    public static class alterViewStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterViewStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:992:1: alterViewStatementSuffix : ( alterViewSuffixProperties | alterStatementSuffixRename[false] | alterStatementSuffixAddPartitions[false] | alterStatementSuffixDropPartitions[false] | selectStatementWithCTE );
    public final HiveParser.alterViewStatementSuffix_return alterViewStatementSuffix() throws RecognitionException {
        HiveParser.alterViewStatementSuffix_return retval = new HiveParser.alterViewStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterViewSuffixProperties_return alterViewSuffixProperties215 =null;

        HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename216 =null;

        HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions217 =null;

        HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions218 =null;

        HiveParser.selectStatementWithCTE_return selectStatementWithCTE219 =null;



         pushMsg("alter view statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:995:5: ( alterViewSuffixProperties | alterStatementSuffixRename[false] | alterStatementSuffixAddPartitions[false] | alterStatementSuffixDropPartitions[false] | selectStatementWithCTE )
            int alt58=5;
            switch ( input.LA(1) ) {
            case KW_SET:
            case KW_UNSET:
                {
                alt58=1;
                }
                break;
            case KW_RENAME:
                {
                alt58=2;
                }
                break;
            case KW_ADD:
                {
                alt58=3;
                }
                break;
            case KW_DROP:
                {
                alt58=4;
                }
                break;
            case KW_MAP:
            case KW_REDUCE:
            case KW_SELECT:
            case KW_WITH:
                {
                alt58=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 58, 0, input);

                throw nvae;

            }

            switch (alt58) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:995:7: alterViewSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterViewSuffixProperties_in_alterViewStatementSuffix3924);
                    alterViewSuffixProperties215=alterViewSuffixProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterViewSuffixProperties215.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:996:7: alterStatementSuffixRename[false]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRename_in_alterViewStatementSuffix3932);
                    alterStatementSuffixRename216=alterStatementSuffixRename(false);

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRename216.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:997:7: alterStatementSuffixAddPartitions[false]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddPartitions_in_alterViewStatementSuffix3941);
                    alterStatementSuffixAddPartitions217=alterStatementSuffixAddPartitions(false);

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixAddPartitions217.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:998:7: alterStatementSuffixDropPartitions[false]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixDropPartitions_in_alterViewStatementSuffix3950);
                    alterStatementSuffixDropPartitions218=alterStatementSuffixDropPartitions(false);

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixDropPartitions218.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:999:7: selectStatementWithCTE
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_selectStatementWithCTE_in_alterViewStatementSuffix3959);
                    selectStatementWithCTE219=selectStatementWithCTE();

                    state._fsp--;

                    adaptor.addChild(root_0, selectStatementWithCTE219.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterViewStatementSuffix"


    public static class alterIndexStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterIndexStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1002:1: alterIndexStatementSuffix : indexName= identifier KW_ON tableName ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties ) ) ;
    public final HiveParser.alterIndexStatementSuffix_return alterIndexStatementSuffix() throws RecognitionException {
        HiveParser.alterIndexStatementSuffix_return retval = new HiveParser.alterIndexStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ON220=null;
        Token KW_REBUILD223=null;
        Token KW_SET224=null;
        Token KW_IDXPROPERTIES225=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tableName221 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec222 =null;

        HiveParser.indexProperties_return indexProperties226 =null;


        CommonTree KW_ON220_tree=null;
        CommonTree KW_REBUILD223_tree=null;
        CommonTree KW_SET224_tree=null;
        CommonTree KW_IDXPROPERTIES225_tree=null;
        RewriteRuleTokenStream stream_KW_REBUILD=new RewriteRuleTokenStream(adaptor,"token KW_REBUILD");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_IDXPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_IDXPROPERTIES");
        RewriteRuleSubtreeStream stream_indexProperties=new RewriteRuleSubtreeStream(adaptor,"rule indexProperties");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter index statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1005:5: (indexName= identifier KW_ON tableName ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties ) ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1005:7: indexName= identifier KW_ON tableName ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties ) )
            {
            pushFollow(FOLLOW_identifier_in_alterIndexStatementSuffix3988);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            KW_ON220=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_alterIndexStatementSuffix3990);  
            stream_KW_ON.add(KW_ON220);


            pushFollow(FOLLOW_tableName_in_alterIndexStatementSuffix3992);
            tableName221=tableName();

            state._fsp--;

            stream_tableName.add(tableName221.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1005:44: ( partitionSpec )?
            int alt59=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt59=1;
                    }
                    break;
            }

            switch (alt59) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1005:44: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_alterIndexStatementSuffix3994);
                    partitionSpec222=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec222.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1006:5: ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties ) )
            int alt60=2;
            switch ( input.LA(1) ) {
            case KW_REBUILD:
                {
                alt60=1;
                }
                break;
            case KW_SET:
                {
                alt60=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 60, 0, input);

                throw nvae;

            }

            switch (alt60) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1007:7: KW_REBUILD
                    {
                    KW_REBUILD223=(Token)match(input,KW_REBUILD,FOLLOW_KW_REBUILD_in_alterIndexStatementSuffix4009);  
                    stream_KW_REBUILD.add(KW_REBUILD223);


                    // AST REWRITE
                    // elements: tableName, partitionSpec, indexName
                    // token labels: 
                    // rule labels: retval, indexName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1008:7: -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:9: ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERINDEX_REBUILD, "TOK_ALTERINDEX_REBUILD")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        adaptor.addChild(root_1, stream_indexName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:55: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1010:7: KW_SET KW_IDXPROPERTIES indexProperties
                    {
                    KW_SET224=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterIndexStatementSuffix4042);  
                    stream_KW_SET.add(KW_SET224);


                    KW_IDXPROPERTIES225=(Token)match(input,KW_IDXPROPERTIES,FOLLOW_KW_IDXPROPERTIES_in_alterIndexStatementSuffix4044);  
                    stream_KW_IDXPROPERTIES.add(KW_IDXPROPERTIES225);


                    pushFollow(FOLLOW_indexProperties_in_alterIndexStatementSuffix4052);
                    indexProperties226=indexProperties();

                    state._fsp--;

                    stream_indexProperties.add(indexProperties226.getTree());

                    // AST REWRITE
                    // elements: indexProperties, indexName, tableName
                    // token labels: 
                    // rule labels: retval, indexName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1012:7: -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1012:9: ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERINDEX_PROPERTIES, "TOK_ALTERINDEX_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        adaptor.addChild(root_1, stream_indexName.nextTree());

                        adaptor.addChild(root_1, stream_indexProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterIndexStatementSuffix"


    public static class alterDatabaseStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1016:1: alterDatabaseStatementSuffix : ( alterDatabaseSuffixProperties | alterDatabaseSuffixSetOwner );
    public final HiveParser.alterDatabaseStatementSuffix_return alterDatabaseStatementSuffix() throws RecognitionException {
        HiveParser.alterDatabaseStatementSuffix_return retval = new HiveParser.alterDatabaseStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterDatabaseSuffixProperties_return alterDatabaseSuffixProperties227 =null;

        HiveParser.alterDatabaseSuffixSetOwner_return alterDatabaseSuffixSetOwner228 =null;



         pushMsg("alter database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1019:5: ( alterDatabaseSuffixProperties | alterDatabaseSuffixSetOwner )
            int alt61=2;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    switch ( input.LA(3) ) {
                    case KW_DBPROPERTIES:
                        {
                        alt61=1;
                        }
                        break;
                    case KW_OWNER:
                        {
                        alt61=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 61, 3, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 61, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_AUTHORIZATION:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_REWRITE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUES:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    switch ( input.LA(3) ) {
                    case KW_DBPROPERTIES:
                        {
                        alt61=1;
                        }
                        break;
                    case KW_OWNER:
                        {
                        alt61=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 61, 4, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 61, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 61, 0, input);

                throw nvae;

            }

            switch (alt61) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1019:7: alterDatabaseSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterDatabaseSuffixProperties_in_alterDatabaseStatementSuffix4103);
                    alterDatabaseSuffixProperties227=alterDatabaseSuffixProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterDatabaseSuffixProperties227.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:7: alterDatabaseSuffixSetOwner
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterDatabaseSuffixSetOwner_in_alterDatabaseStatementSuffix4111);
                    alterDatabaseSuffixSetOwner228=alterDatabaseSuffixSetOwner();

                    state._fsp--;

                    adaptor.addChild(root_0, alterDatabaseSuffixSetOwner228.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseStatementSuffix"


    public static class alterDatabaseSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1023:1: alterDatabaseSuffixProperties : name= identifier KW_SET KW_DBPROPERTIES dbProperties -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties ) ;
    public final HiveParser.alterDatabaseSuffixProperties_return alterDatabaseSuffixProperties() throws RecognitionException {
        HiveParser.alterDatabaseSuffixProperties_return retval = new HiveParser.alterDatabaseSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET229=null;
        Token KW_DBPROPERTIES230=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.dbProperties_return dbProperties231 =null;


        CommonTree KW_SET229_tree=null;
        CommonTree KW_DBPROPERTIES230_tree=null;
        RewriteRuleTokenStream stream_KW_DBPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_DBPROPERTIES");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_dbProperties=new RewriteRuleSubtreeStream(adaptor,"rule dbProperties");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter database properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1026:5: (name= identifier KW_SET KW_DBPROPERTIES dbProperties -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1026:7: name= identifier KW_SET KW_DBPROPERTIES dbProperties
            {
            pushFollow(FOLLOW_identifier_in_alterDatabaseSuffixProperties4140);
            name=identifier();

            state._fsp--;

            stream_identifier.add(name.getTree());

            KW_SET229=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterDatabaseSuffixProperties4142);  
            stream_KW_SET.add(KW_SET229);


            KW_DBPROPERTIES230=(Token)match(input,KW_DBPROPERTIES,FOLLOW_KW_DBPROPERTIES_in_alterDatabaseSuffixProperties4144);  
            stream_KW_DBPROPERTIES.add(KW_DBPROPERTIES230);


            pushFollow(FOLLOW_dbProperties_in_alterDatabaseSuffixProperties4146);
            dbProperties231=dbProperties();

            state._fsp--;

            stream_dbProperties.add(dbProperties231.getTree());

            // AST REWRITE
            // elements: name, dbProperties
            // token labels: 
            // rule labels: retval, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1027:5: -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1027:8: ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERDATABASE_PROPERTIES, "TOK_ALTERDATABASE_PROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                adaptor.addChild(root_1, stream_dbProperties.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseSuffixProperties"


    public static class alterDatabaseSuffixSetOwner_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseSuffixSetOwner"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1030:1: alterDatabaseSuffixSetOwner : dbName= identifier KW_SET KW_OWNER principalName -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName ) ;
    public final HiveParser.alterDatabaseSuffixSetOwner_return alterDatabaseSuffixSetOwner() throws RecognitionException {
        HiveParser.alterDatabaseSuffixSetOwner_return retval = new HiveParser.alterDatabaseSuffixSetOwner_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET232=null;
        Token KW_OWNER233=null;
        HiveParser_IdentifiersParser.identifier_return dbName =null;

        HiveParser.principalName_return principalName234 =null;


        CommonTree KW_SET232_tree=null;
        CommonTree KW_OWNER233_tree=null;
        RewriteRuleTokenStream stream_KW_OWNER=new RewriteRuleTokenStream(adaptor,"token KW_OWNER");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter database set owner", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:5: (dbName= identifier KW_SET KW_OWNER principalName -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:7: dbName= identifier KW_SET KW_OWNER principalName
            {
            pushFollow(FOLLOW_identifier_in_alterDatabaseSuffixSetOwner4190);
            dbName=identifier();

            state._fsp--;

            stream_identifier.add(dbName.getTree());

            KW_SET232=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterDatabaseSuffixSetOwner4192);  
            stream_KW_SET.add(KW_SET232);


            KW_OWNER233=(Token)match(input,KW_OWNER,FOLLOW_KW_OWNER_in_alterDatabaseSuffixSetOwner4194);  
            stream_KW_OWNER.add(KW_OWNER233);


            pushFollow(FOLLOW_principalName_in_alterDatabaseSuffixSetOwner4196);
            principalName234=principalName();

            state._fsp--;

            stream_principalName.add(principalName234.getTree());

            // AST REWRITE
            // elements: dbName, principalName
            // token labels: 
            // rule labels: retval, dbName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_dbName=new RewriteRuleSubtreeStream(adaptor,"rule dbName",dbName!=null?dbName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1034:5: -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1034:8: ^( TOK_ALTERDATABASE_OWNER $dbName principalName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERDATABASE_OWNER, "TOK_ALTERDATABASE_OWNER")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextTree());

                adaptor.addChild(root_1, stream_principalName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseSuffixSetOwner"


    public static class alterStatementSuffixRename_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRename"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1037:1: alterStatementSuffixRename[boolean table] : KW_RENAME KW_TO tableName -> { table }? ^( TOK_ALTERTABLE_RENAME tableName ) -> ^( TOK_ALTERVIEW_RENAME tableName ) ;
    public final HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename(boolean table) throws RecognitionException {
        HiveParser.alterStatementSuffixRename_return retval = new HiveParser.alterStatementSuffixRename_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RENAME235=null;
        Token KW_TO236=null;
        HiveParser_FromClauseParser.tableName_return tableName237 =null;


        CommonTree KW_RENAME235_tree=null;
        CommonTree KW_TO236_tree=null;
        RewriteRuleTokenStream stream_KW_RENAME=new RewriteRuleTokenStream(adaptor,"token KW_RENAME");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("rename statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1040:5: ( KW_RENAME KW_TO tableName -> { table }? ^( TOK_ALTERTABLE_RENAME tableName ) -> ^( TOK_ALTERVIEW_RENAME tableName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1040:7: KW_RENAME KW_TO tableName
            {
            KW_RENAME235=(Token)match(input,KW_RENAME,FOLLOW_KW_RENAME_in_alterStatementSuffixRename4239);  
            stream_KW_RENAME.add(KW_RENAME235);


            KW_TO236=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_alterStatementSuffixRename4241);  
            stream_KW_TO.add(KW_TO236);


            pushFollow(FOLLOW_tableName_in_alterStatementSuffixRename4243);
            tableName237=tableName();

            state._fsp--;

            stream_tableName.add(tableName237.getTree());

            // AST REWRITE
            // elements: tableName, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1041:5: -> { table }? ^( TOK_ALTERTABLE_RENAME tableName )
            if ( table ) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1041:19: ^( TOK_ALTERTABLE_RENAME tableName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAME, "TOK_ALTERTABLE_RENAME")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1042:5: -> ^( TOK_ALTERVIEW_RENAME tableName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1042:19: ^( TOK_ALTERVIEW_RENAME tableName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERVIEW_RENAME, "TOK_ALTERVIEW_RENAME")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRename"


    public static class alterStatementSuffixAddCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1045:1: alterStatementSuffixAddCol : (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN ( restrictOrCascade )? -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS columnNameTypeList ( restrictOrCascade )? ) -> ^( TOK_ALTERTABLE_REPLACECOLS columnNameTypeList ( restrictOrCascade )? ) ;
    public final HiveParser.alterStatementSuffixAddCol_return alterStatementSuffixAddCol() throws RecognitionException {
        HiveParser.alterStatementSuffixAddCol_return retval = new HiveParser.alterStatementSuffixAddCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token add=null;
        Token replace=null;
        Token KW_COLUMNS238=null;
        Token LPAREN239=null;
        Token RPAREN241=null;
        HiveParser.columnNameTypeList_return columnNameTypeList240 =null;

        HiveParser.restrictOrCascade_return restrictOrCascade242 =null;


        CommonTree add_tree=null;
        CommonTree replace_tree=null;
        CommonTree KW_COLUMNS238_tree=null;
        CommonTree LPAREN239_tree=null;
        CommonTree RPAREN241_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_REPLACE=new RewriteRuleTokenStream(adaptor,"token KW_REPLACE");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_ADD=new RewriteRuleTokenStream(adaptor,"token KW_ADD");
        RewriteRuleSubtreeStream stream_restrictOrCascade=new RewriteRuleSubtreeStream(adaptor,"rule restrictOrCascade");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
         pushMsg("add column statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:5: ( (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN ( restrictOrCascade )? -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS columnNameTypeList ( restrictOrCascade )? ) -> ^( TOK_ALTERTABLE_REPLACECOLS columnNameTypeList ( restrictOrCascade )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:7: (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN ( restrictOrCascade )?
            {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:7: (add= KW_ADD |replace= KW_REPLACE )
            int alt62=2;
            switch ( input.LA(1) ) {
            case KW_ADD:
                {
                alt62=1;
                }
                break;
            case KW_REPLACE:
                {
                alt62=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 62, 0, input);

                throw nvae;

            }

            switch (alt62) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:8: add= KW_ADD
                    {
                    add=(Token)match(input,KW_ADD,FOLLOW_KW_ADD_in_alterStatementSuffixAddCol4310);  
                    stream_KW_ADD.add(add);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:21: replace= KW_REPLACE
                    {
                    replace=(Token)match(input,KW_REPLACE,FOLLOW_KW_REPLACE_in_alterStatementSuffixAddCol4316);  
                    stream_KW_REPLACE.add(replace);


                    }
                    break;

            }


            KW_COLUMNS238=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_alterStatementSuffixAddCol4319);  
            stream_KW_COLUMNS.add(KW_COLUMNS238);


            LPAREN239=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_alterStatementSuffixAddCol4321);  
            stream_LPAREN.add(LPAREN239);


            pushFollow(FOLLOW_columnNameTypeList_in_alterStatementSuffixAddCol4323);
            columnNameTypeList240=columnNameTypeList();

            state._fsp--;

            stream_columnNameTypeList.add(columnNameTypeList240.getTree());

            RPAREN241=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_alterStatementSuffixAddCol4325);  
            stream_RPAREN.add(RPAREN241);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:85: ( restrictOrCascade )?
            int alt63=2;
            switch ( input.LA(1) ) {
                case KW_CASCADE:
                case KW_RESTRICT:
                    {
                    alt63=1;
                    }
                    break;
            }

            switch (alt63) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:85: restrictOrCascade
                    {
                    pushFollow(FOLLOW_restrictOrCascade_in_alterStatementSuffixAddCol4327);
                    restrictOrCascade242=restrictOrCascade();

                    state._fsp--;

                    stream_restrictOrCascade.add(restrictOrCascade242.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: restrictOrCascade, columnNameTypeList, columnNameTypeList, restrictOrCascade
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1049:5: -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS columnNameTypeList ( restrictOrCascade )? )
            if (add != null) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1049:24: ^( TOK_ALTERTABLE_ADDCOLS columnNameTypeList ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ADDCOLS, "TOK_ALTERTABLE_ADDCOLS")
                , root_1);

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1049:68: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1050:5: -> ^( TOK_ALTERTABLE_REPLACECOLS columnNameTypeList ( restrictOrCascade )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1050:24: ^( TOK_ALTERTABLE_REPLACECOLS columnNameTypeList ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_REPLACECOLS, "TOK_ALTERTABLE_REPLACECOLS")
                , root_1);

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1050:72: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddCol"


    public static class alterStatementSuffixRenameCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRenameCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1053:1: alterStatementSuffixRenameCol : KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? ( restrictOrCascade )? -> ^( TOK_ALTERTABLE_RENAMECOL $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ( restrictOrCascade )? ) ;
    public final HiveParser.alterStatementSuffixRenameCol_return alterStatementSuffixRenameCol() throws RecognitionException {
        HiveParser.alterStatementSuffixRenameCol_return retval = new HiveParser.alterStatementSuffixRenameCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_CHANGE243=null;
        Token KW_COLUMN244=null;
        Token KW_COMMENT246=null;
        HiveParser_IdentifiersParser.identifier_return oldName =null;

        HiveParser_IdentifiersParser.identifier_return newName =null;

        HiveParser.colType_return colType245 =null;

        HiveParser.alterStatementChangeColPosition_return alterStatementChangeColPosition247 =null;

        HiveParser.restrictOrCascade_return restrictOrCascade248 =null;


        CommonTree comment_tree=null;
        CommonTree KW_CHANGE243_tree=null;
        CommonTree KW_COLUMN244_tree=null;
        CommonTree KW_COMMENT246_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_CHANGE=new RewriteRuleTokenStream(adaptor,"token KW_CHANGE");
        RewriteRuleSubtreeStream stream_restrictOrCascade=new RewriteRuleSubtreeStream(adaptor,"rule restrictOrCascade");
        RewriteRuleSubtreeStream stream_alterStatementChangeColPosition=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementChangeColPosition");
        RewriteRuleSubtreeStream stream_colType=new RewriteRuleSubtreeStream(adaptor,"rule colType");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("rename column name", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:5: ( KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? ( restrictOrCascade )? -> ^( TOK_ALTERTABLE_RENAMECOL $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ( restrictOrCascade )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:7: KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? ( restrictOrCascade )?
            {
            KW_CHANGE243=(Token)match(input,KW_CHANGE,FOLLOW_KW_CHANGE_in_alterStatementSuffixRenameCol4403);  
            stream_KW_CHANGE.add(KW_CHANGE243);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:17: ( KW_COLUMN )?
            int alt64=2;
            switch ( input.LA(1) ) {
                case KW_COLUMN:
                    {
                    alt64=1;
                    }
                    break;
            }

            switch (alt64) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:17: KW_COLUMN
                    {
                    KW_COLUMN244=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementSuffixRenameCol4405);  
                    stream_KW_COLUMN.add(KW_COLUMN244);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4410);
            oldName=identifier();

            state._fsp--;

            stream_identifier.add(oldName.getTree());

            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4414);
            newName=identifier();

            state._fsp--;

            stream_identifier.add(newName.getTree());

            pushFollow(FOLLOW_colType_in_alterStatementSuffixRenameCol4416);
            colType245=colType();

            state._fsp--;

            stream_colType.add(colType245.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:74: ( KW_COMMENT comment= StringLiteral )?
            int alt65=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt65=1;
                    }
                    break;
            }

            switch (alt65) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:75: KW_COMMENT comment= StringLiteral
                    {
                    KW_COMMENT246=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_alterStatementSuffixRenameCol4419);  
                    stream_KW_COMMENT.add(KW_COMMENT246);


                    comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixRenameCol4423);  
                    stream_StringLiteral.add(comment);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:110: ( alterStatementChangeColPosition )?
            int alt66=2;
            switch ( input.LA(1) ) {
                case KW_AFTER:
                case KW_FIRST:
                    {
                    alt66=1;
                    }
                    break;
            }

            switch (alt66) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:110: alterStatementChangeColPosition
                    {
                    pushFollow(FOLLOW_alterStatementChangeColPosition_in_alterStatementSuffixRenameCol4427);
                    alterStatementChangeColPosition247=alterStatementChangeColPosition();

                    state._fsp--;

                    stream_alterStatementChangeColPosition.add(alterStatementChangeColPosition247.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:143: ( restrictOrCascade )?
            int alt67=2;
            switch ( input.LA(1) ) {
                case KW_CASCADE:
                case KW_RESTRICT:
                    {
                    alt67=1;
                    }
                    break;
            }

            switch (alt67) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1056:143: restrictOrCascade
                    {
                    pushFollow(FOLLOW_restrictOrCascade_in_alterStatementSuffixRenameCol4430);
                    restrictOrCascade248=restrictOrCascade();

                    state._fsp--;

                    stream_restrictOrCascade.add(restrictOrCascade248.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: newName, oldName, colType, comment, alterStatementChangeColPosition, restrictOrCascade
            // token labels: comment
            // rule labels: retval, newName, oldName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_newName=new RewriteRuleSubtreeStream(adaptor,"rule newName",newName!=null?newName.tree:null);
            RewriteRuleSubtreeStream stream_oldName=new RewriteRuleSubtreeStream(adaptor,"rule oldName",oldName!=null?oldName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1057:5: -> ^( TOK_ALTERTABLE_RENAMECOL $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ( restrictOrCascade )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1057:7: ^( TOK_ALTERTABLE_RENAMECOL $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAMECOL, "TOK_ALTERTABLE_RENAMECOL")
                , root_1);

                adaptor.addChild(root_1, stream_oldName.nextTree());

                adaptor.addChild(root_1, stream_newName.nextTree());

                adaptor.addChild(root_1, stream_colType.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1057:61: ( $comment)?
                if ( stream_comment.hasNext() ) {
                    adaptor.addChild(root_1, stream_comment.nextNode());

                }
                stream_comment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1057:70: ( alterStatementChangeColPosition )?
                if ( stream_alterStatementChangeColPosition.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementChangeColPosition.nextTree());

                }
                stream_alterStatementChangeColPosition.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1057:103: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRenameCol"


    public static class alterStatementSuffixUpdateStatsCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixUpdateStatsCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1060:1: alterStatementSuffixUpdateStatsCol : KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )? -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? ) ;
    public final HiveParser.alterStatementSuffixUpdateStatsCol_return alterStatementSuffixUpdateStatsCol() throws RecognitionException {
        HiveParser.alterStatementSuffixUpdateStatsCol_return retval = new HiveParser.alterStatementSuffixUpdateStatsCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_UPDATE249=null;
        Token KW_STATISTICS250=null;
        Token KW_FOR251=null;
        Token KW_COLUMN252=null;
        Token KW_SET253=null;
        Token KW_COMMENT255=null;
        HiveParser_IdentifiersParser.identifier_return colName =null;

        HiveParser.tableProperties_return tableProperties254 =null;


        CommonTree comment_tree=null;
        CommonTree KW_UPDATE249_tree=null;
        CommonTree KW_STATISTICS250_tree=null;
        CommonTree KW_FOR251_tree=null;
        CommonTree KW_COLUMN252_tree=null;
        CommonTree KW_SET253_tree=null;
        CommonTree KW_COMMENT255_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");
        RewriteRuleTokenStream stream_KW_UPDATE=new RewriteRuleTokenStream(adaptor,"token KW_UPDATE");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_STATISTICS=new RewriteRuleTokenStream(adaptor,"token KW_STATISTICS");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("update column statistics", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1063:5: ( KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )? -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1063:7: KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )?
            {
            KW_UPDATE249=(Token)match(input,KW_UPDATE,FOLLOW_KW_UPDATE_in_alterStatementSuffixUpdateStatsCol4485);  
            stream_KW_UPDATE.add(KW_UPDATE249);


            KW_STATISTICS250=(Token)match(input,KW_STATISTICS,FOLLOW_KW_STATISTICS_in_alterStatementSuffixUpdateStatsCol4487);  
            stream_KW_STATISTICS.add(KW_STATISTICS250);


            KW_FOR251=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_alterStatementSuffixUpdateStatsCol4489);  
            stream_KW_FOR.add(KW_FOR251);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1063:38: ( KW_COLUMN )?
            int alt68=2;
            switch ( input.LA(1) ) {
                case KW_COLUMN:
                    {
                    alt68=1;
                    }
                    break;
            }

            switch (alt68) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1063:38: KW_COLUMN
                    {
                    KW_COLUMN252=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementSuffixUpdateStatsCol4491);  
                    stream_KW_COLUMN.add(KW_COLUMN252);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixUpdateStatsCol4496);
            colName=identifier();

            state._fsp--;

            stream_identifier.add(colName.getTree());

            KW_SET253=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixUpdateStatsCol4498);  
            stream_KW_SET.add(KW_SET253);


            pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixUpdateStatsCol4500);
            tableProperties254=tableProperties();

            state._fsp--;

            stream_tableProperties.add(tableProperties254.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1063:91: ( KW_COMMENT comment= StringLiteral )?
            int alt69=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt69=1;
                    }
                    break;
            }

            switch (alt69) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1063:92: KW_COMMENT comment= StringLiteral
                    {
                    KW_COMMENT255=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_alterStatementSuffixUpdateStatsCol4503);  
                    stream_KW_COMMENT.add(KW_COMMENT255);


                    comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixUpdateStatsCol4507);  
                    stream_StringLiteral.add(comment);


                    }
                    break;

            }


            // AST REWRITE
            // elements: tableProperties, comment, colName
            // token labels: comment
            // rule labels: retval, colName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_colName=new RewriteRuleSubtreeStream(adaptor,"rule colName",colName!=null?colName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1064:5: -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1064:7: ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_UPDATECOLSTATS, "TOK_ALTERTABLE_UPDATECOLSTATS")
                , root_1);

                adaptor.addChild(root_1, stream_colName.nextTree());

                adaptor.addChild(root_1, stream_tableProperties.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1064:65: ( $comment)?
                if ( stream_comment.hasNext() ) {
                    adaptor.addChild(root_1, stream_comment.nextNode());

                }
                stream_comment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixUpdateStatsCol"


    public static class alterStatementChangeColPosition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementChangeColPosition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1067:1: alterStatementChangeColPosition : (first= KW_FIRST | KW_AFTER afterCol= identifier -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION ) -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol) );
    public final HiveParser.alterStatementChangeColPosition_return alterStatementChangeColPosition() throws RecognitionException {
        HiveParser.alterStatementChangeColPosition_return retval = new HiveParser.alterStatementChangeColPosition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token first=null;
        Token KW_AFTER256=null;
        HiveParser_IdentifiersParser.identifier_return afterCol =null;


        CommonTree first_tree=null;
        CommonTree KW_AFTER256_tree=null;
        RewriteRuleTokenStream stream_KW_AFTER=new RewriteRuleTokenStream(adaptor,"token KW_AFTER");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1068:5: (first= KW_FIRST | KW_AFTER afterCol= identifier -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION ) -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol) )
            int alt70=2;
            switch ( input.LA(1) ) {
            case KW_FIRST:
                {
                alt70=1;
                }
                break;
            case KW_AFTER:
                {
                alt70=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;

            }

            switch (alt70) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1068:7: first= KW_FIRST
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    first=(Token)match(input,KW_FIRST,FOLLOW_KW_FIRST_in_alterStatementChangeColPosition4546); 
                    first_tree = 
                    (CommonTree)adaptor.create(first)
                    ;
                    adaptor.addChild(root_0, first_tree);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1068:22: KW_AFTER afterCol= identifier
                    {
                    KW_AFTER256=(Token)match(input,KW_AFTER,FOLLOW_KW_AFTER_in_alterStatementChangeColPosition4548);  
                    stream_KW_AFTER.add(KW_AFTER256);


                    pushFollow(FOLLOW_identifier_in_alterStatementChangeColPosition4552);
                    afterCol=identifier();

                    state._fsp--;

                    stream_identifier.add(afterCol.getTree());

                    // AST REWRITE
                    // elements: afterCol
                    // token labels: 
                    // rule labels: retval, afterCol
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_afterCol=new RewriteRuleSubtreeStream(adaptor,"rule afterCol",afterCol!=null?afterCol.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1069:5: -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION )
                    if (first != null) {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1069:25: ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION, "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 1070:5: -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1070:8: ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION, "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION")
                        , root_1);

                        adaptor.addChild(root_1, stream_afterCol.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementChangeColPosition"


    public static class alterStatementSuffixAddPartitions_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddPartitions"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1073:1: alterStatementSuffixAddPartitions[boolean table] : KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ -> { table }? ^( TOK_ALTERTABLE_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) -> ^( TOK_ALTERVIEW_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) ;
    public final HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions(boolean table) throws RecognitionException {
        HiveParser.alterStatementSuffixAddPartitions_return retval = new HiveParser.alterStatementSuffixAddPartitions_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ADD257=null;
        HiveParser.ifNotExists_return ifNotExists258 =null;

        HiveParser.alterStatementSuffixAddPartitionsElement_return alterStatementSuffixAddPartitionsElement259 =null;


        CommonTree KW_ADD257_tree=null;
        RewriteRuleTokenStream stream_KW_ADD=new RewriteRuleTokenStream(adaptor,"token KW_ADD");
        RewriteRuleSubtreeStream stream_alterStatementSuffixAddPartitionsElement=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixAddPartitionsElement");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
         pushMsg("add partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:5: ( KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ -> { table }? ^( TOK_ALTERTABLE_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) -> ^( TOK_ALTERVIEW_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:7: KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+
            {
            KW_ADD257=(Token)match(input,KW_ADD,FOLLOW_KW_ADD_in_alterStatementSuffixAddPartitions4605);  
            stream_KW_ADD.add(KW_ADD257);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:14: ( ifNotExists )?
            int alt71=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt71=1;
                    }
                    break;
            }

            switch (alt71) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:14: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_alterStatementSuffixAddPartitions4607);
                    ifNotExists258=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists258.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:27: ( alterStatementSuffixAddPartitionsElement )+
            int cnt72=0;
            loop72:
            do {
                int alt72=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt72=1;
                    }
                    break;

                }

                switch (alt72) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:27: alterStatementSuffixAddPartitionsElement
            	    {
            	    pushFollow(FOLLOW_alterStatementSuffixAddPartitionsElement_in_alterStatementSuffixAddPartitions4610);
            	    alterStatementSuffixAddPartitionsElement259=alterStatementSuffixAddPartitionsElement();

            	    state._fsp--;

            	    stream_alterStatementSuffixAddPartitionsElement.add(alterStatementSuffixAddPartitionsElement259.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt72 >= 1 ) break loop72;
                        EarlyExitException eee =
                            new EarlyExitException(72, input);
                        throw eee;
                }
                cnt72++;
            } while (true);


            // AST REWRITE
            // elements: alterStatementSuffixAddPartitionsElement, ifNotExists, ifNotExists, alterStatementSuffixAddPartitionsElement
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1077:5: -> { table }? ^( TOK_ALTERTABLE_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
            if ( table ) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1077:19: ^( TOK_ALTERTABLE_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ADDPARTS, "TOK_ALTERTABLE_ADDPARTS")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1077:45: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                if ( !(stream_alterStatementSuffixAddPartitionsElement.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_alterStatementSuffixAddPartitionsElement.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementSuffixAddPartitionsElement.nextTree());

                }
                stream_alterStatementSuffixAddPartitionsElement.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1078:5: -> ^( TOK_ALTERVIEW_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1078:19: ^( TOK_ALTERVIEW_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERVIEW_ADDPARTS, "TOK_ALTERVIEW_ADDPARTS")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1078:44: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                if ( !(stream_alterStatementSuffixAddPartitionsElement.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_alterStatementSuffixAddPartitionsElement.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementSuffixAddPartitionsElement.nextTree());

                }
                stream_alterStatementSuffixAddPartitionsElement.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddPartitions"


    public static class alterStatementSuffixAddPartitionsElement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddPartitionsElement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1081:1: alterStatementSuffixAddPartitionsElement : partitionSpec ( partitionLocation )? ;
    public final HiveParser.alterStatementSuffixAddPartitionsElement_return alterStatementSuffixAddPartitionsElement() throws RecognitionException {
        HiveParser.alterStatementSuffixAddPartitionsElement_return retval = new HiveParser.alterStatementSuffixAddPartitionsElement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec260 =null;

        HiveParser.partitionLocation_return partitionLocation261 =null;



        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1082:5: ( partitionSpec ( partitionLocation )? )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1082:7: partitionSpec ( partitionLocation )?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixAddPartitionsElement4673);
            partitionSpec260=partitionSpec();

            state._fsp--;

            adaptor.addChild(root_0, partitionSpec260.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1082:21: ( partitionLocation )?
            int alt73=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt73=1;
                    }
                    break;
            }

            switch (alt73) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1082:21: partitionLocation
                    {
                    pushFollow(FOLLOW_partitionLocation_in_alterStatementSuffixAddPartitionsElement4675);
                    partitionLocation261=partitionLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, partitionLocation261.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddPartitionsElement"


    public static class alterStatementSuffixTouch_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixTouch"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1085:1: alterStatementSuffixTouch : KW_TOUCH ( partitionSpec )* -> ^( TOK_ALTERTABLE_TOUCH ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixTouch_return alterStatementSuffixTouch() throws RecognitionException {
        HiveParser.alterStatementSuffixTouch_return retval = new HiveParser.alterStatementSuffixTouch_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_TOUCH262=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec263 =null;


        CommonTree KW_TOUCH262_tree=null;
        RewriteRuleTokenStream stream_KW_TOUCH=new RewriteRuleTokenStream(adaptor,"token KW_TOUCH");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("touch statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1088:5: ( KW_TOUCH ( partitionSpec )* -> ^( TOK_ALTERTABLE_TOUCH ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1088:7: KW_TOUCH ( partitionSpec )*
            {
            KW_TOUCH262=(Token)match(input,KW_TOUCH,FOLLOW_KW_TOUCH_in_alterStatementSuffixTouch4703);  
            stream_KW_TOUCH.add(KW_TOUCH262);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1088:16: ( partitionSpec )*
            loop74:
            do {
                int alt74=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt74=1;
                    }
                    break;

                }

                switch (alt74) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1088:17: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixTouch4706);
            	    partitionSpec263=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec263.getTree());

            	    }
            	    break;

            	default :
            	    break loop74;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1089:5: -> ^( TOK_ALTERTABLE_TOUCH ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1089:8: ^( TOK_ALTERTABLE_TOUCH ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_TOUCH, "TOK_ALTERTABLE_TOUCH")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1089:31: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixTouch"


    public static class alterStatementSuffixArchive_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixArchive"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1092:1: alterStatementSuffixArchive : KW_ARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_ARCHIVE ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixArchive_return alterStatementSuffixArchive() throws RecognitionException {
        HiveParser.alterStatementSuffixArchive_return retval = new HiveParser.alterStatementSuffixArchive_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ARCHIVE264=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec265 =null;


        CommonTree KW_ARCHIVE264_tree=null;
        RewriteRuleTokenStream stream_KW_ARCHIVE=new RewriteRuleTokenStream(adaptor,"token KW_ARCHIVE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("archive statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1095:5: ( KW_ARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_ARCHIVE ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1095:7: KW_ARCHIVE ( partitionSpec )*
            {
            KW_ARCHIVE264=(Token)match(input,KW_ARCHIVE,FOLLOW_KW_ARCHIVE_in_alterStatementSuffixArchive4750);  
            stream_KW_ARCHIVE.add(KW_ARCHIVE264);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1095:18: ( partitionSpec )*
            loop75:
            do {
                int alt75=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt75=1;
                    }
                    break;

                }

                switch (alt75) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1095:19: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixArchive4753);
            	    partitionSpec265=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec265.getTree());

            	    }
            	    break;

            	default :
            	    break loop75;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1096:5: -> ^( TOK_ALTERTABLE_ARCHIVE ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1096:8: ^( TOK_ALTERTABLE_ARCHIVE ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ARCHIVE, "TOK_ALTERTABLE_ARCHIVE")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1096:33: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixArchive"


    public static class alterStatementSuffixUnArchive_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixUnArchive"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1099:1: alterStatementSuffixUnArchive : KW_UNARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_UNARCHIVE ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixUnArchive_return alterStatementSuffixUnArchive() throws RecognitionException {
        HiveParser.alterStatementSuffixUnArchive_return retval = new HiveParser.alterStatementSuffixUnArchive_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_UNARCHIVE266=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec267 =null;


        CommonTree KW_UNARCHIVE266_tree=null;
        RewriteRuleTokenStream stream_KW_UNARCHIVE=new RewriteRuleTokenStream(adaptor,"token KW_UNARCHIVE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("unarchive statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:5: ( KW_UNARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_UNARCHIVE ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:7: KW_UNARCHIVE ( partitionSpec )*
            {
            KW_UNARCHIVE266=(Token)match(input,KW_UNARCHIVE,FOLLOW_KW_UNARCHIVE_in_alterStatementSuffixUnArchive4797);  
            stream_KW_UNARCHIVE.add(KW_UNARCHIVE266);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:20: ( partitionSpec )*
            loop76:
            do {
                int alt76=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt76=1;
                    }
                    break;

                }

                switch (alt76) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:21: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixUnArchive4800);
            	    partitionSpec267=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec267.getTree());

            	    }
            	    break;

            	default :
            	    break loop76;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1103:5: -> ^( TOK_ALTERTABLE_UNARCHIVE ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1103:8: ^( TOK_ALTERTABLE_UNARCHIVE ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_UNARCHIVE, "TOK_ALTERTABLE_UNARCHIVE")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1103:35: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixUnArchive"


    public static class partitionLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "partitionLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1106:1: partitionLocation : KW_LOCATION locn= StringLiteral -> ^( TOK_PARTITIONLOCATION $locn) ;
    public final HiveParser.partitionLocation_return partitionLocation() throws RecognitionException {
        HiveParser.partitionLocation_return retval = new HiveParser.partitionLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token locn=null;
        Token KW_LOCATION268=null;

        CommonTree locn_tree=null;
        CommonTree KW_LOCATION268_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

         pushMsg("partition location", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:5: ( KW_LOCATION locn= StringLiteral -> ^( TOK_PARTITIONLOCATION $locn) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1110:7: KW_LOCATION locn= StringLiteral
            {
            KW_LOCATION268=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_partitionLocation4850);  
            stream_KW_LOCATION.add(KW_LOCATION268);


            locn=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_partitionLocation4854);  
            stream_StringLiteral.add(locn);


            // AST REWRITE
            // elements: locn
            // token labels: locn
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_locn=new RewriteRuleTokenStream(adaptor,"token locn",locn);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1110:38: -> ^( TOK_PARTITIONLOCATION $locn)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1110:41: ^( TOK_PARTITIONLOCATION $locn)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PARTITIONLOCATION, "TOK_PARTITIONLOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_locn.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "partitionLocation"


    public static class alterStatementSuffixDropPartitions_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixDropPartitions"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1113:1: alterStatementSuffixDropPartitions[boolean table] : KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? -> { table }? ^( TOK_ALTERTABLE_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ) -> ^( TOK_ALTERVIEW_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ) ;
    public final HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions(boolean table) throws RecognitionException {
        HiveParser.alterStatementSuffixDropPartitions_return retval = new HiveParser.alterStatementSuffixDropPartitions_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP269=null;
        Token COMMA272=null;
        HiveParser.ifExists_return ifExists270 =null;

        HiveParser_IdentifiersParser.dropPartitionSpec_return dropPartitionSpec271 =null;

        HiveParser_IdentifiersParser.dropPartitionSpec_return dropPartitionSpec273 =null;

        HiveParser.ignoreProtection_return ignoreProtection274 =null;


        CommonTree KW_DROP269_tree=null;
        CommonTree COMMA272_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_dropPartitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule dropPartitionSpec");
        RewriteRuleSubtreeStream stream_ignoreProtection=new RewriteRuleSubtreeStream(adaptor,"rule ignoreProtection");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         pushMsg("drop partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:5: ( KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? -> { table }? ^( TOK_ALTERTABLE_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ) -> ^( TOK_ALTERVIEW_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:7: KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )?
            {
            KW_DROP269=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_alterStatementSuffixDropPartitions4891);  
            stream_KW_DROP.add(KW_DROP269);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:15: ( ifExists )?
            int alt77=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt77=1;
                    }
                    break;
            }

            switch (alt77) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:15: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_alterStatementSuffixDropPartitions4893);
                    ifExists270=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists270.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_dropPartitionSpec_in_alterStatementSuffixDropPartitions4896);
            dropPartitionSpec271=dropPartitionSpec();

            state._fsp--;

            stream_dropPartitionSpec.add(dropPartitionSpec271.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:43: ( COMMA dropPartitionSpec )*
            loop78:
            do {
                int alt78=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt78=1;
                    }
                    break;

                }

                switch (alt78) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:44: COMMA dropPartitionSpec
            	    {
            	    COMMA272=(Token)match(input,COMMA,FOLLOW_COMMA_in_alterStatementSuffixDropPartitions4899);  
            	    stream_COMMA.add(COMMA272);


            	    pushFollow(FOLLOW_dropPartitionSpec_in_alterStatementSuffixDropPartitions4901);
            	    dropPartitionSpec273=dropPartitionSpec();

            	    state._fsp--;

            	    stream_dropPartitionSpec.add(dropPartitionSpec273.getTree());

            	    }
            	    break;

            	default :
            	    break loop78;
                }
            } while (true);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:70: ( ignoreProtection )?
            int alt79=2;
            switch ( input.LA(1) ) {
                case KW_IGNORE:
                    {
                    alt79=1;
                    }
                    break;
            }

            switch (alt79) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:70: ignoreProtection
                    {
                    pushFollow(FOLLOW_ignoreProtection_in_alterStatementSuffixDropPartitions4905);
                    ignoreProtection274=ignoreProtection();

                    state._fsp--;

                    stream_ignoreProtection.add(ignoreProtection274.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: ignoreProtection, dropPartitionSpec, ifExists, dropPartitionSpec, ifExists, ignoreProtection
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1117:5: -> { table }? ^( TOK_ALTERTABLE_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? )
            if ( table ) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1117:19: ^( TOK_ALTERTABLE_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_DROPPARTS, "TOK_ALTERTABLE_DROPPARTS")
                , root_1);

                if ( !(stream_dropPartitionSpec.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_dropPartitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_dropPartitionSpec.nextTree());

                }
                stream_dropPartitionSpec.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1117:65: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1117:75: ( ignoreProtection )?
                if ( stream_ignoreProtection.hasNext() ) {
                    adaptor.addChild(root_1, stream_ignoreProtection.nextTree());

                }
                stream_ignoreProtection.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1118:5: -> ^( TOK_ALTERVIEW_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1118:19: ^( TOK_ALTERVIEW_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERVIEW_DROPPARTS, "TOK_ALTERVIEW_DROPPARTS")
                , root_1);

                if ( !(stream_dropPartitionSpec.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_dropPartitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_dropPartitionSpec.nextTree());

                }
                stream_dropPartitionSpec.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1118:64: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1118:74: ( ignoreProtection )?
                if ( stream_ignoreProtection.hasNext() ) {
                    adaptor.addChild(root_1, stream_ignoreProtection.nextTree());

                }
                stream_ignoreProtection.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixDropPartitions"


    public static class alterStatementSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1121:1: alterStatementSuffixProperties : ( KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_PROPERTIES tableProperties ) | KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_ALTERTABLE_DROPPROPERTIES tableProperties ( ifExists )? ) );
    public final HiveParser.alterStatementSuffixProperties_return alterStatementSuffixProperties() throws RecognitionException {
        HiveParser.alterStatementSuffixProperties_return retval = new HiveParser.alterStatementSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET275=null;
        Token KW_TBLPROPERTIES276=null;
        Token KW_UNSET278=null;
        Token KW_TBLPROPERTIES279=null;
        HiveParser.tableProperties_return tableProperties277 =null;

        HiveParser.ifExists_return ifExists280 =null;

        HiveParser.tableProperties_return tableProperties281 =null;


        CommonTree KW_SET275_tree=null;
        CommonTree KW_TBLPROPERTIES276_tree=null;
        CommonTree KW_UNSET278_tree=null;
        CommonTree KW_TBLPROPERTIES279_tree=null;
        RewriteRuleTokenStream stream_KW_UNSET=new RewriteRuleTokenStream(adaptor,"token KW_UNSET");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         pushMsg("alter properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1124:5: ( KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_PROPERTIES tableProperties ) | KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_ALTERTABLE_DROPPROPERTIES tableProperties ( ifExists )? ) )
            int alt81=2;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                alt81=1;
                }
                break;
            case KW_UNSET:
                {
                alt81=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 81, 0, input);

                throw nvae;

            }

            switch (alt81) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1124:7: KW_SET KW_TBLPROPERTIES tableProperties
                    {
                    KW_SET275=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixProperties4984);  
                    stream_KW_SET.add(KW_SET275);


                    KW_TBLPROPERTIES276=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterStatementSuffixProperties4986);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES276);


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixProperties4988);
                    tableProperties277=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties277.getTree());

                    // AST REWRITE
                    // elements: tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1125:5: -> ^( TOK_ALTERTABLE_PROPERTIES tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1125:8: ^( TOK_ALTERTABLE_PROPERTIES tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_PROPERTIES, "TOK_ALTERTABLE_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1126:7: KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties
                    {
                    KW_UNSET278=(Token)match(input,KW_UNSET,FOLLOW_KW_UNSET_in_alterStatementSuffixProperties5008);  
                    stream_KW_UNSET.add(KW_UNSET278);


                    KW_TBLPROPERTIES279=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterStatementSuffixProperties5010);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES279);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1126:33: ( ifExists )?
                    int alt80=2;
                    switch ( input.LA(1) ) {
                        case KW_IF:
                            {
                            alt80=1;
                            }
                            break;
                    }

                    switch (alt80) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1126:33: ifExists
                            {
                            pushFollow(FOLLOW_ifExists_in_alterStatementSuffixProperties5012);
                            ifExists280=ifExists();

                            state._fsp--;

                            stream_ifExists.add(ifExists280.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixProperties5015);
                    tableProperties281=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties281.getTree());

                    // AST REWRITE
                    // elements: tableProperties, ifExists
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1127:5: -> ^( TOK_ALTERTABLE_DROPPROPERTIES tableProperties ( ifExists )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1127:8: ^( TOK_ALTERTABLE_DROPPROPERTIES tableProperties ( ifExists )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_DROPPROPERTIES, "TOK_ALTERTABLE_DROPPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1127:56: ( ifExists )?
                        if ( stream_ifExists.hasNext() ) {
                            adaptor.addChild(root_1, stream_ifExists.nextTree());

                        }
                        stream_ifExists.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixProperties"


    public static class alterViewSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterViewSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1130:1: alterViewSuffixProperties : ( KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERVIEW_PROPERTIES tableProperties ) | KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_ALTERVIEW_DROPPROPERTIES tableProperties ( ifExists )? ) );
    public final HiveParser.alterViewSuffixProperties_return alterViewSuffixProperties() throws RecognitionException {
        HiveParser.alterViewSuffixProperties_return retval = new HiveParser.alterViewSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET282=null;
        Token KW_TBLPROPERTIES283=null;
        Token KW_UNSET285=null;
        Token KW_TBLPROPERTIES286=null;
        HiveParser.tableProperties_return tableProperties284 =null;

        HiveParser.ifExists_return ifExists287 =null;

        HiveParser.tableProperties_return tableProperties288 =null;


        CommonTree KW_SET282_tree=null;
        CommonTree KW_TBLPROPERTIES283_tree=null;
        CommonTree KW_UNSET285_tree=null;
        CommonTree KW_TBLPROPERTIES286_tree=null;
        RewriteRuleTokenStream stream_KW_UNSET=new RewriteRuleTokenStream(adaptor,"token KW_UNSET");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         pushMsg("alter view properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1133:5: ( KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERVIEW_PROPERTIES tableProperties ) | KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_ALTERVIEW_DROPPROPERTIES tableProperties ( ifExists )? ) )
            int alt83=2;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                alt83=1;
                }
                break;
            case KW_UNSET:
                {
                alt83=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 83, 0, input);

                throw nvae;

            }

            switch (alt83) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1133:7: KW_SET KW_TBLPROPERTIES tableProperties
                    {
                    KW_SET282=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterViewSuffixProperties5057);  
                    stream_KW_SET.add(KW_SET282);


                    KW_TBLPROPERTIES283=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterViewSuffixProperties5059);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES283);


                    pushFollow(FOLLOW_tableProperties_in_alterViewSuffixProperties5061);
                    tableProperties284=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties284.getTree());

                    // AST REWRITE
                    // elements: tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1134:5: -> ^( TOK_ALTERVIEW_PROPERTIES tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1134:8: ^( TOK_ALTERVIEW_PROPERTIES tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_PROPERTIES, "TOK_ALTERVIEW_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:7: KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties
                    {
                    KW_UNSET285=(Token)match(input,KW_UNSET,FOLLOW_KW_UNSET_in_alterViewSuffixProperties5081);  
                    stream_KW_UNSET.add(KW_UNSET285);


                    KW_TBLPROPERTIES286=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterViewSuffixProperties5083);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES286);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:33: ( ifExists )?
                    int alt82=2;
                    switch ( input.LA(1) ) {
                        case KW_IF:
                            {
                            alt82=1;
                            }
                            break;
                    }

                    switch (alt82) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:33: ifExists
                            {
                            pushFollow(FOLLOW_ifExists_in_alterViewSuffixProperties5085);
                            ifExists287=ifExists();

                            state._fsp--;

                            stream_ifExists.add(ifExists287.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableProperties_in_alterViewSuffixProperties5088);
                    tableProperties288=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties288.getTree());

                    // AST REWRITE
                    // elements: ifExists, tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1136:5: -> ^( TOK_ALTERVIEW_DROPPROPERTIES tableProperties ( ifExists )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1136:8: ^( TOK_ALTERVIEW_DROPPROPERTIES tableProperties ( ifExists )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_DROPPROPERTIES, "TOK_ALTERVIEW_DROPPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1136:55: ( ifExists )?
                        if ( stream_ifExists.hasNext() ) {
                            adaptor.addChild(root_1, stream_ifExists.nextTree());

                        }
                        stream_ifExists.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterViewSuffixProperties"


    public static class alterStatementSuffixSerdeProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixSerdeProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1139:1: alterStatementSuffixSerdeProperties : ( KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )? -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? ) | KW_SET KW_SERDEPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties ) );
    public final HiveParser.alterStatementSuffixSerdeProperties_return alterStatementSuffixSerdeProperties() throws RecognitionException {
        HiveParser.alterStatementSuffixSerdeProperties_return retval = new HiveParser.alterStatementSuffixSerdeProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token serdeName=null;
        Token KW_SET289=null;
        Token KW_SERDE290=null;
        Token KW_WITH291=null;
        Token KW_SERDEPROPERTIES292=null;
        Token KW_SET294=null;
        Token KW_SERDEPROPERTIES295=null;
        HiveParser.tableProperties_return tableProperties293 =null;

        HiveParser.tableProperties_return tableProperties296 =null;


        CommonTree serdeName_tree=null;
        CommonTree KW_SET289_tree=null;
        CommonTree KW_SERDE290_tree=null;
        CommonTree KW_WITH291_tree=null;
        CommonTree KW_SERDEPROPERTIES292_tree=null;
        CommonTree KW_SET294_tree=null;
        CommonTree KW_SERDEPROPERTIES295_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_SERDE=new RewriteRuleTokenStream(adaptor,"token KW_SERDE");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_SERDEPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_SERDEPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
         pushMsg("alter serdes statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:5: ( KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )? -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? ) | KW_SET KW_SERDEPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties ) )
            int alt85=2;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_SERDE:
                    {
                    alt85=1;
                    }
                    break;
                case KW_SERDEPROPERTIES:
                    {
                    alt85=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 85, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 85, 0, input);

                throw nvae;

            }

            switch (alt85) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:7: KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )?
                    {
                    KW_SET289=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixSerdeProperties5130);  
                    stream_KW_SET.add(KW_SET289);


                    KW_SERDE290=(Token)match(input,KW_SERDE,FOLLOW_KW_SERDE_in_alterStatementSuffixSerdeProperties5132);  
                    stream_KW_SERDE.add(KW_SERDE290);


                    serdeName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixSerdeProperties5136);  
                    stream_StringLiteral.add(serdeName);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:47: ( KW_WITH KW_SERDEPROPERTIES tableProperties )?
                    int alt84=2;
                    switch ( input.LA(1) ) {
                        case KW_WITH:
                            {
                            alt84=1;
                            }
                            break;
                    }

                    switch (alt84) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:48: KW_WITH KW_SERDEPROPERTIES tableProperties
                            {
                            KW_WITH291=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_alterStatementSuffixSerdeProperties5139);  
                            stream_KW_WITH.add(KW_WITH291);


                            KW_SERDEPROPERTIES292=(Token)match(input,KW_SERDEPROPERTIES,FOLLOW_KW_SERDEPROPERTIES_in_alterStatementSuffixSerdeProperties5141);  
                            stream_KW_SERDEPROPERTIES.add(KW_SERDEPROPERTIES292);


                            pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixSerdeProperties5143);
                            tableProperties293=tableProperties();

                            state._fsp--;

                            stream_tableProperties.add(tableProperties293.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: tableProperties, serdeName
                    // token labels: serdeName
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_serdeName=new RewriteRuleTokenStream(adaptor,"token serdeName",serdeName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1143:5: -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1143:8: ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SERIALIZER, "TOK_ALTERTABLE_SERIALIZER")
                        , root_1);

                        adaptor.addChild(root_1, stream_serdeName.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1143:47: ( tableProperties )?
                        if ( stream_tableProperties.hasNext() ) {
                            adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        }
                        stream_tableProperties.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1144:7: KW_SET KW_SERDEPROPERTIES tableProperties
                    {
                    KW_SET294=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixSerdeProperties5169);  
                    stream_KW_SET.add(KW_SET294);


                    KW_SERDEPROPERTIES295=(Token)match(input,KW_SERDEPROPERTIES,FOLLOW_KW_SERDEPROPERTIES_in_alterStatementSuffixSerdeProperties5171);  
                    stream_KW_SERDEPROPERTIES.add(KW_SERDEPROPERTIES295);


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixSerdeProperties5173);
                    tableProperties296=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties296.getTree());

                    // AST REWRITE
                    // elements: tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1145:5: -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1145:8: ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SERDEPROPERTIES, "TOK_ALTERTABLE_SERDEPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixSerdeProperties"


    public static class tablePartitionPrefix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tablePartitionPrefix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1148:1: tablePartitionPrefix : tableName ( partitionSpec )? -> ^( TOK_TABLE_PARTITION tableName ( partitionSpec )? ) ;
    public final HiveParser.tablePartitionPrefix_return tablePartitionPrefix() throws RecognitionException {
        HiveParser.tablePartitionPrefix_return retval = new HiveParser.tablePartitionPrefix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser_FromClauseParser.tableName_return tableName297 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec298 =null;


        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        pushMsg("table partition prefix", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1151:3: ( tableName ( partitionSpec )? -> ^( TOK_TABLE_PARTITION tableName ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1151:5: tableName ( partitionSpec )?
            {
            pushFollow(FOLLOW_tableName_in_tablePartitionPrefix5210);
            tableName297=tableName();

            state._fsp--;

            stream_tableName.add(tableName297.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1151:15: ( partitionSpec )?
            int alt86=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt86=1;
                    }
                    break;
            }

            switch (alt86) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1151:15: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_tablePartitionPrefix5212);
                    partitionSpec298=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec298.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1152:3: -> ^( TOK_TABLE_PARTITION tableName ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1152:5: ^( TOK_TABLE_PARTITION tableName ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLE_PARTITION, "TOK_TABLE_PARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1152:37: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tablePartitionPrefix"


    public static class alterStatementSuffixFileFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixFileFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1155:1: alterStatementSuffixFileFormat : KW_SET KW_FILEFORMAT fileFormat -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat ) ;
    public final HiveParser.alterStatementSuffixFileFormat_return alterStatementSuffixFileFormat() throws RecognitionException {
        HiveParser.alterStatementSuffixFileFormat_return retval = new HiveParser.alterStatementSuffixFileFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET299=null;
        Token KW_FILEFORMAT300=null;
        HiveParser.fileFormat_return fileFormat301 =null;


        CommonTree KW_SET299_tree=null;
        CommonTree KW_FILEFORMAT300_tree=null;
        RewriteRuleTokenStream stream_KW_FILEFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_FILEFORMAT");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_fileFormat=new RewriteRuleSubtreeStream(adaptor,"rule fileFormat");
        pushMsg("alter fileformat statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1158:2: ( KW_SET KW_FILEFORMAT fileFormat -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1158:4: KW_SET KW_FILEFORMAT fileFormat
            {
            KW_SET299=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixFileFormat5247);  
            stream_KW_SET.add(KW_SET299);


            KW_FILEFORMAT300=(Token)match(input,KW_FILEFORMAT,FOLLOW_KW_FILEFORMAT_in_alterStatementSuffixFileFormat5249);  
            stream_KW_FILEFORMAT.add(KW_FILEFORMAT300);


            pushFollow(FOLLOW_fileFormat_in_alterStatementSuffixFileFormat5251);
            fileFormat301=fileFormat();

            state._fsp--;

            stream_fileFormat.add(fileFormat301.getTree());

            // AST REWRITE
            // elements: fileFormat
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1159:2: -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1159:5: ^( TOK_ALTERTABLE_FILEFORMAT fileFormat )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_FILEFORMAT, "TOK_ALTERTABLE_FILEFORMAT")
                , root_1);

                adaptor.addChild(root_1, stream_fileFormat.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixFileFormat"


    public static class alterStatementSuffixClusterbySortby_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixClusterbySortby"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1162:1: alterStatementSuffixClusterbySortby : ( KW_NOT KW_CLUSTERED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED ) | KW_NOT KW_SORTED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED ) | tableBuckets -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets ) );
    public final HiveParser.alterStatementSuffixClusterbySortby_return alterStatementSuffixClusterbySortby() throws RecognitionException {
        HiveParser.alterStatementSuffixClusterbySortby_return retval = new HiveParser.alterStatementSuffixClusterbySortby_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_NOT302=null;
        Token KW_CLUSTERED303=null;
        Token KW_NOT304=null;
        Token KW_SORTED305=null;
        HiveParser.tableBuckets_return tableBuckets306 =null;


        CommonTree KW_NOT302_tree=null;
        CommonTree KW_CLUSTERED303_tree=null;
        CommonTree KW_NOT304_tree=null;
        CommonTree KW_SORTED305_tree=null;
        RewriteRuleTokenStream stream_KW_CLUSTERED=new RewriteRuleTokenStream(adaptor,"token KW_CLUSTERED");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_SORTED=new RewriteRuleTokenStream(adaptor,"token KW_SORTED");
        RewriteRuleSubtreeStream stream_tableBuckets=new RewriteRuleSubtreeStream(adaptor,"rule tableBuckets");
        pushMsg("alter partition cluster by sort by statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:3: ( KW_NOT KW_CLUSTERED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED ) | KW_NOT KW_SORTED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED ) | tableBuckets -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets ) )
            int alt87=3;
            switch ( input.LA(1) ) {
            case KW_NOT:
                {
                switch ( input.LA(2) ) {
                case KW_CLUSTERED:
                    {
                    alt87=1;
                    }
                    break;
                case KW_SORTED:
                    {
                    alt87=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 87, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_CLUSTERED:
                {
                alt87=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 87, 0, input);

                throw nvae;

            }

            switch (alt87) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:5: KW_NOT KW_CLUSTERED
                    {
                    KW_NOT302=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixClusterbySortby5282);  
                    stream_KW_NOT.add(KW_NOT302);


                    KW_CLUSTERED303=(Token)match(input,KW_CLUSTERED,FOLLOW_KW_CLUSTERED_in_alterStatementSuffixClusterbySortby5284);  
                    stream_KW_CLUSTERED.add(KW_CLUSTERED303);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1165:25: -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:28: ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_NOT_CLUSTERED, "TOK_NOT_CLUSTERED")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1166:5: KW_NOT KW_SORTED
                    {
                    KW_NOT304=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixClusterbySortby5298);  
                    stream_KW_NOT.add(KW_NOT304);


                    KW_SORTED305=(Token)match(input,KW_SORTED,FOLLOW_KW_SORTED_in_alterStatementSuffixClusterbySortby5300);  
                    stream_KW_SORTED.add(KW_SORTED305);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1166:22: -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1166:25: ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_NOT_SORTED, "TOK_NOT_SORTED")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1167:5: tableBuckets
                    {
                    pushFollow(FOLLOW_tableBuckets_in_alterStatementSuffixClusterbySortby5314);
                    tableBuckets306=tableBuckets();

                    state._fsp--;

                    stream_tableBuckets.add(tableBuckets306.getTree());

                    // AST REWRITE
                    // elements: tableBuckets
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1167:18: -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1167:21: ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableBuckets.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixClusterbySortby"


    public static class alterTblPartitionStatementSuffixSkewedLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatementSuffixSkewedLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1170:1: alterTblPartitionStatementSuffixSkewedLocation : KW_SET KW_SKEWED KW_LOCATION skewedLocations -> ^( TOK_ALTERTABLE_SKEWED_LOCATION skewedLocations ) ;
    public final HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return alterTblPartitionStatementSuffixSkewedLocation() throws RecognitionException {
        HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return retval = new HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET307=null;
        Token KW_SKEWED308=null;
        Token KW_LOCATION309=null;
        HiveParser.skewedLocations_return skewedLocations310 =null;


        CommonTree KW_SET307_tree=null;
        CommonTree KW_SKEWED308_tree=null;
        CommonTree KW_LOCATION309_tree=null;
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");
        RewriteRuleSubtreeStream stream_skewedLocations=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocations");
        pushMsg("alter partition skewed location", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1173:3: ( KW_SET KW_SKEWED KW_LOCATION skewedLocations -> ^( TOK_ALTERTABLE_SKEWED_LOCATION skewedLocations ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1173:5: KW_SET KW_SKEWED KW_LOCATION skewedLocations
            {
            KW_SET307=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterTblPartitionStatementSuffixSkewedLocation5345);  
            stream_KW_SET.add(KW_SET307);


            KW_SKEWED308=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_alterTblPartitionStatementSuffixSkewedLocation5347);  
            stream_KW_SKEWED.add(KW_SKEWED308);


            KW_LOCATION309=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_alterTblPartitionStatementSuffixSkewedLocation5349);  
            stream_KW_LOCATION.add(KW_LOCATION309);


            pushFollow(FOLLOW_skewedLocations_in_alterTblPartitionStatementSuffixSkewedLocation5351);
            skewedLocations310=skewedLocations();

            state._fsp--;

            stream_skewedLocations.add(skewedLocations310.getTree());

            // AST REWRITE
            // elements: skewedLocations
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1174:3: -> ^( TOK_ALTERTABLE_SKEWED_LOCATION skewedLocations )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1174:6: ^( TOK_ALTERTABLE_SKEWED_LOCATION skewedLocations )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED_LOCATION, "TOK_ALTERTABLE_SKEWED_LOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_skewedLocations.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatementSuffixSkewedLocation"


    public static class skewedLocations_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocations"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1177:1: skewedLocations : LPAREN skewedLocationsList RPAREN -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList ) ;
    public final HiveParser.skewedLocations_return skewedLocations() throws RecognitionException {
        HiveParser.skewedLocations_return retval = new HiveParser.skewedLocations_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN311=null;
        Token RPAREN313=null;
        HiveParser.skewedLocationsList_return skewedLocationsList312 =null;


        CommonTree LPAREN311_tree=null;
        CommonTree RPAREN313_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_skewedLocationsList=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocationsList");
         pushMsg("skewed locations", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1180:5: ( LPAREN skewedLocationsList RPAREN -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1181:7: LPAREN skewedLocationsList RPAREN
            {
            LPAREN311=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_skewedLocations5394);  
            stream_LPAREN.add(LPAREN311);


            pushFollow(FOLLOW_skewedLocationsList_in_skewedLocations5396);
            skewedLocationsList312=skewedLocationsList();

            state._fsp--;

            stream_skewedLocationsList.add(skewedLocationsList312.getTree());

            RPAREN313=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_skewedLocations5398);  
            stream_RPAREN.add(RPAREN313);


            // AST REWRITE
            // elements: skewedLocationsList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1181:41: -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1181:44: ^( TOK_SKEWED_LOCATIONS skewedLocationsList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATIONS, "TOK_SKEWED_LOCATIONS")
                , root_1);

                adaptor.addChild(root_1, stream_skewedLocationsList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocations"


    public static class skewedLocationsList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocationsList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1184:1: skewedLocationsList : skewedLocationMap ( COMMA skewedLocationMap )* -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ ) ;
    public final HiveParser.skewedLocationsList_return skewedLocationsList() throws RecognitionException {
        HiveParser.skewedLocationsList_return retval = new HiveParser.skewedLocationsList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA315=null;
        HiveParser.skewedLocationMap_return skewedLocationMap314 =null;

        HiveParser.skewedLocationMap_return skewedLocationMap316 =null;


        CommonTree COMMA315_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_skewedLocationMap=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocationMap");
         pushMsg("skewed locations list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1187:5: ( skewedLocationMap ( COMMA skewedLocationMap )* -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:7: skewedLocationMap ( COMMA skewedLocationMap )*
            {
            pushFollow(FOLLOW_skewedLocationMap_in_skewedLocationsList5439);
            skewedLocationMap314=skewedLocationMap();

            state._fsp--;

            stream_skewedLocationMap.add(skewedLocationMap314.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:25: ( COMMA skewedLocationMap )*
            loop88:
            do {
                int alt88=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt88=1;
                    }
                    break;

                }

                switch (alt88) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:26: COMMA skewedLocationMap
            	    {
            	    COMMA315=(Token)match(input,COMMA,FOLLOW_COMMA_in_skewedLocationsList5442);  
            	    stream_COMMA.add(COMMA315);


            	    pushFollow(FOLLOW_skewedLocationMap_in_skewedLocationsList5444);
            	    skewedLocationMap316=skewedLocationMap();

            	    state._fsp--;

            	    stream_skewedLocationMap.add(skewedLocationMap316.getTree());

            	    }
            	    break;

            	default :
            	    break loop88;
                }
            } while (true);


            // AST REWRITE
            // elements: skewedLocationMap
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1188:52: -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:55: ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATION_LIST, "TOK_SKEWED_LOCATION_LIST")
                , root_1);

                if ( !(stream_skewedLocationMap.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_skewedLocationMap.hasNext() ) {
                    adaptor.addChild(root_1, stream_skewedLocationMap.nextTree());

                }
                stream_skewedLocationMap.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocationsList"


    public static class skewedLocationMap_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocationMap"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1191:1: skewedLocationMap : key= skewedValueLocationElement EQUAL value= StringLiteral -> ^( TOK_SKEWED_LOCATION_MAP $key $value) ;
    public final HiveParser.skewedLocationMap_return skewedLocationMap() throws RecognitionException {
        HiveParser.skewedLocationMap_return retval = new HiveParser.skewedLocationMap_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token value=null;
        Token EQUAL317=null;
        HiveParser.skewedValueLocationElement_return key =null;


        CommonTree value_tree=null;
        CommonTree EQUAL317_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
        RewriteRuleSubtreeStream stream_skewedValueLocationElement=new RewriteRuleSubtreeStream(adaptor,"rule skewedValueLocationElement");
         pushMsg("specifying skewed location map", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1194:5: (key= skewedValueLocationElement EQUAL value= StringLiteral -> ^( TOK_SKEWED_LOCATION_MAP $key $value) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1195:7: key= skewedValueLocationElement EQUAL value= StringLiteral
            {
            pushFollow(FOLLOW_skewedValueLocationElement_in_skewedLocationMap5490);
            key=skewedValueLocationElement();

            state._fsp--;

            stream_skewedValueLocationElement.add(key.getTree());

            EQUAL317=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_skewedLocationMap5492);  
            stream_EQUAL.add(EQUAL317);


            value=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_skewedLocationMap5496);  
            stream_StringLiteral.add(value);


            // AST REWRITE
            // elements: key, value
            // token labels: value
            // rule labels: retval, key
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_value=new RewriteRuleTokenStream(adaptor,"token value",value);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_key=new RewriteRuleSubtreeStream(adaptor,"rule key",key!=null?key.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1195:64: -> ^( TOK_SKEWED_LOCATION_MAP $key $value)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1195:67: ^( TOK_SKEWED_LOCATION_MAP $key $value)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATION_MAP, "TOK_SKEWED_LOCATION_MAP")
                , root_1);

                adaptor.addChild(root_1, stream_key.nextTree());

                adaptor.addChild(root_1, stream_value.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocationMap"


    public static class alterStatementSuffixLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1198:1: alterStatementSuffixLocation : KW_SET KW_LOCATION newLoc= StringLiteral -> ^( TOK_ALTERTABLE_LOCATION $newLoc) ;
    public final HiveParser.alterStatementSuffixLocation_return alterStatementSuffixLocation() throws RecognitionException {
        HiveParser.alterStatementSuffixLocation_return retval = new HiveParser.alterStatementSuffixLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token newLoc=null;
        Token KW_SET318=null;
        Token KW_LOCATION319=null;

        CommonTree newLoc_tree=null;
        CommonTree KW_SET318_tree=null;
        CommonTree KW_LOCATION319_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

        pushMsg("alter location", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1201:3: ( KW_SET KW_LOCATION newLoc= StringLiteral -> ^( TOK_ALTERTABLE_LOCATION $newLoc) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1201:5: KW_SET KW_LOCATION newLoc= StringLiteral
            {
            KW_SET318=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixLocation5533);  
            stream_KW_SET.add(KW_SET318);


            KW_LOCATION319=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_alterStatementSuffixLocation5535);  
            stream_KW_LOCATION.add(KW_LOCATION319);


            newLoc=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixLocation5539);  
            stream_StringLiteral.add(newLoc);


            // AST REWRITE
            // elements: newLoc
            // token labels: newLoc
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_newLoc=new RewriteRuleTokenStream(adaptor,"token newLoc",newLoc);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1202:3: -> ^( TOK_ALTERTABLE_LOCATION $newLoc)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1202:6: ^( TOK_ALTERTABLE_LOCATION $newLoc)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_LOCATION, "TOK_ALTERTABLE_LOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_newLoc.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixLocation"


    public static class alterStatementSuffixSkewedby_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixSkewedby"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1206:1: alterStatementSuffixSkewedby : ( tableSkewed -> ^( TOK_ALTERTABLE_SKEWED tableSkewed ) | KW_NOT KW_SKEWED -> ^( TOK_ALTERTABLE_SKEWED ) | KW_NOT storedAsDirs -> ^( TOK_ALTERTABLE_SKEWED storedAsDirs ) );
    public final HiveParser.alterStatementSuffixSkewedby_return alterStatementSuffixSkewedby() throws RecognitionException {
        HiveParser.alterStatementSuffixSkewedby_return retval = new HiveParser.alterStatementSuffixSkewedby_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_NOT321=null;
        Token KW_SKEWED322=null;
        Token KW_NOT323=null;
        HiveParser.tableSkewed_return tableSkewed320 =null;

        HiveParser.storedAsDirs_return storedAsDirs324 =null;


        CommonTree KW_NOT321_tree=null;
        CommonTree KW_SKEWED322_tree=null;
        CommonTree KW_NOT323_tree=null;
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleSubtreeStream stream_storedAsDirs=new RewriteRuleSubtreeStream(adaptor,"rule storedAsDirs");
        RewriteRuleSubtreeStream stream_tableSkewed=new RewriteRuleSubtreeStream(adaptor,"rule tableSkewed");
        pushMsg("alter skewed by statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1209:2: ( tableSkewed -> ^( TOK_ALTERTABLE_SKEWED tableSkewed ) | KW_NOT KW_SKEWED -> ^( TOK_ALTERTABLE_SKEWED ) | KW_NOT storedAsDirs -> ^( TOK_ALTERTABLE_SKEWED storedAsDirs ) )
            int alt89=3;
            switch ( input.LA(1) ) {
            case KW_SKEWED:
                {
                alt89=1;
                }
                break;
            case KW_NOT:
                {
                switch ( input.LA(2) ) {
                case KW_SKEWED:
                    {
                    alt89=2;
                    }
                    break;
                case KW_STORED:
                    {
                    alt89=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 89, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 89, 0, input);

                throw nvae;

            }

            switch (alt89) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1209:4: tableSkewed
                    {
                    pushFollow(FOLLOW_tableSkewed_in_alterStatementSuffixSkewedby5573);
                    tableSkewed320=tableSkewed();

                    state._fsp--;

                    stream_tableSkewed.add(tableSkewed320.getTree());

                    // AST REWRITE
                    // elements: tableSkewed
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1210:2: -> ^( TOK_ALTERTABLE_SKEWED tableSkewed )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1210:4: ^( TOK_ALTERTABLE_SKEWED tableSkewed )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableSkewed.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1212:3: KW_NOT KW_SKEWED
                    {
                    KW_NOT321=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixSkewedby5588);  
                    stream_KW_NOT.add(KW_NOT321);


                    KW_SKEWED322=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_alterStatementSuffixSkewedby5590);  
                    stream_KW_SKEWED.add(KW_SKEWED322);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1213:2: -> ^( TOK_ALTERTABLE_SKEWED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:4: ^( TOK_ALTERTABLE_SKEWED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1215:3: KW_NOT storedAsDirs
                    {
                    KW_NOT323=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixSkewedby5603);  
                    stream_KW_NOT.add(KW_NOT323);


                    pushFollow(FOLLOW_storedAsDirs_in_alterStatementSuffixSkewedby5605);
                    storedAsDirs324=storedAsDirs();

                    state._fsp--;

                    stream_storedAsDirs.add(storedAsDirs324.getTree());

                    // AST REWRITE
                    // elements: storedAsDirs
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1216:2: -> ^( TOK_ALTERTABLE_SKEWED storedAsDirs )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1216:4: ^( TOK_ALTERTABLE_SKEWED storedAsDirs )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_storedAsDirs.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixSkewedby"


    public static class alterStatementSuffixExchangePartition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixExchangePartition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:1: alterStatementSuffixExchangePartition : KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName -> ^( TOK_ALTERTABLE_EXCHANGEPARTITION partitionSpec $exchangename) ;
    public final HiveParser.alterStatementSuffixExchangePartition_return alterStatementSuffixExchangePartition() throws RecognitionException {
        HiveParser.alterStatementSuffixExchangePartition_return retval = new HiveParser.alterStatementSuffixExchangePartition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_EXCHANGE325=null;
        Token KW_WITH327=null;
        Token KW_TABLE328=null;
        HiveParser_FromClauseParser.tableName_return exchangename =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec326 =null;


        CommonTree KW_EXCHANGE325_tree=null;
        CommonTree KW_WITH327_tree=null;
        CommonTree KW_TABLE328_tree=null;
        RewriteRuleTokenStream stream_KW_EXCHANGE=new RewriteRuleTokenStream(adaptor,"token KW_EXCHANGE");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        pushMsg("alter exchange partition", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1222:5: ( KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName -> ^( TOK_ALTERTABLE_EXCHANGEPARTITION partitionSpec $exchangename) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1222:7: KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName
            {
            KW_EXCHANGE325=(Token)match(input,KW_EXCHANGE,FOLLOW_KW_EXCHANGE_in_alterStatementSuffixExchangePartition5636);  
            stream_KW_EXCHANGE.add(KW_EXCHANGE325);


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixExchangePartition5638);
            partitionSpec326=partitionSpec();

            state._fsp--;

            stream_partitionSpec.add(partitionSpec326.getTree());

            KW_WITH327=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_alterStatementSuffixExchangePartition5640);  
            stream_KW_WITH.add(KW_WITH327);


            KW_TABLE328=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_alterStatementSuffixExchangePartition5642);  
            stream_KW_TABLE.add(KW_TABLE328);


            pushFollow(FOLLOW_tableName_in_alterStatementSuffixExchangePartition5646);
            exchangename=tableName();

            state._fsp--;

            stream_tableName.add(exchangename.getTree());

            // AST REWRITE
            // elements: exchangename, partitionSpec
            // token labels: 
            // rule labels: exchangename, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_exchangename=new RewriteRuleSubtreeStream(adaptor,"rule exchangename",exchangename!=null?exchangename.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1223:5: -> ^( TOK_ALTERTABLE_EXCHANGEPARTITION partitionSpec $exchangename)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1223:8: ^( TOK_ALTERTABLE_EXCHANGEPARTITION partitionSpec $exchangename)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_EXCHANGEPARTITION, "TOK_ALTERTABLE_EXCHANGEPARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                adaptor.addChild(root_1, stream_exchangename.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixExchangePartition"


    public static class alterStatementSuffixProtectMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixProtectMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:1: alterStatementSuffixProtectMode : alterProtectMode -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode ) ;
    public final HiveParser.alterStatementSuffixProtectMode_return alterStatementSuffixProtectMode() throws RecognitionException {
        HiveParser.alterStatementSuffixProtectMode_return retval = new HiveParser.alterStatementSuffixProtectMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterProtectMode_return alterProtectMode329 =null;


        RewriteRuleSubtreeStream stream_alterProtectMode=new RewriteRuleSubtreeStream(adaptor,"rule alterProtectMode");
         pushMsg("alter partition protect mode statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1229:5: ( alterProtectMode -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1229:7: alterProtectMode
            {
            pushFollow(FOLLOW_alterProtectMode_in_alterStatementSuffixProtectMode5688);
            alterProtectMode329=alterProtectMode();

            state._fsp--;

            stream_alterProtectMode.add(alterProtectMode329.getTree());

            // AST REWRITE
            // elements: alterProtectMode
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1230:5: -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1230:8: ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_PROTECTMODE, "TOK_ALTERTABLE_PROTECTMODE")
                , root_1);

                adaptor.addChild(root_1, stream_alterProtectMode.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixProtectMode"


    public static class alterStatementSuffixRenamePart_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRenamePart"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:1: alterStatementSuffixRenamePart : KW_RENAME KW_TO partitionSpec -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec ) ;
    public final HiveParser.alterStatementSuffixRenamePart_return alterStatementSuffixRenamePart() throws RecognitionException {
        HiveParser.alterStatementSuffixRenamePart_return retval = new HiveParser.alterStatementSuffixRenamePart_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RENAME330=null;
        Token KW_TO331=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec332 =null;


        CommonTree KW_RENAME330_tree=null;
        CommonTree KW_TO331_tree=null;
        RewriteRuleTokenStream stream_KW_RENAME=new RewriteRuleTokenStream(adaptor,"token KW_RENAME");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("alter table rename partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1236:5: ( KW_RENAME KW_TO partitionSpec -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1236:7: KW_RENAME KW_TO partitionSpec
            {
            KW_RENAME330=(Token)match(input,KW_RENAME,FOLLOW_KW_RENAME_in_alterStatementSuffixRenamePart5727);  
            stream_KW_RENAME.add(KW_RENAME330);


            KW_TO331=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_alterStatementSuffixRenamePart5729);  
            stream_KW_TO.add(KW_TO331);


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixRenamePart5731);
            partitionSpec332=partitionSpec();

            state._fsp--;

            stream_partitionSpec.add(partitionSpec332.getTree());

            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1237:5: -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1237:7: ^( TOK_ALTERTABLE_RENAMEPART partitionSpec )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAMEPART, "TOK_ALTERTABLE_RENAMEPART")
                , root_1);

                adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRenamePart"


    public static class alterStatementSuffixStatsPart_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixStatsPart"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:1: alterStatementSuffixStatsPart : KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )? -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? ) ;
    public final HiveParser.alterStatementSuffixStatsPart_return alterStatementSuffixStatsPart() throws RecognitionException {
        HiveParser.alterStatementSuffixStatsPart_return retval = new HiveParser.alterStatementSuffixStatsPart_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_UPDATE333=null;
        Token KW_STATISTICS334=null;
        Token KW_FOR335=null;
        Token KW_COLUMN336=null;
        Token KW_SET337=null;
        Token KW_COMMENT339=null;
        HiveParser_IdentifiersParser.identifier_return colName =null;

        HiveParser.tableProperties_return tableProperties338 =null;


        CommonTree comment_tree=null;
        CommonTree KW_UPDATE333_tree=null;
        CommonTree KW_STATISTICS334_tree=null;
        CommonTree KW_FOR335_tree=null;
        CommonTree KW_COLUMN336_tree=null;
        CommonTree KW_SET337_tree=null;
        CommonTree KW_COMMENT339_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");
        RewriteRuleTokenStream stream_KW_UPDATE=new RewriteRuleTokenStream(adaptor,"token KW_UPDATE");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_STATISTICS=new RewriteRuleTokenStream(adaptor,"token KW_STATISTICS");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter table stats partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:5: ( KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )? -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:7: KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )?
            {
            KW_UPDATE333=(Token)match(input,KW_UPDATE,FOLLOW_KW_UPDATE_in_alterStatementSuffixStatsPart5769);  
            stream_KW_UPDATE.add(KW_UPDATE333);


            KW_STATISTICS334=(Token)match(input,KW_STATISTICS,FOLLOW_KW_STATISTICS_in_alterStatementSuffixStatsPart5771);  
            stream_KW_STATISTICS.add(KW_STATISTICS334);


            KW_FOR335=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_alterStatementSuffixStatsPart5773);  
            stream_KW_FOR.add(KW_FOR335);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:38: ( KW_COLUMN )?
            int alt90=2;
            switch ( input.LA(1) ) {
                case KW_COLUMN:
                    {
                    alt90=1;
                    }
                    break;
            }

            switch (alt90) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:38: KW_COLUMN
                    {
                    KW_COLUMN336=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementSuffixStatsPart5775);  
                    stream_KW_COLUMN.add(KW_COLUMN336);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixStatsPart5780);
            colName=identifier();

            state._fsp--;

            stream_identifier.add(colName.getTree());

            KW_SET337=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixStatsPart5782);  
            stream_KW_SET.add(KW_SET337);


            pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixStatsPart5784);
            tableProperties338=tableProperties();

            state._fsp--;

            stream_tableProperties.add(tableProperties338.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:91: ( KW_COMMENT comment= StringLiteral )?
            int alt91=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt91=1;
                    }
                    break;
            }

            switch (alt91) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:92: KW_COMMENT comment= StringLiteral
                    {
                    KW_COMMENT339=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_alterStatementSuffixStatsPart5787);  
                    stream_KW_COMMENT.add(KW_COMMENT339);


                    comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixStatsPart5791);  
                    stream_StringLiteral.add(comment);


                    }
                    break;

            }


            // AST REWRITE
            // elements: colName, comment, tableProperties
            // token labels: comment
            // rule labels: retval, colName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_colName=new RewriteRuleSubtreeStream(adaptor,"rule colName",colName!=null?colName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1244:5: -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1244:7: ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_UPDATECOLSTATS, "TOK_ALTERTABLE_UPDATECOLSTATS")
                , root_1);

                adaptor.addChild(root_1, stream_colName.nextTree());

                adaptor.addChild(root_1, stream_tableProperties.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1244:65: ( $comment)?
                if ( stream_comment.hasNext() ) {
                    adaptor.addChild(root_1, stream_comment.nextNode());

                }
                stream_comment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixStatsPart"


    public static class alterStatementSuffixMergeFiles_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixMergeFiles"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1247:1: alterStatementSuffixMergeFiles : KW_CONCATENATE -> ^( TOK_ALTERTABLE_MERGEFILES ) ;
    public final HiveParser.alterStatementSuffixMergeFiles_return alterStatementSuffixMergeFiles() throws RecognitionException {
        HiveParser.alterStatementSuffixMergeFiles_return retval = new HiveParser.alterStatementSuffixMergeFiles_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CONCATENATE340=null;

        CommonTree KW_CONCATENATE340_tree=null;
        RewriteRuleTokenStream stream_KW_CONCATENATE=new RewriteRuleTokenStream(adaptor,"token KW_CONCATENATE");

         pushMsg("", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:5: ( KW_CONCATENATE -> ^( TOK_ALTERTABLE_MERGEFILES ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:7: KW_CONCATENATE
            {
            KW_CONCATENATE340=(Token)match(input,KW_CONCATENATE,FOLLOW_KW_CONCATENATE_in_alterStatementSuffixMergeFiles5838);  
            stream_KW_CONCATENATE.add(KW_CONCATENATE340);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1251:5: -> ^( TOK_ALTERTABLE_MERGEFILES )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1251:8: ^( TOK_ALTERTABLE_MERGEFILES )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_MERGEFILES, "TOK_ALTERTABLE_MERGEFILES")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixMergeFiles"


    public static class alterProtectMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterProtectMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1254:1: alterProtectMode : ( KW_ENABLE alterProtectModeMode -> ^( TOK_ENABLE alterProtectModeMode ) | KW_DISABLE alterProtectModeMode -> ^( TOK_DISABLE alterProtectModeMode ) );
    public final HiveParser.alterProtectMode_return alterProtectMode() throws RecognitionException {
        HiveParser.alterProtectMode_return retval = new HiveParser.alterProtectMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ENABLE341=null;
        Token KW_DISABLE343=null;
        HiveParser.alterProtectModeMode_return alterProtectModeMode342 =null;

        HiveParser.alterProtectModeMode_return alterProtectModeMode344 =null;


        CommonTree KW_ENABLE341_tree=null;
        CommonTree KW_DISABLE343_tree=null;
        RewriteRuleTokenStream stream_KW_DISABLE=new RewriteRuleTokenStream(adaptor,"token KW_DISABLE");
        RewriteRuleTokenStream stream_KW_ENABLE=new RewriteRuleTokenStream(adaptor,"token KW_ENABLE");
        RewriteRuleSubtreeStream stream_alterProtectModeMode=new RewriteRuleSubtreeStream(adaptor,"rule alterProtectModeMode");
         pushMsg("protect mode specification enable", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:5: ( KW_ENABLE alterProtectModeMode -> ^( TOK_ENABLE alterProtectModeMode ) | KW_DISABLE alterProtectModeMode -> ^( TOK_DISABLE alterProtectModeMode ) )
            int alt92=2;
            switch ( input.LA(1) ) {
            case KW_ENABLE:
                {
                alt92=1;
                }
                break;
            case KW_DISABLE:
                {
                alt92=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 92, 0, input);

                throw nvae;

            }

            switch (alt92) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:7: KW_ENABLE alterProtectModeMode
                    {
                    KW_ENABLE341=(Token)match(input,KW_ENABLE,FOLLOW_KW_ENABLE_in_alterProtectMode5875);  
                    stream_KW_ENABLE.add(KW_ENABLE341);


                    pushFollow(FOLLOW_alterProtectModeMode_in_alterProtectMode5877);
                    alterProtectModeMode342=alterProtectModeMode();

                    state._fsp--;

                    stream_alterProtectModeMode.add(alterProtectModeMode342.getTree());

                    // AST REWRITE
                    // elements: alterProtectModeMode
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1257:39: -> ^( TOK_ENABLE alterProtectModeMode )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:42: ^( TOK_ENABLE alterProtectModeMode )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ENABLE, "TOK_ENABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterProtectModeMode.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1258:7: KW_DISABLE alterProtectModeMode
                    {
                    KW_DISABLE343=(Token)match(input,KW_DISABLE,FOLLOW_KW_DISABLE_in_alterProtectMode5894);  
                    stream_KW_DISABLE.add(KW_DISABLE343);


                    pushFollow(FOLLOW_alterProtectModeMode_in_alterProtectMode5896);
                    alterProtectModeMode344=alterProtectModeMode();

                    state._fsp--;

                    stream_alterProtectModeMode.add(alterProtectModeMode344.getTree());

                    // AST REWRITE
                    // elements: alterProtectModeMode
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1258:40: -> ^( TOK_DISABLE alterProtectModeMode )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1258:43: ^( TOK_DISABLE alterProtectModeMode )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DISABLE, "TOK_DISABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterProtectModeMode.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterProtectMode"


    public static class alterProtectModeMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterProtectModeMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1261:1: alterProtectModeMode : ( KW_OFFLINE -> ^( TOK_OFFLINE ) | KW_NO_DROP ( KW_CASCADE )? -> ^( TOK_NO_DROP ( KW_CASCADE )? ) | KW_READONLY -> ^( TOK_READONLY ) );
    public final HiveParser.alterProtectModeMode_return alterProtectModeMode() throws RecognitionException {
        HiveParser.alterProtectModeMode_return retval = new HiveParser.alterProtectModeMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_OFFLINE345=null;
        Token KW_NO_DROP346=null;
        Token KW_CASCADE347=null;
        Token KW_READONLY348=null;

        CommonTree KW_OFFLINE345_tree=null;
        CommonTree KW_NO_DROP346_tree=null;
        CommonTree KW_CASCADE347_tree=null;
        CommonTree KW_READONLY348_tree=null;
        RewriteRuleTokenStream stream_KW_READONLY=new RewriteRuleTokenStream(adaptor,"token KW_READONLY");
        RewriteRuleTokenStream stream_KW_NO_DROP=new RewriteRuleTokenStream(adaptor,"token KW_NO_DROP");
        RewriteRuleTokenStream stream_KW_CASCADE=new RewriteRuleTokenStream(adaptor,"token KW_CASCADE");
        RewriteRuleTokenStream stream_KW_OFFLINE=new RewriteRuleTokenStream(adaptor,"token KW_OFFLINE");

         pushMsg("protect mode specification enable", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1264:5: ( KW_OFFLINE -> ^( TOK_OFFLINE ) | KW_NO_DROP ( KW_CASCADE )? -> ^( TOK_NO_DROP ( KW_CASCADE )? ) | KW_READONLY -> ^( TOK_READONLY ) )
            int alt94=3;
            switch ( input.LA(1) ) {
            case KW_OFFLINE:
                {
                alt94=1;
                }
                break;
            case KW_NO_DROP:
                {
                alt94=2;
                }
                break;
            case KW_READONLY:
                {
                alt94=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 94, 0, input);

                throw nvae;

            }

            switch (alt94) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1264:7: KW_OFFLINE
                    {
                    KW_OFFLINE345=(Token)match(input,KW_OFFLINE,FOLLOW_KW_OFFLINE_in_alterProtectModeMode5932);  
                    stream_KW_OFFLINE.add(KW_OFFLINE345);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1264:19: -> ^( TOK_OFFLINE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1264:22: ^( TOK_OFFLINE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_OFFLINE, "TOK_OFFLINE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1265:7: KW_NO_DROP ( KW_CASCADE )?
                    {
                    KW_NO_DROP346=(Token)match(input,KW_NO_DROP,FOLLOW_KW_NO_DROP_in_alterProtectModeMode5947);  
                    stream_KW_NO_DROP.add(KW_NO_DROP346);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1265:18: ( KW_CASCADE )?
                    int alt93=2;
                    switch ( input.LA(1) ) {
                        case KW_CASCADE:
                            {
                            alt93=1;
                            }
                            break;
                    }

                    switch (alt93) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1265:18: KW_CASCADE
                            {
                            KW_CASCADE347=(Token)match(input,KW_CASCADE,FOLLOW_KW_CASCADE_in_alterProtectModeMode5949);  
                            stream_KW_CASCADE.add(KW_CASCADE347);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: KW_CASCADE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1265:30: -> ^( TOK_NO_DROP ( KW_CASCADE )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1265:33: ^( TOK_NO_DROP ( KW_CASCADE )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_NO_DROP, "TOK_NO_DROP")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1265:47: ( KW_CASCADE )?
                        if ( stream_KW_CASCADE.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_CASCADE.nextNode()
                            );

                        }
                        stream_KW_CASCADE.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1266:7: KW_READONLY
                    {
                    KW_READONLY348=(Token)match(input,KW_READONLY,FOLLOW_KW_READONLY_in_alterProtectModeMode5967);  
                    stream_KW_READONLY.add(KW_READONLY348);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1266:20: -> ^( TOK_READONLY )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1266:23: ^( TOK_READONLY )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_READONLY, "TOK_READONLY")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterProtectModeMode"


    public static class alterStatementSuffixBucketNum_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixBucketNum"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1269:1: alterStatementSuffixBucketNum : KW_INTO num= Number KW_BUCKETS -> ^( TOK_ALTERTABLE_BUCKETS $num) ;
    public final HiveParser.alterStatementSuffixBucketNum_return alterStatementSuffixBucketNum() throws RecognitionException {
        HiveParser.alterStatementSuffixBucketNum_return retval = new HiveParser.alterStatementSuffixBucketNum_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token num=null;
        Token KW_INTO349=null;
        Token KW_BUCKETS350=null;

        CommonTree num_tree=null;
        CommonTree KW_INTO349_tree=null;
        CommonTree KW_BUCKETS350_tree=null;
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_Number=new RewriteRuleTokenStream(adaptor,"token Number");
        RewriteRuleTokenStream stream_KW_BUCKETS=new RewriteRuleTokenStream(adaptor,"token KW_BUCKETS");

         pushMsg("", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1272:5: ( KW_INTO num= Number KW_BUCKETS -> ^( TOK_ALTERTABLE_BUCKETS $num) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1272:7: KW_INTO num= Number KW_BUCKETS
            {
            KW_INTO349=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_alterStatementSuffixBucketNum6001);  
            stream_KW_INTO.add(KW_INTO349);


            num=(Token)match(input,Number,FOLLOW_Number_in_alterStatementSuffixBucketNum6005);  
            stream_Number.add(num);


            KW_BUCKETS350=(Token)match(input,KW_BUCKETS,FOLLOW_KW_BUCKETS_in_alterStatementSuffixBucketNum6007);  
            stream_KW_BUCKETS.add(KW_BUCKETS350);


            // AST REWRITE
            // elements: num
            // token labels: num
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_num=new RewriteRuleTokenStream(adaptor,"token num",num);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1273:5: -> ^( TOK_ALTERTABLE_BUCKETS $num)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1273:8: ^( TOK_ALTERTABLE_BUCKETS $num)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_BUCKETS, "TOK_ALTERTABLE_BUCKETS")
                , root_1);

                adaptor.addChild(root_1, stream_num.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixBucketNum"


    public static class alterStatementSuffixCompact_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixCompact"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1276:1: alterStatementSuffixCompact : KW_COMPACT compactType= StringLiteral -> ^( TOK_ALTERTABLE_COMPACT $compactType) ;
    public final HiveParser.alterStatementSuffixCompact_return alterStatementSuffixCompact() throws RecognitionException {
        HiveParser.alterStatementSuffixCompact_return retval = new HiveParser.alterStatementSuffixCompact_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token compactType=null;
        Token KW_COMPACT351=null;

        CommonTree compactType_tree=null;
        CommonTree KW_COMPACT351_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMPACT=new RewriteRuleTokenStream(adaptor,"token KW_COMPACT");

         msgs.push("compaction request"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1279:5: ( KW_COMPACT compactType= StringLiteral -> ^( TOK_ALTERTABLE_COMPACT $compactType) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1279:7: KW_COMPACT compactType= StringLiteral
            {
            KW_COMPACT351=(Token)match(input,KW_COMPACT,FOLLOW_KW_COMPACT_in_alterStatementSuffixCompact6047);  
            stream_KW_COMPACT.add(KW_COMPACT351);


            compactType=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixCompact6051);  
            stream_StringLiteral.add(compactType);


            // AST REWRITE
            // elements: compactType
            // token labels: compactType
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_compactType=new RewriteRuleTokenStream(adaptor,"token compactType",compactType);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1280:5: -> ^( TOK_ALTERTABLE_COMPACT $compactType)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1280:8: ^( TOK_ALTERTABLE_COMPACT $compactType)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_COMPACT, "TOK_ALTERTABLE_COMPACT")
                , root_1);

                adaptor.addChild(root_1, stream_compactType.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixCompact"


    public static class fileFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fileFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1284:1: fileFormat : ( KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral KW_SERDE serdeCls= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )? -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt $serdeCls ( $inDriver)? ( $outDriver)? ) |genericSpec= identifier -> ^( TOK_FILEFORMAT_GENERIC $genericSpec) );
    public final HiveParser.fileFormat_return fileFormat() throws RecognitionException {
        HiveParser.fileFormat_return retval = new HiveParser.fileFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token inFmt=null;
        Token outFmt=null;
        Token serdeCls=null;
        Token inDriver=null;
        Token outDriver=null;
        Token KW_INPUTFORMAT352=null;
        Token KW_OUTPUTFORMAT353=null;
        Token KW_SERDE354=null;
        Token KW_INPUTDRIVER355=null;
        Token KW_OUTPUTDRIVER356=null;
        HiveParser_IdentifiersParser.identifier_return genericSpec =null;


        CommonTree inFmt_tree=null;
        CommonTree outFmt_tree=null;
        CommonTree serdeCls_tree=null;
        CommonTree inDriver_tree=null;
        CommonTree outDriver_tree=null;
        CommonTree KW_INPUTFORMAT352_tree=null;
        CommonTree KW_OUTPUTFORMAT353_tree=null;
        CommonTree KW_SERDE354_tree=null;
        CommonTree KW_INPUTDRIVER355_tree=null;
        CommonTree KW_OUTPUTDRIVER356_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INPUTDRIVER=new RewriteRuleTokenStream(adaptor,"token KW_INPUTDRIVER");
        RewriteRuleTokenStream stream_KW_INPUTFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_INPUTFORMAT");
        RewriteRuleTokenStream stream_KW_OUTPUTFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_OUTPUTFORMAT");
        RewriteRuleTokenStream stream_KW_OUTPUTDRIVER=new RewriteRuleTokenStream(adaptor,"token KW_OUTPUTDRIVER");
        RewriteRuleTokenStream stream_KW_SERDE=new RewriteRuleTokenStream(adaptor,"token KW_SERDE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("file format specification", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1287:5: ( KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral KW_SERDE serdeCls= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )? -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt $serdeCls ( $inDriver)? ( $outDriver)? ) |genericSpec= identifier -> ^( TOK_FILEFORMAT_GENERIC $genericSpec) )
            int alt96=2;
            switch ( input.LA(1) ) {
            case KW_INPUTFORMAT:
                {
                switch ( input.LA(2) ) {
                case StringLiteral:
                    {
                    alt96=1;
                    }
                    break;
                case EOF:
                    {
                    alt96=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 1, input);

                    throw nvae;

                }

                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_AUTHORIZATION:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_REWRITE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUES:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt96=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 96, 0, input);

                throw nvae;

            }

            switch (alt96) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1287:7: KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral KW_SERDE serdeCls= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )?
                    {
                    KW_INPUTFORMAT352=(Token)match(input,KW_INPUTFORMAT,FOLLOW_KW_INPUTFORMAT_in_fileFormat6092);  
                    stream_KW_INPUTFORMAT.add(KW_INPUTFORMAT352);


                    inFmt=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6096);  
                    stream_StringLiteral.add(inFmt);


                    KW_OUTPUTFORMAT353=(Token)match(input,KW_OUTPUTFORMAT,FOLLOW_KW_OUTPUTFORMAT_in_fileFormat6098);  
                    stream_KW_OUTPUTFORMAT.add(KW_OUTPUTFORMAT353);


                    outFmt=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6102);  
                    stream_StringLiteral.add(outFmt);


                    KW_SERDE354=(Token)match(input,KW_SERDE,FOLLOW_KW_SERDE_in_fileFormat6104);  
                    stream_KW_SERDE.add(KW_SERDE354);


                    serdeCls=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6108);  
                    stream_StringLiteral.add(serdeCls);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1287:111: ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )?
                    int alt95=2;
                    switch ( input.LA(1) ) {
                        case KW_INPUTDRIVER:
                            {
                            alt95=1;
                            }
                            break;
                    }

                    switch (alt95) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1287:112: KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral
                            {
                            KW_INPUTDRIVER355=(Token)match(input,KW_INPUTDRIVER,FOLLOW_KW_INPUTDRIVER_in_fileFormat6111);  
                            stream_KW_INPUTDRIVER.add(KW_INPUTDRIVER355);


                            inDriver=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6115);  
                            stream_StringLiteral.add(inDriver);


                            KW_OUTPUTDRIVER356=(Token)match(input,KW_OUTPUTDRIVER,FOLLOW_KW_OUTPUTDRIVER_in_fileFormat6117);  
                            stream_KW_OUTPUTDRIVER.add(KW_OUTPUTDRIVER356);


                            outDriver=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6121);  
                            stream_StringLiteral.add(outDriver);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: inDriver, serdeCls, outDriver, inFmt, outFmt
                    // token labels: outDriver, outFmt, inDriver, serdeCls, inFmt
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_outDriver=new RewriteRuleTokenStream(adaptor,"token outDriver",outDriver);
                    RewriteRuleTokenStream stream_outFmt=new RewriteRuleTokenStream(adaptor,"token outFmt",outFmt);
                    RewriteRuleTokenStream stream_inDriver=new RewriteRuleTokenStream(adaptor,"token inDriver",inDriver);
                    RewriteRuleTokenStream stream_serdeCls=new RewriteRuleTokenStream(adaptor,"token serdeCls",serdeCls);
                    RewriteRuleTokenStream stream_inFmt=new RewriteRuleTokenStream(adaptor,"token inFmt",inFmt);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1288:7: -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt $serdeCls ( $inDriver)? ( $outDriver)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1288:10: ^( TOK_TABLEFILEFORMAT $inFmt $outFmt $serdeCls ( $inDriver)? ( $outDriver)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TABLEFILEFORMAT, "TOK_TABLEFILEFORMAT")
                        , root_1);

                        adaptor.addChild(root_1, stream_inFmt.nextNode());

                        adaptor.addChild(root_1, stream_outFmt.nextNode());

                        adaptor.addChild(root_1, stream_serdeCls.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1288:58: ( $inDriver)?
                        if ( stream_inDriver.hasNext() ) {
                            adaptor.addChild(root_1, stream_inDriver.nextNode());

                        }
                        stream_inDriver.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1288:69: ( $outDriver)?
                        if ( stream_outDriver.hasNext() ) {
                            adaptor.addChild(root_1, stream_outDriver.nextNode());

                        }
                        stream_outDriver.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1289:7: genericSpec= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_fileFormat6162);
                    genericSpec=identifier();

                    state._fsp--;

                    stream_identifier.add(genericSpec.getTree());

                    // AST REWRITE
                    // elements: genericSpec
                    // token labels: 
                    // rule labels: retval, genericSpec
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_genericSpec=new RewriteRuleSubtreeStream(adaptor,"rule genericSpec",genericSpec!=null?genericSpec.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1289:30: -> ^( TOK_FILEFORMAT_GENERIC $genericSpec)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1289:33: ^( TOK_FILEFORMAT_GENERIC $genericSpec)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_FILEFORMAT_GENERIC, "TOK_FILEFORMAT_GENERIC")
                        , root_1);

                        adaptor.addChild(root_1, stream_genericSpec.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fileFormat"


    public static class tabTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tabTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1292:1: tabTypeExpr : identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ;
    public final HiveParser.tabTypeExpr_return tabTypeExpr() throws RecognitionException {
        HiveParser.tabTypeExpr_return retval = new HiveParser.tabTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token DOT358=null;
        Token KW_ELEM_TYPE359=null;
        Token KW_KEY_TYPE360=null;
        Token KW_VALUE_TYPE361=null;
        HiveParser_IdentifiersParser.identifier_return identifier357 =null;

        HiveParser_IdentifiersParser.identifier_return identifier362 =null;


        CommonTree DOT358_tree=null;
        CommonTree KW_ELEM_TYPE359_tree=null;
        CommonTree KW_KEY_TYPE360_tree=null;
        CommonTree KW_VALUE_TYPE361_tree=null;

         pushMsg("specifying table types", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:4: ( identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:6: identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_identifier_in_tabTypeExpr6198);
            identifier357=identifier();

            state._fsp--;

            adaptor.addChild(root_0, identifier357.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:17: ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            loop98:
            do {
                int alt98=2;
                switch ( input.LA(1) ) {
                case DOT:
                    {
                    alt98=1;
                    }
                    break;

                }

                switch (alt98) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:18: DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    {
            	    DOT358=(Token)match(input,DOT,FOLLOW_DOT_in_tabTypeExpr6201); 
            	    DOT358_tree = 
            	    (CommonTree)adaptor.create(DOT358)
            	    ;
            	    root_0 = (CommonTree)adaptor.becomeRoot(DOT358_tree, root_0);


            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:23: ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    int alt97=4;
            	    switch ( input.LA(1) ) {
            	    case KW_ELEM_TYPE:
            	        {
            	        alt97=1;
            	        }
            	        break;
            	    case KW_KEY_TYPE:
            	        {
            	        alt97=2;
            	        }
            	        break;
            	    case KW_VALUE_TYPE:
            	        {
            	        alt97=3;
            	        }
            	        break;
            	    case Identifier:
            	    case KW_ADD:
            	    case KW_ADMIN:
            	    case KW_AFTER:
            	    case KW_ALL:
            	    case KW_ALTER:
            	    case KW_ANALYZE:
            	    case KW_ARCHIVE:
            	    case KW_ARRAY:
            	    case KW_AS:
            	    case KW_ASC:
            	    case KW_AUTHORIZATION:
            	    case KW_BEFORE:
            	    case KW_BETWEEN:
            	    case KW_BIGINT:
            	    case KW_BINARY:
            	    case KW_BOOLEAN:
            	    case KW_BOTH:
            	    case KW_BUCKET:
            	    case KW_BUCKETS:
            	    case KW_BY:
            	    case KW_CASCADE:
            	    case KW_CHANGE:
            	    case KW_CLUSTER:
            	    case KW_CLUSTERED:
            	    case KW_CLUSTERSTATUS:
            	    case KW_COLLECTION:
            	    case KW_COLUMNS:
            	    case KW_COMMENT:
            	    case KW_COMPACT:
            	    case KW_COMPACTIONS:
            	    case KW_COMPUTE:
            	    case KW_CONCATENATE:
            	    case KW_CONTINUE:
            	    case KW_CREATE:
            	    case KW_CUBE:
            	    case KW_CURSOR:
            	    case KW_DATA:
            	    case KW_DATABASES:
            	    case KW_DATE:
            	    case KW_DATETIME:
            	    case KW_DBPROPERTIES:
            	    case KW_DECIMAL:
            	    case KW_DEFAULT:
            	    case KW_DEFERRED:
            	    case KW_DEFINED:
            	    case KW_DELETE:
            	    case KW_DELIMITED:
            	    case KW_DEPENDENCY:
            	    case KW_DESC:
            	    case KW_DESCRIBE:
            	    case KW_DIRECTORIES:
            	    case KW_DIRECTORY:
            	    case KW_DISABLE:
            	    case KW_DISTRIBUTE:
            	    case KW_DOUBLE:
            	    case KW_DROP:
            	    case KW_ENABLE:
            	    case KW_ESCAPED:
            	    case KW_EXCLUSIVE:
            	    case KW_EXISTS:
            	    case KW_EXPLAIN:
            	    case KW_EXPORT:
            	    case KW_EXTERNAL:
            	    case KW_FALSE:
            	    case KW_FETCH:
            	    case KW_FIELDS:
            	    case KW_FILE:
            	    case KW_FILEFORMAT:
            	    case KW_FIRST:
            	    case KW_FLOAT:
            	    case KW_FOR:
            	    case KW_FORMAT:
            	    case KW_FORMATTED:
            	    case KW_FULL:
            	    case KW_FUNCTIONS:
            	    case KW_GRANT:
            	    case KW_GROUP:
            	    case KW_GROUPING:
            	    case KW_HOLD_DDLTIME:
            	    case KW_IDXPROPERTIES:
            	    case KW_IGNORE:
            	    case KW_IMPORT:
            	    case KW_IN:
            	    case KW_INDEX:
            	    case KW_INDEXES:
            	    case KW_INNER:
            	    case KW_INPATH:
            	    case KW_INPUTDRIVER:
            	    case KW_INPUTFORMAT:
            	    case KW_INSERT:
            	    case KW_INT:
            	    case KW_INTERSECT:
            	    case KW_INTO:
            	    case KW_IS:
            	    case KW_ITEMS:
            	    case KW_JAR:
            	    case KW_KEYS:
            	    case KW_LATERAL:
            	    case KW_LEFT:
            	    case KW_LIKE:
            	    case KW_LIMIT:
            	    case KW_LINES:
            	    case KW_LOAD:
            	    case KW_LOCAL:
            	    case KW_LOCATION:
            	    case KW_LOCK:
            	    case KW_LOCKS:
            	    case KW_LOGICAL:
            	    case KW_LONG:
            	    case KW_MAPJOIN:
            	    case KW_MATERIALIZED:
            	    case KW_MINUS:
            	    case KW_MSCK:
            	    case KW_NONE:
            	    case KW_NOSCAN:
            	    case KW_NO_DROP:
            	    case KW_NULL:
            	    case KW_OF:
            	    case KW_OFFLINE:
            	    case KW_OPTION:
            	    case KW_ORDER:
            	    case KW_OUT:
            	    case KW_OUTER:
            	    case KW_OUTPUTDRIVER:
            	    case KW_OUTPUTFORMAT:
            	    case KW_OVERWRITE:
            	    case KW_OWNER:
            	    case KW_PARTITION:
            	    case KW_PARTITIONED:
            	    case KW_PARTITIONS:
            	    case KW_PERCENT:
            	    case KW_PLUS:
            	    case KW_PRETTY:
            	    case KW_PRINCIPALS:
            	    case KW_PROCEDURE:
            	    case KW_PROTECTION:
            	    case KW_PURGE:
            	    case KW_RANGE:
            	    case KW_READ:
            	    case KW_READONLY:
            	    case KW_READS:
            	    case KW_REBUILD:
            	    case KW_RECORDREADER:
            	    case KW_RECORDWRITER:
            	    case KW_REGEXP:
            	    case KW_RENAME:
            	    case KW_REPAIR:
            	    case KW_REPLACE:
            	    case KW_RESTRICT:
            	    case KW_REVOKE:
            	    case KW_REWRITE:
            	    case KW_RIGHT:
            	    case KW_RLIKE:
            	    case KW_ROLE:
            	    case KW_ROLES:
            	    case KW_ROLLUP:
            	    case KW_ROW:
            	    case KW_ROWS:
            	    case KW_SCHEMA:
            	    case KW_SCHEMAS:
            	    case KW_SEMI:
            	    case KW_SERDE:
            	    case KW_SERDEPROPERTIES:
            	    case KW_SERVER:
            	    case KW_SET:
            	    case KW_SETS:
            	    case KW_SHARED:
            	    case KW_SHOW:
            	    case KW_SHOW_DATABASE:
            	    case KW_SKEWED:
            	    case KW_SMALLINT:
            	    case KW_SORT:
            	    case KW_SORTED:
            	    case KW_SSL:
            	    case KW_STATISTICS:
            	    case KW_STORED:
            	    case KW_STREAMTABLE:
            	    case KW_STRING:
            	    case KW_STRUCT:
            	    case KW_TABLE:
            	    case KW_TABLES:
            	    case KW_TBLPROPERTIES:
            	    case KW_TEMPORARY:
            	    case KW_TERMINATED:
            	    case KW_TIMESTAMP:
            	    case KW_TINYINT:
            	    case KW_TO:
            	    case KW_TOUCH:
            	    case KW_TRANSACTIONS:
            	    case KW_TRIGGER:
            	    case KW_TRUE:
            	    case KW_TRUNCATE:
            	    case KW_UNARCHIVE:
            	    case KW_UNDO:
            	    case KW_UNION:
            	    case KW_UNIONTYPE:
            	    case KW_UNLOCK:
            	    case KW_UNSET:
            	    case KW_UNSIGNED:
            	    case KW_UPDATE:
            	    case KW_URI:
            	    case KW_USE:
            	    case KW_USER:
            	    case KW_USING:
            	    case KW_UTC:
            	    case KW_UTCTIMESTAMP:
            	    case KW_VALUES:
            	    case KW_VIEW:
            	    case KW_WHILE:
            	    case KW_WITH:
            	        {
            	        alt97=4;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 97, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt97) {
            	        case 1 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:24: KW_ELEM_TYPE
            	            {
            	            KW_ELEM_TYPE359=(Token)match(input,KW_ELEM_TYPE,FOLLOW_KW_ELEM_TYPE_in_tabTypeExpr6205); 
            	            KW_ELEM_TYPE359_tree = 
            	            (CommonTree)adaptor.create(KW_ELEM_TYPE359)
            	            ;
            	            adaptor.addChild(root_0, KW_ELEM_TYPE359_tree);


            	            }
            	            break;
            	        case 2 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:39: KW_KEY_TYPE
            	            {
            	            KW_KEY_TYPE360=(Token)match(input,KW_KEY_TYPE,FOLLOW_KW_KEY_TYPE_in_tabTypeExpr6209); 
            	            KW_KEY_TYPE360_tree = 
            	            (CommonTree)adaptor.create(KW_KEY_TYPE360)
            	            ;
            	            adaptor.addChild(root_0, KW_KEY_TYPE360_tree);


            	            }
            	            break;
            	        case 3 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:53: KW_VALUE_TYPE
            	            {
            	            KW_VALUE_TYPE361=(Token)match(input,KW_VALUE_TYPE,FOLLOW_KW_VALUE_TYPE_in_tabTypeExpr6213); 
            	            KW_VALUE_TYPE361_tree = 
            	            (CommonTree)adaptor.create(KW_VALUE_TYPE361)
            	            ;
            	            adaptor.addChild(root_0, KW_VALUE_TYPE361_tree);


            	            }
            	            break;
            	        case 4 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:69: identifier
            	            {
            	            pushFollow(FOLLOW_identifier_in_tabTypeExpr6217);
            	            identifier362=identifier();

            	            state._fsp--;

            	            adaptor.addChild(root_0, identifier362.getTree());

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop98;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tabTypeExpr"


    public static class descTabTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descTabTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1299:1: descTabTypeExpr : identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )? ;
    public final HiveParser.descTabTypeExpr_return descTabTypeExpr() throws RecognitionException {
        HiveParser.descTabTypeExpr_return retval = new HiveParser.descTabTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token DOT364=null;
        Token KW_ELEM_TYPE365=null;
        Token KW_KEY_TYPE366=null;
        Token KW_VALUE_TYPE367=null;
        HiveParser_IdentifiersParser.identifier_return identifier363 =null;

        HiveParser_IdentifiersParser.identifier_return identifier368 =null;

        HiveParser_IdentifiersParser.identifier_return identifier369 =null;


        CommonTree DOT364_tree=null;
        CommonTree KW_ELEM_TYPE365_tree=null;
        CommonTree KW_KEY_TYPE366_tree=null;
        CommonTree KW_VALUE_TYPE367_tree=null;

         pushMsg("specifying describe table types", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:4: ( identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )? )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:6: identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_identifier_in_descTabTypeExpr6246);
            identifier363=identifier();

            state._fsp--;

            adaptor.addChild(root_0, identifier363.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:17: ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            loop100:
            do {
                int alt100=2;
                switch ( input.LA(1) ) {
                case DOT:
                    {
                    alt100=1;
                    }
                    break;

                }

                switch (alt100) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:18: DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    {
            	    DOT364=(Token)match(input,DOT,FOLLOW_DOT_in_descTabTypeExpr6249); 
            	    DOT364_tree = 
            	    (CommonTree)adaptor.create(DOT364)
            	    ;
            	    root_0 = (CommonTree)adaptor.becomeRoot(DOT364_tree, root_0);


            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:23: ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    int alt99=4;
            	    switch ( input.LA(1) ) {
            	    case KW_ELEM_TYPE:
            	        {
            	        alt99=1;
            	        }
            	        break;
            	    case KW_KEY_TYPE:
            	        {
            	        alt99=2;
            	        }
            	        break;
            	    case KW_VALUE_TYPE:
            	        {
            	        alt99=3;
            	        }
            	        break;
            	    case Identifier:
            	    case KW_ADD:
            	    case KW_ADMIN:
            	    case KW_AFTER:
            	    case KW_ALL:
            	    case KW_ALTER:
            	    case KW_ANALYZE:
            	    case KW_ARCHIVE:
            	    case KW_ARRAY:
            	    case KW_AS:
            	    case KW_ASC:
            	    case KW_AUTHORIZATION:
            	    case KW_BEFORE:
            	    case KW_BETWEEN:
            	    case KW_BIGINT:
            	    case KW_BINARY:
            	    case KW_BOOLEAN:
            	    case KW_BOTH:
            	    case KW_BUCKET:
            	    case KW_BUCKETS:
            	    case KW_BY:
            	    case KW_CASCADE:
            	    case KW_CHANGE:
            	    case KW_CLUSTER:
            	    case KW_CLUSTERED:
            	    case KW_CLUSTERSTATUS:
            	    case KW_COLLECTION:
            	    case KW_COLUMNS:
            	    case KW_COMMENT:
            	    case KW_COMPACT:
            	    case KW_COMPACTIONS:
            	    case KW_COMPUTE:
            	    case KW_CONCATENATE:
            	    case KW_CONTINUE:
            	    case KW_CREATE:
            	    case KW_CUBE:
            	    case KW_CURSOR:
            	    case KW_DATA:
            	    case KW_DATABASES:
            	    case KW_DATE:
            	    case KW_DATETIME:
            	    case KW_DBPROPERTIES:
            	    case KW_DECIMAL:
            	    case KW_DEFAULT:
            	    case KW_DEFERRED:
            	    case KW_DEFINED:
            	    case KW_DELETE:
            	    case KW_DELIMITED:
            	    case KW_DEPENDENCY:
            	    case KW_DESC:
            	    case KW_DESCRIBE:
            	    case KW_DIRECTORIES:
            	    case KW_DIRECTORY:
            	    case KW_DISABLE:
            	    case KW_DISTRIBUTE:
            	    case KW_DOUBLE:
            	    case KW_DROP:
            	    case KW_ENABLE:
            	    case KW_ESCAPED:
            	    case KW_EXCLUSIVE:
            	    case KW_EXISTS:
            	    case KW_EXPLAIN:
            	    case KW_EXPORT:
            	    case KW_EXTERNAL:
            	    case KW_FALSE:
            	    case KW_FETCH:
            	    case KW_FIELDS:
            	    case KW_FILE:
            	    case KW_FILEFORMAT:
            	    case KW_FIRST:
            	    case KW_FLOAT:
            	    case KW_FOR:
            	    case KW_FORMAT:
            	    case KW_FORMATTED:
            	    case KW_FULL:
            	    case KW_FUNCTIONS:
            	    case KW_GRANT:
            	    case KW_GROUP:
            	    case KW_GROUPING:
            	    case KW_HOLD_DDLTIME:
            	    case KW_IDXPROPERTIES:
            	    case KW_IGNORE:
            	    case KW_IMPORT:
            	    case KW_IN:
            	    case KW_INDEX:
            	    case KW_INDEXES:
            	    case KW_INNER:
            	    case KW_INPATH:
            	    case KW_INPUTDRIVER:
            	    case KW_INPUTFORMAT:
            	    case KW_INSERT:
            	    case KW_INT:
            	    case KW_INTERSECT:
            	    case KW_INTO:
            	    case KW_IS:
            	    case KW_ITEMS:
            	    case KW_JAR:
            	    case KW_KEYS:
            	    case KW_LATERAL:
            	    case KW_LEFT:
            	    case KW_LIKE:
            	    case KW_LIMIT:
            	    case KW_LINES:
            	    case KW_LOAD:
            	    case KW_LOCAL:
            	    case KW_LOCATION:
            	    case KW_LOCK:
            	    case KW_LOCKS:
            	    case KW_LOGICAL:
            	    case KW_LONG:
            	    case KW_MAPJOIN:
            	    case KW_MATERIALIZED:
            	    case KW_MINUS:
            	    case KW_MSCK:
            	    case KW_NONE:
            	    case KW_NOSCAN:
            	    case KW_NO_DROP:
            	    case KW_NULL:
            	    case KW_OF:
            	    case KW_OFFLINE:
            	    case KW_OPTION:
            	    case KW_ORDER:
            	    case KW_OUT:
            	    case KW_OUTER:
            	    case KW_OUTPUTDRIVER:
            	    case KW_OUTPUTFORMAT:
            	    case KW_OVERWRITE:
            	    case KW_OWNER:
            	    case KW_PARTITION:
            	    case KW_PARTITIONED:
            	    case KW_PARTITIONS:
            	    case KW_PERCENT:
            	    case KW_PLUS:
            	    case KW_PRETTY:
            	    case KW_PRINCIPALS:
            	    case KW_PROCEDURE:
            	    case KW_PROTECTION:
            	    case KW_PURGE:
            	    case KW_RANGE:
            	    case KW_READ:
            	    case KW_READONLY:
            	    case KW_READS:
            	    case KW_REBUILD:
            	    case KW_RECORDREADER:
            	    case KW_RECORDWRITER:
            	    case KW_REGEXP:
            	    case KW_RENAME:
            	    case KW_REPAIR:
            	    case KW_REPLACE:
            	    case KW_RESTRICT:
            	    case KW_REVOKE:
            	    case KW_REWRITE:
            	    case KW_RIGHT:
            	    case KW_RLIKE:
            	    case KW_ROLE:
            	    case KW_ROLES:
            	    case KW_ROLLUP:
            	    case KW_ROW:
            	    case KW_ROWS:
            	    case KW_SCHEMA:
            	    case KW_SCHEMAS:
            	    case KW_SEMI:
            	    case KW_SERDE:
            	    case KW_SERDEPROPERTIES:
            	    case KW_SERVER:
            	    case KW_SET:
            	    case KW_SETS:
            	    case KW_SHARED:
            	    case KW_SHOW:
            	    case KW_SHOW_DATABASE:
            	    case KW_SKEWED:
            	    case KW_SMALLINT:
            	    case KW_SORT:
            	    case KW_SORTED:
            	    case KW_SSL:
            	    case KW_STATISTICS:
            	    case KW_STORED:
            	    case KW_STREAMTABLE:
            	    case KW_STRING:
            	    case KW_STRUCT:
            	    case KW_TABLE:
            	    case KW_TABLES:
            	    case KW_TBLPROPERTIES:
            	    case KW_TEMPORARY:
            	    case KW_TERMINATED:
            	    case KW_TIMESTAMP:
            	    case KW_TINYINT:
            	    case KW_TO:
            	    case KW_TOUCH:
            	    case KW_TRANSACTIONS:
            	    case KW_TRIGGER:
            	    case KW_TRUE:
            	    case KW_TRUNCATE:
            	    case KW_UNARCHIVE:
            	    case KW_UNDO:
            	    case KW_UNION:
            	    case KW_UNIONTYPE:
            	    case KW_UNLOCK:
            	    case KW_UNSET:
            	    case KW_UNSIGNED:
            	    case KW_UPDATE:
            	    case KW_URI:
            	    case KW_USE:
            	    case KW_USER:
            	    case KW_USING:
            	    case KW_UTC:
            	    case KW_UTCTIMESTAMP:
            	    case KW_VALUES:
            	    case KW_VIEW:
            	    case KW_WHILE:
            	    case KW_WITH:
            	        {
            	        alt99=4;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 99, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt99) {
            	        case 1 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:24: KW_ELEM_TYPE
            	            {
            	            KW_ELEM_TYPE365=(Token)match(input,KW_ELEM_TYPE,FOLLOW_KW_ELEM_TYPE_in_descTabTypeExpr6253); 
            	            KW_ELEM_TYPE365_tree = 
            	            (CommonTree)adaptor.create(KW_ELEM_TYPE365)
            	            ;
            	            adaptor.addChild(root_0, KW_ELEM_TYPE365_tree);


            	            }
            	            break;
            	        case 2 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:39: KW_KEY_TYPE
            	            {
            	            KW_KEY_TYPE366=(Token)match(input,KW_KEY_TYPE,FOLLOW_KW_KEY_TYPE_in_descTabTypeExpr6257); 
            	            KW_KEY_TYPE366_tree = 
            	            (CommonTree)adaptor.create(KW_KEY_TYPE366)
            	            ;
            	            adaptor.addChild(root_0, KW_KEY_TYPE366_tree);


            	            }
            	            break;
            	        case 3 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:53: KW_VALUE_TYPE
            	            {
            	            KW_VALUE_TYPE367=(Token)match(input,KW_VALUE_TYPE,FOLLOW_KW_VALUE_TYPE_in_descTabTypeExpr6261); 
            	            KW_VALUE_TYPE367_tree = 
            	            (CommonTree)adaptor.create(KW_VALUE_TYPE367)
            	            ;
            	            adaptor.addChild(root_0, KW_VALUE_TYPE367_tree);


            	            }
            	            break;
            	        case 4 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:69: identifier
            	            {
            	            pushFollow(FOLLOW_identifier_in_descTabTypeExpr6265);
            	            identifier368=identifier();

            	            state._fsp--;

            	            adaptor.addChild(root_0, identifier368.getTree());

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop100;
                }
            } while (true);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:83: ( identifier )?
            int alt101=2;
            switch ( input.LA(1) ) {
                case Identifier:
                case KW_ADD:
                case KW_ADMIN:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_AUTHORIZATION:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPACT:
                case KW_COMPACTIONS:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILE:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_JAR:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_OWNER:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PRINCIPALS:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_REWRITE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRANSACTIONS:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUES:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt101=1;
                    }
                    break;
                case KW_PARTITION:
                    {
                    switch ( input.LA(2) ) {
                        case EOF:
                        case KW_PARTITION:
                            {
                            alt101=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt101) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:83: identifier
                    {
                    pushFollow(FOLLOW_identifier_in_descTabTypeExpr6270);
                    identifier369=identifier();

                    state._fsp--;

                    adaptor.addChild(root_0, identifier369.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descTabTypeExpr"


    public static class partTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "partTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1306:1: partTypeExpr : tabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? ) ;
    public final HiveParser.partTypeExpr_return partTypeExpr() throws RecognitionException {
        HiveParser.partTypeExpr_return retval = new HiveParser.partTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.tabTypeExpr_return tabTypeExpr370 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec371 =null;


        RewriteRuleSubtreeStream stream_tabTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule tabTypeExpr");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("specifying table partitions", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1309:5: ( tabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1309:8: tabTypeExpr ( partitionSpec )?
            {
            pushFollow(FOLLOW_tabTypeExpr_in_partTypeExpr6298);
            tabTypeExpr370=tabTypeExpr();

            state._fsp--;

            stream_tabTypeExpr.add(tabTypeExpr370.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1309:20: ( partitionSpec )?
            int alt102=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt102=1;
                    }
                    break;
            }

            switch (alt102) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1309:20: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_partTypeExpr6300);
                    partitionSpec371=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec371.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, tabTypeExpr
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1309:35: -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1309:38: ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABTYPE, "TOK_TABTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_tabTypeExpr.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1309:64: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "partTypeExpr"


    public static class descPartTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descPartTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:1: descPartTypeExpr : descTabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? ) ;
    public final HiveParser.descPartTypeExpr_return descPartTypeExpr() throws RecognitionException {
        HiveParser.descPartTypeExpr_return retval = new HiveParser.descPartTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.descTabTypeExpr_return descTabTypeExpr372 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec373 =null;


        RewriteRuleSubtreeStream stream_descTabTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule descTabTypeExpr");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("specifying describe table partitions", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:5: ( descTabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:8: descTabTypeExpr ( partitionSpec )?
            {
            pushFollow(FOLLOW_descTabTypeExpr_in_descPartTypeExpr6340);
            descTabTypeExpr372=descTabTypeExpr();

            state._fsp--;

            stream_descTabTypeExpr.add(descTabTypeExpr372.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:24: ( partitionSpec )?
            int alt103=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt103=1;
                    }
                    break;
            }

            switch (alt103) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:24: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_descPartTypeExpr6342);
                    partitionSpec373=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec373.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: descTabTypeExpr, partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1315:39: -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:42: ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABTYPE, "TOK_TABTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_descTabTypeExpr.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:72: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descPartTypeExpr"


    public static class descStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:1: descStatement : ( ( KW_DESCRIBE | KW_DESC ) ( KW_DATABASE | KW_SCHEMA ) ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) | ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr ) -> ^( TOK_DESCTABLE $parttype ( $descOptions)? ) | ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) );
    public final HiveParser.descStatement_return descStatement() throws RecognitionException {
        HiveParser.descStatement_return retval = new HiveParser.descStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token descOptions=null;
        Token KW_DESCRIBE374=null;
        Token KW_DESC375=null;
        Token KW_DATABASE376=null;
        Token KW_SCHEMA377=null;
        Token KW_EXTENDED378=null;
        Token KW_DESCRIBE379=null;
        Token KW_DESC380=null;
        Token KW_DESCRIBE381=null;
        Token KW_DESC382=null;
        Token KW_FUNCTION383=null;
        Token KW_EXTENDED384=null;
        HiveParser_IdentifiersParser.identifier_return dbName =null;

        HiveParser.descPartTypeExpr_return parttype =null;

        HiveParser_IdentifiersParser.descFuncNames_return name =null;


        CommonTree descOptions_tree=null;
        CommonTree KW_DESCRIBE374_tree=null;
        CommonTree KW_DESC375_tree=null;
        CommonTree KW_DATABASE376_tree=null;
        CommonTree KW_SCHEMA377_tree=null;
        CommonTree KW_EXTENDED378_tree=null;
        CommonTree KW_DESCRIBE379_tree=null;
        CommonTree KW_DESC380_tree=null;
        CommonTree KW_DESCRIBE381_tree=null;
        CommonTree KW_DESC382_tree=null;
        CommonTree KW_FUNCTION383_tree=null;
        CommonTree KW_EXTENDED384_tree=null;
        RewriteRuleTokenStream stream_KW_DESC=new RewriteRuleTokenStream(adaptor,"token KW_DESC");
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_FUNCTION=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTION");
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_PRETTY=new RewriteRuleTokenStream(adaptor,"token KW_PRETTY");
        RewriteRuleTokenStream stream_KW_DESCRIBE=new RewriteRuleTokenStream(adaptor,"token KW_DESCRIBE");
        RewriteRuleSubtreeStream stream_descPartTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule descPartTypeExpr");
        RewriteRuleSubtreeStream stream_descFuncNames=new RewriteRuleSubtreeStream(adaptor,"rule descFuncNames");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("describe statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:5: ( ( KW_DESCRIBE | KW_DESC ) ( KW_DATABASE | KW_SCHEMA ) ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) | ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr ) -> ^( TOK_DESCTABLE $parttype ( $descOptions)? ) | ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) )
            int alt111=3;
            switch ( input.LA(1) ) {
            case KW_DESCRIBE:
                {
                switch ( input.LA(2) ) {
                case KW_DATABASE:
                    {
                    alt111=1;
                    }
                    break;
                case KW_SCHEMA:
                    {
                    switch ( input.LA(3) ) {
                    case KW_EXTENDED:
                        {
                        alt111=1;
                        }
                        break;
                    case Identifier:
                        {
                        alt111=1;
                        }
                        break;
                    case KW_PARTITION:
                        {
                        alt111=1;
                        }
                        break;
                    case EOF:
                    case DOT:
                        {
                        alt111=2;
                        }
                        break;
                    case KW_ADD:
                    case KW_ADMIN:
                    case KW_AFTER:
                    case KW_ALL:
                    case KW_ALTER:
                    case KW_ANALYZE:
                    case KW_ARCHIVE:
                    case KW_ARRAY:
                    case KW_AS:
                    case KW_ASC:
                    case KW_AUTHORIZATION:
                    case KW_BEFORE:
                    case KW_BETWEEN:
                    case KW_BIGINT:
                    case KW_BINARY:
                    case KW_BOOLEAN:
                    case KW_BOTH:
                    case KW_BUCKET:
                    case KW_BUCKETS:
                    case KW_BY:
                    case KW_CASCADE:
                    case KW_CHANGE:
                    case KW_CLUSTER:
                    case KW_CLUSTERED:
                    case KW_CLUSTERSTATUS:
                    case KW_COLLECTION:
                    case KW_COLUMNS:
                    case KW_COMMENT:
                    case KW_COMPACT:
                    case KW_COMPACTIONS:
                    case KW_COMPUTE:
                    case KW_CONCATENATE:
                    case KW_CONTINUE:
                    case KW_CREATE:
                    case KW_CUBE:
                    case KW_CURSOR:
                    case KW_DATA:
                    case KW_DATABASES:
                    case KW_DATE:
                    case KW_DATETIME:
                    case KW_DBPROPERTIES:
                    case KW_DECIMAL:
                    case KW_DEFAULT:
                    case KW_DEFERRED:
                    case KW_DEFINED:
                    case KW_DELETE:
                    case KW_DELIMITED:
                    case KW_DEPENDENCY:
                    case KW_DESC:
                    case KW_DESCRIBE:
                    case KW_DIRECTORIES:
                    case KW_DIRECTORY:
                    case KW_DISABLE:
                    case KW_DISTRIBUTE:
                    case KW_DOUBLE:
                    case KW_DROP:
                    case KW_ELEM_TYPE:
                    case KW_ENABLE:
                    case KW_ESCAPED:
                    case KW_EXCLUSIVE:
                    case KW_EXISTS:
                    case KW_EXPLAIN:
                    case KW_EXPORT:
                    case KW_EXTERNAL:
                    case KW_FALSE:
                    case KW_FETCH:
                    case KW_FIELDS:
                    case KW_FILE:
                    case KW_FILEFORMAT:
                    case KW_FIRST:
                    case KW_FLOAT:
                    case KW_FOR:
                    case KW_FORMAT:
                    case KW_FORMATTED:
                    case KW_FULL:
                    case KW_FUNCTIONS:
                    case KW_GRANT:
                    case KW_GROUP:
                    case KW_GROUPING:
                    case KW_HOLD_DDLTIME:
                    case KW_IDXPROPERTIES:
                    case KW_IGNORE:
                    case KW_IMPORT:
                    case KW_IN:
                    case KW_INDEX:
                    case KW_INDEXES:
                    case KW_INNER:
                    case KW_INPATH:
                    case KW_INPUTDRIVER:
                    case KW_INPUTFORMAT:
                    case KW_INSERT:
                    case KW_INT:
                    case KW_INTERSECT:
                    case KW_INTO:
                    case KW_IS:
                    case KW_ITEMS:
                    case KW_JAR:
                    case KW_KEYS:
                    case KW_KEY_TYPE:
                    case KW_LATERAL:
                    case KW_LEFT:
                    case KW_LIKE:
                    case KW_LIMIT:
                    case KW_LINES:
                    case KW_LOAD:
                    case KW_LOCAL:
                    case KW_LOCATION:
                    case KW_LOCK:
                    case KW_LOCKS:
                    case KW_LOGICAL:
                    case KW_LONG:
                    case KW_MAPJOIN:
                    case KW_MATERIALIZED:
                    case KW_MINUS:
                    case KW_MSCK:
                    case KW_NONE:
                    case KW_NOSCAN:
                    case KW_NO_DROP:
                    case KW_NULL:
                    case KW_OF:
                    case KW_OFFLINE:
                    case KW_OPTION:
                    case KW_ORDER:
                    case KW_OUT:
                    case KW_OUTER:
                    case KW_OUTPUTDRIVER:
                    case KW_OUTPUTFORMAT:
                    case KW_OVERWRITE:
                    case KW_OWNER:
                    case KW_PARTITIONED:
                    case KW_PARTITIONS:
                    case KW_PERCENT:
                    case KW_PLUS:
                    case KW_PRETTY:
                    case KW_PRINCIPALS:
                    case KW_PROCEDURE:
                    case KW_PROTECTION:
                    case KW_PURGE:
                    case KW_RANGE:
                    case KW_READ:
                    case KW_READONLY:
                    case KW_READS:
                    case KW_REBUILD:
                    case KW_RECORDREADER:
                    case KW_RECORDWRITER:
                    case KW_REGEXP:
                    case KW_RENAME:
                    case KW_REPAIR:
                    case KW_REPLACE:
                    case KW_RESTRICT:
                    case KW_REVOKE:
                    case KW_REWRITE:
                    case KW_RIGHT:
                    case KW_RLIKE:
                    case KW_ROLE:
                    case KW_ROLES:
                    case KW_ROLLUP:
                    case KW_ROW:
                    case KW_ROWS:
                    case KW_SCHEMA:
                    case KW_SCHEMAS:
                    case KW_SEMI:
                    case KW_SERDE:
                    case KW_SERDEPROPERTIES:
                    case KW_SERVER:
                    case KW_SET:
                    case KW_SETS:
                    case KW_SHARED:
                    case KW_SHOW:
                    case KW_SHOW_DATABASE:
                    case KW_SKEWED:
                    case KW_SMALLINT:
                    case KW_SORT:
                    case KW_SORTED:
                    case KW_SSL:
                    case KW_STATISTICS:
                    case KW_STORED:
                    case KW_STREAMTABLE:
                    case KW_STRING:
                    case KW_STRUCT:
                    case KW_TABLE:
                    case KW_TABLES:
                    case KW_TBLPROPERTIES:
                    case KW_TEMPORARY:
                    case KW_TERMINATED:
                    case KW_TIMESTAMP:
                    case KW_TINYINT:
                    case KW_TO:
                    case KW_TOUCH:
                    case KW_TRANSACTIONS:
                    case KW_TRIGGER:
                    case KW_TRUE:
                    case KW_TRUNCATE:
                    case KW_UNARCHIVE:
                    case KW_UNDO:
                    case KW_UNION:
                    case KW_UNIONTYPE:
                    case KW_UNLOCK:
                    case KW_UNSET:
                    case KW_UNSIGNED:
                    case KW_UPDATE:
                    case KW_URI:
                    case KW_USE:
                    case KW_USER:
                    case KW_USING:
                    case KW_UTC:
                    case KW_UTCTIMESTAMP:
                    case KW_VALUES:
                    case KW_VALUE_TYPE:
                    case KW_VIEW:
                    case KW_WHILE:
                    case KW_WITH:
                        {
                        alt111=1;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 111, 4, input);

                        throw nvae;

                    }

                    }
                    break;
                case Identifier:
                case KW_ADD:
                case KW_ADMIN:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_AUTHORIZATION:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPACT:
                case KW_COMPACTIONS:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTENDED:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILE:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_JAR:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_OWNER:
                case KW_PARTITION:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PRINCIPALS:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_REWRITE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRANSACTIONS:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUES:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt111=2;
                    }
                    break;
                case KW_FUNCTION:
                    {
                    alt111=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 111, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_DESC:
                {
                switch ( input.LA(2) ) {
                case KW_DATABASE:
                    {
                    alt111=1;
                    }
                    break;
                case KW_SCHEMA:
                    {
                    switch ( input.LA(3) ) {
                    case KW_EXTENDED:
                        {
                        alt111=1;
                        }
                        break;
                    case Identifier:
                        {
                        alt111=1;
                        }
                        break;
                    case KW_PARTITION:
                        {
                        alt111=1;
                        }
                        break;
                    case EOF:
                    case DOT:
                        {
                        alt111=2;
                        }
                        break;
                    case KW_ADD:
                    case KW_ADMIN:
                    case KW_AFTER:
                    case KW_ALL:
                    case KW_ALTER:
                    case KW_ANALYZE:
                    case KW_ARCHIVE:
                    case KW_ARRAY:
                    case KW_AS:
                    case KW_ASC:
                    case KW_AUTHORIZATION:
                    case KW_BEFORE:
                    case KW_BETWEEN:
                    case KW_BIGINT:
                    case KW_BINARY:
                    case KW_BOOLEAN:
                    case KW_BOTH:
                    case KW_BUCKET:
                    case KW_BUCKETS:
                    case KW_BY:
                    case KW_CASCADE:
                    case KW_CHANGE:
                    case KW_CLUSTER:
                    case KW_CLUSTERED:
                    case KW_CLUSTERSTATUS:
                    case KW_COLLECTION:
                    case KW_COLUMNS:
                    case KW_COMMENT:
                    case KW_COMPACT:
                    case KW_COMPACTIONS:
                    case KW_COMPUTE:
                    case KW_CONCATENATE:
                    case KW_CONTINUE:
                    case KW_CREATE:
                    case KW_CUBE:
                    case KW_CURSOR:
                    case KW_DATA:
                    case KW_DATABASES:
                    case KW_DATE:
                    case KW_DATETIME:
                    case KW_DBPROPERTIES:
                    case KW_DECIMAL:
                    case KW_DEFAULT:
                    case KW_DEFERRED:
                    case KW_DEFINED:
                    case KW_DELETE:
                    case KW_DELIMITED:
                    case KW_DEPENDENCY:
                    case KW_DESC:
                    case KW_DESCRIBE:
                    case KW_DIRECTORIES:
                    case KW_DIRECTORY:
                    case KW_DISABLE:
                    case KW_DISTRIBUTE:
                    case KW_DOUBLE:
                    case KW_DROP:
                    case KW_ELEM_TYPE:
                    case KW_ENABLE:
                    case KW_ESCAPED:
                    case KW_EXCLUSIVE:
                    case KW_EXISTS:
                    case KW_EXPLAIN:
                    case KW_EXPORT:
                    case KW_EXTERNAL:
                    case KW_FALSE:
                    case KW_FETCH:
                    case KW_FIELDS:
                    case KW_FILE:
                    case KW_FILEFORMAT:
                    case KW_FIRST:
                    case KW_FLOAT:
                    case KW_FOR:
                    case KW_FORMAT:
                    case KW_FORMATTED:
                    case KW_FULL:
                    case KW_FUNCTIONS:
                    case KW_GRANT:
                    case KW_GROUP:
                    case KW_GROUPING:
                    case KW_HOLD_DDLTIME:
                    case KW_IDXPROPERTIES:
                    case KW_IGNORE:
                    case KW_IMPORT:
                    case KW_IN:
                    case KW_INDEX:
                    case KW_INDEXES:
                    case KW_INNER:
                    case KW_INPATH:
                    case KW_INPUTDRIVER:
                    case KW_INPUTFORMAT:
                    case KW_INSERT:
                    case KW_INT:
                    case KW_INTERSECT:
                    case KW_INTO:
                    case KW_IS:
                    case KW_ITEMS:
                    case KW_JAR:
                    case KW_KEYS:
                    case KW_KEY_TYPE:
                    case KW_LATERAL:
                    case KW_LEFT:
                    case KW_LIKE:
                    case KW_LIMIT:
                    case KW_LINES:
                    case KW_LOAD:
                    case KW_LOCAL:
                    case KW_LOCATION:
                    case KW_LOCK:
                    case KW_LOCKS:
                    case KW_LOGICAL:
                    case KW_LONG:
                    case KW_MAPJOIN:
                    case KW_MATERIALIZED:
                    case KW_MINUS:
                    case KW_MSCK:
                    case KW_NONE:
                    case KW_NOSCAN:
                    case KW_NO_DROP:
                    case KW_NULL:
                    case KW_OF:
                    case KW_OFFLINE:
                    case KW_OPTION:
                    case KW_ORDER:
                    case KW_OUT:
                    case KW_OUTER:
                    case KW_OUTPUTDRIVER:
                    case KW_OUTPUTFORMAT:
                    case KW_OVERWRITE:
                    case KW_OWNER:
                    case KW_PARTITIONED:
                    case KW_PARTITIONS:
                    case KW_PERCENT:
                    case KW_PLUS:
                    case KW_PRETTY:
                    case KW_PRINCIPALS:
                    case KW_PROCEDURE:
                    case KW_PROTECTION:
                    case KW_PURGE:
                    case KW_RANGE:
                    case KW_READ:
                    case KW_READONLY:
                    case KW_READS:
                    case KW_REBUILD:
                    case KW_RECORDREADER:
                    case KW_RECORDWRITER:
                    case KW_REGEXP:
                    case KW_RENAME:
                    case KW_REPAIR:
                    case KW_REPLACE:
                    case KW_RESTRICT:
                    case KW_REVOKE:
                    case KW_REWRITE:
                    case KW_RIGHT:
                    case KW_RLIKE:
                    case KW_ROLE:
                    case KW_ROLES:
                    case KW_ROLLUP:
                    case KW_ROW:
                    case KW_ROWS:
                    case KW_SCHEMA:
                    case KW_SCHEMAS:
                    case KW_SEMI:
                    case KW_SERDE:
                    case KW_SERDEPROPERTIES:
                    case KW_SERVER:
                    case KW_SET:
                    case KW_SETS:
                    case KW_SHARED:
                    case KW_SHOW:
                    case KW_SHOW_DATABASE:
                    case KW_SKEWED:
                    case KW_SMALLINT:
                    case KW_SORT:
                    case KW_SORTED:
                    case KW_SSL:
                    case KW_STATISTICS:
                    case KW_STORED:
                    case KW_STREAMTABLE:
                    case KW_STRING:
                    case KW_STRUCT:
                    case KW_TABLE:
                    case KW_TABLES:
                    case KW_TBLPROPERTIES:
                    case KW_TEMPORARY:
                    case KW_TERMINATED:
                    case KW_TIMESTAMP:
                    case KW_TINYINT:
                    case KW_TO:
                    case KW_TOUCH:
                    case KW_TRANSACTIONS:
                    case KW_TRIGGER:
                    case KW_TRUE:
                    case KW_TRUNCATE:
                    case KW_UNARCHIVE:
                    case KW_UNDO:
                    case KW_UNION:
                    case KW_UNIONTYPE:
                    case KW_UNLOCK:
                    case KW_UNSET:
                    case KW_UNSIGNED:
                    case KW_UPDATE:
                    case KW_URI:
                    case KW_USE:
                    case KW_USER:
                    case KW_USING:
                    case KW_UTC:
                    case KW_UTCTIMESTAMP:
                    case KW_VALUES:
                    case KW_VALUE_TYPE:
                    case KW_VIEW:
                    case KW_WHILE:
                    case KW_WITH:
                        {
                        alt111=1;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 111, 12, input);

                        throw nvae;

                    }

                    }
                    break;
                case Identifier:
                case KW_ADD:
                case KW_ADMIN:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_AUTHORIZATION:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPACT:
                case KW_COMPACTIONS:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTENDED:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILE:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_JAR:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_OWNER:
                case KW_PARTITION:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PRINCIPALS:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_REWRITE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRANSACTIONS:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUES:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt111=2;
                    }
                    break;
                case KW_FUNCTION:
                    {
                    alt111=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 111, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 111, 0, input);

                throw nvae;

            }

            switch (alt111) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:7: ( KW_DESCRIBE | KW_DESC ) ( KW_DATABASE | KW_SCHEMA ) ( KW_EXTENDED )? (dbName= identifier )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:7: ( KW_DESCRIBE | KW_DESC )
                    int alt104=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt104=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt104=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 104, 0, input);

                        throw nvae;

                    }

                    switch (alt104) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE374=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6382);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE374);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:20: KW_DESC
                            {
                            KW_DESC375=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6384);  
                            stream_KW_DESC.add(KW_DESC375);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:29: ( KW_DATABASE | KW_SCHEMA )
                    int alt105=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASE:
                        {
                        alt105=1;
                        }
                        break;
                    case KW_SCHEMA:
                        {
                        alt105=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 105, 0, input);

                        throw nvae;

                    }

                    switch (alt105) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:30: KW_DATABASE
                            {
                            KW_DATABASE376=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_descStatement6388);  
                            stream_KW_DATABASE.add(KW_DATABASE376);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:42: KW_SCHEMA
                            {
                            KW_SCHEMA377=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_descStatement6390);  
                            stream_KW_SCHEMA.add(KW_SCHEMA377);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:53: ( KW_EXTENDED )?
                    int alt106=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt106=1;
                            }
                            break;
                    }

                    switch (alt106) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:53: KW_EXTENDED
                            {
                            KW_EXTENDED378=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6393);  
                            stream_KW_EXTENDED.add(KW_EXTENDED378);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:66: (dbName= identifier )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:67: dbName= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_descStatement6399);
                    dbName=identifier();

                    state._fsp--;

                    stream_identifier.add(dbName.getTree());

                    }


                    // AST REWRITE
                    // elements: KW_EXTENDED, dbName
                    // token labels: 
                    // rule labels: retval, dbName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_dbName=new RewriteRuleSubtreeStream(adaptor,"rule dbName",dbName!=null?dbName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1321:86: -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:89: ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCDATABASE, "TOK_DESCDATABASE")
                        , root_1);

                        adaptor.addChild(root_1, stream_dbName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:116: ( KW_EXTENDED )?
                        if ( stream_KW_EXTENDED.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_EXTENDED.nextNode()
                            );

                        }
                        stream_KW_EXTENDED.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:7: ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:7: ( KW_DESCRIBE | KW_DESC )
                    int alt107=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt107=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt107=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 107, 0, input);

                        throw nvae;

                    }

                    switch (alt107) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE379=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6421);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE379);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:20: KW_DESC
                            {
                            KW_DESC380=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6423);  
                            stream_KW_DESC.add(KW_DESC380);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:29: (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )?
                    int alt108=4;
                    switch ( input.LA(1) ) {
                        case KW_FORMATTED:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                    {
                                    alt108=1;
                                    }
                                    break;
                                case KW_PARTITION:
                                    {
                                    alt108=1;
                                    }
                                    break;
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt108=1;
                                    }
                                    break;
                            }

                            }
                            break;
                        case KW_EXTENDED:
                            {
                            alt108=2;
                            }
                            break;
                        case KW_PRETTY:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                    {
                                    alt108=3;
                                    }
                                    break;
                                case KW_PARTITION:
                                    {
                                    alt108=3;
                                    }
                                    break;
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt108=3;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt108) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:30: descOptions= KW_FORMATTED
                            {
                            descOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_descStatement6429);  
                            stream_KW_FORMATTED.add(descOptions);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:55: descOptions= KW_EXTENDED
                            {
                            descOptions=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6433);  
                            stream_KW_EXTENDED.add(descOptions);


                            }
                            break;
                        case 3 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:79: descOptions= KW_PRETTY
                            {
                            descOptions=(Token)match(input,KW_PRETTY,FOLLOW_KW_PRETTY_in_descStatement6437);  
                            stream_KW_PRETTY.add(descOptions);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:103: (parttype= descPartTypeExpr )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:104: parttype= descPartTypeExpr
                    {
                    pushFollow(FOLLOW_descPartTypeExpr_in_descStatement6444);
                    parttype=descPartTypeExpr();

                    state._fsp--;

                    stream_descPartTypeExpr.add(parttype.getTree());

                    }


                    // AST REWRITE
                    // elements: parttype, descOptions
                    // token labels: descOptions
                    // rule labels: retval, parttype
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_descOptions=new RewriteRuleTokenStream(adaptor,"token descOptions",descOptions);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1322:131: -> ^( TOK_DESCTABLE $parttype ( $descOptions)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:134: ^( TOK_DESCTABLE $parttype ( $descOptions)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCTABLE, "TOK_DESCTABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_parttype.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:161: ( $descOptions)?
                        if ( stream_descOptions.hasNext() ) {
                            adaptor.addChild(root_1, stream_descOptions.nextNode());

                        }
                        stream_descOptions.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:7: ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:7: ( KW_DESCRIBE | KW_DESC )
                    int alt109=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt109=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt109=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 109, 0, input);

                        throw nvae;

                    }

                    switch (alt109) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE381=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6467);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE381);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:20: KW_DESC
                            {
                            KW_DESC382=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6469);  
                            stream_KW_DESC.add(KW_DESC382);


                            }
                            break;

                    }


                    KW_FUNCTION383=(Token)match(input,KW_FUNCTION,FOLLOW_KW_FUNCTION_in_descStatement6472);  
                    stream_KW_FUNCTION.add(KW_FUNCTION383);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:41: ( KW_EXTENDED )?
                    int alt110=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt110=1;
                            }
                            break;
                    }

                    switch (alt110) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:41: KW_EXTENDED
                            {
                            KW_EXTENDED384=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6474);  
                            stream_KW_EXTENDED.add(KW_EXTENDED384);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:54: (name= descFuncNames )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:55: name= descFuncNames
                    {
                    pushFollow(FOLLOW_descFuncNames_in_descStatement6480);
                    name=descFuncNames();

                    state._fsp--;

                    stream_descFuncNames.add(name.getTree());

                    }


                    // AST REWRITE
                    // elements: name, KW_EXTENDED
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1323:75: -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:78: ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCFUNCTION, "TOK_DESCFUNCTION")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:103: ( KW_EXTENDED )?
                        if ( stream_KW_EXTENDED.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_EXTENDED.nextNode()
                            );

                        }
                        stream_KW_EXTENDED.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descStatement"


    public static class analyzeStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "analyzeStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1327:1: analyzeStatement : KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? ) )? -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( KW_COLUMNS )? ( $statsColumnName)? ) ;
    public final HiveParser.analyzeStatement_return analyzeStatement() throws RecognitionException {
        HiveParser.analyzeStatement_return retval = new HiveParser.analyzeStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token noscan=null;
        Token partialscan=null;
        Token KW_ANALYZE385=null;
        Token KW_TABLE386=null;
        Token KW_COMPUTE387=null;
        Token KW_STATISTICS388=null;
        Token KW_FOR389=null;
        Token KW_COLUMNS390=null;
        HiveParser_IdentifiersParser.tableOrPartition_return parttype =null;

        HiveParser.columnNameList_return statsColumnName =null;


        CommonTree noscan_tree=null;
        CommonTree partialscan_tree=null;
        CommonTree KW_ANALYZE385_tree=null;
        CommonTree KW_TABLE386_tree=null;
        CommonTree KW_COMPUTE387_tree=null;
        CommonTree KW_STATISTICS388_tree=null;
        CommonTree KW_FOR389_tree=null;
        CommonTree KW_COLUMNS390_tree=null;
        RewriteRuleTokenStream stream_KW_ANALYZE=new RewriteRuleTokenStream(adaptor,"token KW_ANALYZE");
        RewriteRuleTokenStream stream_KW_NOSCAN=new RewriteRuleTokenStream(adaptor,"token KW_NOSCAN");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_STATISTICS=new RewriteRuleTokenStream(adaptor,"token KW_STATISTICS");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_COMPUTE=new RewriteRuleTokenStream(adaptor,"token KW_COMPUTE");
        RewriteRuleTokenStream stream_KW_PARTIALSCAN=new RewriteRuleTokenStream(adaptor,"token KW_PARTIALSCAN");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
         pushMsg("analyze statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:5: ( KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? ) )? -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( KW_COLUMNS )? ( $statsColumnName)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:7: KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? ) )?
            {
            KW_ANALYZE385=(Token)match(input,KW_ANALYZE,FOLLOW_KW_ANALYZE_in_analyzeStatement6521);  
            stream_KW_ANALYZE.add(KW_ANALYZE385);


            KW_TABLE386=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_analyzeStatement6523);  
            stream_KW_TABLE.add(KW_TABLE386);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:27: (parttype= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:28: parttype= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_analyzeStatement6528);
            parttype=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(parttype.getTree());

            }


            KW_COMPUTE387=(Token)match(input,KW_COMPUTE,FOLLOW_KW_COMPUTE_in_analyzeStatement6531);  
            stream_KW_COMPUTE.add(KW_COMPUTE387);


            KW_STATISTICS388=(Token)match(input,KW_STATISTICS,FOLLOW_KW_STATISTICS_in_analyzeStatement6533);  
            stream_KW_STATISTICS.add(KW_STATISTICS388);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:80: ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? ) )?
            int alt113=4;
            switch ( input.LA(1) ) {
                case KW_NOSCAN:
                    {
                    alt113=1;
                    }
                    break;
                case KW_PARTIALSCAN:
                    {
                    alt113=2;
                    }
                    break;
                case KW_FOR:
                    {
                    alt113=3;
                    }
                    break;
            }

            switch (alt113) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:81: (noscan= KW_NOSCAN )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:81: (noscan= KW_NOSCAN )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:82: noscan= KW_NOSCAN
                    {
                    noscan=(Token)match(input,KW_NOSCAN,FOLLOW_KW_NOSCAN_in_analyzeStatement6539);  
                    stream_KW_NOSCAN.add(noscan);


                    }


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:102: (partialscan= KW_PARTIALSCAN )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:102: (partialscan= KW_PARTIALSCAN )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1330:103: partialscan= KW_PARTIALSCAN
                    {
                    partialscan=(Token)match(input,KW_PARTIALSCAN,FOLLOW_KW_PARTIALSCAN_in_analyzeStatement6547);  
                    stream_KW_PARTIALSCAN.add(partialscan);


                    }


                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:57: ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:57: ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:58: KW_FOR KW_COLUMNS (statsColumnName= columnNameList )?
                    {
                    KW_FOR389=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_analyzeStatement6608);  
                    stream_KW_FOR.add(KW_FOR389);


                    KW_COLUMNS390=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_analyzeStatement6610);  
                    stream_KW_COLUMNS.add(KW_COLUMNS390);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:76: (statsColumnName= columnNameList )?
                    int alt112=2;
                    switch ( input.LA(1) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                            {
                            alt112=1;
                            }
                            break;
                    }

                    switch (alt112) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:77: statsColumnName= columnNameList
                            {
                            pushFollow(FOLLOW_columnNameList_in_analyzeStatement6615);
                            statsColumnName=columnNameList();

                            state._fsp--;

                            stream_columnNameList.add(statsColumnName.getTree());

                            }
                            break;

                    }


                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: partialscan, noscan, KW_COLUMNS, parttype, statsColumnName
            // token labels: partialscan, noscan
            // rule labels: retval, parttype, statsColumnName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_partialscan=new RewriteRuleTokenStream(adaptor,"token partialscan",partialscan);
            RewriteRuleTokenStream stream_noscan=new RewriteRuleTokenStream(adaptor,"token noscan",noscan);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);
            RewriteRuleSubtreeStream stream_statsColumnName=new RewriteRuleSubtreeStream(adaptor,"rule statsColumnName",statsColumnName!=null?statsColumnName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1332:7: -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( KW_COLUMNS )? ( $statsColumnName)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1332:10: ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( KW_COLUMNS )? ( $statsColumnName)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ANALYZE, "TOK_ANALYZE")
                , root_1);

                adaptor.addChild(root_1, stream_parttype.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1332:35: ( $noscan)?
                if ( stream_noscan.hasNext() ) {
                    adaptor.addChild(root_1, stream_noscan.nextNode());

                }
                stream_noscan.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1332:44: ( $partialscan)?
                if ( stream_partialscan.hasNext() ) {
                    adaptor.addChild(root_1, stream_partialscan.nextNode());

                }
                stream_partialscan.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1332:57: ( KW_COLUMNS )?
                if ( stream_KW_COLUMNS.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_KW_COLUMNS.nextNode()
                    );

                }
                stream_KW_COLUMNS.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1332:70: ( $statsColumnName)?
                if ( stream_statsColumnName.hasNext() ) {
                    adaptor.addChild(root_1, stream_statsColumnName.nextTree());

                }
                stream_statsColumnName.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "analyzeStatement"


    public static class showStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1335:1: showStatement : ( KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )? -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? ) | KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )? -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? ) | KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tableName ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWCOLUMNS tableName ( $db_name)? ) | KW_SHOW KW_FUNCTIONS ( KW_LIKE showFunctionIdentifier | showFunctionIdentifier )? -> ^( TOK_SHOWFUNCTIONS ( KW_LIKE )? ( showFunctionIdentifier )? ) | KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )? -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? ) | KW_SHOW KW_CREATE KW_TABLE tabName= tableName -> ^( TOK_SHOW_CREATETABLE $tabName) | KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )? -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? ) | KW_SHOW KW_TBLPROPERTIES tableName ( LPAREN prptyName= StringLiteral RPAREN )? -> ^( TOK_SHOW_TBLPROPERTIES tableName ( $prptyName)? ) | KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) | KW_SHOW KW_LOCKS ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? ) | KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? ) | KW_SHOW KW_COMPACTIONS -> ^( TOK_SHOW_COMPACTIONS ) | KW_SHOW KW_TRANSACTIONS -> ^( TOK_SHOW_TRANSACTIONS ) | KW_SHOW KW_CONF StringLiteral -> ^( TOK_SHOWCONF StringLiteral ) );
    public final HiveParser.showStatement_return showStatement() throws RecognitionException {
        HiveParser.showStatement_return retval = new HiveParser.showStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token prptyName=null;
        Token isExtended=null;
        Token dbName=null;
        Token showOptions=null;
        Token KW_SHOW391=null;
        Token KW_DATABASES392=null;
        Token KW_SCHEMAS393=null;
        Token KW_LIKE394=null;
        Token KW_SHOW396=null;
        Token KW_TABLES397=null;
        Token KW_FROM398=null;
        Token KW_IN399=null;
        Token KW_LIKE400=null;
        Token KW_SHOW403=null;
        Token KW_COLUMNS404=null;
        Token KW_FROM405=null;
        Token KW_IN406=null;
        Token KW_FROM408=null;
        Token KW_IN409=null;
        Token KW_SHOW410=null;
        Token KW_FUNCTIONS411=null;
        Token KW_LIKE412=null;
        Token KW_SHOW415=null;
        Token KW_PARTITIONS416=null;
        Token KW_SHOW418=null;
        Token KW_CREATE419=null;
        Token KW_TABLE420=null;
        Token KW_SHOW421=null;
        Token KW_TABLE422=null;
        Token KW_EXTENDED423=null;
        Token KW_FROM424=null;
        Token KW_IN425=null;
        Token KW_LIKE426=null;
        Token KW_SHOW429=null;
        Token KW_TBLPROPERTIES430=null;
        Token LPAREN432=null;
        Token RPAREN433=null;
        Token KW_SHOW434=null;
        Token KW_LOCKS435=null;
        Token KW_SHOW436=null;
        Token KW_LOCKS437=null;
        Token KW_DATABASE438=null;
        Token KW_SCHEMA439=null;
        Token KW_SHOW440=null;
        Token KW_INDEX441=null;
        Token KW_INDEXES442=null;
        Token KW_ON443=null;
        Token KW_FROM445=null;
        Token KW_IN446=null;
        Token KW_SHOW447=null;
        Token KW_COMPACTIONS448=null;
        Token KW_SHOW449=null;
        Token KW_TRANSACTIONS450=null;
        Token KW_SHOW451=null;
        Token KW_CONF452=null;
        Token StringLiteral453=null;
        HiveParser_IdentifiersParser.identifier_return db_name =null;

        HiveParser_FromClauseParser.tableName_return tabName =null;

        HiveParser.partTypeExpr_return parttype =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier395 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier401 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier402 =null;

        HiveParser_FromClauseParser.tableName_return tableName407 =null;

        HiveParser.showFunctionIdentifier_return showFunctionIdentifier413 =null;

        HiveParser.showFunctionIdentifier_return showFunctionIdentifier414 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec417 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier427 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec428 =null;

        HiveParser_FromClauseParser.tableName_return tableName431 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier444 =null;


        CommonTree prptyName_tree=null;
        CommonTree isExtended_tree=null;
        CommonTree dbName_tree=null;
        CommonTree showOptions_tree=null;
        CommonTree KW_SHOW391_tree=null;
        CommonTree KW_DATABASES392_tree=null;
        CommonTree KW_SCHEMAS393_tree=null;
        CommonTree KW_LIKE394_tree=null;
        CommonTree KW_SHOW396_tree=null;
        CommonTree KW_TABLES397_tree=null;
        CommonTree KW_FROM398_tree=null;
        CommonTree KW_IN399_tree=null;
        CommonTree KW_LIKE400_tree=null;
        CommonTree KW_SHOW403_tree=null;
        CommonTree KW_COLUMNS404_tree=null;
        CommonTree KW_FROM405_tree=null;
        CommonTree KW_IN406_tree=null;
        CommonTree KW_FROM408_tree=null;
        CommonTree KW_IN409_tree=null;
        CommonTree KW_SHOW410_tree=null;
        CommonTree KW_FUNCTIONS411_tree=null;
        CommonTree KW_LIKE412_tree=null;
        CommonTree KW_SHOW415_tree=null;
        CommonTree KW_PARTITIONS416_tree=null;
        CommonTree KW_SHOW418_tree=null;
        CommonTree KW_CREATE419_tree=null;
        CommonTree KW_TABLE420_tree=null;
        CommonTree KW_SHOW421_tree=null;
        CommonTree KW_TABLE422_tree=null;
        CommonTree KW_EXTENDED423_tree=null;
        CommonTree KW_FROM424_tree=null;
        CommonTree KW_IN425_tree=null;
        CommonTree KW_LIKE426_tree=null;
        CommonTree KW_SHOW429_tree=null;
        CommonTree KW_TBLPROPERTIES430_tree=null;
        CommonTree LPAREN432_tree=null;
        CommonTree RPAREN433_tree=null;
        CommonTree KW_SHOW434_tree=null;
        CommonTree KW_LOCKS435_tree=null;
        CommonTree KW_SHOW436_tree=null;
        CommonTree KW_LOCKS437_tree=null;
        CommonTree KW_DATABASE438_tree=null;
        CommonTree KW_SCHEMA439_tree=null;
        CommonTree KW_SHOW440_tree=null;
        CommonTree KW_INDEX441_tree=null;
        CommonTree KW_INDEXES442_tree=null;
        CommonTree KW_ON443_tree=null;
        CommonTree KW_FROM445_tree=null;
        CommonTree KW_IN446_tree=null;
        CommonTree KW_SHOW447_tree=null;
        CommonTree KW_COMPACTIONS448_tree=null;
        CommonTree KW_SHOW449_tree=null;
        CommonTree KW_TRANSACTIONS450_tree=null;
        CommonTree KW_SHOW451_tree=null;
        CommonTree KW_CONF452_tree=null;
        CommonTree StringLiteral453_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_LIKE=new RewriteRuleTokenStream(adaptor,"token KW_LIKE");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_TRANSACTIONS=new RewriteRuleTokenStream(adaptor,"token KW_TRANSACTIONS");
        RewriteRuleTokenStream stream_KW_FUNCTIONS=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTIONS");
        RewriteRuleTokenStream stream_KW_CONF=new RewriteRuleTokenStream(adaptor,"token KW_CONF");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_INDEXES=new RewriteRuleTokenStream(adaptor,"token KW_INDEXES");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_LOCKS=new RewriteRuleTokenStream(adaptor,"token KW_LOCKS");
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_PARTITIONS=new RewriteRuleTokenStream(adaptor,"token KW_PARTITIONS");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_IN=new RewriteRuleTokenStream(adaptor,"token KW_IN");
        RewriteRuleTokenStream stream_KW_COMPACTIONS=new RewriteRuleTokenStream(adaptor,"token KW_COMPACTIONS");
        RewriteRuleTokenStream stream_KW_SCHEMAS=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMAS");
        RewriteRuleTokenStream stream_KW_TABLES=new RewriteRuleTokenStream(adaptor,"token KW_TABLES");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_DATABASES=new RewriteRuleTokenStream(adaptor,"token KW_DATABASES");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_showStmtIdentifier=new RewriteRuleSubtreeStream(adaptor,"rule showStmtIdentifier");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_showFunctionIdentifier=new RewriteRuleSubtreeStream(adaptor,"rule showFunctionIdentifier");
        RewriteRuleSubtreeStream stream_partTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule partTypeExpr");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("show statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:5: ( KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )? -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? ) | KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )? -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? ) | KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tableName ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWCOLUMNS tableName ( $db_name)? ) | KW_SHOW KW_FUNCTIONS ( KW_LIKE showFunctionIdentifier | showFunctionIdentifier )? -> ^( TOK_SHOWFUNCTIONS ( KW_LIKE )? ( showFunctionIdentifier )? ) | KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )? -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? ) | KW_SHOW KW_CREATE KW_TABLE tabName= tableName -> ^( TOK_SHOW_CREATETABLE $tabName) | KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )? -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? ) | KW_SHOW KW_TBLPROPERTIES tableName ( LPAREN prptyName= StringLiteral RPAREN )? -> ^( TOK_SHOW_TBLPROPERTIES tableName ( $prptyName)? ) | KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) | KW_SHOW KW_LOCKS ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? ) | KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? ) | KW_SHOW KW_COMPACTIONS -> ^( TOK_SHOW_COMPACTIONS ) | KW_SHOW KW_TRANSACTIONS -> ^( TOK_SHOW_TRANSACTIONS ) | KW_SHOW KW_CONF StringLiteral -> ^( TOK_SHOWCONF StringLiteral ) )
            int alt136=14;
            switch ( input.LA(1) ) {
            case KW_SHOW:
                {
                switch ( input.LA(2) ) {
                case KW_TABLES:
                    {
                    alt136=2;
                    }
                    break;
                case KW_COLUMNS:
                    {
                    alt136=3;
                    }
                    break;
                case KW_FUNCTIONS:
                    {
                    alt136=4;
                    }
                    break;
                case KW_PARTITIONS:
                    {
                    alt136=5;
                    }
                    break;
                case KW_CREATE:
                    {
                    alt136=6;
                    }
                    break;
                case KW_TABLE:
                    {
                    alt136=7;
                    }
                    break;
                case KW_TBLPROPERTIES:
                    {
                    alt136=8;
                    }
                    break;
                case KW_LOCKS:
                    {
                    switch ( input.LA(3) ) {
                    case EOF:
                    case Identifier:
                    case KW_ADD:
                    case KW_ADMIN:
                    case KW_AFTER:
                    case KW_ALL:
                    case KW_ALTER:
                    case KW_ANALYZE:
                    case KW_ARCHIVE:
                    case KW_ARRAY:
                    case KW_AS:
                    case KW_ASC:
                    case KW_AUTHORIZATION:
                    case KW_BEFORE:
                    case KW_BETWEEN:
                    case KW_BIGINT:
                    case KW_BINARY:
                    case KW_BOOLEAN:
                    case KW_BOTH:
                    case KW_BUCKET:
                    case KW_BUCKETS:
                    case KW_BY:
                    case KW_CASCADE:
                    case KW_CHANGE:
                    case KW_CLUSTER:
                    case KW_CLUSTERED:
                    case KW_CLUSTERSTATUS:
                    case KW_COLLECTION:
                    case KW_COLUMNS:
                    case KW_COMMENT:
                    case KW_COMPACT:
                    case KW_COMPACTIONS:
                    case KW_COMPUTE:
                    case KW_CONCATENATE:
                    case KW_CONTINUE:
                    case KW_CREATE:
                    case KW_CUBE:
                    case KW_CURSOR:
                    case KW_DATA:
                    case KW_DATABASES:
                    case KW_DATE:
                    case KW_DATETIME:
                    case KW_DBPROPERTIES:
                    case KW_DECIMAL:
                    case KW_DEFAULT:
                    case KW_DEFERRED:
                    case KW_DEFINED:
                    case KW_DELETE:
                    case KW_DELIMITED:
                    case KW_DEPENDENCY:
                    case KW_DESC:
                    case KW_DESCRIBE:
                    case KW_DIRECTORIES:
                    case KW_DIRECTORY:
                    case KW_DISABLE:
                    case KW_DISTRIBUTE:
                    case KW_DOUBLE:
                    case KW_DROP:
                    case KW_ELEM_TYPE:
                    case KW_ENABLE:
                    case KW_ESCAPED:
                    case KW_EXCLUSIVE:
                    case KW_EXISTS:
                    case KW_EXPLAIN:
                    case KW_EXPORT:
                    case KW_EXTENDED:
                    case KW_EXTERNAL:
                    case KW_FALSE:
                    case KW_FETCH:
                    case KW_FIELDS:
                    case KW_FILE:
                    case KW_FILEFORMAT:
                    case KW_FIRST:
                    case KW_FLOAT:
                    case KW_FOR:
                    case KW_FORMAT:
                    case KW_FORMATTED:
                    case KW_FULL:
                    case KW_FUNCTIONS:
                    case KW_GRANT:
                    case KW_GROUP:
                    case KW_GROUPING:
                    case KW_HOLD_DDLTIME:
                    case KW_IDXPROPERTIES:
                    case KW_IGNORE:
                    case KW_IMPORT:
                    case KW_IN:
                    case KW_INDEX:
                    case KW_INDEXES:
                    case KW_INNER:
                    case KW_INPATH:
                    case KW_INPUTDRIVER:
                    case KW_INPUTFORMAT:
                    case KW_INSERT:
                    case KW_INT:
                    case KW_INTERSECT:
                    case KW_INTO:
                    case KW_IS:
                    case KW_ITEMS:
                    case KW_JAR:
                    case KW_KEYS:
                    case KW_KEY_TYPE:
                    case KW_LATERAL:
                    case KW_LEFT:
                    case KW_LIKE:
                    case KW_LIMIT:
                    case KW_LINES:
                    case KW_LOAD:
                    case KW_LOCAL:
                    case KW_LOCATION:
                    case KW_LOCK:
                    case KW_LOCKS:
                    case KW_LOGICAL:
                    case KW_LONG:
                    case KW_MAPJOIN:
                    case KW_MATERIALIZED:
                    case KW_MINUS:
                    case KW_MSCK:
                    case KW_NONE:
                    case KW_NOSCAN:
                    case KW_NO_DROP:
                    case KW_NULL:
                    case KW_OF:
                    case KW_OFFLINE:
                    case KW_OPTION:
                    case KW_ORDER:
                    case KW_OUT:
                    case KW_OUTER:
                    case KW_OUTPUTDRIVER:
                    case KW_OUTPUTFORMAT:
                    case KW_OVERWRITE:
                    case KW_OWNER:
                    case KW_PARTITION:
                    case KW_PARTITIONED:
                    case KW_PARTITIONS:
                    case KW_PERCENT:
                    case KW_PLUS:
                    case KW_PRETTY:
                    case KW_PRINCIPALS:
                    case KW_PROCEDURE:
                    case KW_PROTECTION:
                    case KW_PURGE:
                    case KW_RANGE:
                    case KW_READ:
                    case KW_READONLY:
                    case KW_READS:
                    case KW_REBUILD:
                    case KW_RECORDREADER:
                    case KW_RECORDWRITER:
                    case KW_REGEXP:
                    case KW_RENAME:
                    case KW_REPAIR:
                    case KW_REPLACE:
                    case KW_RESTRICT:
                    case KW_REVOKE:
                    case KW_REWRITE:
                    case KW_RIGHT:
                    case KW_RLIKE:
                    case KW_ROLE:
                    case KW_ROLES:
                    case KW_ROLLUP:
                    case KW_ROW:
                    case KW_ROWS:
                    case KW_SCHEMAS:
                    case KW_SEMI:
                    case KW_SERDE:
                    case KW_SERDEPROPERTIES:
                    case KW_SERVER:
                    case KW_SET:
                    case KW_SETS:
                    case KW_SHARED:
                    case KW_SHOW:
                    case KW_SHOW_DATABASE:
                    case KW_SKEWED:
                    case KW_SMALLINT:
                    case KW_SORT:
                    case KW_SORTED:
                    case KW_SSL:
                    case KW_STATISTICS:
                    case KW_STORED:
                    case KW_STREAMTABLE:
                    case KW_STRING:
                    case KW_STRUCT:
                    case KW_TABLE:
                    case KW_TABLES:
                    case KW_TBLPROPERTIES:
                    case KW_TEMPORARY:
                    case KW_TERMINATED:
                    case KW_TIMESTAMP:
                    case KW_TINYINT:
                    case KW_TO:
                    case KW_TOUCH:
                    case KW_TRANSACTIONS:
                    case KW_TRIGGER:
                    case KW_TRUE:
                    case KW_TRUNCATE:
                    case KW_UNARCHIVE:
                    case KW_UNDO:
                    case KW_UNION:
                    case KW_UNIONTYPE:
                    case KW_UNLOCK:
                    case KW_UNSET:
                    case KW_UNSIGNED:
                    case KW_UPDATE:
                    case KW_URI:
                    case KW_USE:
                    case KW_USER:
                    case KW_USING:
                    case KW_UTC:
                    case KW_UTCTIMESTAMP:
                    case KW_VALUES:
                    case KW_VALUE_TYPE:
                    case KW_VIEW:
                    case KW_WHILE:
                    case KW_WITH:
                        {
                        alt136=9;
                        }
                        break;
                    case KW_SCHEMA:
                        {
                        alt136=9;
                        }
                        break;
                    case KW_DATABASE:
                        {
                        alt136=10;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 136, 9, input);

                        throw nvae;

                    }

                    }
                    break;
                case KW_COMPACTIONS:
                    {
                    alt136=12;
                    }
                    break;
                case KW_TRANSACTIONS:
                    {
                    alt136=13;
                    }
                    break;
                case KW_CONF:
                    {
                    alt136=14;
                    }
                    break;
                case KW_DATABASES:
                case KW_SCHEMAS:
                    {
                    alt136=1;
                    }
                    break;
                case KW_FORMATTED:
                case KW_INDEX:
                case KW_INDEXES:
                    {
                    alt136=11;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 136, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 136, 0, input);

                throw nvae;

            }

            switch (alt136) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:7: KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )?
                    {
                    KW_SHOW391=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6677);  
                    stream_KW_SHOW.add(KW_SHOW391);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:15: ( KW_DATABASES | KW_SCHEMAS )
                    int alt114=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASES:
                        {
                        alt114=1;
                        }
                        break;
                    case KW_SCHEMAS:
                        {
                        alt114=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 114, 0, input);

                        throw nvae;

                    }

                    switch (alt114) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:16: KW_DATABASES
                            {
                            KW_DATABASES392=(Token)match(input,KW_DATABASES,FOLLOW_KW_DATABASES_in_showStatement6680);  
                            stream_KW_DATABASES.add(KW_DATABASES392);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:29: KW_SCHEMAS
                            {
                            KW_SCHEMAS393=(Token)match(input,KW_SCHEMAS,FOLLOW_KW_SCHEMAS_in_showStatement6682);  
                            stream_KW_SCHEMAS.add(KW_SCHEMAS393);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:41: ( KW_LIKE showStmtIdentifier )?
                    int alt115=2;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            alt115=1;
                            }
                            break;
                    }

                    switch (alt115) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:42: KW_LIKE showStmtIdentifier
                            {
                            KW_LIKE394=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6686);  
                            stream_KW_LIKE.add(KW_LIKE394);


                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6688);
                            showStmtIdentifier395=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier395.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1338:71: -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:74: ^( TOK_SHOWDATABASES ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWDATABASES, "TOK_SHOWDATABASES")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:94: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:7: KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )?
                    {
                    KW_SHOW396=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6707);  
                    stream_KW_SHOW.add(KW_SHOW396);


                    KW_TABLES397=(Token)match(input,KW_TABLES,FOLLOW_KW_TABLES_in_showStatement6709);  
                    stream_KW_TABLES.add(KW_TABLES397);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:25: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt117=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                            {
                            alt117=1;
                            }
                            break;
                        case KW_IN:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt117=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt117) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:26: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:26: ( KW_FROM | KW_IN )
                            int alt116=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt116=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt116=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 116, 0, input);

                                throw nvae;

                            }

                            switch (alt116) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:27: KW_FROM
                                    {
                                    KW_FROM398=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6713);  
                                    stream_KW_FROM.add(KW_FROM398);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:35: KW_IN
                                    {
                                    KW_IN399=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6715);  
                                    stream_KW_IN.add(KW_IN399);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6720);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:63: ( KW_LIKE showStmtIdentifier | showStmtIdentifier )?
                    int alt118=3;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                case StringLiteral:
                                    {
                                    alt118=1;
                                    }
                                    break;
                                case EOF:
                                    {
                                    alt118=2;
                                    }
                                    break;
                            }

                            }
                            break;
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case StringLiteral:
                            {
                            alt118=2;
                            }
                            break;
                    }

                    switch (alt118) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:64: KW_LIKE showStmtIdentifier
                            {
                            KW_LIKE400=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6725);  
                            stream_KW_LIKE.add(KW_LIKE400);


                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6727);
                            showStmtIdentifier401=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier401.getTree());

                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:91: showStmtIdentifier
                            {
                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6729);
                            showStmtIdentifier402=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier402.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: db_name, showStmtIdentifier
                    // token labels: 
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1339:113: -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:116: ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWTABLES, "TOK_SHOWTABLES")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:133: ( TOK_FROM $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, 
                            (CommonTree)adaptor.create(TOK_FROM, "TOK_FROM")
                            );

                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1339:154: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:7: KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tableName ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    {
                    KW_SHOW403=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6757);  
                    stream_KW_SHOW.add(KW_SHOW403);


                    KW_COLUMNS404=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_showStatement6759);  
                    stream_KW_COLUMNS.add(KW_COLUMNS404);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:26: ( KW_FROM | KW_IN )
                    int alt119=2;
                    switch ( input.LA(1) ) {
                    case KW_FROM:
                        {
                        alt119=1;
                        }
                        break;
                    case KW_IN:
                        {
                        alt119=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 119, 0, input);

                        throw nvae;

                    }

                    switch (alt119) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:27: KW_FROM
                            {
                            KW_FROM405=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6762);  
                            stream_KW_FROM.add(KW_FROM405);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:35: KW_IN
                            {
                            KW_IN406=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6764);  
                            stream_KW_IN.add(KW_IN406);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableName_in_showStatement6767);
                    tableName407=tableName();

                    state._fsp--;

                    stream_tableName.add(tableName407.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:52: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt121=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt121=1;
                            }
                            break;
                    }

                    switch (alt121) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:53: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:53: ( KW_FROM | KW_IN )
                            int alt120=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt120=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt120=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 120, 0, input);

                                throw nvae;

                            }

                            switch (alt120) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:54: KW_FROM
                                    {
                                    KW_FROM408=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6771);  
                                    stream_KW_FROM.add(KW_FROM408);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:62: KW_IN
                                    {
                                    KW_IN409=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6773);  
                                    stream_KW_IN.add(KW_IN409);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6778);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: db_name, tableName
                    // token labels: 
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1341:5: -> ^( TOK_SHOWCOLUMNS tableName ( $db_name)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1341:8: ^( TOK_SHOWCOLUMNS tableName ( $db_name)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWCOLUMNS, "TOK_SHOWCOLUMNS")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1341:37: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:7: KW_SHOW KW_FUNCTIONS ( KW_LIKE showFunctionIdentifier | showFunctionIdentifier )?
                    {
                    KW_SHOW410=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6804);  
                    stream_KW_SHOW.add(KW_SHOW410);


                    KW_FUNCTIONS411=(Token)match(input,KW_FUNCTIONS,FOLLOW_KW_FUNCTIONS_in_showStatement6806);  
                    stream_KW_FUNCTIONS.add(KW_FUNCTIONS411);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:28: ( KW_LIKE showFunctionIdentifier | showFunctionIdentifier )?
                    int alt122=3;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                case StringLiteral:
                                    {
                                    alt122=1;
                                    }
                                    break;
                                case EOF:
                                case DOT:
                                    {
                                    alt122=2;
                                    }
                                    break;
                            }

                            }
                            break;
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case StringLiteral:
                            {
                            alt122=2;
                            }
                            break;
                    }

                    switch (alt122) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:29: KW_LIKE showFunctionIdentifier
                            {
                            KW_LIKE412=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6809);  
                            stream_KW_LIKE.add(KW_LIKE412);


                            pushFollow(FOLLOW_showFunctionIdentifier_in_showStatement6811);
                            showFunctionIdentifier413=showFunctionIdentifier();

                            state._fsp--;

                            stream_showFunctionIdentifier.add(showFunctionIdentifier413.getTree());

                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:60: showFunctionIdentifier
                            {
                            pushFollow(FOLLOW_showFunctionIdentifier_in_showStatement6813);
                            showFunctionIdentifier414=showFunctionIdentifier();

                            state._fsp--;

                            stream_showFunctionIdentifier.add(showFunctionIdentifier414.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showFunctionIdentifier, KW_LIKE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1342:86: -> ^( TOK_SHOWFUNCTIONS ( KW_LIKE )? ( showFunctionIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:89: ^( TOK_SHOWFUNCTIONS ( KW_LIKE )? ( showFunctionIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWFUNCTIONS, "TOK_SHOWFUNCTIONS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:109: ( KW_LIKE )?
                        if ( stream_KW_LIKE.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_LIKE.nextNode()
                            );

                        }
                        stream_KW_LIKE.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:118: ( showFunctionIdentifier )?
                        if ( stream_showFunctionIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showFunctionIdentifier.nextTree());

                        }
                        stream_showFunctionIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1343:7: KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )?
                    {
                    KW_SHOW415=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6836);  
                    stream_KW_SHOW.add(KW_SHOW415);


                    KW_PARTITIONS416=(Token)match(input,KW_PARTITIONS,FOLLOW_KW_PARTITIONS_in_showStatement6838);  
                    stream_KW_PARTITIONS.add(KW_PARTITIONS416);


                    pushFollow(FOLLOW_tableName_in_showStatement6842);
                    tabName=tableName();

                    state._fsp--;

                    stream_tableName.add(tabName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1343:47: ( partitionSpec )?
                    int alt123=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt123=1;
                            }
                            break;
                    }

                    switch (alt123) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1343:47: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_showStatement6844);
                            partitionSpec417=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec417.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: partitionSpec, tabName
                    // token labels: 
                    // rule labels: retval, tabName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tabName=new RewriteRuleSubtreeStream(adaptor,"rule tabName",tabName!=null?tabName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1343:62: -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1343:65: ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWPARTITIONS, "TOK_SHOWPARTITIONS")
                        , root_1);

                        adaptor.addChild(root_1, stream_tabName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1343:95: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1344:7: KW_SHOW KW_CREATE KW_TABLE tabName= tableName
                    {
                    KW_SHOW418=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6866);  
                    stream_KW_SHOW.add(KW_SHOW418);


                    KW_CREATE419=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_showStatement6868);  
                    stream_KW_CREATE.add(KW_CREATE419);


                    KW_TABLE420=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_showStatement6870);  
                    stream_KW_TABLE.add(KW_TABLE420);


                    pushFollow(FOLLOW_tableName_in_showStatement6874);
                    tabName=tableName();

                    state._fsp--;

                    stream_tableName.add(tabName.getTree());

                    // AST REWRITE
                    // elements: tabName
                    // token labels: 
                    // rule labels: retval, tabName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tabName=new RewriteRuleSubtreeStream(adaptor,"rule tabName",tabName!=null?tabName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1344:52: -> ^( TOK_SHOW_CREATETABLE $tabName)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1344:55: ^( TOK_SHOW_CREATETABLE $tabName)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_CREATETABLE, "TOK_SHOW_CREATETABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_tabName.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:7: KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )?
                    {
                    KW_SHOW421=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6891);  
                    stream_KW_SHOW.add(KW_SHOW421);


                    KW_TABLE422=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_showStatement6893);  
                    stream_KW_TABLE.add(KW_TABLE422);


                    KW_EXTENDED423=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement6895);  
                    stream_KW_EXTENDED.add(KW_EXTENDED423);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:36: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt125=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt125=1;
                            }
                            break;
                    }

                    switch (alt125) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:37: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:37: ( KW_FROM | KW_IN )
                            int alt124=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt124=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt124=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 124, 0, input);

                                throw nvae;

                            }

                            switch (alt124) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:38: KW_FROM
                                    {
                                    KW_FROM424=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6899);  
                                    stream_KW_FROM.add(KW_FROM424);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:46: KW_IN
                                    {
                                    KW_IN425=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6901);  
                                    stream_KW_IN.add(KW_IN425);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6906);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    KW_LIKE426=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6910);  
                    stream_KW_LIKE.add(KW_LIKE426);


                    pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6912);
                    showStmtIdentifier427=showStmtIdentifier();

                    state._fsp--;

                    stream_showStmtIdentifier.add(showStmtIdentifier427.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:101: ( partitionSpec )?
                    int alt126=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt126=1;
                            }
                            break;
                    }

                    switch (alt126) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:101: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_showStatement6914);
                            partitionSpec428=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec428.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier, db_name, partitionSpec
                    // token labels: 
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1346:5: -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1346:8: ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TABLESTATUS, "TOK_SHOW_TABLESTATUS")
                        , root_1);

                        adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1346:51: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1346:60: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1347:7: KW_SHOW KW_TBLPROPERTIES tableName ( LPAREN prptyName= StringLiteral RPAREN )?
                    {
                    KW_SHOW429=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6942);  
                    stream_KW_SHOW.add(KW_SHOW429);


                    KW_TBLPROPERTIES430=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_showStatement6944);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES430);


                    pushFollow(FOLLOW_tableName_in_showStatement6946);
                    tableName431=tableName();

                    state._fsp--;

                    stream_tableName.add(tableName431.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1347:42: ( LPAREN prptyName= StringLiteral RPAREN )?
                    int alt127=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt127=1;
                            }
                            break;
                    }

                    switch (alt127) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1347:43: LPAREN prptyName= StringLiteral RPAREN
                            {
                            LPAREN432=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_showStatement6949);  
                            stream_LPAREN.add(LPAREN432);


                            prptyName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_showStatement6953);  
                            stream_StringLiteral.add(prptyName);


                            RPAREN433=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_showStatement6955);  
                            stream_RPAREN.add(RPAREN433);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: tableName, prptyName
                    // token labels: prptyName
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_prptyName=new RewriteRuleTokenStream(adaptor,"token prptyName",prptyName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1347:83: -> ^( TOK_SHOW_TBLPROPERTIES tableName ( $prptyName)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1347:86: ^( TOK_SHOW_TBLPROPERTIES tableName ( $prptyName)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TBLPROPERTIES, "TOK_SHOW_TBLPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1347:122: ( $prptyName)?
                        if ( stream_prptyName.hasNext() ) {
                            adaptor.addChild(root_1, stream_prptyName.nextNode());

                        }
                        stream_prptyName.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:7: KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )?
                    {
                    KW_SHOW434=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6977);  
                    stream_KW_SHOW.add(KW_SHOW434);


                    KW_LOCKS435=(Token)match(input,KW_LOCKS,FOLLOW_KW_LOCKS_in_showStatement6979);  
                    stream_KW_LOCKS.add(KW_LOCKS435);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:24: (parttype= partTypeExpr )?
                    int alt128=2;
                    switch ( input.LA(1) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                            {
                            alt128=1;
                            }
                            break;
                    }

                    switch (alt128) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:25: parttype= partTypeExpr
                            {
                            pushFollow(FOLLOW_partTypeExpr_in_showStatement6984);
                            parttype=partTypeExpr();

                            state._fsp--;

                            stream_partTypeExpr.add(parttype.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:49: (isExtended= KW_EXTENDED )?
                    int alt129=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt129=1;
                            }
                            break;
                    }

                    switch (alt129) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:50: isExtended= KW_EXTENDED
                            {
                            isExtended=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement6991);  
                            stream_KW_EXTENDED.add(isExtended);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: parttype, isExtended
                    // token labels: isExtended
                    // rule labels: retval, parttype
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_isExtended=new RewriteRuleTokenStream(adaptor,"token isExtended",isExtended);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1348:75: -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:78: ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWLOCKS, "TOK_SHOWLOCKS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:95: ( $parttype)?
                        if ( stream_parttype.hasNext() ) {
                            adaptor.addChild(root_1, stream_parttype.nextTree());

                        }
                        stream_parttype.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:106: ( $isExtended)?
                        if ( stream_isExtended.hasNext() ) {
                            adaptor.addChild(root_1, stream_isExtended.nextNode());

                        }
                        stream_isExtended.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:7: KW_SHOW KW_LOCKS ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) (isExtended= KW_EXTENDED )?
                    {
                    KW_SHOW436=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7015);  
                    stream_KW_SHOW.add(KW_SHOW436);


                    KW_LOCKS437=(Token)match(input,KW_LOCKS,FOLLOW_KW_LOCKS_in_showStatement7017);  
                    stream_KW_LOCKS.add(KW_LOCKS437);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:24: ( KW_DATABASE | KW_SCHEMA )
                    int alt130=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASE:
                        {
                        alt130=1;
                        }
                        break;
                    case KW_SCHEMA:
                        {
                        alt130=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 130, 0, input);

                        throw nvae;

                    }

                    switch (alt130) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:25: KW_DATABASE
                            {
                            KW_DATABASE438=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_showStatement7020);  
                            stream_KW_DATABASE.add(KW_DATABASE438);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:37: KW_SCHEMA
                            {
                            KW_SCHEMA439=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_showStatement7022);  
                            stream_KW_SCHEMA.add(KW_SCHEMA439);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:48: (dbName= Identifier )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:49: dbName= Identifier
                    {
                    dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_showStatement7028);  
                    stream_Identifier.add(dbName);


                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:68: (isExtended= KW_EXTENDED )?
                    int alt131=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt131=1;
                            }
                            break;
                    }

                    switch (alt131) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:69: isExtended= KW_EXTENDED
                            {
                            isExtended=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement7034);  
                            stream_KW_EXTENDED.add(isExtended);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: isExtended, dbName
                    // token labels: isExtended, dbName
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_isExtended=new RewriteRuleTokenStream(adaptor,"token isExtended",isExtended);
                    RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1349:94: -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:97: ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWDBLOCKS, "TOK_SHOWDBLOCKS")
                        , root_1);

                        adaptor.addChild(root_1, stream_dbName.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:124: ( $isExtended)?
                        if ( stream_isExtended.hasNext() ) {
                            adaptor.addChild(root_1, stream_isExtended.nextNode());

                        }
                        stream_isExtended.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:7: KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    {
                    KW_SHOW440=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7057);  
                    stream_KW_SHOW.add(KW_SHOW440);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:15: (showOptions= KW_FORMATTED )?
                    int alt132=2;
                    switch ( input.LA(1) ) {
                        case KW_FORMATTED:
                            {
                            alt132=1;
                            }
                            break;
                    }

                    switch (alt132) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:16: showOptions= KW_FORMATTED
                            {
                            showOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_showStatement7062);  
                            stream_KW_FORMATTED.add(showOptions);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:43: ( KW_INDEX | KW_INDEXES )
                    int alt133=2;
                    switch ( input.LA(1) ) {
                    case KW_INDEX:
                        {
                        alt133=1;
                        }
                        break;
                    case KW_INDEXES:
                        {
                        alt133=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 133, 0, input);

                        throw nvae;

                    }

                    switch (alt133) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:44: KW_INDEX
                            {
                            KW_INDEX441=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_showStatement7067);  
                            stream_KW_INDEX.add(KW_INDEX441);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:53: KW_INDEXES
                            {
                            KW_INDEXES442=(Token)match(input,KW_INDEXES,FOLLOW_KW_INDEXES_in_showStatement7069);  
                            stream_KW_INDEXES.add(KW_INDEXES442);


                            }
                            break;

                    }


                    KW_ON443=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_showStatement7072);  
                    stream_KW_ON.add(KW_ON443);


                    pushFollow(FOLLOW_showStmtIdentifier_in_showStatement7074);
                    showStmtIdentifier444=showStmtIdentifier();

                    state._fsp--;

                    stream_showStmtIdentifier.add(showStmtIdentifier444.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:90: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt135=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt135=1;
                            }
                            break;
                    }

                    switch (alt135) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:91: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:91: ( KW_FROM | KW_IN )
                            int alt134=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt134=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt134=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 134, 0, input);

                                throw nvae;

                            }

                            switch (alt134) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:92: KW_FROM
                                    {
                                    KW_FROM445=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement7078);  
                                    stream_KW_FROM.add(KW_FROM445);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:100: KW_IN
                                    {
                                    KW_IN446=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement7080);  
                                    stream_KW_IN.add(KW_IN446);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement7085);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier, showOptions, db_name
                    // token labels: showOptions
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_showOptions=new RewriteRuleTokenStream(adaptor,"token showOptions",showOptions);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1351:5: -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1351:8: ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWINDEXES, "TOK_SHOWINDEXES")
                        , root_1);

                        adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1351:46: ( $showOptions)?
                        if ( stream_showOptions.hasNext() ) {
                            adaptor.addChild(root_1, stream_showOptions.nextNode());

                        }
                        stream_showOptions.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1351:60: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1352:7: KW_SHOW KW_COMPACTIONS
                    {
                    KW_SHOW447=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7115);  
                    stream_KW_SHOW.add(KW_SHOW447);


                    KW_COMPACTIONS448=(Token)match(input,KW_COMPACTIONS,FOLLOW_KW_COMPACTIONS_in_showStatement7117);  
                    stream_KW_COMPACTIONS.add(KW_COMPACTIONS448);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1352:30: -> ^( TOK_SHOW_COMPACTIONS )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1352:33: ^( TOK_SHOW_COMPACTIONS )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_COMPACTIONS, "TOK_SHOW_COMPACTIONS")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1353:7: KW_SHOW KW_TRANSACTIONS
                    {
                    KW_SHOW449=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7131);  
                    stream_KW_SHOW.add(KW_SHOW449);


                    KW_TRANSACTIONS450=(Token)match(input,KW_TRANSACTIONS,FOLLOW_KW_TRANSACTIONS_in_showStatement7133);  
                    stream_KW_TRANSACTIONS.add(KW_TRANSACTIONS450);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1353:31: -> ^( TOK_SHOW_TRANSACTIONS )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1353:34: ^( TOK_SHOW_TRANSACTIONS )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TRANSACTIONS, "TOK_SHOW_TRANSACTIONS")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 14 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1354:7: KW_SHOW KW_CONF StringLiteral
                    {
                    KW_SHOW451=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7147);  
                    stream_KW_SHOW.add(KW_SHOW451);


                    KW_CONF452=(Token)match(input,KW_CONF,FOLLOW_KW_CONF_in_showStatement7149);  
                    stream_KW_CONF.add(KW_CONF452);


                    StringLiteral453=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_showStatement7151);  
                    stream_StringLiteral.add(StringLiteral453);


                    // AST REWRITE
                    // elements: StringLiteral
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1354:37: -> ^( TOK_SHOWCONF StringLiteral )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1354:40: ^( TOK_SHOWCONF StringLiteral )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWCONF, "TOK_SHOWCONF")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_StringLiteral.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showStatement"


    public static class lockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1357:1: lockStatement : KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? ) ;
    public final HiveParser.lockStatement_return lockStatement() throws RecognitionException {
        HiveParser.lockStatement_return retval = new HiveParser.lockStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_LOCK454=null;
        Token KW_TABLE455=null;
        HiveParser_FromClauseParser.tableName_return tableName456 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec457 =null;

        HiveParser.lockMode_return lockMode458 =null;


        CommonTree KW_LOCK454_tree=null;
        CommonTree KW_TABLE455_tree=null;
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_lockMode=new RewriteRuleSubtreeStream(adaptor,"rule lockMode");
         pushMsg("lock statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1360:5: ( KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1360:7: KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode
            {
            KW_LOCK454=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_lockStatement7186);  
            stream_KW_LOCK.add(KW_LOCK454);


            KW_TABLE455=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_lockStatement7188);  
            stream_KW_TABLE.add(KW_TABLE455);


            pushFollow(FOLLOW_tableName_in_lockStatement7190);
            tableName456=tableName();

            state._fsp--;

            stream_tableName.add(tableName456.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1360:34: ( partitionSpec )?
            int alt137=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt137=1;
                    }
                    break;
            }

            switch (alt137) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1360:34: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_lockStatement7192);
                    partitionSpec457=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec457.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_lockMode_in_lockStatement7195);
            lockMode458=lockMode();

            state._fsp--;

            stream_lockMode.add(lockMode458.getTree());

            // AST REWRITE
            // elements: partitionSpec, tableName, lockMode
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1360:58: -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1360:61: ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOCKTABLE, "TOK_LOCKTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                adaptor.addChild(root_1, stream_lockMode.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1360:96: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockStatement"


    public static class lockDatabase_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockDatabase"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1363:1: lockDatabase : KW_LOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) lockMode -> ^( TOK_LOCKDB $dbName lockMode ) ;
    public final HiveParser.lockDatabase_return lockDatabase() throws RecognitionException {
        HiveParser.lockDatabase_return retval = new HiveParser.lockDatabase_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token dbName=null;
        Token KW_LOCK459=null;
        Token KW_DATABASE460=null;
        Token KW_SCHEMA461=null;
        HiveParser.lockMode_return lockMode462 =null;


        CommonTree dbName_tree=null;
        CommonTree KW_LOCK459_tree=null;
        CommonTree KW_DATABASE460_tree=null;
        CommonTree KW_SCHEMA461_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleSubtreeStream stream_lockMode=new RewriteRuleSubtreeStream(adaptor,"rule lockMode");
         pushMsg("lock database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1366:5: ( KW_LOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) lockMode -> ^( TOK_LOCKDB $dbName lockMode ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1366:7: KW_LOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) lockMode
            {
            KW_LOCK459=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_lockDatabase7235);  
            stream_KW_LOCK.add(KW_LOCK459);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1366:15: ( KW_DATABASE | KW_SCHEMA )
            int alt138=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt138=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt138=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;

            }

            switch (alt138) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1366:16: KW_DATABASE
                    {
                    KW_DATABASE460=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_lockDatabase7238);  
                    stream_KW_DATABASE.add(KW_DATABASE460);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1366:28: KW_SCHEMA
                    {
                    KW_SCHEMA461=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_lockDatabase7240);  
                    stream_KW_SCHEMA.add(KW_SCHEMA461);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1366:39: (dbName= Identifier )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1366:40: dbName= Identifier
            {
            dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_lockDatabase7246);  
            stream_Identifier.add(dbName);


            }


            pushFollow(FOLLOW_lockMode_in_lockDatabase7249);
            lockMode462=lockMode();

            state._fsp--;

            stream_lockMode.add(lockMode462.getTree());

            // AST REWRITE
            // elements: lockMode, dbName
            // token labels: dbName
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1366:68: -> ^( TOK_LOCKDB $dbName lockMode )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1366:71: ^( TOK_LOCKDB $dbName lockMode )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOCKDB, "TOK_LOCKDB")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextNode());

                adaptor.addChild(root_1, stream_lockMode.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockDatabase"


    public static class lockMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1369:1: lockMode : ( KW_SHARED | KW_EXCLUSIVE );
    public final HiveParser.lockMode_return lockMode() throws RecognitionException {
        HiveParser.lockMode_return retval = new HiveParser.lockMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token set463=null;

        CommonTree set463_tree=null;

         pushMsg("lock mode", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1372:5: ( KW_SHARED | KW_EXCLUSIVE )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:
            {
            root_0 = (CommonTree)adaptor.nil();


            set463=(Token)input.LT(1);

            if ( input.LA(1)==KW_EXCLUSIVE||input.LA(1)==KW_SHARED ) {
                input.consume();
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(set463)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockMode"


    public static class unlockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unlockStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:1: unlockStatement : KW_UNLOCK KW_TABLE tableName ( partitionSpec )? -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? ) ;
    public final HiveParser.unlockStatement_return unlockStatement() throws RecognitionException {
        HiveParser.unlockStatement_return retval = new HiveParser.unlockStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_UNLOCK464=null;
        Token KW_TABLE465=null;
        HiveParser_FromClauseParser.tableName_return tableName466 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec467 =null;


        CommonTree KW_UNLOCK464_tree=null;
        CommonTree KW_TABLE465_tree=null;
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_UNLOCK=new RewriteRuleTokenStream(adaptor,"token KW_UNLOCK");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("unlock statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:5: ( KW_UNLOCK KW_TABLE tableName ( partitionSpec )? -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:7: KW_UNLOCK KW_TABLE tableName ( partitionSpec )?
            {
            KW_UNLOCK464=(Token)match(input,KW_UNLOCK,FOLLOW_KW_UNLOCK_in_unlockStatement7318);  
            stream_KW_UNLOCK.add(KW_UNLOCK464);


            KW_TABLE465=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_unlockStatement7320);  
            stream_KW_TABLE.add(KW_TABLE465);


            pushFollow(FOLLOW_tableName_in_unlockStatement7322);
            tableName466=tableName();

            state._fsp--;

            stream_tableName.add(tableName466.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:36: ( partitionSpec )?
            int alt139=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt139=1;
                    }
                    break;
            }

            switch (alt139) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:36: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_unlockStatement7324);
                    partitionSpec467=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec467.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: tableName, partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1378:52: -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:55: ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_UNLOCKTABLE, "TOK_UNLOCKTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:83: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unlockStatement"


    public static class unlockDatabase_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unlockDatabase"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1381:1: unlockDatabase : KW_UNLOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) -> ^( TOK_UNLOCKDB $dbName) ;
    public final HiveParser.unlockDatabase_return unlockDatabase() throws RecognitionException {
        HiveParser.unlockDatabase_return retval = new HiveParser.unlockDatabase_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token dbName=null;
        Token KW_UNLOCK468=null;
        Token KW_DATABASE469=null;
        Token KW_SCHEMA470=null;

        CommonTree dbName_tree=null;
        CommonTree KW_UNLOCK468_tree=null;
        CommonTree KW_DATABASE469_tree=null;
        CommonTree KW_SCHEMA470_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_UNLOCK=new RewriteRuleTokenStream(adaptor,"token KW_UNLOCK");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");

         pushMsg("unlock database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:5: ( KW_UNLOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) -> ^( TOK_UNLOCKDB $dbName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:7: KW_UNLOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier )
            {
            KW_UNLOCK468=(Token)match(input,KW_UNLOCK,FOLLOW_KW_UNLOCK_in_unlockDatabase7364);  
            stream_KW_UNLOCK.add(KW_UNLOCK468);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:17: ( KW_DATABASE | KW_SCHEMA )
            int alt140=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt140=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt140=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 140, 0, input);

                throw nvae;

            }

            switch (alt140) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:18: KW_DATABASE
                    {
                    KW_DATABASE469=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_unlockDatabase7367);  
                    stream_KW_DATABASE.add(KW_DATABASE469);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:30: KW_SCHEMA
                    {
                    KW_SCHEMA470=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_unlockDatabase7369);  
                    stream_KW_SCHEMA.add(KW_SCHEMA470);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:41: (dbName= Identifier )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:42: dbName= Identifier
            {
            dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_unlockDatabase7375);  
            stream_Identifier.add(dbName);


            }


            // AST REWRITE
            // elements: dbName
            // token labels: dbName
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1384:61: -> ^( TOK_UNLOCKDB $dbName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:64: ^( TOK_UNLOCKDB $dbName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_UNLOCKDB, "TOK_UNLOCKDB")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unlockDatabase"


    public static class createRoleStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createRoleStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1387:1: createRoleStatement : KW_CREATE KW_ROLE roleName= identifier -> ^( TOK_CREATEROLE $roleName) ;
    public final HiveParser.createRoleStatement_return createRoleStatement() throws RecognitionException {
        HiveParser.createRoleStatement_return retval = new HiveParser.createRoleStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE471=null;
        Token KW_ROLE472=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_CREATE471_tree=null;
        CommonTree KW_ROLE472_tree=null;
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("create role", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1390:5: ( KW_CREATE KW_ROLE roleName= identifier -> ^( TOK_CREATEROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1390:7: KW_CREATE KW_ROLE roleName= identifier
            {
            KW_CREATE471=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createRoleStatement7412);  
            stream_KW_CREATE.add(KW_CREATE471);


            KW_ROLE472=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_createRoleStatement7414);  
            stream_KW_ROLE.add(KW_ROLE472);


            pushFollow(FOLLOW_identifier_in_createRoleStatement7418);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1391:5: -> ^( TOK_CREATEROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1391:8: ^( TOK_CREATEROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEROLE, "TOK_CREATEROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createRoleStatement"


    public static class dropRoleStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropRoleStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:1: dropRoleStatement : KW_DROP KW_ROLE roleName= identifier -> ^( TOK_DROPROLE $roleName) ;
    public final HiveParser.dropRoleStatement_return dropRoleStatement() throws RecognitionException {
        HiveParser.dropRoleStatement_return retval = new HiveParser.dropRoleStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP473=null;
        Token KW_ROLE474=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_DROP473_tree=null;
        CommonTree KW_ROLE474_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("drop role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1397:5: ( KW_DROP KW_ROLE roleName= identifier -> ^( TOK_DROPROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1397:7: KW_DROP KW_ROLE roleName= identifier
            {
            KW_DROP473=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropRoleStatement7458);  
            stream_KW_DROP.add(KW_DROP473);


            KW_ROLE474=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_dropRoleStatement7460);  
            stream_KW_ROLE.add(KW_ROLE474);


            pushFollow(FOLLOW_identifier_in_dropRoleStatement7464);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1398:5: -> ^( TOK_DROPROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1398:8: ^( TOK_DROPROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPROLE, "TOK_DROPROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropRoleStatement"


    public static class grantPrivileges_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantPrivileges"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1401:1: grantPrivileges : KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )? -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? ) ;
    public final HiveParser.grantPrivileges_return grantPrivileges() throws RecognitionException {
        HiveParser.grantPrivileges_return retval = new HiveParser.grantPrivileges_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT475=null;
        Token KW_TO477=null;
        HiveParser.privilegeList_return privList =null;

        HiveParser.privilegeObject_return privilegeObject476 =null;

        HiveParser.principalSpecification_return principalSpecification478 =null;

        HiveParser.withGrantOption_return withGrantOption479 =null;


        CommonTree KW_GRANT475_tree=null;
        CommonTree KW_TO477_tree=null;
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_withGrantOption=new RewriteRuleSubtreeStream(adaptor,"rule withGrantOption");
        RewriteRuleSubtreeStream stream_privilegeList=new RewriteRuleSubtreeStream(adaptor,"rule privilegeList");
        RewriteRuleSubtreeStream stream_privilegeObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeObject");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        pushMsg("grant privileges", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:5: ( KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )? -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:7: KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )?
            {
            KW_GRANT475=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_grantPrivileges7504);  
            stream_KW_GRANT.add(KW_GRANT475);


            pushFollow(FOLLOW_privilegeList_in_grantPrivileges7508);
            privList=privilegeList();

            state._fsp--;

            stream_privilegeList.add(privList.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1405:7: ( privilegeObject )?
            int alt141=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt141=1;
                    }
                    break;
            }

            switch (alt141) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1405:7: privilegeObject
                    {
                    pushFollow(FOLLOW_privilegeObject_in_grantPrivileges7516);
                    privilegeObject476=privilegeObject();

                    state._fsp--;

                    stream_privilegeObject.add(privilegeObject476.getTree());

                    }
                    break;

            }


            KW_TO477=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_grantPrivileges7525);  
            stream_KW_TO.add(KW_TO477);


            pushFollow(FOLLOW_principalSpecification_in_grantPrivileges7527);
            principalSpecification478=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification478.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1407:7: ( withGrantOption )?
            int alt142=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt142=1;
                    }
                    break;
            }

            switch (alt142) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1407:7: withGrantOption
                    {
                    pushFollow(FOLLOW_withGrantOption_in_grantPrivileges7535);
                    withGrantOption479=withGrantOption();

                    state._fsp--;

                    stream_withGrantOption.add(withGrantOption479.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: privilegeObject, withGrantOption, principalSpecification, privList
            // token labels: 
            // rule labels: retval, privList
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_privList=new RewriteRuleSubtreeStream(adaptor,"rule privList",privList!=null?privList.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1408:5: -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:8: ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT, "TOK_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_privList.nextTree());

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:53: ( privilegeObject )?
                if ( stream_privilegeObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeObject.nextTree());

                }
                stream_privilegeObject.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:70: ( withGrantOption )?
                if ( stream_withGrantOption.hasNext() ) {
                    adaptor.addChild(root_1, stream_withGrantOption.nextTree());

                }
                stream_withGrantOption.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantPrivileges"


    public static class revokePrivileges_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "revokePrivileges"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1411:1: revokePrivileges : KW_REVOKE ( grantOptionFor )? privilegeList ( privilegeObject )? KW_FROM principalSpecification -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ( grantOptionFor )? ) ;
    public final HiveParser.revokePrivileges_return revokePrivileges() throws RecognitionException {
        HiveParser.revokePrivileges_return retval = new HiveParser.revokePrivileges_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_REVOKE480=null;
        Token KW_FROM484=null;
        HiveParser.grantOptionFor_return grantOptionFor481 =null;

        HiveParser.privilegeList_return privilegeList482 =null;

        HiveParser.privilegeObject_return privilegeObject483 =null;

        HiveParser.principalSpecification_return principalSpecification485 =null;


        CommonTree KW_REVOKE480_tree=null;
        CommonTree KW_FROM484_tree=null;
        RewriteRuleTokenStream stream_KW_REVOKE=new RewriteRuleTokenStream(adaptor,"token KW_REVOKE");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_grantOptionFor=new RewriteRuleSubtreeStream(adaptor,"rule grantOptionFor");
        RewriteRuleSubtreeStream stream_privilegeList=new RewriteRuleSubtreeStream(adaptor,"rule privilegeList");
        RewriteRuleSubtreeStream stream_privilegeObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeObject");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        pushMsg("revoke privileges", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:5: ( KW_REVOKE ( grantOptionFor )? privilegeList ( privilegeObject )? KW_FROM principalSpecification -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ( grantOptionFor )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:7: KW_REVOKE ( grantOptionFor )? privilegeList ( privilegeObject )? KW_FROM principalSpecification
            {
            KW_REVOKE480=(Token)match(input,KW_REVOKE,FOLLOW_KW_REVOKE_in_revokePrivileges7584);  
            stream_KW_REVOKE.add(KW_REVOKE480);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:17: ( grantOptionFor )?
            int alt143=2;
            switch ( input.LA(1) ) {
                case KW_GRANT:
                    {
                    alt143=1;
                    }
                    break;
            }

            switch (alt143) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:17: grantOptionFor
                    {
                    pushFollow(FOLLOW_grantOptionFor_in_revokePrivileges7586);
                    grantOptionFor481=grantOptionFor();

                    state._fsp--;

                    stream_grantOptionFor.add(grantOptionFor481.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_privilegeList_in_revokePrivileges7589);
            privilegeList482=privilegeList();

            state._fsp--;

            stream_privilegeList.add(privilegeList482.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:47: ( privilegeObject )?
            int alt144=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt144=1;
                    }
                    break;
            }

            switch (alt144) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:47: privilegeObject
                    {
                    pushFollow(FOLLOW_privilegeObject_in_revokePrivileges7591);
                    privilegeObject483=privilegeObject();

                    state._fsp--;

                    stream_privilegeObject.add(privilegeObject483.getTree());

                    }
                    break;

            }


            KW_FROM484=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_revokePrivileges7594);  
            stream_KW_FROM.add(KW_FROM484);


            pushFollow(FOLLOW_principalSpecification_in_revokePrivileges7596);
            principalSpecification485=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification485.getTree());

            // AST REWRITE
            // elements: principalSpecification, grantOptionFor, privilegeObject, privilegeList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1415:5: -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ( grantOptionFor )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1415:8: ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ( grantOptionFor )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REVOKE, "TOK_REVOKE")
                , root_1);

                adaptor.addChild(root_1, stream_privilegeList.nextTree());

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1415:58: ( privilegeObject )?
                if ( stream_privilegeObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeObject.nextTree());

                }
                stream_privilegeObject.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1415:75: ( grantOptionFor )?
                if ( stream_grantOptionFor.hasNext() ) {
                    adaptor.addChild(root_1, stream_grantOptionFor.nextTree());

                }
                stream_grantOptionFor.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "revokePrivileges"


    public static class grantRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:1: grantRole : KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )? -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ ) ;
    public final HiveParser.grantRole_return grantRole() throws RecognitionException {
        HiveParser.grantRole_return retval = new HiveParser.grantRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT486=null;
        Token KW_ROLE487=null;
        Token COMMA489=null;
        Token KW_TO491=null;
        HiveParser_IdentifiersParser.identifier_return identifier488 =null;

        HiveParser_IdentifiersParser.identifier_return identifier490 =null;

        HiveParser.principalSpecification_return principalSpecification492 =null;

        HiveParser.withAdminOption_return withAdminOption493 =null;


        CommonTree KW_GRANT486_tree=null;
        CommonTree KW_ROLE487_tree=null;
        CommonTree COMMA489_tree=null;
        CommonTree KW_TO491_tree=null;
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_withAdminOption=new RewriteRuleSubtreeStream(adaptor,"rule withAdminOption");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("grant role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:5: ( KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )? -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:7: KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )?
            {
            KW_GRANT486=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_grantRole7643);  
            stream_KW_GRANT.add(KW_GRANT486);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:16: ( KW_ROLE )?
            int alt145=2;
            switch ( input.LA(1) ) {
                case KW_ROLE:
                    {
                    switch ( input.LA(2) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                            {
                            alt145=1;
                            }
                            break;
                        case KW_TO:
                            {
                            switch ( input.LA(3) ) {
                                case COMMA:
                                case KW_TO:
                                    {
                                    alt145=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt145) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:16: KW_ROLE
                    {
                    KW_ROLE487=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_grantRole7645);  
                    stream_KW_ROLE.add(KW_ROLE487);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_grantRole7648);
            identifier488=identifier();

            state._fsp--;

            stream_identifier.add(identifier488.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:36: ( COMMA identifier )*
            loop146:
            do {
                int alt146=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt146=1;
                    }
                    break;

                }

                switch (alt146) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:37: COMMA identifier
            	    {
            	    COMMA489=(Token)match(input,COMMA,FOLLOW_COMMA_in_grantRole7651);  
            	    stream_COMMA.add(COMMA489);


            	    pushFollow(FOLLOW_identifier_in_grantRole7653);
            	    identifier490=identifier();

            	    state._fsp--;

            	    stream_identifier.add(identifier490.getTree());

            	    }
            	    break;

            	default :
            	    break loop146;
                }
            } while (true);


            KW_TO491=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_grantRole7657);  
            stream_KW_TO.add(KW_TO491);


            pushFollow(FOLLOW_principalSpecification_in_grantRole7659);
            principalSpecification492=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification492.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:85: ( withAdminOption )?
            int alt147=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt147=1;
                    }
                    break;
            }

            switch (alt147) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:85: withAdminOption
                    {
                    pushFollow(FOLLOW_withAdminOption_in_grantRole7661);
                    withAdminOption493=withAdminOption();

                    state._fsp--;

                    stream_withAdminOption.add(withAdminOption493.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: identifier, withAdminOption, principalSpecification
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1422:5: -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1422:8: ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT_ROLE, "TOK_GRANT_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1422:48: ( withAdminOption )?
                if ( stream_withAdminOption.hasNext() ) {
                    adaptor.addChild(root_1, stream_withAdminOption.nextTree());

                }
                stream_withAdminOption.reset();

                if ( !(stream_identifier.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_identifier.hasNext() ) {
                    adaptor.addChild(root_1, stream_identifier.nextTree());

                }
                stream_identifier.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantRole"


    public static class revokeRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "revokeRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1425:1: revokeRole : KW_REVOKE ( adminOptionFor )? ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification -> ^( TOK_REVOKE_ROLE principalSpecification ( adminOptionFor )? ( identifier )+ ) ;
    public final HiveParser.revokeRole_return revokeRole() throws RecognitionException {
        HiveParser.revokeRole_return retval = new HiveParser.revokeRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_REVOKE494=null;
        Token KW_ROLE496=null;
        Token COMMA498=null;
        Token KW_FROM500=null;
        HiveParser.adminOptionFor_return adminOptionFor495 =null;

        HiveParser_IdentifiersParser.identifier_return identifier497 =null;

        HiveParser_IdentifiersParser.identifier_return identifier499 =null;

        HiveParser.principalSpecification_return principalSpecification501 =null;


        CommonTree KW_REVOKE494_tree=null;
        CommonTree KW_ROLE496_tree=null;
        CommonTree COMMA498_tree=null;
        CommonTree KW_FROM500_tree=null;
        RewriteRuleTokenStream stream_KW_REVOKE=new RewriteRuleTokenStream(adaptor,"token KW_REVOKE");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_adminOptionFor=new RewriteRuleSubtreeStream(adaptor,"rule adminOptionFor");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("revoke role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:5: ( KW_REVOKE ( adminOptionFor )? ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification -> ^( TOK_REVOKE_ROLE principalSpecification ( adminOptionFor )? ( identifier )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:7: KW_REVOKE ( adminOptionFor )? ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification
            {
            KW_REVOKE494=(Token)match(input,KW_REVOKE,FOLLOW_KW_REVOKE_in_revokeRole7707);  
            stream_KW_REVOKE.add(KW_REVOKE494);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:17: ( adminOptionFor )?
            int alt148=2;
            switch ( input.LA(1) ) {
                case KW_ADMIN:
                    {
                    switch ( input.LA(2) ) {
                        case KW_OPTION:
                            {
                            alt148=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt148) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:17: adminOptionFor
                    {
                    pushFollow(FOLLOW_adminOptionFor_in_revokeRole7709);
                    adminOptionFor495=adminOptionFor();

                    state._fsp--;

                    stream_adminOptionFor.add(adminOptionFor495.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:33: ( KW_ROLE )?
            int alt149=2;
            switch ( input.LA(1) ) {
                case KW_ROLE:
                    {
                    switch ( input.LA(2) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                            {
                            alt149=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt149) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:33: KW_ROLE
                    {
                    KW_ROLE496=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_revokeRole7712);  
                    stream_KW_ROLE.add(KW_ROLE496);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_revokeRole7715);
            identifier497=identifier();

            state._fsp--;

            stream_identifier.add(identifier497.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:53: ( COMMA identifier )*
            loop150:
            do {
                int alt150=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt150=1;
                    }
                    break;

                }

                switch (alt150) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:54: COMMA identifier
            	    {
            	    COMMA498=(Token)match(input,COMMA,FOLLOW_COMMA_in_revokeRole7718);  
            	    stream_COMMA.add(COMMA498);


            	    pushFollow(FOLLOW_identifier_in_revokeRole7720);
            	    identifier499=identifier();

            	    state._fsp--;

            	    stream_identifier.add(identifier499.getTree());

            	    }
            	    break;

            	default :
            	    break loop150;
                }
            } while (true);


            KW_FROM500=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_revokeRole7724);  
            stream_KW_FROM.add(KW_FROM500);


            pushFollow(FOLLOW_principalSpecification_in_revokeRole7726);
            principalSpecification501=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification501.getTree());

            // AST REWRITE
            // elements: principalSpecification, adminOptionFor, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1429:5: -> ^( TOK_REVOKE_ROLE principalSpecification ( adminOptionFor )? ( identifier )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1429:8: ^( TOK_REVOKE_ROLE principalSpecification ( adminOptionFor )? ( identifier )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REVOKE_ROLE, "TOK_REVOKE_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1429:49: ( adminOptionFor )?
                if ( stream_adminOptionFor.hasNext() ) {
                    adaptor.addChild(root_1, stream_adminOptionFor.nextTree());

                }
                stream_adminOptionFor.reset();

                if ( !(stream_identifier.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_identifier.hasNext() ) {
                    adaptor.addChild(root_1, stream_identifier.nextTree());

                }
                stream_identifier.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "revokeRole"


    public static class showRoleGrants_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRoleGrants"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1432:1: showRoleGrants : KW_SHOW KW_ROLE KW_GRANT principalName -> ^( TOK_SHOW_ROLE_GRANT principalName ) ;
    public final HiveParser.showRoleGrants_return showRoleGrants() throws RecognitionException {
        HiveParser.showRoleGrants_return retval = new HiveParser.showRoleGrants_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW502=null;
        Token KW_ROLE503=null;
        Token KW_GRANT504=null;
        HiveParser.principalName_return principalName505 =null;


        CommonTree KW_SHOW502_tree=null;
        CommonTree KW_ROLE503_tree=null;
        CommonTree KW_GRANT504_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        pushMsg("show role grants", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:5: ( KW_SHOW KW_ROLE KW_GRANT principalName -> ^( TOK_SHOW_ROLE_GRANT principalName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:7: KW_SHOW KW_ROLE KW_GRANT principalName
            {
            KW_SHOW502=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRoleGrants7771);  
            stream_KW_SHOW.add(KW_SHOW502);


            KW_ROLE503=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_showRoleGrants7773);  
            stream_KW_ROLE.add(KW_ROLE503);


            KW_GRANT504=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_showRoleGrants7775);  
            stream_KW_GRANT.add(KW_GRANT504);


            pushFollow(FOLLOW_principalName_in_showRoleGrants7777);
            principalName505=principalName();

            state._fsp--;

            stream_principalName.add(principalName505.getTree());

            // AST REWRITE
            // elements: principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1436:5: -> ^( TOK_SHOW_ROLE_GRANT principalName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:8: ^( TOK_SHOW_ROLE_GRANT principalName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLE_GRANT, "TOK_SHOW_ROLE_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_principalName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRoleGrants"


    public static class showRoles_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRoles"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1440:1: showRoles : KW_SHOW KW_ROLES -> ^( TOK_SHOW_ROLES ) ;
    public final HiveParser.showRoles_return showRoles() throws RecognitionException {
        HiveParser.showRoles_return retval = new HiveParser.showRoles_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW506=null;
        Token KW_ROLES507=null;

        CommonTree KW_SHOW506_tree=null;
        CommonTree KW_ROLES507_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_ROLES=new RewriteRuleTokenStream(adaptor,"token KW_ROLES");

        pushMsg("show roles", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1443:5: ( KW_SHOW KW_ROLES -> ^( TOK_SHOW_ROLES ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1443:7: KW_SHOW KW_ROLES
            {
            KW_SHOW506=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRoles7817);  
            stream_KW_SHOW.add(KW_SHOW506);


            KW_ROLES507=(Token)match(input,KW_ROLES,FOLLOW_KW_ROLES_in_showRoles7819);  
            stream_KW_ROLES.add(KW_ROLES507);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1444:5: -> ^( TOK_SHOW_ROLES )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1444:8: ^( TOK_SHOW_ROLES )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLES, "TOK_SHOW_ROLES")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRoles"


    public static class showCurrentRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showCurrentRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1447:1: showCurrentRole : KW_SHOW KW_CURRENT KW_ROLES -> ^( TOK_SHOW_SET_ROLE ) ;
    public final HiveParser.showCurrentRole_return showCurrentRole() throws RecognitionException {
        HiveParser.showCurrentRole_return retval = new HiveParser.showCurrentRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW508=null;
        Token KW_CURRENT509=null;
        Token KW_ROLES510=null;

        CommonTree KW_SHOW508_tree=null;
        CommonTree KW_CURRENT509_tree=null;
        CommonTree KW_ROLES510_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_CURRENT=new RewriteRuleTokenStream(adaptor,"token KW_CURRENT");
        RewriteRuleTokenStream stream_KW_ROLES=new RewriteRuleTokenStream(adaptor,"token KW_ROLES");

        pushMsg("show current role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:5: ( KW_SHOW KW_CURRENT KW_ROLES -> ^( TOK_SHOW_SET_ROLE ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:7: KW_SHOW KW_CURRENT KW_ROLES
            {
            KW_SHOW508=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showCurrentRole7856);  
            stream_KW_SHOW.add(KW_SHOW508);


            KW_CURRENT509=(Token)match(input,KW_CURRENT,FOLLOW_KW_CURRENT_in_showCurrentRole7858);  
            stream_KW_CURRENT.add(KW_CURRENT509);


            KW_ROLES510=(Token)match(input,KW_ROLES,FOLLOW_KW_ROLES_in_showCurrentRole7860);  
            stream_KW_ROLES.add(KW_ROLES510);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1451:5: -> ^( TOK_SHOW_SET_ROLE )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1451:8: ^( TOK_SHOW_SET_ROLE )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showCurrentRole"


    public static class setRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1454:1: setRole : KW_SET KW_ROLE roleName= identifier -> ^( TOK_SHOW_SET_ROLE $roleName) ;
    public final HiveParser.setRole_return setRole() throws RecognitionException {
        HiveParser.setRole_return retval = new HiveParser.setRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET511=null;
        Token KW_ROLE512=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_SET511_tree=null;
        CommonTree KW_ROLE512_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("set role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1457:5: ( KW_SET KW_ROLE roleName= identifier -> ^( TOK_SHOW_SET_ROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1457:7: KW_SET KW_ROLE roleName= identifier
            {
            KW_SET511=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_setRole7897);  
            stream_KW_SET.add(KW_SET511);


            KW_ROLE512=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_setRole7899);  
            stream_KW_ROLE.add(KW_ROLE512);


            pushFollow(FOLLOW_identifier_in_setRole7903);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1458:5: -> ^( TOK_SHOW_SET_ROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1458:8: ^( TOK_SHOW_SET_ROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setRole"


    public static class showGrants_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showGrants"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1461:1: showGrants : KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )? -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? ) ;
    public final HiveParser.showGrants_return showGrants() throws RecognitionException {
        HiveParser.showGrants_return retval = new HiveParser.showGrants_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW513=null;
        Token KW_GRANT514=null;
        Token KW_ON516=null;
        HiveParser.principalName_return principalName515 =null;

        HiveParser.privilegeIncludeColObject_return privilegeIncludeColObject517 =null;


        CommonTree KW_SHOW513_tree=null;
        CommonTree KW_GRANT514_tree=null;
        CommonTree KW_ON516_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        RewriteRuleSubtreeStream stream_privilegeIncludeColObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeIncludeColObject");
        pushMsg("show grants", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:5: ( KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )? -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:7: KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )?
            {
            KW_SHOW513=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showGrants7943);  
            stream_KW_SHOW.add(KW_SHOW513);


            KW_GRANT514=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_showGrants7945);  
            stream_KW_GRANT.add(KW_GRANT514);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:24: ( principalName )?
            int alt151=2;
            switch ( input.LA(1) ) {
                case KW_GROUP:
                case KW_ROLE:
                case KW_USER:
                    {
                    alt151=1;
                    }
                    break;
            }

            switch (alt151) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:24: principalName
                    {
                    pushFollow(FOLLOW_principalName_in_showGrants7947);
                    principalName515=principalName();

                    state._fsp--;

                    stream_principalName.add(principalName515.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:39: ( KW_ON privilegeIncludeColObject )?
            int alt152=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt152=1;
                    }
                    break;
            }

            switch (alt152) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:40: KW_ON privilegeIncludeColObject
                    {
                    KW_ON516=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_showGrants7951);  
                    stream_KW_ON.add(KW_ON516);


                    pushFollow(FOLLOW_privilegeIncludeColObject_in_showGrants7953);
                    privilegeIncludeColObject517=privilegeIncludeColObject();

                    state._fsp--;

                    stream_privilegeIncludeColObject.add(privilegeIncludeColObject517.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: principalName, privilegeIncludeColObject
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1465:5: -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1465:8: ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_GRANT, "TOK_SHOW_GRANT")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1465:25: ( principalName )?
                if ( stream_principalName.hasNext() ) {
                    adaptor.addChild(root_1, stream_principalName.nextTree());

                }
                stream_principalName.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1465:40: ( privilegeIncludeColObject )?
                if ( stream_privilegeIncludeColObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeIncludeColObject.nextTree());

                }
                stream_privilegeIncludeColObject.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showGrants"


    public static class showRolePrincipals_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRolePrincipals"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1468:1: showRolePrincipals : KW_SHOW KW_PRINCIPALS roleName= identifier -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName) ;
    public final HiveParser.showRolePrincipals_return showRolePrincipals() throws RecognitionException {
        HiveParser.showRolePrincipals_return retval = new HiveParser.showRolePrincipals_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW518=null;
        Token KW_PRINCIPALS519=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_SHOW518_tree=null;
        CommonTree KW_PRINCIPALS519_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_PRINCIPALS=new RewriteRuleTokenStream(adaptor,"token KW_PRINCIPALS");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("show role principals", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1471:5: ( KW_SHOW KW_PRINCIPALS roleName= identifier -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1471:7: KW_SHOW KW_PRINCIPALS roleName= identifier
            {
            KW_SHOW518=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRolePrincipals7998);  
            stream_KW_SHOW.add(KW_SHOW518);


            KW_PRINCIPALS519=(Token)match(input,KW_PRINCIPALS,FOLLOW_KW_PRINCIPALS_in_showRolePrincipals8000);  
            stream_KW_PRINCIPALS.add(KW_PRINCIPALS519);


            pushFollow(FOLLOW_identifier_in_showRolePrincipals8004);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1472:5: -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1472:8: ^( TOK_SHOW_ROLE_PRINCIPALS $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLE_PRINCIPALS, "TOK_SHOW_ROLE_PRINCIPALS")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRolePrincipals"


    public static class privilegeIncludeColObject_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeIncludeColObject"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1476:1: privilegeIncludeColObject : ( KW_ALL -> ^( TOK_RESOURCE_ALL ) | privObjectCols -> ^( TOK_PRIV_OBJECT_COL privObjectCols ) );
    public final HiveParser.privilegeIncludeColObject_return privilegeIncludeColObject() throws RecognitionException {
        HiveParser.privilegeIncludeColObject_return retval = new HiveParser.privilegeIncludeColObject_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALL520=null;
        HiveParser.privObjectCols_return privObjectCols521 =null;


        CommonTree KW_ALL520_tree=null;
        RewriteRuleTokenStream stream_KW_ALL=new RewriteRuleTokenStream(adaptor,"token KW_ALL");
        RewriteRuleSubtreeStream stream_privObjectCols=new RewriteRuleSubtreeStream(adaptor,"rule privObjectCols");
        pushMsg("privilege object including columns", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:5: ( KW_ALL -> ^( TOK_RESOURCE_ALL ) | privObjectCols -> ^( TOK_PRIV_OBJECT_COL privObjectCols ) )
            int alt153=2;
            switch ( input.LA(1) ) {
            case KW_ALL:
                {
                alt153=1;
                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_AUTHORIZATION:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASE:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_REWRITE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUES:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt153=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 153, 0, input);

                throw nvae;

            }

            switch (alt153) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:7: KW_ALL
                    {
                    KW_ALL520=(Token)match(input,KW_ALL,FOLLOW_KW_ALL_in_privilegeIncludeColObject8045);  
                    stream_KW_ALL.add(KW_ALL520);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1479:14: -> ^( TOK_RESOURCE_ALL )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:17: ^( TOK_RESOURCE_ALL )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_RESOURCE_ALL, "TOK_RESOURCE_ALL")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1480:7: privObjectCols
                    {
                    pushFollow(FOLLOW_privObjectCols_in_privilegeIncludeColObject8059);
                    privObjectCols521=privObjectCols();

                    state._fsp--;

                    stream_privObjectCols.add(privObjectCols521.getTree());

                    // AST REWRITE
                    // elements: privObjectCols
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1480:22: -> ^( TOK_PRIV_OBJECT_COL privObjectCols )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1480:25: ^( TOK_PRIV_OBJECT_COL privObjectCols )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_OBJECT_COL, "TOK_PRIV_OBJECT_COL")
                        , root_1);

                        adaptor.addChild(root_1, stream_privObjectCols.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeIncludeColObject"


    public static class privilegeObject_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeObject"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1483:1: privilegeObject : KW_ON privObject -> ^( TOK_PRIV_OBJECT privObject ) ;
    public final HiveParser.privilegeObject_return privilegeObject() throws RecognitionException {
        HiveParser.privilegeObject_return retval = new HiveParser.privilegeObject_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ON522=null;
        HiveParser.privObject_return privObject523 =null;


        CommonTree KW_ON522_tree=null;
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_privObject=new RewriteRuleSubtreeStream(adaptor,"rule privObject");
        pushMsg("privilege object", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:5: ( KW_ON privObject -> ^( TOK_PRIV_OBJECT privObject ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:7: KW_ON privObject
            {
            KW_ON522=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_privilegeObject8094);  
            stream_KW_ON.add(KW_ON522);


            pushFollow(FOLLOW_privObject_in_privilegeObject8096);
            privObject523=privObject();

            state._fsp--;

            stream_privObject.add(privObject523.getTree());

            // AST REWRITE
            // elements: privObject
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1486:24: -> ^( TOK_PRIV_OBJECT privObject )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:27: ^( TOK_PRIV_OBJECT privObject )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRIV_OBJECT, "TOK_PRIV_OBJECT")
                , root_1);

                adaptor.addChild(root_1, stream_privObject.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeObject"


    public static class privObject_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privObject"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1490:1: privObject : ( ( KW_DATABASE | KW_SCHEMA ) identifier -> ^( TOK_DB_TYPE identifier ) | ( KW_TABLE )? tableName ( partitionSpec )? -> ^( TOK_TABLE_TYPE tableName ( partitionSpec )? ) | KW_URI (path= StringLiteral ) -> ^( TOK_URI_TYPE $path) | KW_SERVER identifier -> ^( TOK_SERVER_TYPE identifier ) );
    public final HiveParser.privObject_return privObject() throws RecognitionException {
        HiveParser.privObject_return retval = new HiveParser.privObject_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token path=null;
        Token KW_DATABASE524=null;
        Token KW_SCHEMA525=null;
        Token KW_TABLE527=null;
        Token KW_URI530=null;
        Token KW_SERVER531=null;
        HiveParser_IdentifiersParser.identifier_return identifier526 =null;

        HiveParser_FromClauseParser.tableName_return tableName528 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec529 =null;

        HiveParser_IdentifiersParser.identifier_return identifier532 =null;


        CommonTree path_tree=null;
        CommonTree KW_DATABASE524_tree=null;
        CommonTree KW_SCHEMA525_tree=null;
        CommonTree KW_TABLE527_tree=null;
        CommonTree KW_URI530_tree=null;
        CommonTree KW_SERVER531_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_SERVER=new RewriteRuleTokenStream(adaptor,"token KW_SERVER");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_URI=new RewriteRuleTokenStream(adaptor,"token KW_URI");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1491:5: ( ( KW_DATABASE | KW_SCHEMA ) identifier -> ^( TOK_DB_TYPE identifier ) | ( KW_TABLE )? tableName ( partitionSpec )? -> ^( TOK_TABLE_TYPE tableName ( partitionSpec )? ) | KW_URI (path= StringLiteral ) -> ^( TOK_URI_TYPE $path) | KW_SERVER identifier -> ^( TOK_SERVER_TYPE identifier ) )
            int alt157=4;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt157=1;
                }
                break;
            case KW_SCHEMA:
                {
                switch ( input.LA(2) ) {
                case Identifier:
                case KW_ADD:
                case KW_ADMIN:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_AUTHORIZATION:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPACT:
                case KW_COMPACTIONS:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILE:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_JAR:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_OWNER:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PRINCIPALS:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_REWRITE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TOUCH:
                case KW_TRANSACTIONS:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUES:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt157=1;
                    }
                    break;
                case KW_PARTITION:
                    {
                    switch ( input.LA(3) ) {
                    case LPAREN:
                        {
                        alt157=2;
                        }
                        break;
                    case KW_FROM:
                    case KW_TO:
                        {
                        alt157=1;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 157, 9, input);

                        throw nvae;

                    }

                    }
                    break;
                case DOT:
                case KW_FROM:
                    {
                    alt157=2;
                    }
                    break;
                case KW_TO:
                    {
                    switch ( input.LA(3) ) {
                    case KW_FROM:
                    case KW_TO:
                        {
                        alt157=1;
                        }
                        break;
                    case KW_GROUP:
                    case KW_ROLE:
                    case KW_USER:
                        {
                        alt157=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 157, 11, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 157, 2, input);

                    throw nvae;

                }

                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_AUTHORIZATION:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_REWRITE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUES:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt157=2;
                }
                break;
            case KW_URI:
                {
                switch ( input.LA(2) ) {
                case DOT:
                case KW_FROM:
                case KW_PARTITION:
                case KW_TO:
                    {
                    alt157=2;
                    }
                    break;
                case StringLiteral:
                    {
                    alt157=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 157, 5, input);

                    throw nvae;

                }

                }
                break;
            case KW_SERVER:
                {
                switch ( input.LA(2) ) {
                case DOT:
                case KW_FROM:
                    {
                    alt157=2;
                    }
                    break;
                case KW_PARTITION:
                    {
                    switch ( input.LA(3) ) {
                    case LPAREN:
                        {
                        alt157=2;
                        }
                        break;
                    case KW_FROM:
                    case KW_TO:
                        {
                        alt157=4;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 157, 20, input);

                        throw nvae;

                    }

                    }
                    break;
                case KW_TO:
                    {
                    switch ( input.LA(3) ) {
                    case KW_GROUP:
                    case KW_ROLE:
                    case KW_USER:
                        {
                        alt157=2;
                        }
                        break;
                    case KW_FROM:
                    case KW_TO:
                        {
                        alt157=4;
                        }
                        break;
                    default:
                        NoViableAltException nv