/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.remoting.api.Http2WireProtocol;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleClientHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleCommandOutBoundHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleHttp2FrameServerHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleServerConnectionHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleTailHandler;

@Activate
public class TripleHttp2Protocol
extends Http2WireProtocol
implements ScopeModelAware {
    private static final int MIB_1 = 0x100000;
    private static final int MIB_8 = 0x800000;
    private static final int KIB_32 = 32768;
    private static final int DEFAULT_MAX_HEADER_LIST_SIZE = 32768;
    private static final int DEFAULT_SETTING_HEADER_LIST_SIZE = 4096;
    private static final int DEFAULT_MAX_FRAME_SIZE = 0x800000;
    private static final int DEFAULT_WINDOW_INIT_SIZE = 0x800000;
    private ExtensionLoader<HeaderFilter> filtersLoader;
    private FrameworkModel frameworkModel;
    private Configuration config = ConfigurationUtils.getGlobalConfiguration(ApplicationModel.defaultModel());

    @Override
    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.config = ConfigurationUtils.getGlobalConfiguration(applicationModel);
        this.filtersLoader = applicationModel.getExtensionLoader(HeaderFilter.class);
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void configServerPipeline(final URL url, ChannelPipeline pipeline, SslContext sslContext) {
        final List<Object> headFilters = this.filtersLoader != null ? this.filtersLoader.getActivateExtension(url, "header.filter") : Collections.emptyList();
        Http2FrameCodec codec = Http2FrameCodecBuilder.forServer().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)this.config.getInt("dubbo.rpc.tri.header-table-size", 4096)).maxConcurrentStreams((long)this.config.getInt("dubbo.rpc.tri.max-concurrent-streams", Integer.MAX_VALUE)).initialWindowSize(this.config.getInt("dubbo.rpc.tri.initial-window-size", 0x800000)).maxFrameSize(this.config.getInt("dubbo.rpc.tri.max-frame-size", 0x800000)).maxHeaderListSize((long)this.config.getInt("dubbo.rpc.tri.max-header-list-size", 32768))).frameLogger(SERVER_LOGGER).build();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new TripleCommandOutBoundHandler()});
                p.addLast(new ChannelHandler[]{new TripleHttp2FrameServerHandler(TripleHttp2Protocol.this.frameworkModel, TripleHttp2Protocol.this.lookupExecutor(url), headFilters)});
            }
        });
        pipeline.addLast(new ChannelHandler[]{codec, new TripleServerConnectionHandler(), handler, new TripleTailHandler()});
    }

    private Executor lookupExecutor(URL url) {
        return url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension().getExecutor(url);
    }

    @Override
    public void configClientPipeline(URL url, ChannelPipeline pipeline, SslContext sslContext) {
        Http2FrameCodec codec = Http2FrameCodecBuilder.forClient().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)this.config.getInt("dubbo.rpc.tri.header-table-size", 4096)).pushEnabled(this.config.getBoolean("dubbo.rpc.tri.enable-push", false)).maxConcurrentStreams((long)this.config.getInt("dubbo.rpc.tri.max-concurrent-streams", Integer.MAX_VALUE)).initialWindowSize(this.config.getInt("dubbo.rpc.tri.initial-window-size", 0x800000)).maxFrameSize(this.config.getInt("dubbo.rpc.tri.max-frame-size", 0x800000)).maxHeaderListSize((long)this.config.getInt("dubbo.rpc.tri.max-header-list-size", 32768))).frameLogger(CLIENT_LOGGER).build();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new TripleClientHandler(this.frameworkModel));
        pipeline.addLast(new ChannelHandler[]{codec, handler, new TripleTailHandler()});
    }
}

