/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="publishMetadata", summary="update service metadata and service instance", example={"publishMetadata", "publishMetadata 5"})
public class PublishMetadata
implements BaseCommand {
    private static final Logger logger = LoggerFactory.getLogger(PublishMetadata.class);
    private final FrameworkModel frameworkModel;

    public PublishMetadata(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        logger.info("received publishMetadata command.");
        StringBuilder stringBuilder = new StringBuilder();
        List<ApplicationModel> applicationModels = this.frameworkModel.getApplicationModels();
        for (ApplicationModel applicationModel : applicationModels) {
            if (ArrayUtils.isEmpty(args)) {
                ServiceInstanceMetadataUtils.refreshMetadataAndInstance(applicationModel);
                stringBuilder.append("publish metadata succeeded. App:").append(applicationModel.getApplicationName()).append("\n");
                continue;
            }
            try {
                int delay = Integer.parseInt(args[0]);
                FrameworkExecutorRepository frameworkExecutorRepository = applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
                frameworkExecutorRepository.nextScheduledExecutor().schedule(() -> ServiceInstanceMetadataUtils.refreshMetadataAndInstance(applicationModel), (long)delay, TimeUnit.SECONDS);
            }
            catch (NumberFormatException e) {
                logger.error("Wrong delay param", e);
                return "publishMetadata failed! Wrong delay param!";
            }
            stringBuilder.append("publish task submitted, will publish in ").append(args[0]).append(" seconds. App:").append(applicationModel.getApplicationName()).append("\n");
        }
        return stringBuilder.toString();
    }
}

