/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.monitor.dubbo;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.monitor.Monitor;
import org.apache.dubbo.monitor.MonitorService;
import org.apache.dubbo.monitor.dubbo.Statistics;
import org.apache.dubbo.monitor.dubbo.StatisticsItem;
import org.apache.dubbo.rpc.Invoker;

public class DubboMonitor
implements Monitor {
    private static final Logger logger = LoggerFactory.getLogger(DubboMonitor.class);
    private final ScheduledExecutorService scheduledExecutorService;
    private final ScheduledFuture<?> sendFuture;
    private final Invoker<MonitorService> monitorInvoker;
    private final MonitorService monitorService;
    private final ConcurrentMap<Statistics, AtomicReference<StatisticsItem>> statisticsMap = new ConcurrentHashMap<Statistics, AtomicReference<StatisticsItem>>();

    public DubboMonitor(Invoker<MonitorService> monitorInvoker, MonitorService monitorService) {
        this.monitorInvoker = monitorInvoker;
        this.monitorService = monitorService;
        this.scheduledExecutorService = monitorInvoker.getUrl().getOrDefaultFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class).getSharedScheduledExecutor();
        long monitorInterval = monitorInvoker.getUrl().getPositiveParameter("interval", 60000);
        this.sendFuture = this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                this.send();
            }
            catch (Throwable t) {
                logger.error("Unexpected error occur at send statistic, cause: " + t.getMessage(), t);
            }
        }, monitorInterval, monitorInterval, TimeUnit.MILLISECONDS);
    }

    public void send() {
        if (logger.isDebugEnabled()) {
            logger.debug("Send statistics to monitor " + this.getUrl());
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        for (Map.Entry entry : this.statisticsMap.entrySet()) {
            StatisticsItem current;
            Statistics statistics = (Statistics)entry.getKey();
            AtomicReference reference = (AtomicReference)entry.getValue();
            StatisticsItem statisticsItem = (StatisticsItem)reference.get();
            URL url = statistics.getUrl().addParameters("timestamp", timestamp, "success", String.valueOf(statisticsItem.getSuccess()), "failure", String.valueOf(statisticsItem.getFailure()), "input", String.valueOf(statisticsItem.getInput()), "output", String.valueOf(statisticsItem.getOutput()), "elapsed", String.valueOf(statisticsItem.getElapsed()), "concurrent", String.valueOf(statisticsItem.getConcurrent()), "max.input", String.valueOf(statisticsItem.getMaxInput()), "max.output", String.valueOf(statisticsItem.getMaxOutput()), "max.elapsed", String.valueOf(statisticsItem.getMaxElapsed()), "max.concurrent", String.valueOf(statisticsItem.getMaxConcurrent()), "dubbo", this.getUrl().getParameter("dubbo"));
            this.monitorService.collect(url.toSerializableURL());
            StatisticsItem update = new StatisticsItem();
            do {
                if ((current = (StatisticsItem)reference.get()) == null) {
                    update.setItems(0L, 0L, 0L, 0L, 0L, 0L);
                    continue;
                }
                update.setItems(current.getSuccess() - statisticsItem.getSuccess(), current.getFailure() - statisticsItem.getFailure(), current.getInput() - statisticsItem.getInput(), current.getOutput() - statisticsItem.getOutput(), current.getElapsed() - statisticsItem.getElapsed(), current.getConcurrent() - statisticsItem.getConcurrent());
            } while (!reference.compareAndSet(current, update));
        }
    }

    @Override
    public void collect(URL url) {
        StatisticsItem current;
        int success = url.getParameter("success", 0);
        int failure = url.getParameter("failure", 0);
        int input = url.getParameter("input", 0);
        int output = url.getParameter("output", 0);
        int elapsed = url.getParameter("elapsed", 0);
        int concurrent = url.getParameter("concurrent", 0);
        Statistics statistics = new Statistics(url);
        AtomicReference reference = this.statisticsMap.computeIfAbsent(statistics, k -> new AtomicReference());
        StatisticsItem update = new StatisticsItem();
        do {
            if ((current = (StatisticsItem)reference.get()) == null) {
                update.setItems(success, failure, input, output, elapsed, concurrent, input, output, elapsed, concurrent);
                continue;
            }
            update.setItems(current.getSuccess() + (long)success, current.getFailure() + (long)failure, current.getInput() + (long)input, current.getOutput() + (long)output, current.getElapsed() + (long)elapsed, (current.getConcurrent() + (long)concurrent) / 2L, current.getMaxInput() > (long)input ? current.getMaxInput() : (long)input, current.getMaxOutput() > (long)output ? current.getMaxOutput() : (long)output, current.getMaxElapsed() > (long)elapsed ? current.getMaxElapsed() : (long)elapsed, current.getMaxConcurrent() > (long)concurrent ? current.getMaxConcurrent() : (long)concurrent);
        } while (!reference.compareAndSet(current, update));
    }

    @Override
    public List<URL> lookup(URL query) {
        return this.monitorService.lookup(query);
    }

    @Override
    public URL getUrl() {
        return this.monitorInvoker.getUrl();
    }

    @Override
    public boolean isAvailable() {
        return this.monitorInvoker.isAvailable();
    }

    @Override
    public void destroy() {
        try {
            ExecutorUtil.cancelScheduledFuture(this.sendFuture);
        }
        catch (Throwable t) {
            logger.error("Unexpected error occur at cancel sender timer, cause: " + t.getMessage(), t);
        }
        this.monitorInvoker.destroy();
    }
}

